/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.jdbc;

/**
 * Interface that defines a cache refresh operation.
 * To be exposed for management via JMX.
 *
 * @author Rob Harrop
 * @author Juergen Hoeller
 * @see SimpleJdbcClinic
 */
public interface SimpleJdbcClinicMBean {

    /**
     * Refresh the cache of Vets that the Clinic is holding.
     * @see org.springframework.samples.petclinic.Clinic#getVets()
     * @see SimpleJdbcClinic#refreshVetsCache()
     */
    void refreshVetsCache();

}
