/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.regexp;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpressionExtractor;
import edu.stanford.nlp.time.TimeExpressionExtractorFactory;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class NumberSequenceClassifier
extends AbstractSequenceClassifier<CoreLabel> {
    private static Redwood.RedwoodChannels log = Redwood.channels(NumberSequenceClassifier.class);
    private static final boolean DEBUG = false;
    private final boolean useSUTime;
    public static final boolean USE_SUTIME_DEFAULT = TimeExpressionExtractorFactory.DEFAULT_EXTRACTOR_PRESENT;
    public static final String USE_SUTIME_PROPERTY = "ner.useSUTime";
    public static final String USE_SUTIME_PROPERTY_BASE = "useSUTime";
    public static final String SUTIME_PROPERTY = "sutime";
    private final TimeExpressionExtractor timexExtractor;
    private static final Pattern MONTH_PATTERN = Pattern.compile("January|Jan\\.?|February|Feb\\.?|March|Mar\\.?|April|Apr\\.?|May|June|Jun\\.?|July|Jul\\.?|August|Aug\\.?|September|Sept?\\.?|October|Oct\\.?|November|Nov\\.?|December|Dec\\.");
    private static final Pattern YEAR_PATTERN = Pattern.compile("[1-3][0-9]{3}|'?[0-9]{2}");
    private static final Pattern DAY_PATTERN = Pattern.compile("(?:[1-9]|[12][0-9]|3[01])(?:st|nd|rd)?");
    private static final Pattern DATE_PATTERN = Pattern.compile("(?:[1-9]|[0-3][0-9])\\\\?/(?:[1-9]|[0-3][0-9])\\\\?/[1-3][0-9]{3}");
    private static final Pattern DATE_PATTERN2 = Pattern.compile("[12][0-9]{3}[-/](?:0?[1-9]|1[0-2])[-/][0-3][0-9]");
    private static final Pattern TIME_PATTERN = Pattern.compile("[0-2]?[0-9]:[0-5][0-9]");
    private static final Pattern TIME_PATTERN2 = Pattern.compile("[0-2][0-9]:[0-5][0-9]:[0-5][0-9]");
    private static final Pattern AM_PM = Pattern.compile("(a\\.?m\\.?)|(p\\.?m\\.?)", 2);
    public static final Pattern CURRENCY_WORD_PATTERN = Pattern.compile("(?:dollar|cent|euro|pound)s?|penny|pence|yen|yuan|won", 2);
    public static final Pattern CURRENCY_SYMBOL_PATTERN = Pattern.compile("\\$|\u00a2|\u20ac|#|&#163;|&pound;|\u00a3|\u00a5|\u20a9|(?:US|HK|A|C|NT|S|NZ)\\$", 2);
    public static final Pattern ORDINAL_PATTERN = Pattern.compile("(?i)[2-9]?1st|[2-9]?2nd|[2-9]?3rd|1[0-9]th|[2-9]?[04-9]th|100+th|zeroth|first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|twenty-first|twenty-second|twenty-third|twenty-fourth|twenty-fifth|twenty-sixth|twenty-seventh|twenty-eighth|twenty-ninth|thirtieth|thirty-first|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth|hundredth|thousandth|millionth");
    public static final Pattern ARMY_TIME_MORNING = Pattern.compile("0([0-9])([0-9]){2}");
    public static final Pattern GENERIC_TIME_WORDS = Pattern.compile("(morning|evening|night|noon|midnight|teatime|lunchtime|dinnertime|suppertime|afternoon|midday|dusk|dawn|sunup|sundown|daybreak|day)");
    public static final Pattern PERCENT_WORD_PATTERN = Pattern.compile("percent", 2);
    public static final Pattern PERCENT_SYMBOL_PATTERN = Pattern.compile("%");

    public NumberSequenceClassifier() {
        this(new Properties(), USE_SUTIME_DEFAULT, new Properties());
        if (!CURRENCY_WORD_PATTERN.matcher("pounds").matches()) {
            log.info("NumberSequence: Currency pattern broken");
        }
    }

    public NumberSequenceClassifier(boolean useSUTime) {
        this(new Properties(), useSUTime, new Properties());
    }

    public NumberSequenceClassifier(Properties props, boolean useSUTime, Properties sutimeProps) {
        super(props);
        this.useSUTime = useSUTime;
        this.timexExtractor = this.useSUTime ? TimeExpressionExtractorFactory.createExtractor(SUTIME_PROPERTY, sutimeProps) : null;
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> document) {
        return this.classifyWithGlobalInformation(document, (CoreMap)null, (CoreMap)null);
    }

    @Override
    public List<CoreLabel> classifyWithGlobalInformation(List<CoreLabel> tokens, CoreMap document, CoreMap sentence) {
        if (this.useSUTime) {
            return this.classifyWithSUTime(tokens, document, sentence);
        }
        return this.classifyOld(tokens);
    }

    @Override
    public void finalizeClassification(CoreMap document) {
        if (this.useSUTime) {
            this.timexExtractor.finalize(document);
        }
    }

    private List<CoreLabel> classifyWithSUTime(List<CoreLabel> tokenSequence, CoreMap document, CoreMap sentence) {
        CoreLabel token;
        int i;
        int offset;
        int end;
        int start;
        for (CoreLabel token2 : tokenSequence) {
            if (token2.get(CoreAnnotations.AnswerAnnotation.class) != null) continue;
            token2.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
        }
        CoreMap timeSentence = sentence != null ? NumberSequenceClassifier.alignSentence(sentence) : NumberSequenceClassifier.buildSentenceFromTokens(tokenSequence);
        List<CoreMap> timeExpressions = this.runSUTime(timeSentence, document);
        List numbers = (List)timeSentence.get(CoreAnnotations.NumerizedTokensAnnotation.class);
        if (timeExpressions != null) {
            for (CoreMap timeExpression : timeExpressions) {
                Timex timex;
                start = (Integer)timeExpression.get(CoreAnnotations.TokenBeginAnnotation.class);
                end = (Integer)timeExpression.get(CoreAnnotations.TokenEndAnnotation.class);
                offset = 0;
                if (sentence != null && sentence.containsKey(CoreAnnotations.TokenBeginAnnotation.class)) {
                    offset = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
                }
                if ((timex = (Timex)timeExpression.get(TimeAnnotations.TimexAnnotation.class)) == null) continue;
                String label = timex.timexType();
                for (i = start; i < end; ++i) {
                    token = tokenSequence.get(i - offset);
                    if (!((String)token.get(CoreAnnotations.AnswerAnnotation.class)).equals(this.flags.backgroundSymbol)) continue;
                    token.set(CoreAnnotations.AnswerAnnotation.class, label);
                    token.set(TimeAnnotations.TimexAnnotation.class, timex);
                }
            }
        }
        if (numbers != null) {
            for (CoreMap number : numbers) {
                if (!number.containsKey(CoreAnnotations.NumericCompositeValueAnnotation.class)) continue;
                start = (Integer)number.get(CoreAnnotations.TokenBeginAnnotation.class);
                end = (Integer)number.get(CoreAnnotations.TokenEndAnnotation.class);
                offset = 0;
                if (sentence != null && sentence.containsKey(CoreAnnotations.TokenBeginAnnotation.class)) {
                    offset = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
                }
                String type = (String)number.get(CoreAnnotations.NumericCompositeTypeAnnotation.class);
                Number value = (Number)number.get(CoreAnnotations.NumericCompositeValueAnnotation.class);
                if (type == null) continue;
                for (i = start; i < end; ++i) {
                    token = tokenSequence.get(i - offset);
                    if (!((String)token.get(CoreAnnotations.AnswerAnnotation.class)).equals(this.flags.backgroundSymbol)) continue;
                    token.set(CoreAnnotations.AnswerAnnotation.class, type);
                    if (value == null) continue;
                    token.set(CoreAnnotations.NumericCompositeValueAnnotation.class, value);
                }
            }
        }
        for (CoreLabel token3 : tokenSequence) {
            if (!"CD".equals(token3.tag()) || !((String)token3.get(CoreAnnotations.AnswerAnnotation.class)).equals(this.flags.backgroundSymbol)) continue;
            token3.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
        }
        this.moneyAndPercentRecognizer(tokenSequence);
        this.ordinalRecognizer(tokenSequence);
        return tokenSequence;
    }

    public static CoreMap alignSentence(CoreMap sentence) {
        String text = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
        if (text != null) {
            return sentence;
        }
        CoreMap newSentence = NumberSequenceClassifier.buildSentenceFromTokens((List)sentence.get(CoreAnnotations.TokensAnnotation.class), (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        newSentence.set(CoreAnnotations.TokenBeginAnnotation.class, sentence.get(CoreAnnotations.TokenBeginAnnotation.class));
        newSentence.set(CoreAnnotations.TokenEndAnnotation.class, sentence.get(CoreAnnotations.TokenEndAnnotation.class));
        return newSentence;
    }

    private static CoreMap buildSentenceFromTokens(List<CoreLabel> tokens) {
        return NumberSequenceClassifier.buildSentenceFromTokens(tokens, null, null);
    }

    private static CoreMap buildSentenceFromTokens(List<CoreLabel> tokens, Integer characterOffsetStart, Integer characterOffsetEnd) {
        boolean adjustCharacterOffsets = false;
        String text = NumberSequenceClassifier.buildText(tokens, CoreAnnotations.OriginalTextAnnotation.class);
        if (text == null) {
            text = NumberSequenceClassifier.buildText(tokens, CoreAnnotations.TextAnnotation.class);
            adjustCharacterOffsets = true;
            if (text == null) {
                throw new RuntimeException("ERROR: to use SUTime, sentences must have TextAnnotation set, or the individual tokens must have OriginalTextAnnotation or TextAnnotation set!");
            }
        }
        List<CoreLabel> tokenSequence = NumberSequenceClassifier.copyTokens(tokens, adjustCharacterOffsets, false);
        Annotation newSentence = new Annotation(text);
        newSentence.set(CoreAnnotations.TokensAnnotation.class, tokenSequence);
        if (!adjustCharacterOffsets && characterOffsetStart != null && characterOffsetEnd != null) {
            newSentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, characterOffsetStart);
            newSentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, characterOffsetEnd);
        } else {
            int tokenCharStart = (Integer)tokenSequence.get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int tokenCharEnd = (Integer)tokenSequence.get(tokenSequence.size() - 1).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            newSentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, tokenCharStart);
            newSentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, tokenCharEnd);
        }
        newSentence.set(CoreAnnotations.TokenBeginAnnotation.class, 0);
        newSentence.set(CoreAnnotations.TokenEndAnnotation.class, tokenSequence.size());
        return newSentence;
    }

    private static String buildText(List<CoreLabel> tokens, Class<? extends CoreAnnotation<String>> textAnnotation) {
        StringBuilder os = new StringBuilder();
        int sz = tokens.size();
        for (int i = 0; i < sz; ++i) {
            String word;
            CoreLabel crt = tokens.get(i);
            if (i > 0) {
                CoreLabel prev = tokens.get(i - 1);
                int spaces = 1;
                if (crt.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                    spaces = (Integer)crt.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) - (Integer)prev.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                }
                while (spaces > 0) {
                    os.append(' ');
                    --spaces;
                }
            }
            if ((word = (String)crt.get(textAnnotation)) == null) {
                return null;
            }
            os.append(word);
        }
        return os.toString();
    }

    private List<CoreMap> runSUTime(CoreMap sentence, CoreMap document) {
        List<CoreMap> timeExpressions = this.timexExtractor.extractTimeExpressionCoreMaps(sentence, document);
        if (timeExpressions != null) {
            // empty if block
        }
        return timeExpressions;
    }

    private void moneyAndPercentRecognizer(List<CoreLabel> tokenSequence) {
        for (int i = 0; i < tokenSequence.size(); ++i) {
            CoreLabel prev;
            CoreLabel crt = tokenSequence.get(i);
            CoreLabel next = i < tokenSequence.size() - 1 ? tokenSequence.get(i + 1) : null;
            CoreLabel coreLabel = prev = i > 0 ? tokenSequence.get(i - 1) : null;
            if (CURRENCY_SYMBOL_PATTERN.matcher(crt.word()).matches() && next != null && (((String)next.get(CoreAnnotations.AnswerAnnotation.class)).equals("NUMBER") || "CD".equals(next.tag()))) {
                crt.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                i = this.changeLeftToRight(tokenSequence, i + 1, (String)next.get(CoreAnnotations.AnswerAnnotation.class), next.tag(), "MONEY") - 1;
                continue;
            }
            if ((CURRENCY_WORD_PATTERN.matcher(crt.word()).matches() || CURRENCY_SYMBOL_PATTERN.matcher(crt.word()).matches()) && prev != null && (((String)prev.get(CoreAnnotations.AnswerAnnotation.class)).equals("NUMBER") || "CD".equals(prev.tag())) && !NumberSequenceClassifier.leftScanFindsWeightWord(tokenSequence, i)) {
                crt.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                this.changeRightToLeft(tokenSequence, i - 1, (String)prev.get(CoreAnnotations.AnswerAnnotation.class), prev.tag(), "MONEY");
                continue;
            }
            if (!PERCENT_WORD_PATTERN.matcher(crt.word()).matches() && !PERCENT_SYMBOL_PATTERN.matcher(crt.word()).matches() || prev == null || !((String)prev.get(CoreAnnotations.AnswerAnnotation.class)).equals("NUMBER") && !"CD".equals(prev.tag())) continue;
            crt.set(CoreAnnotations.AnswerAnnotation.class, "PERCENT");
            this.changeRightToLeft(tokenSequence, i - 1, (String)prev.get(CoreAnnotations.AnswerAnnotation.class), prev.tag(), "PERCENT");
        }
    }

    private void ordinalRecognizer(List<CoreLabel> tokenSequence) {
        for (CoreLabel crt : tokenSequence) {
            if (!((String)crt.get(CoreAnnotations.AnswerAnnotation.class)).equals(this.flags.backgroundSymbol) && !((String)crt.get(CoreAnnotations.AnswerAnnotation.class)).equals("NUMBER") || !ORDINAL_PATTERN.matcher(crt.word()).matches()) continue;
            crt.set(CoreAnnotations.AnswerAnnotation.class, "ORDINAL");
        }
    }

    private int changeLeftToRight(List<CoreLabel> tokens, int start, String oldTag, String posTag, String newTag) {
        while (start < tokens.size()) {
            CoreLabel crt = tokens.get(start);
            if (!oldTag.equals(this.flags.backgroundSymbol) && !((String)crt.get(CoreAnnotations.AnswerAnnotation.class)).equals(oldTag) || oldTag.equals(this.flags.backgroundSymbol) && !crt.tag().equals(posTag)) break;
            crt.set(CoreAnnotations.AnswerAnnotation.class, newTag);
            ++start;
        }
        return start;
    }

    private int changeRightToLeft(List<CoreLabel> tokens, int start, String oldTag, String posTag, String newTag) {
        while (start >= 0) {
            CoreLabel crt = tokens.get(start);
            if (!oldTag.equals(this.flags.backgroundSymbol) && !((String)crt.get(CoreAnnotations.AnswerAnnotation.class)).equals(oldTag) || oldTag.equals(this.flags.backgroundSymbol) && !crt.tag().equals(posTag)) break;
            crt.set(CoreAnnotations.AnswerAnnotation.class, newTag);
            --start;
        }
        return start;
    }

    private static List<CoreLabel> copyTokens(List<CoreLabel> srcList, boolean adjustCharacterOffsets, boolean forceCopy) {
        if (!adjustCharacterOffsets && !forceCopy) {
            return srcList;
        }
        ArrayList<CoreLabel> dstList = new ArrayList<CoreLabel>();
        int adjustment = 0;
        int offset = 0;
        for (CoreLabel src : srcList) {
            if (adjustCharacterOffsets) {
                int end;
                int start;
                int wordLength;
                int n = wordLength = src.containsKey(CoreAnnotations.OriginalTextAnnotation.class) ? ((String)src.get(CoreAnnotations.OriginalTextAnnotation.class)).length() : src.word().length();
                if (src.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class) && src.containsKey(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
                    start = (Integer)src.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    end = (Integer)src.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    int origLength = end - start;
                    end = (start += adjustment) + wordLength;
                    dstList.add(NumberSequenceClassifier.copyCoreLabel(src, start, end));
                    adjustment += wordLength - origLength;
                    continue;
                }
                start = offset;
                end = start + wordLength;
                offset = end + 1;
                dstList.add(NumberSequenceClassifier.copyCoreLabel(src, start, end));
                continue;
            }
            dstList.add(NumberSequenceClassifier.copyCoreLabel(src, null, null));
        }
        return dstList;
    }

    public static void transferAnnotations(CoreLabel src, CoreLabel dst) {
        if (src.containsKey(CoreAnnotations.NumericCompositeValueAnnotation.class)) {
            dst.set(CoreAnnotations.NumericCompositeValueAnnotation.class, src.get(CoreAnnotations.NumericCompositeValueAnnotation.class));
        }
        if (src.containsKey(CoreAnnotations.NumericCompositeTypeAnnotation.class)) {
            dst.set(CoreAnnotations.NumericCompositeTypeAnnotation.class, src.get(CoreAnnotations.NumericCompositeTypeAnnotation.class));
        }
        if (src.containsKey(TimeAnnotations.TimexAnnotation.class)) {
            dst.set(TimeAnnotations.TimexAnnotation.class, src.get(TimeAnnotations.TimexAnnotation.class));
        }
    }

    public static List<CoreLabel> copyTokens(List<CoreLabel> srcTokens, CoreMap srcSentence) {
        boolean adjustCharacterOffsets = false;
        if (srcSentence == null || srcSentence.get(CoreAnnotations.TextAnnotation.class) == null || srcTokens.isEmpty() || srcTokens.get(0).get(CoreAnnotations.OriginalTextAnnotation.class) == null) {
            adjustCharacterOffsets = true;
        }
        return NumberSequenceClassifier.copyTokens(srcTokens, adjustCharacterOffsets, true);
    }

    private static CoreLabel copyCoreLabel(CoreLabel src, Integer startOffset, Integer endOffset) {
        CoreLabel dst = new CoreLabel();
        dst.setWord(src.word());
        dst.setTag(src.tag());
        if (src.containsKey(CoreAnnotations.OriginalTextAnnotation.class)) {
            dst.set(CoreAnnotations.OriginalTextAnnotation.class, src.get(CoreAnnotations.OriginalTextAnnotation.class));
        }
        if (startOffset == null) {
            dst.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, src.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
        } else {
            dst.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, startOffset);
        }
        if (endOffset == null) {
            dst.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, src.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        } else {
            dst.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, endOffset);
        }
        NumberSequenceClassifier.transferAnnotations(src, dst);
        return dst;
    }

    private List<CoreLabel> classifyOld(List<CoreLabel> document) {
        PaddedList<CoreMap> pl = new PaddedList<CoreMap>(document, this.pad);
        int sz = pl.size();
        for (int i = 0; i < sz; ++i) {
            CoreLabel me = (CoreLabel)pl.get(i);
            CoreLabel prev = (CoreLabel)pl.get(i - 1);
            CoreLabel next = (CoreLabel)pl.get(i + 1);
            CoreLabel next2 = (CoreLabel)pl.get(i + 2);
            me.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
            if (CURRENCY_SYMBOL_PATTERN.matcher(me.word()).matches() && (prev.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD") || next.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD"))) {
                me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD")) {
                if (TIME_PATTERN.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                    continue;
                }
                if (TIME_PATTERN2.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                    continue;
                }
                if (DATE_PATTERN.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (DATE_PATTERN2.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (next.get(CoreAnnotations.TextAnnotation.class) != null && me.get(CoreAnnotations.TextAnnotation.class) != null && DAY_PATTERN.matcher((CharSequence)me.get(CoreAnnotations.TextAnnotation.class)).matches() && MONTH_PATTERN.matcher((CharSequence)next.get(CoreAnnotations.TextAnnotation.class)).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (prev.get(CoreAnnotations.TextAnnotation.class) != null && MONTH_PATTERN.matcher((CharSequence)prev.get(CoreAnnotations.TextAnnotation.class)).matches() && me.get(CoreAnnotations.TextAnnotation.class) != null && DAY_PATTERN.matcher((CharSequence)me.get(CoreAnnotations.TextAnnotation.class)).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (NumberSequenceClassifier.rightScanFindsMoneyWord(pl, i) && !NumberSequenceClassifier.leftScanFindsWeightWord(pl, i)) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                    continue;
                }
                if (ARMY_TIME_MORNING.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                    continue;
                }
                if (YEAR_PATTERN.matcher(me.word()).matches() && prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("DATE") && (MONTH_PATTERN.matcher(prev.word()).matches() || ((String)((CoreLabel)pl.get(i - 2)).get(CoreAnnotations.AnswerAnnotation.class)).equals("DATE"))) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("MONEY")) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                    continue;
                }
                me.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
                continue;
            }
            if (AM_PM.matcher(me.word()).matches() && ((String)prev.get(CoreAnnotations.AnswerAnnotation.class)).equals("TIME")) {
                me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals(",") && prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("DATE") && next.word() != null && YEAR_PATTERN.matcher(next.word()).matches()) {
                me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP") && MONTH_PATTERN.matcher(me.word()).matches()) {
                if (!prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("DATE") && !next.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD")) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CC")) {
                String wd;
                if (prev.tag() == null || !prev.tag().equals("CD") || next.tag() == null || !next.tag().equals("CD") || me.get(CoreAnnotations.TextAnnotation.class) == null || !((String)me.get(CoreAnnotations.TextAnnotation.class)).equalsIgnoreCase("and") || !(wd = prev.word()).equalsIgnoreCase("hundred") && !wd.equalsIgnoreCase("thousand") && !wd.equalsIgnoreCase("million") && !wd.equalsIgnoreCase("billion") && !wd.equalsIgnoreCase("trillion")) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NN") || me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNS"))) {
                if (CURRENCY_WORD_PATTERN.matcher(me.word()).matches()) {
                    if (!prev.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD") || !prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("MONEY")) continue;
                    me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                    continue;
                }
                if (me.word().equals("m") || me.word().equals("b")) {
                    if (prev.getString(CoreAnnotations.AnswerAnnotation.class).equals("MONEY")) {
                        me.set(CoreAnnotations.AnswerAnnotation.class, "MONEY");
                        continue;
                    }
                    me.set(CoreAnnotations.AnswerAnnotation.class, "NUMBER");
                    continue;
                }
                if (ORDINAL_PATTERN.matcher(me.word()).matches()) {
                    if ((next.word() == null || !MONTH_PATTERN.matcher(next.word()).matches()) && (next.word() == null || !next.word().equalsIgnoreCase("of") || next2.word() == null || !MONTH_PATTERN.matcher(next2.word()).matches())) continue;
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (!GENERIC_TIME_WORDS.matcher(me.word()).matches()) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "TIME");
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("JJ")) {
                if (next.word() != null && MONTH_PATTERN.matcher(next.word()).matches() || next.word() != null && next.word().equalsIgnoreCase("of") && next2.word() != null && MONTH_PATTERN.matcher(next2.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
                    continue;
                }
                if (!ORDINAL_PATTERN.matcher(me.word()).matches()) continue;
                me.set(CoreAnnotations.AnswerAnnotation.class, "ORDINAL");
                continue;
            }
            if (!me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("IN") || !me.word().equalsIgnoreCase("of") || prev.get(CoreAnnotations.TextAnnotation.class) == null || !ORDINAL_PATTERN.matcher((CharSequence)prev.get(CoreAnnotations.TextAnnotation.class)).matches() || next.get(CoreAnnotations.TextAnnotation.class) == null || !MONTH_PATTERN.matcher((CharSequence)next.get(CoreAnnotations.TextAnnotation.class)).matches()) continue;
            me.set(CoreAnnotations.AnswerAnnotation.class, "DATE");
        }
        return document;
    }

    private static boolean leftScanFindsWeightWord(List<CoreLabel> pl, int i) {
        for (int j = i - 1; j >= 0 && j >= i - 3; --j) {
            CoreLabel fl = pl.get(j);
            if (!fl.word().startsWith("weigh")) continue;
            return true;
        }
        return false;
    }

    private static boolean rightScanFindsMoneyWord(List<CoreLabel> pl, int i) {
        int j;
        int sz = pl.size();
        for (j = i; j < sz && pl.get(j).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD"); ++j) {
        }
        if (j >= sz) {
            return false;
        }
        String tag = pl.get(j).getString(CoreAnnotations.PartOfSpeechAnnotation.class);
        String word = pl.get(j).word();
        return (tag.equals("NN") || tag.equals("NNS")) && CURRENCY_WORD_PATTERN.matcher(word).matches();
    }

    @Override
    public void train(Collection<List<CoreLabel>> docs, DocumentReaderAndWriter<CoreLabel> readerAndWriter) {
    }

    @Override
    public void serializeClassifier(String serializePath) {
        log.info("Serializing classifier to " + serializePath + "...");
        log.info("done.");
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        NumberSequenceClassifier nsc = new NumberSequenceClassifier(props, true, props);
        String trainFile = nsc.flags.trainFile;
        String testFile = nsc.flags.testFile;
        String textFile = nsc.flags.textFile;
        String loadPath = nsc.flags.loadClassifier;
        String serializeTo = nsc.flags.serializeTo;
        if (loadPath != null) {
            nsc.loadClassifierNoExceptions(loadPath);
            nsc.flags.setProperties(props);
        } else if (trainFile != null) {
            nsc.train(trainFile);
        }
        if (serializeTo != null) {
            nsc.serializeClassifier(serializeTo);
        }
        if (testFile != null) {
            nsc.classifyAndWriteAnswers(testFile, nsc.makeReaderAndWriter(), true);
        }
        if (textFile != null) {
            PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
            nsc.classifyAndWriteAnswers(textFile, readerAndWriter, false);
        }
    }
}

