/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.configuration.impl;

import de.jollyday.configuration.ConfigurationProvider;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(URLConfigurationProvider.class.getName());

    public Properties getProperties() {
        String[] strConfigURLs;
        Properties properties = new Properties();
        Properties systemProps = System.getProperties();
        String configURLs = systemProps.getProperty("de.jollyday.config.urls");
        if (configURLs != null && (strConfigURLs = configURLs.split(",")) != null) {
            for (String strURL : strConfigURLs) {
                this.readPropertiesFromURL(properties, strURL);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertiesFromURL(Properties properties, String strURL) {
        if (strURL == null || "".equals(strURL)) {
            return;
        }
        InputStream inputStream = null;
        try {
            URL configURL = new URL(strURL.trim());
            inputStream = configURL.openStream();
            properties.load(inputStream);
            this.closeStreamFromURL(strURL, inputStream);
        }
        catch (Exception e) {
            try {
                LOG.log(Level.WARNING, "Cannot read configuration from '" + strURL + "'.", e);
                this.closeStreamFromURL(strURL, inputStream);
            }
            catch (Throwable throwable) {
                this.closeStreamFromURL(strURL, inputStream);
                throw throwable;
            }
        }
    }

    private void closeStreamFromURL(String strURL, InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOG.warning("Cannot close stream for configuration URL " + strURL + ".");
            }
        }
    }
}

