/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.Collection;

public interface Classifier<L, F>
extends Serializable {
    public L classOf(Datum<L, F> var1);

    public Counter<L> scoresOf(Datum<L, F> var1);

    public Collection<L> labels();

    default public Pair<Double, Double> evaluatePrecisionAndRecall(GeneralDataset<L, F> testData, L targetLabel) {
        if (targetLabel == null) {
            throw new IllegalArgumentException("Must supply a target label to compute precision and recall against");
        }
        int numCorrectAndTarget = 0;
        int numTargetGuess = 0;
        int numTargetGold = 0;
        for (RVFDatum<L, F> datum : testData) {
            L label = datum.label();
            if (label == null) {
                throw new IllegalArgumentException("Cannot compute precision and recall on unlabelled dataset. Offending datum: " + datum);
            }
            L guess = this.classOf(datum);
            if (label.equals(targetLabel)) {
                ++numTargetGold;
            }
            if (!guess.equals(targetLabel)) continue;
            ++numTargetGuess;
            if (!guess.equals(label)) continue;
            ++numCorrectAndTarget;
        }
        double precision = numTargetGuess == 0 ? 0.0 : (double)numCorrectAndTarget / (double)numTargetGuess;
        double recall = numTargetGold == 0 ? 1.0 : (double)numCorrectAndTarget / (double)numTargetGold;
        return Pair.makePair(precision, recall);
    }

    default public double evaluateAccuracy(GeneralDataset<L, F> testData) {
        int numCorrect = 0;
        for (RVFDatum<L, F> datum : testData) {
            L label = datum.label();
            if (label == null) {
                throw new IllegalArgumentException("Cannot compute precision and recall on unlabelled dataset. Offending datum: " + datum);
            }
            L guess = this.classOf(datum);
            if (!label.equals(guess)) continue;
            ++numCorrect;
        }
        return (double)numCorrect / (double)testData.size;
    }
}

