/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.io.Lexer;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.JFlexDummyLexer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class LexerTokenizer
extends AbstractTokenizer<String> {
    private final Lexer lexer;

    @Override
    protected String getNext() {
        String token = null;
        try {
            int a = 0;
            while (a == 0) {
                a = this.lexer.yylex();
            }
            if (a != this.lexer.getYYEOF()) {
                token = this.lexer.yytext();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return token;
    }

    public LexerTokenizer(Lexer l) {
        if (l == null) {
            throw new IllegalArgumentException("You can't make a Tokenizer out of a null Lexer!");
        }
        this.lexer = l;
    }

    public LexerTokenizer(Lexer l, Reader r) {
        this(l);
        try {
            l.yyreset(r);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage());
        }
        this.getNext();
    }

    public static void main(String[] args) throws IOException {
        LexerTokenizer t = new LexerTokenizer(new JFlexDummyLexer(null), new BufferedReader(new FileReader(args[0])));
        while (t.hasNext()) {
            System.out.println("token " + (String)t.next());
        }
    }
}

