/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;

class ExtractorWordShapeConjunction
extends Extractor {
    private static final long serialVersionUID = -49L;
    private final int wordShaper;
    private final int left;
    private final int right;
    private final String name;

    ExtractorWordShapeConjunction(int left, int right, String wsc) {
        this.left = left;
        this.right = right;
        this.wordShaper = WordShapeClassifier.lookupShaper(wsc);
        this.name = "ExtractorWordShapeConjunction(" + left + ',' + right + ',' + wsc + ')';
    }

    @Override
    String extract(History h, PairsHolder pH) {
        StringBuilder sb = new StringBuilder();
        for (int j = this.left; j <= this.right; ++j) {
            String s = pH.getWord(h, j);
            sb.append(WordShapeClassifier.wordShape(s, this.wordShaper));
            if (j >= this.right) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

