/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ChineseGrammaticalRelations {
    private static final TregexPatternCompiler tregexCompiler = new TregexPatternCompiler((HeadFinder)null);
    public static final ReadWriteLock valuesLock = new ReentrantReadWriteLock();
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(Language.Chinese, "arg", "argument", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(Language.Chinese, "conj", "conjunct", GrammaticalRelation.DEPENDENT, "FRAG|INC|IP|VP|NP|ADJP|PP|ADVP|UCP", tregexCompiler, "NP|ADJP|PP|ADVP|UCP < (!PU=target $+ CC)", "VP < (!PU=target !$- VP $+ CC)", "VP|NP|ADJP|PP|ADVP|UCP < ( __=target $+ PU $+ CC)", "VP   < ( /^V/=target  $+ ((PU < \u3001) $+ /^V/))", "NP   < ( /^N/=target  $+ ((PU < \u3001) $+ /^N/))", "ADJP < ( JJ|ADJP=target  $+ ((PU < \u3001) $+ JJ|ADJP))", "PP   < ( /^P/=target  $+ ((PU < \u3001) $+ /^P/))", "ADVP < ( /^AD/ $+ ((PU < \u3001) $+ /^AD/=target))", "UCP  < ( __=target    $+ (PU < \u3001) )", "PP < (PP $+ PP=target )", "NP <( NP=target $+ ((PU < \u3001) $+ NP) )", "NP <( NN|NR|NT|PN=target $+ ((PU < \uff0c|\u3001) $+ NN|NR|NT|PN) )", "VP < (CC $+ VV=target)", "FRAG|INC|IP|VP < (VP  < VV|VC|VRD|VCD|VE|VA < NP|QP|LCP  $ IP|VP|VRD|VCD|VE|VC|VA=target)  ", "IP|VP < ( IP|VP < NP|QP|LCP $ IP|VP=target )");
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(Language.Chinese, "cop", "copula", GrammaticalRelation.DEPENDENT, "VP", tregexCompiler, " VP < VC=target");
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(Language.Chinese, "cc", "coordination", GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP", tregexCompiler, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP < (CC=target)");
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(Language.Chinese, "punct", "punctuation", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ < PU=target");
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(Language.Chinese, "subj", "subject", ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(Language.Chinese, "nsubj", "nominal subject", SUBJECT, "IP|VP", tregexCompiler, "IP <( ( NP|QP=target!< NT ) $++ ( /^VP|VCD|IP/  !< VE !<VC !<SB !<LB  ))", "NP !$+ VP < ( (  NP|DP|QP=target !< NT ) $+ ( /^VP|VCD/ !<VE !< VC !<SB !<LB))");
    public static final GrammaticalRelation TOP_SUBJECT = new GrammaticalRelation(Language.Chinese, "top", "topic", SUBJECT, "IP|VP", tregexCompiler, "IP|VP < ( NP|DP=target $+ ( VP < VC|VE ) )", "IP < (IP=target $+ ( VP < VC|VE))");
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.Chinese, "nsubjpass", "nominal passive subject", NOMINAL_SUBJECT, "IP", tregexCompiler, "IP < (NP=target $+ (VP|IP < SB|LB))");
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(Language.Chinese, "csubj", "clausal subject", SUBJECT, "IP", tregexCompiler, new String[0]);
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(Language.Chinese, "comp", "complement", ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation(Language.Chinese, "obj", "object", COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(Language.Chinese, "dobj", "direct object", OBJECT, "CP|VP", tregexCompiler, "VP < ( /^V*/ $+ NP $+ NP|DP=target ) !< VC ", " VP < ( /^V*/ $+ NP|DP=target ! $+ NP|DP) !< VC ", "CP < (IP $++ NP=target ) !<< VC");
    public static final GrammaticalRelation RANGE = new GrammaticalRelation(Language.Chinese, "range", "range", OBJECT, "VP", tregexCompiler, " VP < ( NP|DP|QP $+ NP|DP|QP=target)", "VP < ( VV $+ QP=target )");
    public static final GrammaticalRelation PREPOSITIONAL_OBJECT = new GrammaticalRelation(Language.Chinese, "pobj", "prepositional object", OBJECT, "^PP", tregexCompiler, "/^PP/ < /^P/ < /^NP|^DP|QP/=target");
    public static final GrammaticalRelation TIME_POSTPOSITION = new GrammaticalRelation(Language.Chinese, "lobj", "localizer object", OBJECT, "LCP", tregexCompiler, "LCP < ( NP|QP|DP=target $+ LC)");
    public static final GrammaticalRelation ATTRIBUTIVE = new GrammaticalRelation(Language.Chinese, "attr", "attributive", COMPLEMENT, "VP", tregexCompiler, "VP < /^VC$/ < NP|QP=target");
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.Chinese, "ccomp", "clausal complement", COMPLEMENT, "VP|ADJP|IP", tregexCompiler, "  VP  < VV|VC|VRD|VCD  !< NP|QP|LCP  < IP|VP|VRD|VCD=target > IP|VP ");
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.Chinese, "xcomp", "xclausal complement", COMPLEMENT, "VP|ADJP", tregexCompiler, new String[0]);
    public static final GrammaticalRelation COMPLEMENTIZER = new GrammaticalRelation(Language.Chinese, "cpm", "complementizer", COMPLEMENT, "^CP", tregexCompiler, "/^CP/ < (__  $++ DEC=target)");
    public static final GrammaticalRelation LC_COMPLEMENT = new GrammaticalRelation(Language.Chinese, "loc", "localizer complement", COMPLEMENT, "VP|IP", tregexCompiler, "VP|IP < LCP=target ");
    public static final GrammaticalRelation RES_VERB = new GrammaticalRelation(Language.Chinese, "rcomp", "result verb", COMPLEMENT, "VRD", tregexCompiler, "VRD < ( /V*/ $+ /V*/=target )");
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(Language.Chinese, "mod", "modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation VERB_COMPOUND = new GrammaticalRelation(Language.Chinese, "comod", "coordinated verb compound", MODIFIER, "VCD", tregexCompiler, "VCD < ( VV|VA $+  VV|VA=target)");
    public static final GrammaticalRelation MODAL_VERB = new GrammaticalRelation(Language.Chinese, "mmod", "modal verb", MODIFIER, "VP", tregexCompiler, "VP < ( VV=target !< /^\u6ca1\u6709$/ $+ VP|VRD )");
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(Language.Chinese, "pass", "passive", MODIFIER, "VP", tregexCompiler, "VP < SB|LB=target");
    public static final GrammaticalRelation BA = new GrammaticalRelation(Language.Chinese, "ba", "ba", GrammaticalRelation.DEPENDENT, "VP|IP", tregexCompiler, "VP|IP < BA=target ");
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "tmod", "temporal modifier", MODIFIER, "VP|IP", tregexCompiler, "VP|IP < (NP=target < NT !.. /^VC$/ $++  VP)");
    public static final GrammaticalRelation TIME = new GrammaticalRelation(Language.Chinese, "lccomp", "clausal complement of localizer", MODIFIER, "LCP", tregexCompiler, "/LCP/ < ( IP=target $+ LC )");
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation(Language.Chinese, "rcmod", "relative clause modifier", MODIFIER, "NP", tregexCompiler, "NP  $++ (CP=target ) > NP ", "NP  < ( CP=target $++ NP  )");
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(Language.Chinese, "nummod", "numeric modifier", MODIFIER, "QP|NP", tregexCompiler, "QP < CD=target", "NP < ( QP=target !<< CLP )");
    public static final GrammaticalRelation ODNUMERIC_MODIFIER = new GrammaticalRelation(Language.Chinese, "ordmod", "numeric modifier", MODIFIER, "NP|QP", tregexCompiler, "NP < QP=target < ( OD !$+ CLP )", "QP < (OD=target $+ CLP)");
    public static final GrammaticalRelation NUMBER_MODIFIER = new GrammaticalRelation(Language.Chinese, "clf", "classifier modifier", MODIFIER, "^NP|DP|QP", tregexCompiler, "NP|QP < ( QP  =target << M $++ NN|NP|QP)", "DP < ( DT $+ CLP=target )");
    public static final GrammaticalRelation NOUN_COMPOUND_MODIFIER = new GrammaticalRelation(Language.Chinese, "nn", "nn modifier", MODIFIER, "^NP", tregexCompiler, "NP < (NN|NR|NT=target $+ NN|NR|NT)", "NP < (NN|NR|NT $+ FW=target)", " NP <  (NP=target !$+ PU|CC $++ NP|PRN )");
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "amod", "adjectival modifier", MODIFIER, "NP|CLP|QP", tregexCompiler, "NP|CLP|QP < (ADJP=target $++ NP|CLP|QP ) ");
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "advmod", "adverbial modifier", MODIFIER, "VP|ADJP|IP|CP|PP|NP|QP", tregexCompiler, "VP|ADJP|IP|CP|PP|NP < (ADVP=target !< (AD < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/))", "VP|ADJP < AD|CS=target", "QP < (ADVP=target $+ QP)", "QP < ( QP $+ ADVP=target)");
    public static final GrammaticalRelation IP_MODIFIER = new GrammaticalRelation(Language.Chinese, "vmod", "participle modifier", MODIFIER, "NP", tregexCompiler, "NP < IP=target ");
    public static final GrammaticalRelation PRN_MODIFIER = new GrammaticalRelation(Language.Chinese, "prnmod", "prn odifier", MODIFIER, "NP", tregexCompiler, "NP < PRN=target ");
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(Language.Chinese, "neg", "negation modifier", ADVERBIAL_MODIFIER, "VP|ADJP|IP", tregexCompiler, "VP|ADJP|IP < (AD|VV=target < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/)", "VP|ADJP|IP < (ADVP|VV=target < (AD < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/))");
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(Language.Chinese, "det", "determiner", MODIFIER, "^NP|DP", tregexCompiler, "/^NP/ < (DP=target $++ NP )");
    public static final GrammaticalRelation DVP_MODIFIER = new GrammaticalRelation(Language.Chinese, "dvpm", "dvp marker", MODIFIER, "DVP", tregexCompiler, "DVP < (__ $+ DEV=target ) ");
    public static final GrammaticalRelation DVPM_MODIFIER = new GrammaticalRelation(Language.Chinese, "dvpmod", "dvp modifier", MODIFIER, "VP", tregexCompiler, " VP < ( DVP=target $+ VP) ");
    public static final GrammaticalRelation ASSOCIATIVE_MODIFIER = new GrammaticalRelation(Language.Chinese, "assm", "associative marker", MODIFIER, "DNP", tregexCompiler, " DNP < ( __ $+ DEG=target ) ");
    public static final GrammaticalRelation ASSOCIATIVEM_MODIFIER = new GrammaticalRelation(Language.Chinese, "assmod", "associative modifier", MODIFIER, "NP|QP", tregexCompiler, "NP|QP < ( DNP =target $++ NP|QP ) ");
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.Chinese, "prep", "prepositional modifier", MODIFIER, "^NP|VP|IP", tregexCompiler, "/^NP/ < /^PP/=target", "VP < /^PP/=target", "IP < /^PP/=target ");
    public static final GrammaticalRelation CL_MODIFIER = new GrammaticalRelation(Language.Chinese, "pccomp", "clause complement of a preposition", MODIFIER, "^PP|IP", tregexCompiler, "PP < (P $+ IP|VP =target)", "IP < (CP=target $++ VP)");
    public static final GrammaticalRelation PREPOSITIONAL_LOC_MODIFIER = new GrammaticalRelation(Language.Chinese, "plmod", "prepositional localizer modifier", MODIFIER, "PP", tregexCompiler, "PP < ( P $++ LCP=target )");
    public static final GrammaticalRelation PREDICATE_ASPECT = new GrammaticalRelation(Language.Chinese, "asp", "aspect", MODIFIER, "VP", tregexCompiler, "VP < ( /^V*/ $+ AS=target)");
    public static final GrammaticalRelation PART_VERB = new GrammaticalRelation(Language.Chinese, "prtmod", "particle verb", MODIFIER, "VP|IP", tregexCompiler, "VP|IP < ( MSP=target )");
    public static final GrammaticalRelation ETC = new GrammaticalRelation(Language.Chinese, "etc", "ETC", MODIFIER, "^NP", tregexCompiler, "/^NP/ < (NN|NR . ETC=target)");
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation(Language.Chinese, "sdep", "semantic dependent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONTROLLED_SUBJECT = new GrammaticalRelation(Language.Chinese, "xsubj", "controlled subject", SEMANTIC_DEPENDENT, "VP", tregexCompiler, "VP !< NP < VP > (IP !$- NP !< NP !>> (VP < VC ) >+(VP) (VP $-- NP=target))");
    private static final GrammaticalRelation[] rawValues = new GrammaticalRelation[]{ADJECTIVAL_MODIFIER, ADVERBIAL_MODIFIER, ARGUMENT, ASSOCIATIVEM_MODIFIER, ASSOCIATIVE_MODIFIER, ATTRIBUTIVE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, BA, CLAUSAL_COMPLEMENT, CLAUSAL_SUBJECT, CL_MODIFIER, COMPLEMENT, COMPLEMENTIZER, CONJUNCT, CONTROLLED_SUBJECT, COORDINATION, GrammaticalRelation.DEPENDENT, DETERMINER, DIRECT_OBJECT, DVPM_MODIFIER, DVP_MODIFIER, ETC, GrammaticalRelation.GOVERNOR, IP_MODIFIER, LC_COMPLEMENT, MODAL_VERB, MODIFIER, NEGATION_MODIFIER, NOMINAL_PASSIVE_SUBJECT, NOMINAL_SUBJECT, NOUN_COMPOUND_MODIFIER, NUMBER_MODIFIER, NUMERIC_MODIFIER, OBJECT, ODNUMERIC_MODIFIER, PART_VERB, PREDICATE_ASPECT, PREPOSITIONAL_LOC_MODIFIER, PREPOSITIONAL_MODIFIER, PREPOSITIONAL_OBJECT, PRN_MODIFIER, PUNCTUATION, RANGE, RELATIVE_CLAUSE_MODIFIER, RES_VERB, SEMANTIC_DEPENDENT, SUBJECT, TEMPORAL_MODIFIER, TIME, TIME_POSTPOSITION, TOP_SUBJECT, VERB_COMPOUND, XCLAUSAL_COMPLEMENT};
    private static final List<GrammaticalRelation> values = new ArrayList<GrammaticalRelation>();
    private static final List<GrammaticalRelation> synchronizedValues = Collections.synchronizedList(values);
    public static final Set<GrammaticalRelation> universalValues = new HashSet<GrammaticalRelation>();
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();

    private ChineseGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return Collections.unmodifiableList(values);
    }

    public static Lock valuesLock() {
        return valuesLock.readLock();
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, ChineseGrammaticalRelations.values(), ChineseGrammaticalRelations.valuesLock());
    }

    static {
        for (int i = 0; i < rawValues.length; ++i) {
            GrammaticalRelation gr = rawValues[i];
            synchronizedValues.add(gr);
        }
        ChineseGrammaticalRelations.valuesLock().lock();
        try {
            for (GrammaticalRelation gr : ChineseGrammaticalRelations.values()) {
                shortNameToGRel.put(gr.getShortName(), gr);
            }
        }
        finally {
            ChineseGrammaticalRelations.valuesLock().unlock();
        }
    }
}

