/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.trees.international.pennchinese.RadicalMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NERFeatureFactory<IN extends CoreLabel>
extends FeatureFactory<IN> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NERFeatureFactory.class);
    private static final long serialVersionUID = -2329726064739185544L;
    private Map<String, String> lexicon;
    private Map<String, Collection<String>> wordToSubstrings = Generics.newHashMap();
    private static final Pattern ordinalPattern = Pattern.compile("(?:(?:first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twenty|twentieth|thirty|thirtieth|forty|fortieth|fifty|fiftieth|sixty|sixtieth|seventy|seventieth|eighty|eightieth|ninety|ninetieth|one|two|three|four|five|six|seven|eight|nine|hundred|hundredth)-?)+|[0-9]+(?:st|nd|rd|th)", 2);
    private static final Pattern numberPattern = Pattern.compile("[0-9]+");
    private static final Pattern ordinalEndPattern = Pattern.compile("(?:st|nd|rd|th)", 2);
    private Map<String, Collection<String>> wordToGazetteEntries = Generics.newHashMap();
    private Map<String, Collection<GazetteInfo>> wordToGazetteInfos = Generics.newHashMap();
    private Set<Class<? extends CoreLabel.GenericAnnotation<?>>> genericAnnotationKeys;
    private Set<String> lastNames;
    private Set<String> maleNames;
    private Set<String> femaleNames;
    private final Pattern titlePattern = Pattern.compile("(?:Mr|Ms|Mrs|Dr|Miss|Sen|Judge|Sir)\\.?");
    private static final Pattern titlePattern2 = Pattern.compile("(?i:Mr|Mrs|Ms|Miss|Drs?|Profs?|Sens?|Reps?|Attys?|Lt|Col|Gen|Messrs|Govs?|Adm|Rev|Maj|Sgt|Cpl|Pvt|Capt|Ste?|Ave|Pres|Lieut|Hon|Brig|Co?mdr|Pfc|Spc|Supts?|Det|Mt|Ft|Adj|Adv|Asst|Assoc|Ens|Insp|Mlle|Mme|Msgr|Sfc)\\.?");
    private static final Pattern splitSlashHyphenWordsPattern = Pattern.compile("[-/]");

    @Override
    public void init(SeqClassifierFlags flags) {
        super.init(flags);
        this.initGazette();
        if (flags.useDistSim) {
            this.initLexicon(flags);
        }
    }

    @Override
    public Collection<String> getCliqueFeatures(PaddedList<IN> cInfo, int loc, Clique clique) {
        Set<String> features = Generics.newHashSet(100);
        FeatureCollector c = new FeatureCollector(features);
        String domain = (String)((CoreLabel)cInfo.get(0)).get(CoreAnnotations.DomainAnnotation.class);
        c.setDomain(domain);
        if (clique == cliqueC) {
            this.featuresC(cInfo, loc, c);
        } else if (clique == cliqueCpC) {
            this.featuresCpC(cInfo, loc, c);
            this.featuresCnC(cInfo, loc - 1, c);
        } else if (clique == cliqueCp2C) {
            this.featuresCp2C(cInfo, loc, c);
        } else if (clique == cliqueCp3C) {
            this.featuresCp3C(cInfo, loc, c);
        } else if (clique == cliqueCp4C) {
            this.featuresCp4C(cInfo, loc, c);
        } else if (clique == cliqueCp5C) {
            this.featuresCp5C(cInfo, loc, c);
        } else if (clique == cliqueCpCp2C) {
            this.featuresCpCp2C(cInfo, loc, c);
            this.featuresCpCnC(cInfo, loc - 1, c);
        } else if (clique == cliqueCpCp2Cp3C) {
            this.featuresCpCp2Cp3C(cInfo, loc, c);
        } else if (clique == cliqueCpCp2Cp3Cp4C) {
            this.featuresCpCp2Cp3Cp4C(cInfo, loc, c);
        } else {
            throw new IllegalArgumentException("Unknown clique: " + clique);
        }
        return features;
    }

    private void initLexicon(SeqClassifierFlags flags) {
        if (flags.distSimLexicon == null) {
            return;
        }
        if (this.lexicon != null) {
            return;
        }
        Timing timing = new Timing();
        Interner<String> interner = new Interner<String>();
        this.lexicon = Generics.newHashMap(10000);
        boolean terryKoo = "terryKoo".equals(flags.distSimFileFormat);
        Pattern p = Pattern.compile(terryKoo ? "\\t" : "\\s+");
        for (String line : ObjectBank.getLineIterator(flags.distSimLexicon, flags.inputEncoding)) {
            String wordClass;
            String word;
            String[] bits;
            if (terryKoo) {
                bits = p.split(line);
                word = bits[1];
                wordClass = bits[0];
                if (flags.distSimMaxBits > 0 && wordClass.length() > flags.distSimMaxBits) {
                    wordClass = wordClass.substring(0, flags.distSimMaxBits);
                }
            } else {
                bits = p.split(line);
                word = bits[0];
                wordClass = bits[1];
            }
            if (!flags.casedDistSim) {
                word = word.toLowerCase();
            }
            if (flags.numberEquivalenceDistSim) {
                word = WordShapeClassifier.wordShape(word, 13);
            }
            this.lexicon.put(word, interner.intern(wordClass));
        }
        timing.done(log, "Loading distsim lexicon from " + flags.distSimLexicon);
    }

    public String describeDistsimLexicon() {
        if (this.lexicon == null) {
            return "No distsim lexicon";
        }
        return "Distsim lexicon of size " + this.lexicon.size();
    }

    private void distSimAnnotate(PaddedList<IN> info) {
        for (CoreLabel fl : info) {
            String distSim;
            if (fl.containsKey(CoreAnnotations.DistSimAnnotation.class)) {
                return;
            }
            String word = this.getWord(fl);
            if (!this.flags.casedDistSim) {
                word = word.toLowerCase();
            }
            if (this.flags.numberEquivalenceDistSim) {
                word = WordShapeClassifier.wordShape(word, 13);
            }
            if ((distSim = this.lexicon.get(word)) == null) {
                distSim = this.flags.unknownWordDistSimClass;
            }
            fl.set(CoreAnnotations.DistSimAnnotation.class, distSim);
        }
    }

    public void clearMemory() {
        this.wordToSubstrings = Generics.newHashMap();
        this.lexicon = null;
    }

    private static String dehyphenate(String str) {
        String retStr = str;
        int leng = str.length();
        int hyphen = 2;
        do {
            if ((hyphen = retStr.indexOf(45, hyphen)) >= 0 && hyphen < leng - 2) {
                retStr = retStr.substring(0, hyphen) + retStr.substring(hyphen + 1);
                continue;
            }
            hyphen = -1;
        } while (hyphen >= 0);
        return retStr;
    }

    private static String greekify(String str) {
        String pattern = "(alpha)|(beta)|(gamma)|(delta)|(epsilon)|(zeta)|(kappa)|(lambda)|(rho)|(sigma)|(tau)|(upsilon)|(omega)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.replaceAll("~");
    }

    private static boolean isNameCase(String str) {
        if (str.length() < 2) {
            return false;
        }
        if (!Character.isUpperCase(str.charAt(0)) && !Character.isTitleCase(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean noUpperCase(String str) {
        if (str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasLetter(String str) {
        if (str.length() < 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isOrdinal(List<? extends CoreLabel> wordInfos, int pos) {
        CoreLabel p;
        CoreLabel c = wordInfos.get(pos);
        String cWord = this.getWord(c);
        Matcher m = ordinalPattern.matcher(cWord);
        if (m.matches()) {
            return true;
        }
        m = numberPattern.matcher(cWord);
        if (m.matches()) {
            CoreLabel n;
            return pos + 1 < wordInfos.size() && (m = ordinalEndPattern.matcher(this.getWord(n = wordInfos.get(pos + 1)))).matches();
        }
        m = ordinalEndPattern.matcher(cWord);
        if (m.matches() && pos > 0 && (m = numberPattern.matcher(this.getWord(p = wordInfos.get(pos - 1)))).matches()) {
            return true;
        }
        if (cWord.equals("-") && pos + 1 < wordInfos.size() && pos > 0) {
            p = wordInfos.get(pos - 1);
            CoreLabel n = wordInfos.get(pos + 1);
            m = ordinalPattern.matcher(this.getWord(p));
            if (m.matches() && (m = ordinalPattern.matcher(this.getWord(n))).matches()) {
                return true;
            }
        }
        return false;
    }

    private void readGazette(BufferedReader in) throws IOException {
        String line;
        Pattern p = Pattern.compile("^(\\S+)\\s+(.+)$");
        while ((line = in.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String type = this.intern(m.group(1));
            String phrase = m.group(2);
            String[] words = phrase.split(" ");
            for (int i = 0; i < words.length; ++i) {
                String word = this.intern(words[i]);
                if (this.flags.sloppyGazette) {
                    Collection<String> entries = this.wordToGazetteEntries.get(word);
                    if (entries == null) {
                        entries = Generics.newHashSet();
                        this.wordToGazetteEntries.put(word, entries);
                    }
                    String feature = this.intern(type + "-GAZ" + words.length);
                    entries.add(feature);
                    feature = this.intern(type + "-GAZ");
                    entries.add(feature);
                }
                if (!this.flags.cleanGazette) continue;
                Collection<GazetteInfo> infos = this.wordToGazetteInfos.get(word);
                if (infos == null) {
                    infos = Generics.newHashSet();
                    this.wordToGazetteInfos.put(word, infos);
                }
                GazetteInfo info = new GazetteInfo(this.intern(type + "-GAZ" + words.length), i, words);
                infos.add(info);
                info = new GazetteInfo(this.intern(type + "-GAZ"), i, words);
                infos.add(info);
            }
        }
    }

    private void makeGenericKeyCache(CoreLabel c) {
        this.genericAnnotationKeys = Generics.newHashSet();
        for (Class<?> key : c.keySet()) {
            if (!CoreLabel.genericValues.containsKey(key)) continue;
            Class<?> genKey = key;
            this.genericAnnotationKeys.add(genKey);
        }
    }

    private void generateSlashHyphenFeatures(String word, String fragSuffix, String wordSuffix, FeatureCollector out2) {
        String[] bits;
        for (String bit : bits = splitSlashHyphenWordsPattern.split(word)) {
            if (this.flags.slashHyphenTreatment == SeqClassifierFlags.SlashHyphenEnum.WFRAG) {
                out2.build().append(bit).append(fragSuffix).add();
                continue;
            }
            if (this.flags.slashHyphenTreatment == SeqClassifierFlags.SlashHyphenEnum.BOTH) {
                out2.build().append(bit).append(fragSuffix).add();
                out2.build().append(bit).append(wordSuffix).add();
                continue;
            }
            out2.build().append(bit).append(wordSuffix).add();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void featuresC(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        out2.setSuffix("C");
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel n = (CoreLabel)cInfo.get(loc + 1);
        CoreLabel n2 = (CoreLabel)cInfo.get(loc + 2);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String nWord = this.getWord(n);
        String cShape = c.getString(CoreAnnotations.ShapeAnnotation.class);
        String pShape = p.getString(CoreAnnotations.ShapeAnnotation.class);
        String nShape = n.getString(CoreAnnotations.ShapeAnnotation.class);
        if (this.flags.useDistSim) {
            this.distSimAnnotate(cInfo);
        }
        if (this.flags.useBagOfWords) {
            for (CoreLabel coreLabel : cInfo) {
                out2.build().append(this.getWord(coreLabel)).append("-BAGOFWORDS").add();
            }
        }
        if (this.flags.useDistSim && this.flags.useMoreTags) {
            out2.build().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append(cWord).append("-PDISTSIM-CWORD").add();
        }
        if (this.flags.useDistSim) {
            out2.build().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM").add();
        }
        if (this.flags.useTitle) {
            if (this.titlePattern.matcher(cWord).matches()) {
                out2.add("IS_TITLE");
            }
        } else if (this.flags.useTitle2 && titlePattern2.matcher(cWord).matches()) {
            out2.add("IS_TITLE");
        }
        if (this.flags.slashHyphenTreatment != SeqClassifierFlags.SlashHyphenEnum.NONE && this.flags.useWord) {
            this.generateSlashHyphenFeatures(cWord, "-WFRAG", "-WORD", out2);
        }
        if (this.flags.useInternal && this.flags.useExternal) {
            String lem;
            if (this.flags.useWord) {
                out2.build().append(cWord).append("-WORD").add();
            }
            if (this.flags.use2W) {
                out2.build().append(this.getWord(p2)).append("-P2W").add();
                out2.build().append(this.getWord(n2)).append("-N2W").add();
            }
            if (this.flags.useLC) {
                out2.build().append(cWord.toLowerCase()).append("-CL").add();
                out2.build().append(pWord.toLowerCase()).append("-PL").add();
                out2.build().append(nWord.toLowerCase()).append("-NL").add();
            }
            if (this.flags.useUnknown) {
                out2.build().append((String)c.get(CoreAnnotations.UnknownAnnotation.class)).append("-UNKNOWN").add();
                out2.build().append((String)p.get(CoreAnnotations.UnknownAnnotation.class)).append("-PUNKNOWN").add();
                out2.build().append((String)n.get(CoreAnnotations.UnknownAnnotation.class)).append("-NUNKNOWN").add();
            }
            if (this.flags.useLemmas && !(lem = c.getString(CoreAnnotations.LemmaAnnotation.class)).isEmpty()) {
                out2.build().append(lem).append("-LEM").add();
            }
            if (this.flags.usePrevNextLemmas) {
                Iterator<String> plem = p.getString(CoreAnnotations.LemmaAnnotation.class);
                String string = n.getString(CoreAnnotations.LemmaAnnotation.class);
                if (!((String)((Object)plem)).isEmpty()) {
                    out2.build().append((String)((Object)plem)).append("-PLEM").add();
                }
                if (!string.isEmpty()) {
                    out2.build().append(string).append("-NLEM").add();
                }
            }
            if (this.flags.checkNameList) {
                try {
                    String name;
                    if (this.lastNames == null) {
                        this.lastNames = Generics.newHashSet();
                        for (String string : ObjectBank.getLineIterator(this.flags.lastNameList)) {
                            this.lastNames.add(string.split("\\s+")[0]);
                        }
                    }
                    if (this.maleNames == null) {
                        this.maleNames = Generics.newHashSet();
                        for (String string : ObjectBank.getLineIterator(this.flags.maleNameList)) {
                            this.maleNames.add(string.split("\\s+")[0]);
                        }
                    }
                    if (this.femaleNames == null) {
                        this.femaleNames = Generics.newHashSet();
                        for (String string : ObjectBank.getLineIterator(this.flags.femaleNameList)) {
                            this.femaleNames.add(string.split("\\s+")[0]);
                        }
                    }
                    if (this.lastNames.contains(name = cWord.toUpperCase())) {
                        out2.add("LAST_NAME");
                    }
                    if (this.maleNames.contains(name)) {
                        out2.add("MALE_NAME");
                    }
                    if (this.femaleNames.contains(name)) {
                        out2.add("FEMALE_NAME");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.flags.binnedLengths != null) {
                int n3;
                int n4;
                int len = cWord.length();
                int n5 = -1;
                int end = -1;
                for (int i = 0; i < this.flags.binnedLengths.length; ++i) {
                    if (len > this.flags.binnedLengths[i]) continue;
                    n4 = i == 0 ? 1 : this.flags.binnedLengths[i - 1];
                    end = this.flags.binnedLengths[i];
                    break;
                }
                if (n4 < 0) {
                    n3 = this.flags.binnedLengths[this.flags.binnedLengths.length - 1];
                }
                out2.build().append("Len-").append(Integer.toString(n3)).dash().append(end > 0 ? Integer.toString(end) : "Inf").add();
            }
            if (this.flags.useABGENE) {
                out2.build().append((String)c.get(CoreAnnotations.AbgeneAnnotation.class)).append("-ABGENE").add();
                out2.build().append((String)p.get(CoreAnnotations.AbgeneAnnotation.class)).append("-PABGENE").add();
                out2.build().append((String)n.get(CoreAnnotations.AbgeneAnnotation.class)).append("-NABGENE").add();
            }
            if (this.flags.useABSTRFreqDict) {
                out2.build().append((String)c.get(CoreAnnotations.AbstrAnnotation.class)).append("-ABSTRACT").append((String)c.get(CoreAnnotations.FreqAnnotation.class)).append("-FREQ").append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
                out2.build().append((String)c.get(CoreAnnotations.AbstrAnnotation.class)).append("-ABSTRACT").append((String)c.get(CoreAnnotations.DictAnnotation.class)).append("-DICT").append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
                out2.build().append((String)c.get(CoreAnnotations.AbstrAnnotation.class)).append("-ABSTRACT").append((String)c.get(CoreAnnotations.DictAnnotation.class)).append("-DICT").append((String)c.get(CoreAnnotations.FreqAnnotation.class)).append("-FREQ").append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
            }
            if (this.flags.useABSTR) {
                out2.build().append((String)c.get(CoreAnnotations.AbstrAnnotation.class)).append("-ABSTRACT").add();
                out2.build().append((String)p.get(CoreAnnotations.AbstrAnnotation.class)).append("-PABSTRACT").add();
                out2.build().append((String)n.get(CoreAnnotations.AbstrAnnotation.class)).append("-NABSTRACT").add();
            }
            if (this.flags.useGENIA) {
                out2.build().append((String)c.get(CoreAnnotations.GeniaAnnotation.class)).append("-GENIA").add();
                out2.build().append((String)p.get(CoreAnnotations.GeniaAnnotation.class)).append("-PGENIA").add();
                out2.build().append((String)n.get(CoreAnnotations.GeniaAnnotation.class)).append("-NGENIA").add();
            }
            if (this.flags.useWEBFreqDict) {
                out2.build().append((String)c.get(CoreAnnotations.WebAnnotation.class)).append("-WEB").append((String)c.get(CoreAnnotations.FreqAnnotation.class)).append("-FREQ").append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
                out2.build().append((String)c.get(CoreAnnotations.WebAnnotation.class)).append("-WEB").append((String)c.get(CoreAnnotations.DictAnnotation.class)).append("-DICT").append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
                out2.build().append((String)c.get(CoreAnnotations.WebAnnotation.class)).append("-WEB").append((String)c.get(CoreAnnotations.DictAnnotation.class)).append("-DICT").append((String)c.get(CoreAnnotations.FreqAnnotation.class)).append("-FREQ").append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
            }
            if (this.flags.useWEB) {
                out2.build().append((String)c.get(CoreAnnotations.WebAnnotation.class)).append("-WEB").add();
                out2.build().append((String)p.get(CoreAnnotations.WebAnnotation.class)).append("-PWEB").add();
                out2.build().append((String)n.get(CoreAnnotations.WebAnnotation.class)).append("-NWEB").add();
            }
            if (this.flags.useIsURL) {
                out2.build().append((String)c.get(CoreAnnotations.IsURLAnnotation.class)).append("-ISURL").add();
            }
            if (this.flags.useEntityRule) {
                out2.build().append((String)c.get(CoreAnnotations.EntityRuleAnnotation.class)).append("-ENTITYRULE").add();
            }
            if (this.flags.useEntityTypes) {
                out2.build().append((String)c.get(CoreAnnotations.EntityTypeAnnotation.class)).append("-ENTITYTYPE").add();
            }
            if (this.flags.useIsDateRange) {
                out2.build().append((String)c.get(CoreAnnotations.IsDateRangeAnnotation.class)).append("-ISDATERANGE").add();
            }
            if (this.flags.useABSTRFreq) {
                out2.build().append((String)c.get(CoreAnnotations.AbstrAnnotation.class)).append("-ABSTRACT").append((String)c.get(CoreAnnotations.FreqAnnotation.class)).append("-FREQ").add();
            }
            if (this.flags.useFREQ) {
                out2.build().append((String)c.get(CoreAnnotations.FreqAnnotation.class)).append("-FREQ").add();
            }
            if (this.flags.useMoreTags) {
                out2.build().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(cWord).append("-PTAG-CWORD").add();
            }
            if (this.flags.usePosition) {
                out2.build().append((String)c.get(CoreAnnotations.PositionAnnotation.class)).append("-POSITION").add();
            }
            if (this.flags.useBeginSent) {
                String pos = (String)c.get(CoreAnnotations.PositionAnnotation.class);
                if ("0".equals(pos)) {
                    out2.add("BEGIN-SENT");
                    out2.build().append(cShape).append("-BEGIN-SENT").add();
                } else if (Integer.toString(cInfo.size() - 1).equals(pos)) {
                    out2.add("END-SENT");
                    out2.build().append(cShape).append("-END-SENT").add();
                } else {
                    out2.add("IN-SENT");
                    out2.build().append(cShape).append("-IN-SENT").add();
                }
            }
            if (this.flags.useTags) {
                out2.build().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TAG").add();
            }
            if (this.flags.useOrdinal) {
                if (this.isOrdinal(cInfo, loc)) {
                    out2.add("C_ORDINAL");
                    if (this.isOrdinal(cInfo, loc - 1)) {
                        out2.add("PC_ORDINAL");
                    }
                }
                if (this.isOrdinal(cInfo, loc - 1)) {
                    out2.add("P_ORDINAL");
                }
            }
            if (this.flags.usePrev) {
                out2.build().append(pWord).append("-PW").add();
                if (this.flags.useTags) {
                    out2.build().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-PTAG").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).append("-PDISTSIM").add();
                }
                if (this.flags.useIsURL) {
                    out2.build().append((String)p.get(CoreAnnotations.IsURLAnnotation.class)).append("-PISURL").add();
                }
                if (this.flags.useEntityTypes) {
                    out2.build().append((String)p.get(CoreAnnotations.EntityTypeAnnotation.class)).append("-PENTITYTYPE").add();
                }
            }
            if (this.flags.useNext) {
                out2.build().append(nWord).append("-NW").add();
                if (this.flags.useTags) {
                    out2.build().append(n.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-NTAG").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)n.get(CoreAnnotations.DistSimAnnotation.class)).append("-NDISTSIM").add();
                }
                if (this.flags.useIsURL) {
                    out2.build().append((String)n.get(CoreAnnotations.IsURLAnnotation.class)).append("-NISURL").add();
                }
                if (this.flags.useEntityTypes) {
                    out2.build().append((String)n.get(CoreAnnotations.EntityTypeAnnotation.class)).append("-NENTITYTYPE").add();
                }
            }
            if (this.flags.useEitherSideWord) {
                out2.build().append(pWord).append("-EW").add();
                out2.build().append(nWord).append("-EW").add();
            }
            if (this.flags.useWordPairs) {
                out2.build().append(cWord).dash().append(pWord).append("-W-PW").add();
                out2.build().append(cWord).dash().append(nWord).append("-W-NW").add();
            }
            if (this.flags.useSymTags) {
                if (this.flags.useTags) {
                    out2.build().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(n.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-PCNTAGS").add();
                    out2.build().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(n.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-CNTAGS").add();
                    out2.build().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-PCTAGS").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)n.get(CoreAnnotations.DistSimAnnotation.class)).append("-PCNDISTSIM").add();
                    out2.build().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)n.get(CoreAnnotations.DistSimAnnotation.class)).append("-CNDISTSIM").add();
                    out2.build().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-PCDISTSIM").add();
                }
            }
            if (this.flags.useSymWordPairs) {
                out2.build().append(pWord).dash().append(nWord).append("-SWORDS").add();
            }
            if (this.flags.useGazFeatures || this.flags.useMoreGazFeatures) {
                String pGazAnnotation = (String)p.get(CoreAnnotations.GazAnnotation.class);
                String string = (String)n.get(CoreAnnotations.GazAnnotation.class);
                String cGazAnnotation = (String)c.get(CoreAnnotations.GazAnnotation.class);
                if (this.flags.useGazFeatures) {
                    if (cGazAnnotation != null && !cGazAnnotation.equals(this.flags.dropGaz)) {
                        out2.build().append(cGazAnnotation).append("-GAZ").add();
                    }
                    if (string != null && !string.equals(this.flags.dropGaz)) {
                        out2.build().append(string).append("-NGAZ").add();
                    }
                    if (pGazAnnotation != null && !pGazAnnotation.equals(this.flags.dropGaz)) {
                        out2.build().append(pGazAnnotation).append("-PGAZ").add();
                    }
                }
                if (this.flags.useMoreGazFeatures && cGazAnnotation != null && !cGazAnnotation.equals(this.flags.dropGaz)) {
                    out2.build().append(cGazAnnotation).dash().append(cWord).append("-CG-CW-GAZ").add();
                    if (string != null && !string.equals(this.flags.dropGaz)) {
                        out2.build().append(cGazAnnotation).dash().append(string).append("-CNGAZ").add();
                    }
                    if (pGazAnnotation != null && !pGazAnnotation.equals(this.flags.dropGaz)) {
                        out2.build().append(pGazAnnotation).dash().append(cGazAnnotation).append("-PCGAZ").add();
                    }
                }
            }
            if (this.flags.useAbbr || this.flags.useMinimalAbbr) {
                out2.build().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-ABBR").add();
            }
            if ((this.flags.useAbbr1 || this.flags.useMinimalAbbr1) && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                out2.build().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-ABBR").add();
            }
            if (this.flags.useAbbr) {
                out2.build().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-PCABBR").add();
                out2.build().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)n.get(CoreAnnotations.AbbrAnnotation.class)).append("-CNABBR").add();
                out2.build().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)n.get(CoreAnnotations.AbbrAnnotation.class)).append("-PCNABBR").add();
            }
            if (this.flags.useAbbr1 && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                out2.build().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-PCABBR").add();
                out2.build().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)n.get(CoreAnnotations.AbbrAnnotation.class)).append("-CNABBR").add();
                out2.build().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)n.get(CoreAnnotations.AbbrAnnotation.class)).append("-PCNABBR").add();
            }
            if (this.flags.useChunks) {
                out2.build().append((String)p.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ChunkAnnotation.class)).append("-PCCHUNK").add();
                out2.build().append((String)c.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)n.get(CoreAnnotations.ChunkAnnotation.class)).append("-CNCHUNK").add();
                out2.build().append((String)p.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)n.get(CoreAnnotations.ChunkAnnotation.class)).append("-PCNCHUNK").add();
            }
            if (this.flags.useMinimalAbbr) {
                out2.build().append(cWord).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-CWABB").add();
            }
            if (this.flags.useMinimalAbbr1 && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                out2.build().append(cWord).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-CWABB").add();
            }
            String prevVB = "";
            String string = "";
            if (this.flags.usePrevVB) {
                int j = loc - 1;
                while (true) {
                    CoreLabel wi;
                    if ((wi = (CoreLabel)cInfo.get(j)) == cInfo.getPad()) {
                        prevVB = "X";
                        out2.add("X-PVB");
                        break;
                    }
                    if (wi.getString(CoreAnnotations.PartOfSpeechAnnotation.class).startsWith("VB")) {
                        out2.build().append(this.getWord(wi)).append("-PVB").add();
                        prevVB = this.getWord(wi);
                        break;
                    }
                    --j;
                }
            }
            if (this.flags.useNextVB) {
                int j = loc + 1;
                while (true) {
                    CoreLabel wi;
                    if ((wi = (CoreLabel)cInfo.get(j)) == cInfo.getPad()) {
                        out2.add("X-NVB");
                        String string2 = "X";
                        break;
                    }
                    if (wi.getString(CoreAnnotations.PartOfSpeechAnnotation.class).startsWith("VB")) {
                        out2.build().append(this.getWord(wi)).append("-NVB").add();
                        String string3 = this.getWord(wi);
                        break;
                    }
                    ++j;
                }
            }
            if (this.flags.useVB) {
                void var17_48;
                out2.build().append(prevVB).dash().append((String)var17_48).append("-PNVB").add();
            }
            if (this.flags.useShapeConjunctions) {
                out2.build().append((String)c.get(CoreAnnotations.PositionAnnotation.class)).append(cShape).append("-POS-SH").add();
                if (this.flags.useTags) {
                    out2.build().append(c.tag()).append(cShape).append("-TAG-SH").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append(cShape).append("-DISTSIM-SH").add();
                }
            }
            if (this.flags.useWordTag) {
                out2.build().append(cWord).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-W-T").add();
                out2.build().append(cWord).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-W-PT").add();
                out2.build().append(cWord).dash().append(n.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-W-NT").add();
            }
            if (this.flags.useNPHead) {
                out2.build().append((String)c.get(CoreAnnotations.HeadWordStringAnnotation.class)).append("-HW").add();
                if (this.flags.useTags) {
                    out2.build().append((String)c.get(CoreAnnotations.HeadWordStringAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-HW-T").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)c.get(CoreAnnotations.HeadWordStringAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-HW-DISTSIM").add();
                }
            }
            if (this.flags.useNPGovernor) {
                out2.build().append((String)c.get(CoreAnnotations.GovernorAnnotation.class)).append("-GW").add();
                if (this.flags.useTags) {
                    out2.build().append((String)c.get(CoreAnnotations.GovernorAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-GW-T").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)c.get(CoreAnnotations.GovernorAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM-T1").add();
                }
            }
            if (this.flags.useHeadGov) {
                out2.build().append((String)c.get(CoreAnnotations.HeadWordStringAnnotation.class)).dash().append((String)c.get(CoreAnnotations.GovernorAnnotation.class)).append("-HW_GW").add();
            }
            if (this.flags.useClassFeature) {
                out2.add("###");
            }
            if (this.flags.useFirstWord) {
                out2.add(this.getWord((CoreLabel)cInfo.get(0)));
            }
            if (this.flags.useNGrams) {
                Collection<String> subs = null;
                if (this.flags.cacheNGrams) {
                    subs = this.wordToSubstrings.get(cWord);
                }
                if (subs == null) {
                    int j;
                    subs = new ArrayList<String>();
                    String word = '<' + cWord + '>';
                    if (this.flags.lowercaseNGrams) {
                        word = word.toLowerCase();
                    }
                    if (this.flags.dehyphenateNGrams) {
                        word = NERFeatureFactory.dehyphenate(word);
                    }
                    if (this.flags.greekifyNGrams) {
                        word = NERFeatureFactory.greekify(word);
                    }
                    if (this.flags.noMidNGrams) {
                        int max = this.flags.maxNGramLeng >= 0 ? Math.min(this.flags.maxNGramLeng, word.length()) : word.length();
                        for (j = 2; j <= max; ++j) {
                            subs.add(this.intern('#' + word.substring(0, j) + '#'));
                        }
                        int start = this.flags.maxNGramLeng >= 0 ? Math.max(0, word.length() - this.flags.maxNGramLeng) : 0;
                        int lenM1 = word.length() - 1;
                        for (int i = start; i < lenM1; ++i) {
                            subs.add(this.intern('#' + word.substring(i) + '#'));
                        }
                    } else {
                        for (int i = 0; i < word.length(); ++i) {
                            int max = Math.min(word.length(), i + this.flags.maxNGramLeng);
                            for (j = i + 2; j <= max; ++j) {
                                if (this.flags.maxNGramLeng >= 0 && j - i > this.flags.maxNGramLeng) continue;
                                subs.add(this.intern('#' + word.substring(i, j) + '#'));
                            }
                        }
                    }
                    if (this.flags.cacheNGrams) {
                        this.wordToSubstrings.put(cWord, subs);
                    }
                }
                for (String sub : subs) {
                    out2.add(sub);
                }
                if (this.flags.conjoinShapeNGrams) {
                    for (String str : subs) {
                        out2.build().append(str).dash().append(cShape).append("-CNGram-CS").add();
                    }
                }
            }
            if (this.flags.useGazettes) {
                Collection<GazetteInfo> infos;
                Collection<String> entries;
                if (this.flags.sloppyGazette && (entries = this.wordToGazetteEntries.get(cWord)) != null) {
                    for (String entry : entries) {
                        out2.add(entry);
                    }
                }
                if (this.flags.cleanGazette && (infos = this.wordToGazetteInfos.get(cWord)) != null) {
                    block18: for (GazetteInfo gInfo : infos) {
                        for (int gLoc = 0; gLoc < gInfo.words.length; ++gLoc) {
                            if (!gInfo.words[gLoc].equals(this.getWord((CoreLabel)cInfo.get(loc + gLoc - gInfo.loc)))) continue block18;
                        }
                        out2.add(gInfo.feature);
                    }
                }
            }
            if (this.flags.wordShape > -1 || this.flags.useShapeStrings) {
                out2.build().append(cShape).append("-TYPE").add();
                if (this.flags.useTypeSeqs) {
                    out2.build().append(pShape).append("-PTYPE").add();
                    out2.build().append(nShape).append("-NTYPE").add();
                    out2.build().append(pWord).append("...").append(cShape).append("-PW_CTYPE").add();
                    out2.build().append(cShape).append("...").append(nWord).append("-NW_CTYPE").add();
                    out2.build().append(pShape).append("...").append(cShape).append("-PCTYPE").add();
                    out2.build().append(cShape).append("...").append(nShape).append("-CNTYPE").add();
                    out2.build().append(pShape).append("...").append(cShape).append("...").append(nShape).append("-PCNTYPE").add();
                }
            }
            if (this.flags.useLastRealWord && pWord.length() <= 3) {
                out2.build().append(this.getWord(p2)).append("...").append(cShape).append("-PPW_CTYPE").add();
            }
            if (this.flags.useNextRealWord && nWord.length() <= 3) {
                out2.build().append(this.getWord(n2)).append("...").append(cShape).append("-NNW_CTYPE").add();
            }
            if (this.flags.useOccurrencePatterns) {
                this.occurrencePatterns(cInfo, loc, out2);
            }
            if (this.flags.useDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    CoreLabel dn = (CoreLabel)cInfo.get(loc + i);
                    CoreLabel dp = (CoreLabel)cInfo.get(loc - i);
                    out2.build().append(this.getWord(dn)).append("-DISJN").add();
                    if (this.flags.useDisjunctiveShapeInteraction) {
                        out2.build().append(this.getWord(dn)).dash().append(cShape).append("-DISJN-CS").add();
                    }
                    out2.build().append(this.getWord(dp)).append("-DISJP").add();
                    if (!this.flags.useDisjunctiveShapeInteraction) continue;
                    out2.build().append(this.getWord(dp)).dash().append(cShape).append("-DISJP-CS").add();
                }
            }
            if (this.flags.useUndirectedDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    CoreLabel dn = (CoreLabel)cInfo.get(loc + i);
                    CoreLabel dp = (CoreLabel)cInfo.get(loc - i);
                    out2.build().append(this.getWord(dn)).append("-DISJ").add();
                    out2.build().append(this.getWord(dp)).append("-DISJ").add();
                }
            }
            if (this.flags.useWideDisjunctive) {
                for (int i = 1; i <= this.flags.wideDisjunctionWidth; ++i) {
                    out2.build().append(this.getWord((CoreLabel)cInfo.get(loc + i))).append("-DISJWN").add();
                    out2.build().append(this.getWord((CoreLabel)cInfo.get(loc - i))).append("-DISJWP").add();
                }
            }
            if (this.flags.useEitherSideDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    out2.build().append(this.getWord((CoreLabel)cInfo.get(loc + i))).append("-DISJWE").add();
                    out2.build().append(this.getWord((CoreLabel)cInfo.get(loc - i))).append("-DISJWE").add();
                }
            }
            if (this.flags.useDisjShape) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    out2.build().append((String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class)).append("-NDISJSHAPE").add();
                    out2.build().append(cShape).dash().append((String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class)).append("-CNDISJSHAPE").add();
                }
            }
            if (this.flags.useExtraTaggySequences) {
                if (this.flags.useTags) {
                    out2.build().append(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TTS").add();
                    out2.build().append(p3.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TTTS").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)p2.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM_TTS1").add();
                    out2.build().append((String)p3.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p2.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM_TTTS1").add();
                }
            }
            if (this.flags.useMUCFeatures) {
                out2.build().append((String)c.get(CoreAnnotations.SectionAnnotation.class)).append("-SECTION").add();
                out2.build().append((String)c.get(CoreAnnotations.WordPositionAnnotation.class)).append("-WORD_POSITION").add();
                out2.build().append((String)c.get(CoreAnnotations.SentencePositionAnnotation.class)).append("-SENT_POSITION").add();
                out2.build().append((String)c.get(CoreAnnotations.ParaPositionAnnotation.class)).append("-PARA_POSITION").add();
                out2.build().append((String)c.get(CoreAnnotations.WordPositionAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-WORD_POSITION_SHAPE").add();
            }
        } else if (this.flags.useInternal) {
            if (this.flags.useWord) {
                out2.build().append(cWord).append("-WORD").add();
            }
            if (this.flags.useNGrams) {
                Collection<String> subs = this.wordToSubstrings.get(cWord);
                if (subs == null) {
                    void var17_55;
                    subs = new ArrayList<String>();
                    String string = '<' + cWord + '>';
                    if (this.flags.lowercaseNGrams) {
                        String string4 = string.toLowerCase();
                    }
                    if (this.flags.dehyphenateNGrams) {
                        void var17_51;
                        String string5 = NERFeatureFactory.dehyphenate((String)var17_51);
                    }
                    if (this.flags.greekifyNGrams) {
                        void var17_53;
                        String string6 = NERFeatureFactory.greekify((String)var17_53);
                    }
                    for (int i = 0; i < var17_55.length(); ++i) {
                        for (int j = i + 2; j <= var17_55.length(); ++j) {
                            if (this.flags.noMidNGrams && i != 0 && j != var17_55.length() || this.flags.maxNGramLeng >= 0 && j - i > this.flags.maxNGramLeng) continue;
                            subs.add(this.intern('#' + var17_55.substring(i, j) + '#'));
                        }
                    }
                    if (this.flags.cacheNGrams) {
                        this.wordToSubstrings.put(cWord, subs);
                    }
                }
                for (String sub : subs) {
                    out2.add(sub);
                }
                if (this.flags.conjoinShapeNGrams) {
                    String string = (String)c.get(CoreAnnotations.ShapeAnnotation.class);
                    for (String str : subs) {
                        out2.build().append(str).dash().append(string).append("-CNGram-CS").add();
                    }
                }
            }
            if (this.flags.wordShape > -1 || this.flags.useShapeStrings) {
                out2.build().append(cShape).append("-TYPE").add();
            }
            if (this.flags.useOccurrencePatterns) {
                this.occurrencePatterns(cInfo, loc, out2);
            }
        } else if (this.flags.useExternal) {
            if (this.flags.usePrev) {
                out2.build().append(pWord).append("-PW").add();
            }
            if (this.flags.useNext) {
                out2.build().append(nWord).append("-NW").add();
            }
            if (this.flags.useWordPairs) {
                out2.build().append(cWord).dash().append(pWord).append("-W-PW").add();
                out2.build().append(cWord).dash().append(nWord).append("-W-NW").add();
            }
            if (this.flags.useSymWordPairs) {
                out2.build().append(pWord).dash().append(nWord).append("-SWORDS").add();
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs) {
                out2.build().append(pShape).append("-PTYPE").add();
                out2.build().append(nShape).append("-NTYPE").add();
                out2.build().append(pWord).append("...").append(cShape).append("-PW_CTYPE").add();
                out2.build().append(cShape).append("...").append(nWord).append("-NW_CTYPE").add();
                if (this.flags.maxLeft > 0) {
                    out2.build().append(pShape).append("...").append(cShape).append("-PCTYPE").add();
                }
                out2.build().append(cShape).append("...").append(nShape).append("-CNTYPE").add();
                out2.build().append(pShape).append("...").append(cShape).append("...").append(nShape).append("-PCNTYPE").add();
            }
            if (this.flags.useLastRealWord && pWord.length() <= 3) {
                out2.build().append(this.getWord(p2)).append("...").append(cShape).append("-PPW_CTYPE").add();
            }
            if (this.flags.useNextRealWord && nWord.length() <= 3) {
                out2.build().append(this.getWord(n2)).append("...").append(cShape).append("-NNW_CTYPE").add();
            }
            if (this.flags.useDisjunctive) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    CoreLabel coreLabel = (CoreLabel)cInfo.get(loc + i);
                    CoreLabel dp = (CoreLabel)cInfo.get(loc - i);
                    out2.build().append(this.getWord(coreLabel)).append("-DISJN").add();
                    if (this.flags.useDisjunctiveShapeInteraction) {
                        out2.build().append(this.getWord(coreLabel)).dash().append(cShape).append("-DISJN-CS").add();
                    }
                    out2.build().append(this.getWord(dp)).append("-DISJP").add();
                    if (!this.flags.useDisjunctiveShapeInteraction) continue;
                    out2.build().append(this.getWord(dp)).dash().append(cShape).append("-DISJP-CS").add();
                }
            }
            if (this.flags.useWideDisjunctive) {
                for (int i = 1; i <= this.flags.wideDisjunctionWidth; ++i) {
                    out2.build().append(this.getWord((CoreLabel)cInfo.get(loc + i))).append("-DISJWN").add();
                    out2.build().append(this.getWord((CoreLabel)cInfo.get(loc - i))).append("-DISJWP").add();
                }
            }
            if (this.flags.useDisjShape) {
                for (int i = 1; i <= this.flags.disjunctionWidth; ++i) {
                    out2.build().append((String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class)).append("-NDISJSHAPE").add();
                    out2.build().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).dash().append((String)((CoreLabel)cInfo.get(loc + i)).get(CoreAnnotations.ShapeAnnotation.class)).append("-CNDISJSHAPE").add();
                }
            }
        }
        if (this.flags.twoStage) {
            out2.build().append((String)c.get(Bin1Annotation.class)).append("-BIN1").add();
            out2.build().append((String)c.get(Bin2Annotation.class)).append("-BIN2").add();
            out2.build().append((String)c.get(Bin3Annotation.class)).append("-BIN3").add();
            out2.build().append((String)c.get(Bin4Annotation.class)).append("-BIN4").add();
            out2.build().append((String)c.get(Bin5Annotation.class)).append("-BIN5").add();
            out2.build().append((String)c.get(Bin6Annotation.class)).append("-BIN6").add();
        }
        if (this.flags.useIfInteger) {
            try {
                int val = Integer.parseInt(cWord);
                if (val > 0) {
                    out2.add("POSITIVE_INTEGER");
                } else if (val < 0) {
                    out2.add("NEGATIVE_INTEGER");
                }
            }
            catch (NumberFormatException val) {
                // empty catch block
            }
        }
        if (this.flags.useGenericFeatures) {
            if (this.genericAnnotationKeys == null) {
                this.makeGenericKeyCache(c);
            }
            for (Class<? extends CoreLabel.GenericAnnotation<?>> clazz : this.genericAnnotationKeys) {
                Object col = c.get(clazz);
                if (col instanceof Collection) {
                    for (Object ob : (Collection)col) {
                        out2.build().append(ob.toString()).dash().append(CoreLabel.genericValues.get(clazz)).add();
                    }
                    continue;
                }
                if (col == null) continue;
                out2.build().append(col.toString()).dash().append(CoreLabel.genericValues.get(clazz)).add();
            }
        }
        if (this.flags.useTopics) {
            out2.build().append((String)c.get(CoreAnnotations.TopicAnnotation.class)).append("-TopicID").add();
            out2.build().append((String)p.get(CoreAnnotations.TopicAnnotation.class)).append("-PTopicID").add();
            out2.build().append((String)n.get(CoreAnnotations.TopicAnnotation.class)).append("-NTopicID").add();
        }
        if (c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class) != null) {
            out2.build().append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-CStackedNERTag").add();
            out2.build().append(cWord).dash().append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-WCStackedNERTag").add();
            if (this.flags.useNext) {
                out2.build().append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append((String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-CNStackedNERTag").add();
                out2.build().append(cWord).dash().append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append((String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-WCNStackedNERTag").add();
                if (this.flags.usePrev) {
                    out2.build().append((String)p.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append((String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-PCNStackedNERTag").add();
                    out2.build().append((String)p.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append(cWord).append(" -").append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append((String)n.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-PWCNStackedNERTag").add();
                }
            }
            if (this.flags.usePrev) {
                out2.build().append((String)p.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).dash().append((String)c.get(CoreAnnotations.StackedNamedEntityTagAnnotation.class)).append("-PCStackedNERTag").add();
            }
        }
        if (this.flags.useWordnetFeatures) {
            out2.build().append((String)c.get(CoreAnnotations.WordnetSynAnnotation.class)).append("-WordnetSyn").add();
        }
        if (this.flags.useProtoFeatures) {
            out2.build().append((String)c.get(CoreAnnotations.ProtoAnnotation.class)).append("-Proto").add();
        }
        if (this.flags.usePhraseWordTags) {
            out2.build().append((String)c.get(CoreAnnotations.PhraseWordsTagAnnotation.class)).append("-PhraseTag").add();
        }
        if (this.flags.usePhraseWords) {
            for (String string : (List)c.get(CoreAnnotations.PhraseWordsAnnotation.class)) {
                out2.build().append(string).append("-PhraseWord").add();
            }
        }
        if (this.flags.useCommonWordsFeature) {
            out2.add((String)c.get(CoreAnnotations.CommonWordsAnnotation.class));
        }
        if (this.flags.useRadical && cWord.length() > 0) {
            if (cWord.length() == 1) {
                out2.build().append(RadicalMap.getRadical(cWord.charAt(0))).append("-SINGLE-CHAR-RADICAL").add();
            } else {
                out2.build().append(RadicalMap.getRadical(cWord.charAt(0))).append("-START-RADICAL").add();
                out2.build().append(RadicalMap.getRadical(cWord.charAt(cWord.length() - 1))).append("-END-RADICAL").add();
            }
            for (int i = 0; i < cWord.length(); ++i) {
                out2.build().append(RadicalMap.getRadical(cWord.charAt(i))).append("-RADICAL").add();
            }
        }
        if (this.flags.splitWordRegex != null && !this.flags.splitWordRegex.isEmpty()) {
            for (String s : c.word().split(this.flags.splitWordRegex)) {
                out2.build().append(s).append("-SPLITWORD").add();
            }
        }
        if (this.flags.useMoreNeighborNGrams) {
            void var17_75;
            void var17_73;
            void var17_71;
            void var17_69;
            int maxLen = pWord.length();
            if (this.flags.maxNGramLeng >= 0 && this.flags.maxNGramLeng < maxLen) {
                maxLen = this.flags.maxNGramLeng;
            }
            boolean bl = true;
            while (var17_69 <= maxLen) {
                out2.build().append(pWord.substring(0, (int)var17_69)).append("-PREV-PREFIX").add();
                ++var17_69;
            }
            int n6 = pWord.length() - maxLen;
            while (var17_71 < pWord.length()) {
                out2.build().append(pWord.substring((int)var17_71, pWord.length())).append("-PREV-SUFFIX").add();
                ++var17_71;
            }
            maxLen = nWord.length();
            if (this.flags.maxNGramLeng >= 0 && this.flags.maxNGramLeng < maxLen) {
                maxLen = this.flags.maxNGramLeng;
            }
            boolean bl2 = true;
            while (var17_73 <= maxLen) {
                out2.build().append(nWord.substring(0, (int)var17_73)).append("-NEXT-PREFIX").add();
                ++var17_73;
            }
            int n7 = nWord.length() - maxLen;
            while (var17_75 < nWord.length()) {
                out2.build().append(nWord.substring((int)var17_75, nWord.length())).append("-NEXT-SUFFIX").add();
                ++var17_75;
            }
        }
    }

    protected void featuresCpC(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (this.flags.noEdgeFeature) {
            return;
        }
        out2.setSuffix("CpC");
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel n = (CoreLabel)cInfo.get(loc + 1);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String cDS = c.getString(CoreAnnotations.DistSimAnnotation.class);
        String pDS = p.getString(CoreAnnotations.DistSimAnnotation.class);
        String cShape = c.getString(CoreAnnotations.ShapeAnnotation.class);
        String pShape = p.getString(CoreAnnotations.ShapeAnnotation.class);
        if (this.flags.transitionEdgeOnly) {
            out2.add("PSEQ");
            return;
        }
        if (this.flags.useNeighborNGrams) {
            int pos;
            int len;
            int maxLen = pWord.length();
            if (this.flags.maxNGramLeng >= 0 && this.flags.maxNGramLeng < maxLen) {
                maxLen = this.flags.maxNGramLeng;
            }
            for (len = 1; len <= maxLen; ++len) {
                out2.build().append(pWord.substring(0, len)).append("-PREVIOUS-PREFIX").add();
            }
            for (pos = pWord.length() - maxLen; pos < pWord.length(); ++pos) {
                out2.build().append(pWord.substring(pos, pWord.length())).append("-PREVIOUS-SUFFIX").add();
            }
            maxLen = cWord.length();
            if (this.flags.maxNGramLeng >= 0 && this.flags.maxNGramLeng < maxLen) {
                maxLen = this.flags.maxNGramLeng;
            }
            for (len = 1; len <= maxLen; ++len) {
                out2.build().append(cWord.substring(0, len)).append("-CURRENT-PREFIX").add();
            }
            for (pos = cWord.length() - maxLen; pos < cWord.length(); ++pos) {
                out2.build().append(cWord.substring(pos, cWord.length())).append("-CURRENT-SUFFIX").add();
            }
        }
        if (this.flags.useInternal && this.flags.useExternal) {
            if (this.flags.useOrdinal) {
                if (this.isOrdinal(cInfo, loc)) {
                    out2.add("C_ORDINAL");
                    if (this.isOrdinal(cInfo, loc - 1)) {
                        out2.add("PC_ORDINAL");
                    }
                }
                if (this.isOrdinal(cInfo, loc - 1)) {
                    out2.add("P_ORDINAL");
                }
            }
            if (this.flags.useAbbr || this.flags.useMinimalAbbr) {
                out2.build().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-PABBRANS").add();
            }
            if ((this.flags.useAbbr1 || this.flags.useMinimalAbbr1) && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
                out2.build().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-PABBRANS").add();
            }
            if (this.flags.useChunkySequences) {
                out2.build().append((String)p.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)n.get(CoreAnnotations.ChunkAnnotation.class)).append("-PCNCHUNK").add();
            }
            if (this.flags.usePrev && this.flags.useSequences && this.flags.usePrevSequences) {
                out2.add("PSEQ");
                out2.build().append(cWord).append("-PSEQW").add();
                if (!this.flags.strictGoodCoNLL) {
                    out2.build().append(pWord).dash().append(cWord).append("-PSEQW2").add();
                    out2.build().append(pWord).append("-PSEQpW").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append(pDS).append("-PSEQpDS").add();
                    out2.build().append(cDS).append("-PSEQcDS").add();
                    out2.build().append(pDS).dash().append(cDS).append("-PSEQpcDS").add();
                }
                if (this.flags.wordShape > -1 || this.flags.useShapeStrings) {
                    if (!this.flags.strictGoodCoNLL) {
                        out2.build().append(pShape).append("-PSEQpS").add();
                        out2.build().append(cShape).append("-PSEQcS").add();
                    }
                    if (this.flags.strictGoodCoNLL && !this.flags.removeStrictGoodCoNLLDuplicates) {
                        out2.build().append(pShape).dash().append(cShape).append("-PSEQpcS").add();
                    }
                }
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && (this.flags.useTypeSeqs2 || this.flags.useTypeSeqs3)) {
                if (this.flags.useTypeSeqs3) {
                    out2.build().append(pShape).dash().append(cShape).dash().append((String)n.get(CoreAnnotations.ShapeAnnotation.class)).append("-PCNSHAPES").add();
                }
                if (this.flags.useTypeSeqs2) {
                    out2.build().append(pShape).dash().append(cShape).append("-TYPES").add();
                }
                if (this.flags.useYetMoreCpCShapes) {
                    String p2Shape = ((CoreLabel)cInfo.get(loc - 2)).getString(CoreAnnotations.ShapeAnnotation.class);
                    out2.build().append(p2Shape).dash().append(pShape).dash().append(cShape).append("-YMS").add();
                    out2.build().append(pShape).dash().append(cShape).dash().append(n.getString(CoreAnnotations.ShapeAnnotation.class)).append("-YMSPCN").add();
                }
            }
            if (this.flags.useTypeySequences) {
                out2.build().append(cShape).append("-TPS2").add();
                out2.build().append((String)n.get(CoreAnnotations.ShapeAnnotation.class)).append("-TNS1").add();
            }
            if (this.flags.useTaggySequences) {
                if (this.flags.useTags) {
                    out2.build().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TS").add();
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM_TS1").add();
                }
            }
            if (this.flags.useParenMatching) {
                if (this.flags.useReverse) {
                    if ((cWord.equals("(") || cWord.equals("[") || cWord.equals("-LRB-")) && (pWord.equals(")") || pWord.equals("]") || pWord.equals("-RRB-"))) {
                        out2.add("PAREN-MATCH");
                    }
                } else if ((cWord.equals(")") || cWord.equals("]") || cWord.equals("-RRB-")) && (pWord.equals("(") || pWord.equals("[") || pWord.equals("-LRB-"))) {
                    out2.add("PAREN-MATCH");
                }
            }
            if (this.flags.useEntityTypeSequences) {
                out2.build().append((String)p.get(CoreAnnotations.EntityTypeAnnotation.class)).dash().append((String)c.get(CoreAnnotations.EntityTypeAnnotation.class)).append("-ETSEQ").add();
            }
            if (this.flags.useURLSequences) {
                out2.build().append((String)p.get(CoreAnnotations.IsURLAnnotation.class)).dash().append((String)c.get(CoreAnnotations.IsURLAnnotation.class)).append("-URLSEQ").add();
            }
        } else if (this.flags.useInternal) {
            if (this.flags.useSequences && this.flags.usePrevSequences) {
                out2.add("PSEQ");
                out2.build().append(cWord).append("-PSEQW").add();
            }
            if (this.flags.useTypeySequences) {
                out2.build().append(cShape).append("-TPS2").add();
            }
        } else if (this.flags.useExternal) {
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs) {
                if (this.flags.useTypeSeqs3) {
                    out2.build().append(pShape).dash().append(cShape).dash().append((String)n.get(CoreAnnotations.ShapeAnnotation.class)).append("-PCNSHAPES").add();
                }
                if (this.flags.useTypeSeqs2) {
                    out2.build().append(pShape).dash().append(cShape).append("-TYPES").add();
                }
            }
            if (this.flags.useTypeySequences) {
                out2.build().append((String)n.get(CoreAnnotations.ShapeAnnotation.class)).append("-TNS1").add();
                out2.build().append(pShape).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-TPS").add();
            }
        }
    }

    protected void featuresCp2C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        out2.setSuffix("Cp2C");
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        if (this.flags.useMoreAbbr) {
            out2.build().append((String)p2.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-P2ABBRANS").add();
        }
        if (this.flags.useMinimalAbbr) {
            out2.build().append((String)p2.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-P2AP2CABB").add();
        }
        if (this.flags.useMinimalAbbr1 && !((String)c.get(CoreAnnotations.AbbrAnnotation.class)).equals("XX")) {
            out2.build().append((String)p2.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-P2AP2CABB").add();
        }
        if (this.flags.useParenMatching) {
            if (this.flags.useReverse) {
                if ((cWord.equals("(") || cWord.equals("[") || cWord.equals("-LRB-")) && (p2Word.equals(")") || p2Word.equals("]") || p2Word.equals("-RRB-")) && !pWord.equals(")") && !pWord.equals("]") && !pWord.equals("-RRB-")) {
                    out2.add("PAREN-MATCH");
                }
            } else if ((cWord.equals(")") || cWord.equals("]") || cWord.equals("-RRB-")) && (p2Word.equals("(") || p2Word.equals("[") || p2Word.equals("-LRB-")) && !pWord.equals("(") && !pWord.equals("[") && !pWord.equals("-LRB-")) {
                out2.add("PAREN-MATCH");
            }
        }
    }

    protected void featuresCp3C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (!this.flags.useParenMatching) {
            return;
        }
        out2.setSuffix("Cp3C");
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        String p3Word = this.getWord(p3);
        if (this.flags.useReverse) {
            if (!(!cWord.equals("(") && !cWord.equals("[") || this.flags.maxLeft < 3 || !p3Word.equals(")") && !p3Word.equals("]") || p2Word.equals(")") || p2Word.equals("]") || pWord.equals(")") || pWord.equals("]"))) {
                out2.add("PAREN-MATCH");
            }
        } else if (!(!cWord.equals(")") && !cWord.equals("]") || this.flags.maxLeft < 3 || !p3Word.equals("(") && !p3Word.equals("[") || p2Word.equals("(") || p2Word.equals("[") || pWord.equals("(") || pWord.equals("["))) {
            out2.add("PAREN-MATCH");
        }
    }

    protected void featuresCp4C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (!this.flags.useParenMatching) {
            return;
        }
        out2.setSuffix("Cp4C");
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        CoreLabel p4 = (CoreLabel)cInfo.get(loc - 4);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        String p3Word = this.getWord(p3);
        String p4Word = this.getWord(p4);
        if (this.flags.useReverse) {
            if (!(!cWord.equals("(") && !cWord.equals("[") || this.flags.maxLeft < 4 || !p4Word.equals(")") && !p4Word.equals("]") || p3Word.equals(")") || p3Word.equals("]") || p2Word.equals(")") || p2Word.equals("]") || pWord.equals(")") || pWord.equals("]"))) {
                out2.add("PAREN-MATCH");
            }
        } else if (!(!cWord.equals(")") && !cWord.equals("]") || this.flags.maxLeft < 4 || !p4Word.equals("(") && !p4Word.equals("[") || p3Word.equals("(") || p3Word.equals("[") || p2Word.equals("(") || p2Word.equals("[") || pWord.equals("(") || pWord.equals("["))) {
            out2.add("PAREN-MATCH");
        }
    }

    protected void featuresCp5C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (!this.flags.useParenMatching) {
            return;
        }
        out2.setSuffix("Cp5C");
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        CoreLabel p4 = (CoreLabel)cInfo.get(loc - 4);
        CoreLabel p5 = (CoreLabel)cInfo.get(loc - 5);
        String cWord = this.getWord(c);
        String pWord = this.getWord(p);
        String p2Word = this.getWord(p2);
        String p3Word = this.getWord(p3);
        String p4Word = this.getWord(p4);
        String p5Word = this.getWord(p5);
        if (this.flags.useReverse) {
            if (!(!cWord.equals("(") && !cWord.equals("[") || this.flags.maxLeft < 5 || !p5Word.equals(")") && !p5Word.equals("]") || p4Word.equals(")") || p4Word.equals("]") || p3Word.equals(")") || p3Word.equals("]") || p2Word.equals(")") || p2Word.equals("]") || pWord.equals(")") || pWord.equals("]"))) {
                out2.add("PAREN-MATCH");
            }
        } else if (!(!cWord.equals(")") && !cWord.equals("]") || this.flags.maxLeft < 5 || !p5Word.equals("(") && !p5Word.equals("[") || p4Word.equals("(") || p4Word.equals("[") || p3Word.equals("(") || p3Word.equals("[") || p2Word.equals("(") || p2Word.equals("[") || pWord.equals("(") || pWord.equals("["))) {
            out2.add("PAREN-MATCH");
        }
    }

    protected void featuresCpCp2C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        out2.setSuffix("CpCp2C");
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        String pWord = this.getWord(p);
        if (this.flags.useInternal && this.flags.useExternal) {
            if (this.flags.strictGoodCoNLL && !this.flags.removeStrictGoodCoNLLDuplicates && this.flags.useTypeySequences && this.flags.maxLeft >= 2) {
                out2.build().append((String)p2.get(CoreAnnotations.ShapeAnnotation.class)).dash().append((String)p.get(CoreAnnotations.ShapeAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-TTPS").add();
            }
            if (this.flags.useAbbr) {
                out2.build().append((String)p2.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)p.get(CoreAnnotations.AbbrAnnotation.class)).dash().append((String)c.get(CoreAnnotations.AbbrAnnotation.class)).append("-2PABBRANS").add();
            }
            if (this.flags.useChunks) {
                out2.build().append((String)p2.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)p.get(CoreAnnotations.ChunkAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ChunkAnnotation.class)).append("-2PCHUNKS").add();
            }
            if (this.flags.useLongSequences) {
                out2.add("PPSEQ");
            }
            if (this.flags.useBoundarySequences && pWord.equals("*BOUNDARY*")) {
                out2.add("BNDRY-SPAN-PPSEQ");
            }
            if (this.flags.useTaggySequences) {
                if (this.flags.useTags) {
                    out2.build().append(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TTS").add();
                    if (this.flags.useTaggySequencesShapeInteraction) {
                        out2.build().append(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-TTS-CS").add();
                    }
                }
                if (this.flags.useDistSim) {
                    out2.build().append((String)p2.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM_TTS1").add();
                    if (this.flags.useTaggySequencesShapeInteraction) {
                        out2.build().append((String)p2.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-DISTSIM_TTS1-CS").add();
                    }
                }
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && this.flags.useTypeSeqs2 && this.flags.maxLeft >= 2) {
                String cShape = (String)c.get(CoreAnnotations.ShapeAnnotation.class);
                String pShape = (String)p.get(CoreAnnotations.ShapeAnnotation.class);
                String p2Shape = (String)p2.get(CoreAnnotations.ShapeAnnotation.class);
                out2.build().append(p2Shape).dash().append(pShape).dash().append(cShape).append("-TYPETYPES").add();
            }
        } else if (this.flags.useInternal) {
            if (this.flags.useLongSequences) {
                out2.add("PPSEQ");
            }
        } else if (this.flags.useExternal) {
            if (this.flags.useLongSequences) {
                out2.add("PPSEQ");
            }
            if ((this.flags.wordShape > -1 || this.flags.useShapeStrings) && this.flags.useTypeSeqs && this.flags.useTypeSeqs2 && this.flags.maxLeft >= 2) {
                String cShape = (String)c.get(CoreAnnotations.ShapeAnnotation.class);
                String pShape = (String)p.get(CoreAnnotations.ShapeAnnotation.class);
                String p2Shape = (String)p2.get(CoreAnnotations.ShapeAnnotation.class);
                out2.build().append(p2Shape).dash().append(pShape).dash().append(cShape).append("-TYPETYPES").add();
            }
        }
    }

    protected void featuresCpCp2Cp3C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        out2.setSuffix("CpCp2Cp3C");
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        if (this.flags.useTaggySequences) {
            CoreLabel c = (CoreLabel)cInfo.get(loc);
            CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
            CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
            if (this.flags.useTags && this.flags.maxLeft >= 3 && !this.flags.dontExtendTaggy) {
                out2.build().append(p3.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).append("-TTTS").add();
                if (this.flags.useTaggySequencesShapeInteraction) {
                    out2.build().append(p3.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p2.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(p.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append(c.getString(CoreAnnotations.PartOfSpeechAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-TTTS-CS").add();
                }
            }
            if (this.flags.useDistSim && this.flags.maxLeft >= 3 && !this.flags.dontExtendTaggy) {
                out2.build().append((String)p3.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p2.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).append("-DISTSIM_TTTS1").add();
                if (this.flags.useTaggySequencesShapeInteraction) {
                    out2.build().append((String)p3.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p2.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)p.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.DistSimAnnotation.class)).dash().append((String)c.get(CoreAnnotations.ShapeAnnotation.class)).append("-DISTSIM_TTTS1-CS").add();
                }
            }
        }
        if (this.flags.maxLeft >= 3) {
            if (this.flags.useLongSequences) {
                out2.add("PPPSEQ");
            }
            if (this.flags.useBoundarySequences && this.getWord(p).equals("*BOUNDARY*")) {
                out2.add("BNDRY-SPAN-PPPSEQ");
            }
        }
    }

    protected void featuresCpCp2Cp3Cp4C(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (this.flags.maxLeft >= 4) {
            out2.setSuffix("CpCp2Cp3Cp4C");
            CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
            if (this.flags.useLongSequences) {
                out2.add("PPPPSEQ");
            }
            if (this.flags.useBoundarySequences && this.getWord(p).equals("*BOUNDARY*")) {
                out2.add("BNDRY-SPAN-PPPPSEQ");
            }
        }
    }

    protected void featuresCnC(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (this.flags.useNext && this.flags.useSequences && this.flags.useNextSequences) {
            CoreLabel c = (CoreLabel)cInfo.get(loc);
            out2.setSuffix("CnC");
            out2.add("NSEQ");
            out2.build().append(this.getWord(c)).append("-NSEQW").add();
        }
    }

    protected void featuresCpCnC(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        if (this.flags.useNext && this.flags.usePrev && this.flags.useSequences && this.flags.usePrevSequences && this.flags.useNextSequences) {
            CoreLabel c = (CoreLabel)cInfo.get(loc);
            out2.setSuffix("CpCnC");
            out2.add("PNSEQ");
            out2.build().append(this.getWord(c)).append("-PNSEQW").add();
        }
    }

    private int reverse(int i) {
        return this.flags.useReverse ? -1 * i : i;
    }

    private void occurrencePatterns(PaddedList<IN> cInfo, int loc, FeatureCollector out2) {
        String word = this.getWord((CoreLabel)cInfo.get(loc));
        String nWord = this.getWord((CoreLabel)cInfo.get(loc + this.reverse(1)));
        CoreLabel p = (CoreLabel)cInfo.get(loc - this.reverse(1));
        String pWord = this.getWord(p);
        if (!(NERFeatureFactory.isNameCase(word) && NERFeatureFactory.noUpperCase(nWord) && NERFeatureFactory.hasLetter(nWord) && NERFeatureFactory.hasLetter(pWord) && p != cInfo.getPad())) {
            out2.add("NO-OCCURRENCE-PATTERN");
            return;
        }
        if (((CoreLabel)cInfo.get(loc - this.reverse(1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class) != null && NERFeatureFactory.isNameCase(pWord) && ((CoreLabel)cInfo.get(loc - this.reverse(1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
            int jump;
            for (jump = 3; jump < 150; ++jump) {
                if (!this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump))).equals(word)) continue;
                if (this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).equals(pWord)) {
                    out2.add("XY-NEXT-OCCURRENCE-XY");
                    continue;
                }
                out2.add("XY-NEXT-OCCURRENCE-Y");
            }
            for (jump = -3; jump > -150; --jump) {
                if (!this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump))).equals(word)) continue;
                if (this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).equals(pWord)) {
                    out2.add("XY-PREV-OCCURRENCE-XY");
                    continue;
                }
                out2.add("XY-PREV-OCCURRENCE-Y");
            }
        } else {
            int jump;
            for (jump = 3; jump < 150; ++jump) {
                if (!this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump))).equals(word)) continue;
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    out2.add("X-NEXT-OCCURRENCE-YX");
                    continue;
                }
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump + 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump + 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    out2.add("X-NEXT-OCCURRENCE-XY");
                    continue;
                }
                out2.add("X-NEXT-OCCURRENCE-X");
            }
            for (jump = -3; jump > -150; --jump) {
                if (this.getWord((CoreLabel)cInfo.get(loc + jump)) == null || !this.getWord((CoreLabel)cInfo.get(loc + jump)).equals(word)) continue;
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump + 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump + 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    out2.add("X-PREV-OCCURRENCE-YX");
                    continue;
                }
                if (NERFeatureFactory.isNameCase(this.getWord((CoreLabel)cInfo.get(loc + this.reverse(jump - 1)))) && ((CoreLabel)cInfo.get(loc + this.reverse(jump - 1))).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NNP")) {
                    out2.add("X-PREV-OCCURRENCE-XY");
                    continue;
                }
                out2.add("X-PREV-OCCURRENCE-X");
            }
        }
    }

    private String intern(String s) {
        return this.flags.intern ? s.intern() : s;
    }

    private void initGazette() {
        try {
            if (this.flags.gazettes == null) {
                this.flags.gazettes = new ArrayList<String>();
            }
            List<String> gazettes = this.flags.gazettes;
            for (String gazetteFile : gazettes) {
                BufferedReader r = IOUtils.readerFromString(gazetteFile, this.flags.inputEncoding);
                Throwable throwable = null;
                try {
                    this.readGazette(r);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static class Bin6Annotation
    implements CoreAnnotation<String> {
        private Bin6Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin5Annotation
    implements CoreAnnotation<String> {
        private Bin5Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin4Annotation
    implements CoreAnnotation<String> {
        private Bin4Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin3Annotation
    implements CoreAnnotation<String> {
        private Bin3Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin2Annotation
    implements CoreAnnotation<String> {
        private Bin2Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class Bin1Annotation
    implements CoreAnnotation<String> {
        private Bin1Annotation() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    private static class GazetteInfo
    implements Serializable {
        final String feature;
        final int loc;
        final String[] words;
        private static final long serialVersionUID = -5903728481621584810L;

        public GazetteInfo(String feature, int loc, String[] words) {
            this.feature = feature;
            this.loc = loc;
            this.words = words;
        }
    }

    protected static class FeatureCollector {
        String suffix = null;
        String domain = null;
        private StringBuilder buf = new StringBuilder(100);
        Set<String> collection;

        public FeatureCollector(Set<String> output) {
            this.collection = output;
        }

        public FeatureCollector setSuffix(String suffix) {
            assert (suffix != null && !suffix.isEmpty()) : "Only non-empty suffixes are supported right now";
            this.suffix = suffix;
            return this;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        private String intern(String s) {
            return s;
        }

        public FeatureCollector build() {
            assert (this.buf.length() == 0) : "Previous feature not added? " + this.buf.toString();
            this.buf.setLength(0);
            return this;
        }

        public FeatureCollector append(String s) {
            this.buf.append(s);
            return this;
        }

        public FeatureCollector append(char c) {
            this.buf.append(c);
            return this;
        }

        public FeatureCollector dash() {
            this.buf.append('-');
            return this;
        }

        public void add() {
            int l = this.buf.append('|').length();
            this.collection.add(this.intern(this.buf.append(this.suffix).toString()));
            if (this.domain != null) {
                this.buf.setLength(l);
                this.collection.add(this.intern(this.buf.append(this.domain).append('-').append(this.suffix).toString()));
            }
            this.buf.setLength(0);
        }

        public void add(String feat) {
            this.build().append(feat).add();
        }
    }
}

