/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.util.Index;

public class WeightedRVFDataset<L, F>
extends RVFDataset<L, F> {
    private static final long serialVersionUID = 1L;
    float[] weights = new float[16];

    public WeightedRVFDataset() {
    }

    protected WeightedRVFDataset(Index<L> labelIndex, int[] trainLabels, Index<F> featureIndex, int[][] trainData, double[][] trainValues, float[] trainWeights) {
        super(labelIndex, trainLabels, featureIndex, trainData, trainValues);
        this.weights = trainWeights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[] trimToSize(float[] i) {
        float[] newI = new float[this.size];
        Class<System> clazz = System.class;
        synchronized (System.class) {
            System.arraycopy(i, 0, newI, 0, this.size);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return newI;
        }
    }

    public float[] getWeights() {
        if (this.weights.length != this.size) {
            this.weights = this.trimToSize(this.weights);
        }
        return this.weights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void addWeight(float weight) {
        if (this.weights.length == this.size) {
            float[] newWeights = new float[this.size * 2];
            Class<System> clazz = System.class;
            // MONITORENTER : java.lang.System.class
            System.arraycopy(this.weights, 0, newWeights, 0, this.size);
            // MONITOREXIT : clazz
            this.weights = newWeights;
        }
        this.weights[this.size] = weight;
    }

    public void add(RVFDatum<L, F> d, float weight) {
        this.addWeight(weight);
        super.add(d);
    }

    @Override
    public void add(Datum<L, F> d) {
        this.addWeight(1.0f);
        super.add(d);
    }

    @Override
    public void add(Datum<L, F> d, String src, String id) {
        this.addWeight(1.0f);
        super.add(d, src, id);
    }
}

