/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;

public class ExactBestSequenceFinder
implements BestSequenceFinder {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ExactBestSequenceFinder.class);
    private static final boolean DEBUG = false;

    public static Pair<int[], Double> bestSequenceWithLinearConstraints(SequenceModel ts, double[][] linearConstraints) {
        return ExactBestSequenceFinder.bestSequence(ts, linearConstraints);
    }

    @Override
    public int[] bestSequence(SequenceModel ts) {
        return ExactBestSequenceFinder.bestSequence(ts, null).first();
    }

    private static Pair<int[], Double> bestSequence(SequenceModel ts, double[][] linearConstraints) {
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        int padLength = length + leftWindow + rightWindow;
        if (linearConstraints != null && linearConstraints.length != padLength) {
            throw new RuntimeException("linearConstraints.length (" + linearConstraints.length + ") does not match padLength (" + padLength + ") of SequenceModel, length==" + length + ", leftW=" + leftWindow + ", rightW=" + rightWindow);
        }
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos = 0; pos < padLength; ++pos) {
            tags[pos] = ts.getPossibleValues(pos);
            tagNum[pos] = tags[pos].length;
        }
        int[] productSizes = ExactBestSequenceFinder.initProductSizes(ts, tagNum, new int[padLength]);
        int[] tempTags = new int[padLength];
        double[][] windowScore = ExactBestSequenceFinder.computeWindowScore(ts, tags, tagNum, tempTags, productSizes);
        double[][] score = new double[padLength][];
        int[][] trace = new int[padLength][];
        for (int pos = 0; pos < padLength; ++pos) {
            score[pos] = new double[productSizes[pos]];
            trace[pos] = new int[productSizes[pos]];
        }
        ExactBestSequenceFinder.forwardViterbi(leftWindow, rightWindow, length, linearConstraints, tagNum, productSizes, windowScore, score, trace);
        double bestFinalScore = Double.NEGATIVE_INFINITY;
        int bestCurrentProduct = -1;
        int end = leftWindow + length - 1;
        int productEnd = productSizes[end];
        for (int product = 0; product < productEnd; ++product) {
            double s = score[end][product];
            if (!(s > bestFinalScore)) continue;
            bestCurrentProduct = product;
            bestFinalScore = s;
        }
        int lastProduct = bestCurrentProduct;
        for (int last = padLength - 1; last >= length - 1 && last >= 0; --last) {
            int tagNum_last = tagNum[last];
            int tempProduct = lastProduct;
            tempTags[last] = tags[last][tempProduct - (lastProduct /= tagNum_last) * tagNum_last];
        }
        for (int pos = leftWindow + length - 2; pos >= leftWindow; --pos) {
            int bestNextProduct = bestCurrentProduct;
            int prevPos = pos - leftWindow;
            bestCurrentProduct = trace[pos + 1][bestNextProduct];
            tempTags[prevPos] = tags[prevPos][bestCurrentProduct / (productSizes[pos] / tagNum[prevPos])];
        }
        return new Pair<int[], Double>(tempTags, bestFinalScore);
    }

    private static int[] initProductSizes(SequenceModel ts, int[] tagNum, int[] productSizes) {
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        int window = leftWindow + rightWindow;
        int padLength = productSizes.length;
        int curProduct = 1;
        for (int i = 0; i < window; ++i) {
            curProduct *= tagNum[i];
        }
        if (window < padLength) {
            productSizes[leftWindow] = curProduct *= tagNum[window];
        }
        for (int pos = window + 1; pos < padLength; ++pos) {
            curProduct /= tagNum[pos - window - 1];
            productSizes[pos - rightWindow] = curProduct *= tagNum[pos];
        }
        return productSizes;
    }

    private static double[][] computeWindowScore(SequenceModel ts, int[][] tags, int[] tagNum, int[] tempTags, int[] productSizes) {
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        int padLength = length + leftWindow + rightWindow;
        double[][] windowScore = new double[padLength][];
        for (int pos = leftWindow; pos < leftWindow + length; ++pos) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            int tagNum_pos = tagNum[pos];
            int productSizes_pos = productSizes[pos];
            windowScore[pos] = new double[productSizes_pos];
            double[] windowScore_pos = windowScore[pos];
            Arrays.fill(tempTags, tags[0][0]);
            for (int product = 0; product < productSizes_pos; ++product) {
                int p = product;
                int shift = 1;
                int endCurPos = pos - leftWindow;
                for (int curPos = pos + rightWindow; curPos >= endCurPos; --curPos) {
                    int tn = tagNum[curPos];
                    int oldp = p;
                    tempTags[curPos] = tags[curPos][oldp - (p /= tn) * tn];
                    if (curPos <= pos) continue;
                    shift *= tn;
                }
                if (tempTags[pos] != tags[pos][0]) continue;
                double[] scores = ts.scoresOf(tempTags, pos);
                for (int t = 0; t < tagNum_pos; ++t) {
                    windowScore_pos[product + t * shift] = scores[t];
                }
            }
        }
        return windowScore;
    }

    private static int forwardViterbiInitial(int pos, double[][] linearConstraints, int[] tagNum, int[] productSizes, double[][] windowScore, double[][] score, int[][] trace) {
        int products = productSizes[pos];
        for (int product = 0; product < products; ++product) {
            double[] score_pos = score[pos];
            int[] trace_pos = trace[pos];
            double[] linearConstraints_pos = linearConstraints != null ? linearConstraints[pos] : null;
            int tagNum_pos = tagNum[pos];
            double[] windowScore_pos = windowScore[pos];
            double score_product = windowScore_pos[product];
            if (linearConstraints_pos != null) {
                score_product += linearConstraints_pos[product % tagNum_pos];
            }
            score_pos[product] = score_product;
            trace_pos[product] = -1;
        }
        return pos;
    }

    private static void forwardViterbi(int leftWindow, int rightWindow, int length, double[][] linearConstraints, int[] tagNum, int[] productSizes, double[][] windowScore, double[][] score, int[][] trace) {
        int endpos = length + leftWindow;
        int pos = ExactBestSequenceFinder.forwardViterbiInitial(leftWindow, linearConstraints, tagNum, productSizes, windowScore, score, trace);
        ++pos;
        while (pos < endpos) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            double[] score_pos = score[pos];
            double[] score_posm1 = score[pos - 1];
            int[] trace_pos = trace[pos];
            double[] linearConstraints_pos = linearConstraints != null ? linearConstraints[pos] : null;
            int tagNum_pos = tagNum[pos];
            int tagNumRight = tagNum[pos + rightWindow];
            int tagNumLeft = tagNum[pos - leftWindow - 1];
            double[] windowScore_pos = windowScore[pos];
            int products = productSizes[pos];
            int factor = products / tagNumRight;
            for (int product = 0; product < products; ++product) {
                double score_product = Double.NEGATIVE_INFINITY;
                int trace_product = -1;
                int sharedProduct = product / tagNumRight;
                double windowProductScore = windowScore_pos[product];
                for (int newTagNum = 0; newTagNum < tagNumLeft; ++newTagNum) {
                    int predProduct = newTagNum * factor + sharedProduct;
                    double predScore = score_posm1[predProduct] + windowProductScore;
                    if (linearConstraints_pos != null) {
                        predScore += linearConstraints_pos[product % tagNum_pos];
                    }
                    if (!(predScore > score_product)) continue;
                    score_product = predScore;
                    trace_product = predProduct;
                }
                score_pos[product] = score_product;
                trace_pos[product] = trace_product;
            }
            ++pos;
        }
    }
}

