/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.parser.lexparser.ChineseCharacterBasedLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.process.WordSegmenter;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Distribution;
import edu.stanford.nlp.stats.GeneralizedCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.DeltaIndex;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChineseMarkovWordSegmenter
implements WordSegmenter {
    private Distribution<String> initialPOSDist;
    private Map<String, Distribution> markovPOSDists;
    private ChineseCharacterBasedLexicon lex;
    private Set<String> POSes;
    private final Index<String> wordIndex;
    private final Index<String> tagIndex;
    private transient ClassicCounter<String> initial;
    private transient GeneralizedCounter ruleCounter;
    private static final long serialVersionUID = 1559606198270645508L;

    public ChineseMarkovWordSegmenter(ChineseCharacterBasedLexicon lex, Index<String> wordIndex, Index<String> tagIndex) {
        this.lex = lex;
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
    }

    public ChineseMarkovWordSegmenter(ChineseTreebankParserParams params, Index<String> wordIndex, Index<String> tagIndex) {
        this.lex = new ChineseCharacterBasedLexicon(params, wordIndex, tagIndex);
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
    }

    @Override
    public void initializeTraining(double numTrees) {
        this.lex.initializeTraining(numTrees);
        this.initial = new ClassicCounter();
        this.ruleCounter = new GeneralizedCounter(2);
    }

    @Override
    public void train(Collection<Tree> trees) {
        for (Tree tree : trees) {
            this.train(tree);
        }
    }

    @Override
    public void train(Tree tree) {
        this.train((List<TaggedWord>)tree.taggedYield());
    }

    @Override
    public void train(List<TaggedWord> sentence) {
        this.lex.train(sentence, 1.0);
        String last = null;
        for (TaggedWord tagLabel : sentence) {
            String tag = tagLabel.tag();
            this.tagIndex.add(tag);
            if (last == null) {
                this.initial.incrementCount(tag);
            } else {
                this.ruleCounter.incrementCount2D(last, tag);
            }
            last = tag;
        }
    }

    @Override
    public void finishTraining() {
        this.lex.finishTraining();
        int numTags = this.tagIndex.size();
        this.POSes = Generics.newHashSet(this.tagIndex.objectsList());
        this.initialPOSDist = Distribution.laplaceSmoothedDistribution(this.initial, numTags, 0.5);
        this.markovPOSDists = Generics.newHashMap();
        Set entries = this.ruleCounter.lowestLevelCounterEntrySet();
        for (Map.Entry entry : entries) {
            Distribution d = Distribution.laplaceSmoothedDistribution(entry.getValue(), numTags, 0.5);
            this.markovPOSDists.put((String)entry.getKey().get(0), d);
        }
    }

    @Override
    public List<HasWord> segment(String s) {
        return this.segmentWordsWithMarkov(s);
    }

    private ArrayList<TaggedWord> basicSegmentWords(String s) {
        int end;
        int start;
        int diff;
        DeltaIndex<String> deltaWordIndex = new DeltaIndex<String>(this.wordIndex);
        int length = s.length();
        double[][] scores = new double[length][length + 1];
        int[][] splitBacktrace = new int[length][length + 1];
        int[][] POSbacktrace = new int[length][length + 1];
        for (int i = 0; i < length; ++i) {
            Arrays.fill(scores[i], Double.NEGATIVE_INFINITY);
        }
        for (diff = 1; diff <= 10; ++diff) {
            start = 0;
            while (start + diff <= length) {
                end = start + diff;
                StringBuilder wordBuf = new StringBuilder();
                for (int pos = start; pos < end; ++pos) {
                    wordBuf.append(s.charAt(pos));
                }
                String word = wordBuf.toString();
                for (String tag : this.POSes) {
                    IntTaggedWord itw = new IntTaggedWord(word, tag, deltaWordIndex, this.tagIndex);
                    double newScore = (double)this.lex.score(itw, 0, word, null) + Math.log(this.lex.getPOSDistribution().probabilityOf(tag));
                    if (!(newScore > scores[start][end])) continue;
                    scores[start][end] = newScore;
                    splitBacktrace[start][end] = end;
                    POSbacktrace[start][end] = itw.tag();
                }
                ++start;
            }
        }
        for (diff = 2; diff <= length; ++diff) {
            start = 0;
            while (start + diff <= length) {
                end = start + diff;
                for (int split = start + 1; split < end && split - start <= 10; ++split) {
                    double newScore;
                    if (splitBacktrace[start][split] != split || !((newScore = scores[start][split] + scores[split][end]) > scores[start][end])) continue;
                    scores[start][end] = newScore;
                    splitBacktrace[start][end] = split;
                }
                ++start;
            }
        }
        ArrayList<TaggedWord> words = new ArrayList<TaggedWord>();
        start = 0;
        while (start < length) {
            end = splitBacktrace[start][length];
            StringBuilder wordBuf = new StringBuilder();
            for (int pos = start; pos < end; ++pos) {
                wordBuf.append(s.charAt(pos));
            }
            String word = wordBuf.toString();
            String tag = this.tagIndex.get(POSbacktrace[start][end]);
            words.add(new TaggedWord(word, tag));
            start = end;
        }
        return new ArrayList<TaggedWord>(words);
    }

    private ArrayList<HasWord> segmentWordsWithMarkov(String s) {
        int end;
        int start;
        int diff;
        DeltaIndex<String> deltaWordIndex = new DeltaIndex<String>(this.wordIndex);
        int length = s.length();
        int numTags = this.POSes.size();
        double[][][] scores = new double[length][length + 1][numTags];
        int[][][] splitBacktrace = new int[length][length + 1][numTags];
        int[][][] POSbacktrace = new int[length][length + 1][numTags];
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length + 1; ++j) {
                Arrays.fill(scores[i][j], Double.NEGATIVE_INFINITY);
            }
        }
        for (diff = 1; diff <= 10; ++diff) {
            start = 0;
            while (start + diff <= length) {
                end = start + diff;
                StringBuilder wordBuf = new StringBuilder();
                for (int pos = start; pos < end; ++pos) {
                    wordBuf.append(s.charAt(pos));
                }
                String word = wordBuf.toString();
                for (String tag : this.POSes) {
                    IntTaggedWord itw = new IntTaggedWord(word, tag, deltaWordIndex, this.tagIndex);
                    double score = this.lex.score(itw, 0, word, null);
                    if (start == 0) {
                        score += Math.log(this.initialPOSDist.probabilityOf(tag));
                    }
                    scores[start][end][itw.tag()] = score;
                    splitBacktrace[start][end][itw.tag()] = end;
                }
                ++start;
            }
        }
        for (diff = 2; diff <= length; ++diff) {
            start = 0;
            while (start + diff <= length) {
                end = start + diff;
                for (int split = start + 1; split < end && split - start <= 10; ++split) {
                    for (String tag : this.POSes) {
                        Distribution rTagDist;
                        int tagNum = this.tagIndex.addToIndex(tag);
                        if (splitBacktrace[start][split][tagNum] != split || (rTagDist = this.markovPOSDists.get(tag)) == null) continue;
                        for (String rTag : this.POSes) {
                            int rTagNum = this.tagIndex.addToIndex(rTag);
                            double newScore = scores[start][split][tagNum] + scores[split][end][rTagNum] + Math.log(rTagDist.probabilityOf(rTag));
                            if (!(newScore > scores[start][end][tagNum])) continue;
                            scores[start][end][tagNum] = newScore;
                            splitBacktrace[start][end][tagNum] = split;
                            POSbacktrace[start][end][tagNum] = rTagNum;
                        }
                    }
                }
                ++start;
            }
        }
        int nextPOS = ArrayMath.argmax(scores[0][length]);
        ArrayList<HasWord> words = new ArrayList<HasWord>();
        int start2 = 0;
        while (start2 < length) {
            int split = splitBacktrace[start2][length][nextPOS];
            StringBuilder wordBuf = new StringBuilder();
            for (int i = start2; i < split; ++i) {
                wordBuf.append(s.charAt(i));
            }
            String word = wordBuf.toString();
            words.add(new Word(word));
            if (split < length) {
                nextPOS = POSbacktrace[start2][length][nextPOS];
            }
            start2 = split;
        }
        return words;
    }

    /*
     * WARNING - void declaration
     */
    private Distribution<Integer> getSegmentedWordLengthDistribution(Treebank tb) {
        ClassicCounter<Integer> c = new ClassicCounter<Integer>();
        for (Tree gold : tb) {
            void var8_8;
            StringBuilder goldChars = new StringBuilder();
            ArrayList<Label> goldYield = gold.yield();
            for (Word word : goldYield) {
                goldChars.append(word);
            }
            List<HasWord> ourWords = this.segment(goldChars.toString());
            boolean bl = false;
            while (var8_8 < ourWords.size()) {
                c.incrementCount(ourWords.get((int)var8_8).word().length());
                ++var8_8;
            }
        }
        return Distribution.getDistribution(c);
    }

    @Override
    public void loadSegmenter(String filename) {
        throw new UnsupportedOperationException();
    }
}

