/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.tagger.maxent.AmbiguityClasses;
import edu.stanford.nlp.tagger.maxent.CountWrapper;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TagCount;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class Dictionary {
    private static final Redwood.RedwoodChannels log = Redwood.channels(Dictionary.class);
    private final Map<String, TagCount> dict = Generics.newHashMap();
    private final Map<Integer, CountWrapper> partTakingVerbs = Generics.newHashMap();
    private static final String naWord = "NA";
    private static final boolean VERBOSE = false;

    void fillWordTagCounts(Map<String, IntCounter<String>> wordTagCounts) {
        for (Map.Entry<String, IntCounter<String>> wordTagCount : wordTagCounts.entrySet()) {
            this.dict.put(wordTagCount.getKey(), new TagCount(wordTagCount.getValue()));
        }
    }

    protected void addVThatTaking(String verb) {
        int i = verb.hashCode();
        CountWrapper wrap = this.partTakingVerbs.get(i);
        if (wrap != null) {
            wrap.incThat();
        } else {
            this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 1, 0, 0));
        }
    }

    protected int getCountPart(String verb) {
        CountWrapper wrap = this.partTakingVerbs.get(verb.hashCode());
        return wrap != null ? wrap.getCountPart() : 0;
    }

    protected int getCountThat(String verb) {
        CountWrapper wrap = this.partTakingVerbs.get(verb.hashCode());
        return wrap != null ? wrap.getCountThat() : 0;
    }

    protected int getCountIn(String verb) {
        CountWrapper wrap = this.partTakingVerbs.get(verb.hashCode());
        return wrap != null ? wrap.getCountIn() : 0;
    }

    protected int getCountRB(String verb) {
        CountWrapper wrap = this.partTakingVerbs.get(verb.hashCode());
        return wrap != null ? wrap.getCountRB() : 0;
    }

    protected int getCount(String word, String tag) {
        TagCount count = this.dict.get(word);
        return count != null ? count.get(tag) : 0;
    }

    protected String[] getTags(String word) {
        TagCount count = this.dict.get(word);
        return count != null ? count.getTags() : null;
    }

    protected TagCount get(String word) {
        return this.dict.get(word);
    }

    String getFirstTag(String word) {
        TagCount count = this.dict.get(word);
        return count != null ? count.getFirstTag() : null;
    }

    protected int sum(String word) {
        TagCount count = this.dict.get(word);
        return count != null ? count.sum() : 0;
    }

    boolean isUnknown(String word) {
        return !this.dict.containsKey(word);
    }

    void save(DataOutputStream file) {
        String[] arr = this.dict.keySet().toArray(new String[this.dict.keySet().size()]);
        try {
            file.writeInt(arr.length);
            log.info("Saving dictionary of " + arr.length + " words ...");
            for (String word : arr) {
                TagCount count = this.get(word);
                file.writeUTF(word);
                count.save(file);
            }
            Integer[] arrverbs = this.partTakingVerbs.keySet().toArray(new Integer[this.partTakingVerbs.keySet().size()]);
            file.writeInt(arrverbs.length);
            for (Integer iO : arrverbs) {
                CountWrapper tC = this.partTakingVerbs.get(iO);
                file.writeInt(iO);
                tC.save(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readTags(DataInputStream rf) throws IOException {
        int maxNumTags = 0;
        int len = rf.readInt();
        Interner<String> interner = new Interner<String>();
        for (int i = 0; i < len; ++i) {
            String word = rf.readUTF();
            TagCount count = TagCount.readTagCount(rf, interner);
            int numTags = count.numTags();
            if (numTags > maxNumTags) {
                maxNumTags = numTags;
            }
            this.dict.put(word, count);
        }
    }

    private void readVerbs(DataInputStream rf) throws IOException {
        int len = rf.readInt();
        for (int i = 0; i < len; ++i) {
            int iO = rf.readInt();
            CountWrapper tC = new CountWrapper();
            tC.read(rf);
            this.partTakingVerbs.put(iO, tC);
        }
    }

    protected void read(String filename) {
        try {
            DataInputStream rf = IOUtils.getDataInputStream(filename);
            this.readTags(rf);
            this.readVerbs(rf);
            rf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream file) {
        try {
            this.readTags(file);
            this.readVerbs(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setAmbClasses(AmbiguityClasses ambClasses, int veryCommonWordThresh, TTags ttags) {
        for (Map.Entry<String, TagCount> entry : this.dict.entrySet()) {
            String w = entry.getKey();
            TagCount count = entry.getValue();
            int ambClassId = ambClasses.getClass(w, this, veryCommonWordThresh, ttags);
            count.setAmbClassId(ambClassId);
        }
    }

    protected int getAmbClass(String word) {
        if (word.equals(naWord)) {
            return -2;
        }
        if (this.get(word) == null) {
            return -1;
        }
        return this.get(word).getAmbClassId();
    }

    public static void main(String[] args) {
        String s = "word";
        String tag = "tag";
        Dictionary d = new Dictionary();
        System.out.println(d.getCount(s, tag));
        System.out.println(d.getFirstTag(s));
    }
}

