/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;

public class ChineseGrammaticalStructure
extends GrammaticalStructure {
    private static Redwood.RedwoodChannels log = Redwood.channels(ChineseGrammaticalStructure.class);
    private static HeadFinder shf = new ChineseSemanticHeadFinder();
    private static final long serialVersionUID = 8877651855167458256L;

    public ChineseGrammaticalStructure(Tree t) {
        this(t, new ChineseTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public ChineseGrammaticalStructure(Tree t, Predicate<String> puncFilter) {
        this(t, puncFilter, shf);
    }

    public ChineseGrammaticalStructure(Tree t, HeadFinder hf) {
        this(t, null, hf);
    }

    public ChineseGrammaticalStructure(Tree t, Predicate<String> puncFilter, HeadFinder hf) {
        super(t, ChineseGrammaticalRelations.values(), ChineseGrammaticalRelations.valuesLock(), null, hf, puncFilter, Filters.acceptFilter());
    }

    public ChineseGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, GrammaticalStructure.Extras includeExtras) {
        ChineseGrammaticalStructure.collapsePrepAndPoss(list);
    }

    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        Map map = Generics.newHashMap();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), Generics.newHashSet());
            }
            ((Set)map.get(typedDep.gov())).add(typedDep);
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            IndexedWord td1Dep = td1.dep();
            String td1DepPOS = td1Dep.tag();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            for (TypedDependency td2 : possibles) {
                if (td1.reln() != GrammaticalRelation.DEPENDENT || td2.reln() != GrammaticalRelation.DEPENDENT || !td1DepPOS.equals("P")) continue;
                GrammaticalRelation td3reln = ChineseGrammaticalRelations.valueOf(td1Dep.value());
                if (td3reln == null) {
                    td3reln = GrammaticalRelation.valueOf(Language.Chinese, td1Dep.value());
                }
                TypedDependency td3 = new TypedDependency(td3reln, td1.gov(), td2.dep());
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (!td1.reln().equals(GrammaticalRelation.KILL)) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln().equals(GrammaticalRelation.KILL)) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            if (td.reln().equals(GrammaticalRelation.KILL)) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    public static void main(String[] args) {
        Properties params = StringUtils.argsToProperties(args);
        if (params.getProperty("sentFile") != null) {
            log.error("Parsing sentences to constituency trees is not supported for Chinese. Please parse your sentences first and then convert them to dependency trees using the -treeFile option.");
            return;
        }
        GrammaticalStructureConversionUtils.convertTrees(args, "zh-sd");
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticalStructureCollection(String fileName) throws IOException {
        return ChineseGrammaticalStructure.readCoNLLXGrammaticalStructureCollection(fileName, ChineseGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static ChineseGrammaticalStructure buildCoNLLXGrammaticalStructure(List<List<String>> tokenFields) {
        return (ChineseGrammaticalStructure)ChineseGrammaticalStructure.buildCoNLLXGrammaticalStructure(tokenFields, ChineseGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static class FromDependenciesFactory
    implements GrammaticalStructureFromDependenciesFactory {
        @Override
        public ChineseGrammaticalStructure build(List<TypedDependency> tdeps, TreeGraphNode root) {
            return new ChineseGrammaticalStructure(tdeps, root);
        }
    }
}

