/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.ComplexNodePattern;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.TwoDimensionalCollectionValuedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.function.Function;

public class CoreMapNodePatternTrigger
implements MultiPatternMatcher.NodePatternTrigger<CoreMap> {
    final Collection<SequencePattern<CoreMap>> alwaysTriggered;
    TwoDimensionalCollectionValuedMap<Class, Object, SequencePattern<CoreMap>> annotationTriggers = new TwoDimensionalCollectionValuedMap(true);
    TwoDimensionalCollectionValuedMap<Class, String, SequencePattern<CoreMap>> lowercaseStringTriggers = new TwoDimensionalCollectionValuedMap(true);
    private static final Comparator<StringTriggerCandidate> STRING_TRIGGER_CANDIDATE_COMPARATOR = new Comparator<StringTriggerCandidate>(){

        @Override
        public int compare(StringTriggerCandidate o1, StringTriggerCandidate o2) {
            if (o1.keyLevel != o2.keyLevel) {
                return o1.keyLevel < o2.keyLevel ? -1 : 1;
            }
            int v1 = o1.effectiveValueLength;
            int v2 = o2.effectiveValueLength;
            if (v1 != v2) {
                return v1 < v2 ? -1 : 1;
            }
            return 0;
        }
    };

    public CoreMapNodePatternTrigger(SequencePattern<CoreMap> ... patterns) {
        this(Arrays.asList(patterns));
    }

    public CoreMapNodePatternTrigger(Collection<? extends SequencePattern<CoreMap>> patterns) {
        Function<NodePattern, StringTriggerCandidate> stringTriggerFilter = in -> {
            if (in instanceof CoreMapNodePattern) {
                CoreMapNodePattern p = (CoreMapNodePattern)in;
                for (Pair v : p.getAnnotationPatterns()) {
                    if (!(v.second instanceof ComplexNodePattern.StringAnnotationPattern)) continue;
                    return new StringTriggerCandidate((Class)v.first, ((ComplexNodePattern.StringAnnotationPattern)v.second).target, ((ComplexNodePattern.StringAnnotationPattern)v.second).ignoreCase());
                }
            }
            return null;
        };
        LinkedHashSet<SequencePattern<CoreMap>> alwaysTriggeredTemp = new LinkedHashSet<SequencePattern<CoreMap>>();
        for (SequencePattern<CoreMap> sequencePattern : patterns) {
            Collection<StringTriggerCandidate> triggerCandidates = sequencePattern.findNodePatterns(stringTriggerFilter, false, true);
            StringTriggerCandidate trigger = triggerCandidates.stream().max(STRING_TRIGGER_CANDIDATE_COMPARATOR).orElse(null);
            if (!triggerCandidates.isEmpty()) {
                if (trigger.ignoreCase) {
                    this.lowercaseStringTriggers.add(trigger.key, trigger.value.toLowerCase(), sequencePattern);
                    continue;
                }
                this.annotationTriggers.add(trigger.key, (Object)trigger.value, sequencePattern);
                continue;
            }
            alwaysTriggeredTemp.add(sequencePattern);
        }
        this.alwaysTriggered = alwaysTriggeredTemp.size() == 0 ? Collections.emptySet() : (alwaysTriggeredTemp.size() == 1 ? Collections.singleton(alwaysTriggeredTemp.iterator().next()) : Collections.unmodifiableList(new ArrayList(alwaysTriggeredTemp)));
    }

    @Override
    public Collection<SequencePattern<CoreMap>> apply(CoreMap in) {
        Collection<SequencePattern<CoreMap>> triggered;
        Object value;
        LinkedHashSet<SequencePattern<CoreMap>> triggeredPatterns = new LinkedHashSet<SequencePattern<CoreMap>>();
        triggeredPatterns.addAll(this.alwaysTriggered);
        for (Class key : this.annotationTriggers.firstKeySet()) {
            value = in.get(key);
            if (value == null || (triggered = this.annotationTriggers.get(key, value)) == null) continue;
            triggeredPatterns.addAll(triggered);
        }
        for (Class key : this.lowercaseStringTriggers.firstKeySet()) {
            value = in.get(key);
            if (value == null || !(value instanceof String) || (triggered = this.lowercaseStringTriggers.get(key, ((String)value).toLowerCase())) == null) continue;
            triggeredPatterns.addAll(triggered);
        }
        return triggeredPatterns;
    }

    private static class StringTriggerCandidate {
        Class key;
        String value;
        boolean ignoreCase;
        int keyLevel;
        int effectiveValueLength;

        public StringTriggerCandidate(Class key, String value, boolean ignoreCase) {
            this.key = key;
            this.value = value;
            this.ignoreCase = ignoreCase;
            this.keyLevel = CoreAnnotations.TextAnnotation.class.equals((Object)key) || CoreAnnotations.LemmaAnnotation.class.equals((Object)key) ? 1 : 0;
            this.effectiveValueLength = "-LRB-".equals(value) || "-RRB-".equals(value) ? 1 : value.length();
        }
    }
}

