/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TreeLocation {
    private final String relation;
    private final TsurgeonPattern child;
    private static final Pattern daughterPattern = Pattern.compile(">-?([0-9]+)");

    public TreeLocation(String relation, TsurgeonPattern p) {
        this.relation = relation;
        this.child = p;
    }

    void setRoot(TsurgeonPatternRoot root) {
        this.child.setRoot(root);
    }

    public LocationMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new LocationMatcher(newNodeNames, coindexer);
    }

    public String toString() {
        return this.relation + ' ' + this.child;
    }

    class LocationMatcher {
        Map<String, Tree> newNodeNames;
        CoindexationGenerator coindexer;
        TsurgeonMatcher childMatcher;

        LocationMatcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            this.newNodeNames = newNodeNames;
            this.coindexer = coindexer;
            this.childMatcher = TreeLocation.this.child.matcher(newNodeNames, coindexer);
        }

        Pair<Tree, Integer> evaluate(Tree tree, TregexMatcher tregex) {
            Tree parent;
            int newIndex;
            Tree relativeNode = this.childMatcher.evaluate(tree, tregex);
            Matcher m = daughterPattern.matcher(TreeLocation.this.relation);
            if (m.matches()) {
                newIndex = Integer.parseInt(m.group(1)) - 1;
                parent = relativeNode;
                if (TreeLocation.this.relation.charAt(1) == '-') {
                    newIndex = parent.children().length - newIndex;
                }
            } else {
                parent = relativeNode.parent(tree);
                if (parent == null) {
                    throw new RuntimeException("Error: looking for a non-existent parent in tree " + tree + " for \"" + this.toString() + '\"');
                }
                int index = parent.objectIndexOf(relativeNode);
                switch (TreeLocation.this.relation) {
                    case "$+": {
                        newIndex = index;
                        break;
                    }
                    case "$-": {
                        newIndex = index + 1;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Error: Haven't dealt with relation " + TreeLocation.this.relation + " yet.");
                    }
                }
            }
            return new Pair<Tree, Integer>(parent, newIndex);
        }
    }
}

