/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ivy.ant.IvyCacheTask;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class IvyCacheFileset
extends IvyCacheTask {
    private String setid;

    public String getSetid() {
        return this.setid;
    }

    public void setSetid(String string) {
        this.setid = string;
    }

    @Override
    public void setUseOrigin(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("the cachefileset task does not support the useOrigin mode, since filesets require to have only one root directory. Please use the the cachepath task instead");
        }
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.setid == null) {
            throw new BuildException("setid is required in ivy cachefileset");
        }
        try {
            FileSet fileSet;
            List<ArtifactDownloadReport> list = this.getArtifactReports();
            File file = null;
            for (ArtifactDownloadReport object : list) {
                if (object.getLocalFile() == null) continue;
                file = this.getBaseDir(file, object.getLocalFile());
            }
            if (file == null) {
                fileSet = new EmptyFileSet();
            } else {
                fileSet = new FileSet();
                fileSet.setDir(file);
                for (ArtifactDownloadReport artifactDownloadReport : list) {
                    if (artifactDownloadReport.getLocalFile() == null) continue;
                    PatternSet.NameEntry nameEntry = fileSet.createInclude();
                    nameEntry.setName(this.getPath(file, artifactDownloadReport.getLocalFile()));
                }
            }
            fileSet.setProject(this.getProject());
            this.getProject().addReference(this.setid, (Object)fileSet);
        }
        catch (Exception exception) {
            throw new BuildException("impossible to build ivy cache fileset: " + exception, (Throwable)exception);
        }
    }

    private String getPath(File file, File file2) {
        String string = file.getAbsolutePath();
        int n = string.length();
        if (!string.endsWith(File.separator)) {
            ++n;
        }
        return file2.getAbsolutePath().substring(n);
    }

    File getBaseDir(File file, File file2) {
        File file3;
        if (file == null) {
            return file2.getParentFile().getAbsoluteFile();
        }
        Iterator iterator = this.getParents(file).iterator();
        Iterator iterator2 = this.getParents(file2.getAbsoluteFile()).iterator();
        File file4 = null;
        while (iterator.hasNext() && iterator2.hasNext() && (file3 = (File)iterator.next()).equals(iterator2.next())) {
            file4 = file3;
        }
        return file4;
    }

    private LinkedList getParents(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        while (file != null) {
            linkedList.addFirst(file);
            file = file.getParentFile();
        }
        return linkedList;
    }

    private static class EmptyDirectoryScanner
    extends DirectoryScanner {
        private EmptyDirectoryScanner() {
        }

        public String[] getIncludedFiles() {
            return new String[0];
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("EmptyFileSet Iterator");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("EmptyFileSet Iterator");
        }
    }

    private static class EmptyFileSet
    extends FileSet {
        private DirectoryScanner ds = new EmptyDirectoryScanner();

        private EmptyFileSet() {
        }

        public Iterator iterator() {
            return new EmptyIterator();
        }

        public Object clone() {
            return new EmptyFileSet();
        }

        public int size() {
            return 0;
        }

        public DirectoryScanner getDirectoryScanner(Project project) {
            return this.ds;
        }
    }
}

