/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.NormalRelativeUrlResolver;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.CacheUtil;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.core.pack.PackingRegistry;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.core.settings.XmlSettingsParser;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.osgi.core.OsgiLatestStrategy;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.ErrorCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestCompatibleConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.latest.LatestTimeStrategy;
import org.apache.ivy.plugins.lock.CreateFileLockStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NIOFileLockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.report.LogReportOutputter;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.DualResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class IvySettings
implements SortEngineSettings,
PublishEngineSettings,
ParserSettings,
DeliverEngineSettings,
CheckEngineSettings,
InstallEngineSettings,
ResolverSettings,
ResolveEngineSettings,
RetrieveEngineSettings,
RepositoryManagementEngineSettings {
    private static final long INTERUPT_TIMEOUT = 2000L;
    private Map typeDefs = new HashMap();
    private Map resolversMap = new HashMap();
    private DependencyResolver defaultResolver;
    private DependencyResolver dictatorResolver = null;
    private String defaultResolverName;
    private File defaultCache;
    private String defaultBranch = null;
    private boolean checkUpToDate = true;
    private ModuleRules moduleSettings = new ModuleRules();
    private Map conflictsManager = new HashMap();
    private Map latestStrategies = new HashMap();
    private Map lockStrategies = new HashMap();
    private Map namespaces = new HashMap();
    private Map matchers = new HashMap();
    private Map reportOutputters = new HashMap();
    private Map versionMatchers = new HashMap();
    private Map circularDependencyStrategies = new HashMap();
    private Map repositoryCacheManagers = new HashMap();
    private Map signatureGenerators = new HashMap();
    private List triggers = new ArrayList();
    private IvyVariableContainer variableContainer = new IvyVariableContainerImpl();
    private boolean validate = true;
    private LatestStrategy defaultLatestStrategy = null;
    private LockStrategy defaultLockStrategy = null;
    private ConflictManager defaultConflictManager = null;
    private CircularDependencyStrategy circularDependencyStrategy = null;
    private RepositoryCacheManager defaultRepositoryCacheManager = null;
    private ResolutionCacheManager resolutionCacheManager = null;
    private List listingIgnore = new ArrayList();
    private boolean repositoriesConfigured;
    private boolean useRemoteConfig = false;
    private File defaultUserDir;
    private File baseDir = new File(".").getAbsoluteFile();
    private List classpathURLs = new ArrayList();
    private ClassLoader classloader;
    private Boolean debugConflictResolution;
    private boolean logNotConvertedExclusionRule;
    private VersionMatcher versionMatcher;
    private StatusManager statusManager;
    private Boolean debugLocking;
    private Boolean dumpMemoryUsage;
    private String defaultCacheIvyPattern;
    private String defaultCacheArtifactPattern;
    private boolean defaultUseOrigin;
    private String defaultResolveMode = "default";
    private PackingRegistry packingRegistry = new PackingRegistry();

    public IvySettings() {
        this(new IvyVariableContainerImpl());
    }

    public IvySettings(IvyVariableContainer ivyVariableContainer) {
        Object object;
        this.setVariableContainer(ivyVariableContainer);
        this.setVariable("ivy.default.settings.dir", this.getDefaultSettingsDir(), true);
        this.setVariable("ivy.basedir", this.getBaseDir().getAbsolutePath());
        this.setDeprecatedVariable("ivy.default.conf.dir", "ivy.default.settings.dir");
        String string = System.getProperty("ivy.typedef.files");
        if (string != null) {
            object = string.split("\\,");
            for (int i = 0; i < ((String[])object).length; ++i) {
                try {
                    this.typeDefs(new FileInputStream(Checks.checkAbsolute(object[i].trim(), "ivy.typedef.files")), true);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Message.warn("typedefs file not found: " + object[i].trim());
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn("problem with typedef file: " + object[i].trim(), iOException);
                }
            }
        } else {
            try {
                this.typeDefs(IvySettings.getSettingsURL("typedef.properties").openStream(), true);
            }
            catch (IOException iOException) {
                Message.warn("impossible to load default type defs", iOException);
            }
        }
        object = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        OsgiLatestStrategy osgiLatestStrategy = new OsgiLatestStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", (LatestStrategy)object);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addLatestStrategy("latest-osgi", osgiLatestStrategy);
        this.addLockStrategy("no-lock", new NoLockStrategy());
        this.addLockStrategy("artifact-lock", new CreateFileLockStrategy(this.debugLocking()));
        this.addLockStrategy("artifact-lock-nio", new NIOFileLockStrategy(this.debugLocking()));
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-compatible", new LatestCompatibleConflictManager("latest-compatible", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.INSTANCE);
        this.addMatcher(RegexpPatternMatcher.INSTANCE);
        this.addMatcher(ExactOrRegexpPatternMatcher.INSTANCE);
        try {
            Class<?> clazz = IvySettings.class.getClassLoader().loadClass("org.apache.ivy.plugins.matcher.GlobPatternMatcher");
            Field field = clazz.getField("INSTANCE");
            this.addMatcher((PatternMatcher)field.get(null));
        }
        catch (Exception exception) {
            Message.info("impossible to define glob matcher: org.apache.ivy.plugins.matcher.GlobPatternMatcher was not found", exception);
        }
        this.addReportOutputter(new LogReportOutputter());
        this.addReportOutputter(new XmlReportOutputter());
        this.configureDefaultCircularDependencyStrategies();
        this.listingIgnore.add(".cvsignore");
        this.listingIgnore.add("CVS");
        this.listingIgnore.add(".svn");
        this.listingIgnore.add("maven-metadata.xml");
        this.listingIgnore.add("maven-metadata.xml.md5");
        this.listingIgnore.add("maven-metadata.xml.sha1");
        this.addSystemProperties();
    }

    private synchronized void addSystemProperties() {
        try {
            this.addAllVariables((Map)System.getProperties().clone());
        }
        catch (AccessControlException accessControlException) {
            Message.verbose("access denied to getting all system properties: they won't be available as Ivy variables.\nset " + accessControlException.getPermission() + " permission if you want to access them");
        }
    }

    @Override
    public synchronized void configureRepositories(boolean bl) {
        if (!this.repositoriesConfigured) {
            Properties properties;
            block9: {
                Object object;
                properties = new Properties();
                boolean bl2 = false;
                if (this.useRemoteConfig && bl) {
                    try {
                        object = new URL("http://ant.apache.org/ivy/repository.properties");
                        Message.verbose("configuring repositories with " + object);
                        properties.load(URLHandlerRegistry.getDefault().openStream((URL)object));
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        Message.verbose("unable to use remote repository configuration", exception);
                        properties = new Properties();
                    }
                }
                if (!bl2) {
                    object = null;
                    try {
                        object = IvySettings.getSettingsURL("repository.properties").openStream();
                        properties.load((InputStream)object);
                    }
                    catch (IOException iOException) {
                        Message.error("unable to use internal repository configuration", iOException);
                        if (object == null) break block9;
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.addAllVariables(properties, false);
            this.repositoriesConfigured = true;
        }
    }

    public synchronized void typeDefs(InputStream inputStream) throws IOException {
        this.typeDefs(inputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void typeDefs(InputStream inputStream, boolean bl) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.typeDefs(properties, bl);
        }
        finally {
            inputStream.close();
        }
    }

    public synchronized void typeDefs(Properties properties) {
        this.typeDefs(properties, false);
    }

    public synchronized void typeDefs(Properties properties, boolean bl) {
        for (String string : properties.keySet()) {
            this.typeDef(string, properties.getProperty(string), bl);
        }
    }

    public synchronized void load(File file) throws ParseException, IOException {
        Message.info(":: loading settings :: file = " + file);
        long l = System.currentTimeMillis();
        this.setSettingsVariables(file);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        try {
            new XmlSettingsParser(this).parse(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("given file cannot be transformed to url: " + file);
            illegalArgumentException.initCause(malformedURLException);
            throw illegalArgumentException;
        }
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - l) + "ms)");
        this.dumpSettings();
    }

    public synchronized void load(URL uRL) throws ParseException, IOException {
        Message.info(":: loading settings :: url = " + uRL);
        long l = System.currentTimeMillis();
        this.setSettingsVariables(uRL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        new XmlSettingsParser(this).parse(uRL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - l) + "ms)");
        this.dumpSettings();
    }

    public synchronized void defaultInit() throws IOException {
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.getDefaultCache();
        this.loadDefaultProperties();
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        this.dumpSettings();
    }

    public synchronized void loadDefault() throws ParseException, IOException {
        this.load(IvySettings.getDefaultSettingsURL());
    }

    public synchronized void loadDefault14() throws ParseException, IOException {
        this.load(IvySettings.getDefault14SettingsURL());
    }

    private void loadDefaultProperties() throws IOException {
        this.loadProperties(IvySettings.getDefaultPropertiesURL(), false);
    }

    public static URL getDefaultPropertiesURL() {
        return IvySettings.getSettingsURL("ivy.properties");
    }

    public static URL getDefaultSettingsURL() {
        return IvySettings.getSettingsURL("ivysettings.xml");
    }

    public static URL getDefault14SettingsURL() {
        return IvySettings.getSettingsURL("ivysettings-1.4.xml");
    }

    private String getDefaultSettingsDir() {
        String string = IvySettings.getDefaultSettingsURL().toExternalForm();
        return string.substring(0, string.length() - "ivysettings.xml".length() - 1);
    }

    private static URL getSettingsURL(String string) {
        return XmlSettingsParser.class.getResource(string);
    }

    public synchronized void setSettingsVariables(File file) {
        try {
            this.setVariable("ivy.settings.dir", new File(file.getAbsolutePath()).getParent());
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            this.setVariable("ivy.settings.file", file.getAbsolutePath());
            this.setDeprecatedVariable("ivy.conf.file", "ivy.settings.file");
            this.setVariable("ivy.settings.url", file.toURI().toURL().toExternalForm());
            this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
            this.setVariable("ivy.settings.dir.url", new File(file.getAbsolutePath()).getParentFile().toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("given file cannot be transformed to url: " + file);
            illegalArgumentException.initCause(malformedURLException);
            throw illegalArgumentException;
        }
    }

    private void setDeprecatedVariable(String string, String string2) {
        this.setVariable(string, this.getVariable(string2));
    }

    public synchronized void setSettingsVariables(URL uRL) {
        String string = uRL.toExternalForm();
        this.setVariable("ivy.settings.url", string);
        this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        int n = string.lastIndexOf(47);
        if (n != -1) {
            String string2 = string.substring(0, n);
            this.setVariable("ivy.settings.dir", string2);
            this.setVariable("ivy.settings.dir.url", string2);
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
        } else {
            Message.warn("settings url does not contain any slash (/): ivy.settings.dir variable not set");
        }
    }

    private void dumpSettings() {
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        Message.verbose("\tdefault resolver: " + this.getDefaultResolver());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.doValidate());
        Message.debug("\tcheck up2date: " + this.isCheckUpToDate());
        if (!this.classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this.classpathURLs.size() + " custom classpath urls:");
            Iterator<Object> iterator = this.classpathURLs.iterator();
            while (iterator.hasNext()) {
                Message.debug("\t\t" + iterator.next());
            }
        }
        Message.verbose("\t-- " + this.resolversMap.size() + " resolvers:");
        for (DependencyResolver dependencyResolver : this.resolversMap.values()) {
            dependencyResolver.dumpSettings();
        }
        Message.debug("\tmodule settings:");
        this.moduleSettings.dump("\t\t");
    }

    public synchronized void loadProperties(URL uRL) throws IOException {
        this.loadProperties(uRL, true);
    }

    public synchronized void loadProperties(URL uRL, boolean bl) throws IOException {
        this.loadProperties(uRL.openStream(), bl);
    }

    public synchronized void loadProperties(File file) throws IOException {
        this.loadProperties(file, true);
    }

    public synchronized void loadProperties(File file, boolean bl) throws IOException {
        this.loadProperties(new FileInputStream(file), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(InputStream inputStream, boolean bl) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.addAllVariables(properties, bl);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void setVariable(String string, String string2) {
        this.setVariable(string, string2, true);
    }

    public synchronized void setVariable(String string, String string2, boolean bl) {
        this.setVariable(string, string2, bl, null, null);
    }

    public synchronized void setVariable(String string, String string2, boolean bl, String string3, String string4) {
        if (string3 != null && this.variableContainer.getVariable(string3) == null) {
            Message.verbose("Not setting '" + string + "' to '" + string2 + "' since '" + string3 + "' is not set.");
            return;
        }
        if (string4 != null && this.variableContainer.getVariable(string4) != null) {
            Message.verbose("Not setting '" + string + "' to '" + string2 + "' since '" + string4 + "' is set.");
            return;
        }
        this.variableContainer.setVariable(string, string2, bl);
    }

    public synchronized void addAllVariables(Map map) {
        this.addAllVariables(map, true);
    }

    public synchronized void addAllVariables(Map map, boolean bl) {
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            this.setVariable(string, string2, bl);
        }
    }

    @Override
    public synchronized String substitute(String string) {
        return IvyPatternHelper.substituteVariables(string, this.variableContainer);
    }

    @Override
    public synchronized Map substitute(Map map) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), this.substitute((String)entry.getValue()));
        }
        return linkedHashMap;
    }

    @Override
    public synchronized IvyVariableContainer getVariables() {
        return this.variableContainer;
    }

    public synchronized Class typeDef(String string, String string2) {
        return this.typeDef(string, string2, false);
    }

    public synchronized Class typeDef(String string, String string2, boolean bl) {
        Class clazz = this.classForName(string2, bl);
        if (clazz != null) {
            this.typeDefs.put(string, clazz);
        }
        return clazz;
    }

    private Class classForName(String string, boolean bl) {
        try {
            return this.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                Message.info("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = this.classpathURLs.isEmpty() ? Ivy.class.getClassLoader() : new URLClassLoader(this.classpathURLs.toArray(new URL[this.classpathURLs.size()]), Ivy.class.getClassLoader());
        }
        return this.classloader;
    }

    public synchronized void addClasspathURL(URL uRL) {
        this.classpathURLs.add(uRL);
        this.classloader = null;
    }

    public synchronized Map getTypeDefs() {
        return this.typeDefs;
    }

    public synchronized Class getTypeDef(String string) {
        return (Class)this.typeDefs.get(string);
    }

    public synchronized void addConfigured(DependencyResolver dependencyResolver) {
        this.addResolver(dependencyResolver);
    }

    public synchronized void addConfigured(ModuleDescriptorParser moduleDescriptorParser) {
        ModuleDescriptorParserRegistry.getInstance().addParser(moduleDescriptorParser);
    }

    public synchronized void addConfigured(SignatureGenerator signatureGenerator) {
        this.addSignatureGenerator(signatureGenerator);
    }

    public synchronized void addSignatureGenerator(SignatureGenerator signatureGenerator) {
        this.init(signatureGenerator);
        this.signatureGenerators.put(signatureGenerator.getName(), signatureGenerator);
    }

    @Override
    public synchronized SignatureGenerator getSignatureGenerator(String string) {
        return (SignatureGenerator)this.signatureGenerators.get(string);
    }

    public synchronized void addResolver(DependencyResolver dependencyResolver) {
        if (dependencyResolver == null) {
            throw new NullPointerException("null resolver");
        }
        this.init(dependencyResolver);
        this.resolversMap.put(dependencyResolver.getName(), dependencyResolver);
        if (dependencyResolver instanceof ChainResolver) {
            List list = ((ChainResolver)dependencyResolver).getResolvers();
            for (DependencyResolver dependencyResolver2 : list) {
                this.addResolver(dependencyResolver2);
            }
        } else if (dependencyResolver instanceof DualResolver) {
            DependencyResolver dependencyResolver3;
            DependencyResolver dependencyResolver4 = ((DualResolver)dependencyResolver).getIvyResolver();
            if (dependencyResolver4 != null) {
                this.addResolver(dependencyResolver4);
            }
            if ((dependencyResolver3 = ((DualResolver)dependencyResolver).getArtifactResolver()) != null) {
                this.addResolver(dependencyResolver3);
            }
        }
    }

    public synchronized void setDefaultCache(File file) {
        this.setVariable("ivy.cache.dir", file.getAbsolutePath(), false);
        this.defaultCache = file;
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.defaultCache);
        }
    }

    public synchronized void setDefaultResolver(String string) {
        this.checkResolverName(string);
        if (string != null && !string.equals(this.defaultResolverName)) {
            this.defaultResolver = null;
        }
        this.defaultResolverName = string;
    }

    private void checkResolverName(String string) {
        if (string != null && !this.resolversMap.containsKey(string)) {
            throw new IllegalArgumentException("no resolver found called " + string + ": check your settings");
        }
    }

    public synchronized void addModuleConfiguration(Map map, PatternMatcher patternMatcher, String string, String string2, String string3, String string4) {
        this.checkResolverName(string);
        this.moduleSettings.defineRule(new MapMatcher(map, patternMatcher), new ModuleSettings(string, string2, string3, string4));
    }

    @Override
    public synchronized File resolveFile(String string) {
        return FileUtil.resolveFile(this.baseDir, string);
    }

    public synchronized void setBaseDir(File file) {
        this.baseDir = file.getAbsoluteFile();
        this.setVariable("ivy.basedir", this.baseDir.getAbsolutePath());
        this.setVariable("basedir", this.baseDir.getAbsolutePath(), false);
    }

    public synchronized File getBaseDir() {
        return this.baseDir;
    }

    public synchronized File getDefaultIvyUserDir() {
        if (this.defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.home"), "ivy.home"));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this.defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy2"));
                Message.verbose("no default ivy user dir defined: set to " + this.defaultUserDir);
            }
        }
        return this.defaultUserDir;
    }

    public synchronized void setDefaultIvyUserDir(File file) {
        this.defaultUserDir = file;
        this.setVariable("ivy.default.ivy.user.dir", this.defaultUserDir.getAbsolutePath());
        this.setVariable("ivy.home", this.defaultUserDir.getAbsolutePath());
    }

    public synchronized File getDefaultCache() {
        if (this.defaultCache == null) {
            String string = this.getVariable("ivy.cache.dir");
            if (string != null) {
                this.defaultCache = Checks.checkAbsolute(string, "ivy.cache.dir");
            } else {
                this.setDefaultCache(new File(this.getDefaultIvyUserDir(), "cache"));
                Message.verbose("no default cache defined: set to " + this.defaultCache);
            }
        }
        return this.defaultCache;
    }

    public synchronized void setDefaultRepositoryCacheBasedir(String string) {
        this.setVariable("ivy.cache.repository", string, true);
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.getDefaultRepositoryCacheBasedir());
        }
    }

    public synchronized void setDefaultResolutionCacheBasedir(String string) {
        this.setVariable("ivy.cache.resolution", string, true);
        if (this.resolutionCacheManager != null && this.resolutionCacheManager instanceof DefaultResolutionCacheManager) {
            ((DefaultResolutionCacheManager)this.resolutionCacheManager).setBasedir(this.getDefaultResolutionCacheBasedir());
        }
    }

    public synchronized File getDefaultRepositoryCacheBasedir() {
        String string = this.getVariable("ivy.cache.repository");
        if (string != null) {
            return Checks.checkAbsolute(string, "ivy.cache.repository");
        }
        return this.getDefaultCache();
    }

    public synchronized File getDefaultResolutionCacheBasedir() {
        String string = this.getVariable("ivy.cache.resolution");
        if (string != null) {
            return Checks.checkAbsolute(string, "ivy.cache.resolution");
        }
        return this.getDefaultCache();
    }

    @Override
    public synchronized void setDictatorResolver(DependencyResolver dependencyResolver) {
        this.dictatorResolver = dependencyResolver;
    }

    @Override
    public synchronized DependencyResolver getResolver(ModuleRevisionId moduleRevisionId) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        String string = this.getResolverName(moduleRevisionId);
        return this.getResolver(string);
    }

    public synchronized boolean hasResolver(String string) {
        return this.resolversMap.containsKey(string);
    }

    @Override
    public synchronized DependencyResolver getResolver(String string) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        DependencyResolver dependencyResolver = (DependencyResolver)this.resolversMap.get(string);
        if (dependencyResolver == null) {
            Message.error("unknown resolver " + string);
        }
        return dependencyResolver;
    }

    public synchronized DependencyResolver getDefaultResolver() {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        if (this.defaultResolver == null) {
            this.defaultResolver = (DependencyResolver)this.resolversMap.get(this.defaultResolverName);
        }
        return this.defaultResolver;
    }

    @Override
    public synchronized String getResolverName(ModuleRevisionId moduleRevisionId) {
        ModuleSettings moduleSettings = (ModuleSettings)this.moduleSettings.getRule(moduleRevisionId, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getResolverName() != null;
            }
        });
        return moduleSettings == null ? this.defaultResolverName : moduleSettings.getResolverName();
    }

    @Override
    public synchronized String getDefaultBranch(ModuleId moduleId) {
        ModuleSettings moduleSettings = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getBranch() != null;
            }
        });
        return moduleSettings == null ? this.getDefaultBranch() : moduleSettings.getBranch();
    }

    public synchronized String getDefaultBranch() {
        return this.defaultBranch;
    }

    public synchronized void setDefaultBranch(String string) {
        this.defaultBranch = string;
    }

    @Override
    public synchronized ConflictManager getConflictManager(ModuleId moduleId) {
        ModuleSettings moduleSettings = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getConflictManager() != null;
            }
        });
        if (moduleSettings == null) {
            return this.getDefaultConflictManager();
        }
        ConflictManager conflictManager = this.getConflictManager(moduleSettings.getConflictManager());
        if (conflictManager == null) {
            throw new IllegalStateException("ivy badly configured: unknown conflict manager " + moduleSettings.getConflictManager());
        }
        return conflictManager;
    }

    @Override
    public synchronized String getResolveMode(ModuleId moduleId) {
        ModuleSettings moduleSettings = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getResolveMode() != null;
            }
        });
        return moduleSettings == null ? this.getDefaultResolveMode() : moduleSettings.getResolveMode();
    }

    public synchronized String getDefaultResolveMode() {
        return this.defaultResolveMode;
    }

    public synchronized void setDefaultResolveMode(String string) {
        this.defaultResolveMode = string;
    }

    public synchronized void addConfigured(ConflictManager conflictManager) {
        this.addConflictManager(conflictManager.getName(), conflictManager);
    }

    @Override
    public synchronized ConflictManager getConflictManager(String string) {
        if ("default".equals(string)) {
            return this.getDefaultConflictManager();
        }
        return (ConflictManager)this.conflictsManager.get(string);
    }

    public synchronized void addConflictManager(String string, ConflictManager conflictManager) {
        this.init(conflictManager);
        this.conflictsManager.put(string, conflictManager);
    }

    public synchronized void addConfigured(LatestStrategy latestStrategy) {
        this.addLatestStrategy(latestStrategy.getName(), latestStrategy);
    }

    @Override
    public synchronized LatestStrategy getLatestStrategy(String string) {
        if ("default".equals(string)) {
            return this.getDefaultLatestStrategy();
        }
        return (LatestStrategy)this.latestStrategies.get(string);
    }

    public synchronized void addLatestStrategy(String string, LatestStrategy latestStrategy) {
        this.init(latestStrategy);
        this.latestStrategies.put(string, latestStrategy);
    }

    public synchronized void addConfigured(LockStrategy lockStrategy) {
        this.addLockStrategy(lockStrategy.getName(), lockStrategy);
    }

    public synchronized LockStrategy getLockStrategy(String string) {
        if ("default".equals(string)) {
            return this.getDefaultLockStrategy();
        }
        return (LockStrategy)this.lockStrategies.get(string);
    }

    public synchronized void addLockStrategy(String string, LockStrategy lockStrategy) {
        this.init(lockStrategy);
        this.lockStrategies.put(string, lockStrategy);
    }

    public synchronized void addConfigured(Namespace namespace) {
        this.addNamespace(namespace);
    }

    @Override
    public synchronized Namespace getNamespace(String string) {
        if ("system".equals(string)) {
            return this.getSystemNamespace();
        }
        return (Namespace)this.namespaces.get(string);
    }

    @Override
    public final Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public synchronized void addNamespace(Namespace namespace) {
        this.init(namespace);
        this.namespaces.put(namespace.getName(), namespace);
    }

    public synchronized void addConfigured(PatternMatcher patternMatcher) {
        this.addMatcher(patternMatcher);
    }

    @Override
    public synchronized PatternMatcher getMatcher(String string) {
        return (PatternMatcher)this.matchers.get(string);
    }

    public synchronized void addMatcher(PatternMatcher patternMatcher) {
        this.init(patternMatcher);
        this.matchers.put(patternMatcher.getName(), patternMatcher);
    }

    public synchronized void addConfigured(RepositoryCacheManager repositoryCacheManager) {
        this.addRepositoryCacheManager(repositoryCacheManager);
    }

    @Override
    public synchronized RepositoryCacheManager getRepositoryCacheManager(String string) {
        return (RepositoryCacheManager)this.repositoryCacheManagers.get(string);
    }

    public synchronized void addRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.init(repositoryCacheManager);
        this.repositoryCacheManagers.put(repositoryCacheManager.getName(), repositoryCacheManager);
    }

    @Override
    public synchronized RepositoryCacheManager[] getRepositoryCacheManagers() {
        return this.repositoryCacheManagers.values().toArray(new RepositoryCacheManager[this.repositoryCacheManagers.size()]);
    }

    public synchronized void addConfigured(ReportOutputter reportOutputter) {
        this.addReportOutputter(reportOutputter);
    }

    public synchronized ReportOutputter getReportOutputter(String string) {
        return (ReportOutputter)this.reportOutputters.get(string);
    }

    public synchronized void addReportOutputter(ReportOutputter reportOutputter) {
        this.init(reportOutputter);
        this.reportOutputters.put(reportOutputter.getName(), reportOutputter);
    }

    @Override
    public synchronized ReportOutputter[] getReportOutputters() {
        return this.reportOutputters.values().toArray(new ReportOutputter[this.reportOutputters.size()]);
    }

    public synchronized void addConfigured(VersionMatcher versionMatcher) {
        this.addVersionMatcher(versionMatcher);
    }

    public synchronized VersionMatcher getVersionMatcher(String string) {
        return (VersionMatcher)this.versionMatchers.get(string);
    }

    public synchronized void addVersionMatcher(VersionMatcher versionMatcher) {
        this.init(versionMatcher);
        this.versionMatchers.put(versionMatcher.getName(), versionMatcher);
        if (this.versionMatcher == null) {
            this.versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this.versionMatcher instanceof ChainVersionMatcher) {
            ChainVersionMatcher chainVersionMatcher = (ChainVersionMatcher)this.versionMatcher;
            chainVersionMatcher.add(versionMatcher);
        }
    }

    public synchronized VersionMatcher[] getVersionMatchers() {
        return this.versionMatchers.values().toArray(new VersionMatcher[this.versionMatchers.size()]);
    }

    @Override
    public synchronized VersionMatcher getVersionMatcher() {
        if (this.versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this.versionMatcher;
    }

    public synchronized void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    @Override
    public synchronized CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this.circularDependencyStrategy == null) {
            this.circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this.circularDependencyStrategy;
    }

    public synchronized CircularDependencyStrategy getCircularDependencyStrategy(String string) {
        if ("default".equals(string)) {
            string = "warn";
        }
        return (CircularDependencyStrategy)this.circularDependencyStrategies.get(string);
    }

    public synchronized void setCircularDependencyStrategy(CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDependencyStrategy = circularDependencyStrategy;
    }

    public synchronized void addConfigured(CircularDependencyStrategy circularDependencyStrategy) {
        this.addCircularDependencyStrategy(circularDependencyStrategy);
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDependencyStrategies.put(circularDependencyStrategy.getName(), circularDependencyStrategy);
    }

    private void configureDefaultCircularDependencyStrategies() {
        this.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
    }

    @Override
    public synchronized StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = StatusManager.newDefaultInstance();
        }
        return this.statusManager;
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    @Override
    public synchronized String[] getIgnorableFilenames() {
        return this.listingIgnore.toArray(new String[this.listingIgnore.size()]);
    }

    @Override
    public synchronized void filterIgnore(Collection collection) {
        collection.removeAll(this.listingIgnore);
    }

    @Override
    public synchronized boolean isCheckUpToDate() {
        return this.checkUpToDate;
    }

    public synchronized void setCheckUpToDate(boolean bl) {
        this.checkUpToDate = bl;
    }

    @Override
    public synchronized boolean doValidate() {
        return this.validate;
    }

    public synchronized void setValidate(boolean bl) {
        this.validate = bl;
    }

    @Override
    public synchronized String getVariable(String string) {
        return this.variableContainer.getVariable(string);
    }

    public synchronized ConflictManager getDefaultConflictManager() {
        if (this.defaultConflictManager == null) {
            this.defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
            ((LatestConflictManager)this.defaultConflictManager).setSettings(this);
        }
        return this.defaultConflictManager;
    }

    public synchronized void setDefaultConflictManager(ConflictManager conflictManager) {
        this.defaultConflictManager = conflictManager;
    }

    @Override
    public synchronized LatestStrategy getDefaultLatestStrategy() {
        if (this.defaultLatestStrategy == null) {
            this.defaultLatestStrategy = new LatestRevisionStrategy();
        }
        return this.defaultLatestStrategy;
    }

    public synchronized void setDefaultLatestStrategy(LatestStrategy latestStrategy) {
        this.defaultLatestStrategy = latestStrategy;
    }

    public synchronized LockStrategy getDefaultLockStrategy() {
        if (this.defaultLockStrategy == null) {
            this.defaultLockStrategy = new NoLockStrategy();
        }
        return this.defaultLockStrategy;
    }

    public synchronized void setDefaultLockStrategy(LockStrategy lockStrategy) {
        this.defaultLockStrategy = lockStrategy;
    }

    @Override
    public synchronized RepositoryCacheManager getDefaultRepositoryCacheManager() {
        if (this.defaultRepositoryCacheManager == null) {
            this.defaultRepositoryCacheManager = new DefaultRepositoryCacheManager("default-cache", this, this.getDefaultRepositoryCacheBasedir());
            this.addRepositoryCacheManager(this.defaultRepositoryCacheManager);
        }
        return this.defaultRepositoryCacheManager;
    }

    public synchronized void setDefaultRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.defaultRepositoryCacheManager = repositoryCacheManager;
    }

    @Override
    public synchronized ResolutionCacheManager getResolutionCacheManager() {
        if (this.resolutionCacheManager == null) {
            this.resolutionCacheManager = new DefaultResolutionCacheManager(this.getDefaultResolutionCacheBasedir());
            this.init(this.resolutionCacheManager);
        }
        return this.resolutionCacheManager;
    }

    public synchronized void setResolutionCacheManager(ResolutionCacheManager resolutionCacheManager) {
        this.resolutionCacheManager = resolutionCacheManager;
    }

    public synchronized void addTrigger(Trigger trigger) {
        this.init(trigger);
        this.triggers.add(trigger);
    }

    public synchronized List getTriggers() {
        return this.triggers;
    }

    public synchronized void addConfigured(Trigger trigger) {
        this.addTrigger(trigger);
    }

    public synchronized boolean isUseRemoteConfig() {
        return this.useRemoteConfig;
    }

    public synchronized void setUseRemoteConfig(boolean bl) {
        this.useRemoteConfig = bl;
    }

    public synchronized boolean logModulesInUse() {
        String string = this.getVariable("ivy.log.modules.in.use");
        return string == null || Boolean.valueOf(string) != false;
    }

    @Override
    public synchronized boolean logModuleWhenFound() {
        String string = this.getVariable("ivy.log.module.when.found");
        return string == null || Boolean.valueOf(string) != false;
    }

    @Override
    public synchronized boolean logResolvedRevision() {
        String string = this.getVariable("ivy.log.resolved.revision");
        return string == null || Boolean.valueOf(string) != false;
    }

    @Override
    public synchronized boolean debugConflictResolution() {
        if (this.debugConflictResolution == null) {
            String string = this.getVariable("ivy.log.conflict.resolution");
            this.debugConflictResolution = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugConflictResolution;
    }

    public synchronized boolean debugLocking() {
        if (this.debugLocking == null) {
            String string = this.getVariable("ivy.log.locking");
            this.debugLocking = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugLocking;
    }

    @Override
    public synchronized boolean dumpMemoryUsage() {
        if (this.dumpMemoryUsage == null) {
            String string = this.getVariable("ivy.log.memory");
            this.dumpMemoryUsage = string != null && Boolean.valueOf(string) != false;
        }
        return this.dumpMemoryUsage;
    }

    @Override
    public synchronized boolean logNotConvertedExclusionRule() {
        return this.logNotConvertedExclusionRule;
    }

    @Override
    public synchronized void setLogNotConvertedExclusionRule(boolean bl) {
        this.logNotConvertedExclusionRule = bl;
    }

    private void init(Object object) {
        if (object instanceof IvySettingsAware) {
            ((IvySettingsAware)object).setSettings(this);
        } else if (object instanceof DependencyResolver) {
            ((DependencyResolver)object).setSettings(this);
        }
    }

    public final long getInterruptTimeout() {
        return 2000L;
    }

    public synchronized Collection getResolvers() {
        return this.resolversMap.values();
    }

    @Override
    public synchronized Collection getResolverNames() {
        return this.resolversMap.keySet();
    }

    @Override
    public synchronized Collection getMatcherNames() {
        return this.matchers.keySet();
    }

    public synchronized IvyVariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    public synchronized void setVariableContainer(IvyVariableContainer ivyVariableContainer) {
        this.variableContainer = ivyVariableContainer;
    }

    @Override
    public synchronized RelativeUrlResolver getRelativeUrlResolver() {
        return new NormalRelativeUrlResolver();
    }

    public synchronized void setDefaultCacheIvyPattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.defaultCacheIvyPattern = string;
    }

    public synchronized String getDefaultCacheIvyPattern() {
        return this.defaultCacheIvyPattern;
    }

    public synchronized void setDefaultCacheArtifactPattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.defaultCacheArtifactPattern = string;
    }

    public synchronized String getDefaultCacheArtifactPattern() {
        return this.defaultCacheArtifactPattern;
    }

    public synchronized void setDefaultUseOrigin(boolean bl) {
        this.defaultUseOrigin = bl;
    }

    public synchronized boolean isDefaultUseOrigin() {
        return this.defaultUseOrigin;
    }

    public synchronized void useDeprecatedUseOrigin() {
        Message.deprecated("useOrigin option is deprecated when calling resolve, use useOrigin setting on the cache implementation instead");
        this.setDefaultUseOrigin(true);
    }

    public synchronized void validate() {
        this.validateAll(this.resolversMap.values());
        this.validateAll(this.conflictsManager.values());
        this.validateAll(this.latestStrategies.values());
        this.validateAll(this.lockStrategies.values());
        this.validateAll(this.repositoryCacheManagers.values());
        this.validateAll(this.reportOutputters.values());
        this.validateAll(this.circularDependencyStrategies.values());
        this.validateAll(this.versionMatchers.values());
        this.validateAll(this.namespaces.values());
    }

    private void validateAll(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof Validatable)) continue;
            ((Validatable)e).validate();
        }
    }

    @Override
    public Namespace getContextNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public synchronized void addConfigured(ArchivePacking archivePacking) {
        this.init(archivePacking);
        this.packingRegistry.register(archivePacking);
    }

    public PackingRegistry getPackingRegistry() {
        return this.packingRegistry;
    }

    private static class ModuleSettings {
        private String resolverName;
        private String branch;
        private String conflictManager;
        private String resolveMode;

        public ModuleSettings(String string, String string2, String string3, String string4) {
            this.resolverName = string;
            this.branch = string2;
            this.conflictManager = string3;
            this.resolveMode = string4;
        }

        public String toString() {
            return (this.resolverName != null ? "resolver: " + this.resolverName : "") + (this.branch != null ? "branch: " + this.branch : "") + (this.conflictManager != null ? "conflictManager: " + this.conflictManager : "") + (this.resolveMode != null ? "resolveMode: " + this.resolveMode : "");
        }

        public String getBranch() {
            return this.branch;
        }

        public String getResolverName() {
            return this.resolverName;
        }

        public String getConflictManager() {
            return this.conflictManager;
        }

        public String getResolveMode() {
            return this.resolveMode;
        }
    }
}

