/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.osgi.filter.OSGiFilter;

public abstract class MultiOperatorFilter
extends OSGiFilter {
    private List<OSGiFilter> subFilters = new ArrayList<OSGiFilter>();

    public MultiOperatorFilter() {
    }

    public MultiOperatorFilter(OSGiFilter[] oSGiFilterArray) {
        for (int i = 0; i < oSGiFilterArray.length; ++i) {
            OSGiFilter oSGiFilter = oSGiFilterArray[i];
            this.add(oSGiFilter);
        }
    }

    protected abstract char operator();

    @Override
    public void append(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        stringBuffer.append(this.operator());
        for (OSGiFilter oSGiFilter : this.subFilters) {
            oSGiFilter.append(stringBuffer);
        }
        stringBuffer.append(')');
    }

    public void add(OSGiFilter oSGiFilter) {
        this.subFilters.add(oSGiFilter);
    }

    public List<OSGiFilter> getSubFilters() {
        return this.subFilters;
    }

    public int hashCode() {
        int n = 1;
        for (OSGiFilter oSGiFilter : this.subFilters) {
            n = 31 * n + (oSGiFilter == null ? 0 : oSGiFilter.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MultiOperatorFilter)) {
            return false;
        }
        MultiOperatorFilter multiOperatorFilter = (MultiOperatorFilter)object;
        if (this.subFilters == null) {
            if (multiOperatorFilter.subFilters != null) {
                return false;
            }
        } else {
            if (multiOperatorFilter.subFilters == null) {
                return false;
            }
            if (this.subFilters.size() != multiOperatorFilter.subFilters.size()) {
                return false;
            }
            if (!this.subFilters.containsAll(multiOperatorFilter.subFilters)) {
                return false;
            }
        }
        return true;
    }
}

