/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class P2MetadataParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;
    private int logLevel = 2;

    public P2MetadataParser(P2Descriptor p2Descriptor) {
        this.p2Descriptor = p2Descriptor;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    @Override
    public void parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(this.p2Descriptor);
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)repositoryHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    private static String namespace2Type(String string) {
        if (string.equals("java.package")) {
            return "package";
        }
        if (string.equals("osgi.bundle")) {
            return "bundle";
        }
        return null;
    }

    private class InstructionHandler
    extends DelegatingHandler {
        private static final String INSTRUCTION = "instruction";
        private static final String KEY = "key";
        String key;

        public InstructionHandler() {
            super(INSTRUCTION);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.key = attributes.getValue(KEY);
        }
    }

    private class InstructionsHandler
    extends DelegatingHandler {
        private static final String INSTRUCTIONS = "instructions";
        String manifest;
        Boolean zipped;

        public InstructionsHandler() {
            super(INSTRUCTIONS);
            this.addChild(new InstructionHandler(), new DelegatingHandler.ChildElementHandler<InstructionHandler>(){

                @Override
                public void childHanlded(InstructionHandler instructionHandler) {
                    InstructionsHandler.this.manifest = null;
                    InstructionsHandler.this.zipped = null;
                    String string = instructionHandler.getBufferedChars().trim();
                    if ("manifest".equals(instructionHandler.key)) {
                        InstructionsHandler.this.manifest = string;
                    } else if ("zipped".equals(instructionHandler.key) && string.length() != 0) {
                        InstructionsHandler.this.zipped = Boolean.valueOf(string);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
        }
    }

    private class TouchpointDataHandler
    extends DelegatingHandler {
        private static final String TOUCHPOINTDATA = "touchpointData";
        String manifest;
        Boolean zipped;

        public TouchpointDataHandler() {
            super(TOUCHPOINTDATA);
            this.addChild(new InstructionsHandler(), new DelegatingHandler.ChildElementHandler<InstructionsHandler>(){

                @Override
                public void childHanlded(InstructionsHandler instructionsHandler) {
                    TouchpointDataHandler.this.manifest = instructionsHandler.manifest;
                    TouchpointDataHandler.this.zipped = instructionsHandler.zipped;
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
        }
    }

    private class ArtifactHandler
    extends DelegatingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String ID = "id";
        private static final String VERSION = "version";
        private static final String CLASSIFIER = "classifier";
        P2Artifact artifact;

        public ArtifactHandler() {
            super(ARTIFACT);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            String string3 = attributes.getValue(CLASSIFIER);
            try {
                this.artifact = new P2Artifact(string, new Version(string2), string3);
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on artifact '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
        }
    }

    private class ArtifactsHandler
    extends DelegatingHandler {
        private static final String ARTIFACTS = "artifacts";
        private static final String SIZE = "size";
        List<P2Artifact> artifacts;

        public ArtifactsHandler() {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegatingHandler.ChildElementHandler<ArtifactHandler>(){

                @Override
                public void childHanlded(ArtifactHandler artifactHandler) {
                    ArtifactsHandler.this.artifacts.add(artifactHandler.artifact);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.artifacts = new ArrayList<P2Artifact>(n);
        }
    }

    private class MetaRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String META_REQUIREMENTS = "metaRequirements";

        public MetaRequirementsHandler() {
            super(META_REQUIREMENTS);
        }
    }

    private class HostRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String HOST_REQUIREMENTS = "hostRequirements";

        public HostRequirementsHandler() {
            super(HOST_REQUIREMENTS);
        }
    }

    private class RequiredHandler
    extends DelegatingHandler {
        private static final String REQUIRED = "required";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String RANGE = "range";
        private static final String OPTIONAL = "optional";
        String namespace;
        String name;
        VersionRange range;
        boolean optional;

        public RequiredHandler() {
            super(REQUIRED);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXParseException {
            this.namespace = attributes.getValue(NAMESPACE);
            this.name = attributes.getValue(NAME);
            try {
                this.range = new VersionRange(attributes.getValue(RANGE));
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
            this.optional = this.getOptionalBooleanAttribute(attributes, OPTIONAL, Boolean.FALSE);
        }
    }

    private class RequiresHandler
    extends AbstractRequirementHandler {
        private static final String REQUIRES = "requires";

        public RequiresHandler() {
            super(REQUIRES);
        }
    }

    abstract class AbstractRequirementHandler
    extends DelegatingHandler {
        private static final String SIZE = "size";
        List<BundleRequirement> requirements;

        public AbstractRequirementHandler(String string) {
            super(string);
            this.addChild(new RequiredHandler(), new DelegatingHandler.ChildElementHandler<RequiredHandler>(){

                @Override
                public void childHanlded(RequiredHandler requiredHandler) {
                    String string = requiredHandler.name;
                    VersionRange versionRange = requiredHandler.range;
                    String string2 = P2MetadataParser.namespace2Type(requiredHandler.namespace);
                    if (string2 == null) {
                        if (P2MetadataParser.this.logLevel >= 4) {
                            Message.debug("Unsupported required capability " + requiredHandler.namespace + " " + string + " " + versionRange);
                        }
                    } else {
                        String string3 = requiredHandler.optional ? "optional" : null;
                        AbstractRequirementHandler.this.requirements.add(new BundleRequirement(string2, string, versionRange, string3));
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.requirements = new ArrayList<BundleRequirement>(n);
        }
    }

    private static class ProvidedHandler
    extends DelegatingHandler {
        private static final String PROVIDED = "provided";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        String namespace;
        String name;
        Version version;

        public ProvidedHandler() {
            super(PROVIDED);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.namespace = attributes.getValue(NAMESPACE);
            this.name = attributes.getValue(NAME);
            try {
                this.version = new Version(attributes.getValue(VERSION));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on provided capability: " + this.version + " (" + parseException.getMessage() + ")");
            }
        }
    }

    private class ProvidesHandler
    extends DelegatingHandler {
        private static final String PROVIDES = "provides";
        private static final String SIZE = "size";
        List<BundleCapability> capabilities;
        String eclipseType;

        public ProvidesHandler() {
            super(PROVIDES);
            this.addChild(new ProvidedHandler(), new DelegatingHandler.ChildElementHandler<ProvidedHandler>(){

                @Override
                public void childHanlded(ProvidedHandler providedHandler) {
                    if (providedHandler.namespace.equals("org.eclipse.equinox.p2.eclipse.type")) {
                        ProvidesHandler.this.eclipseType = providedHandler.name;
                    } else {
                        String string = P2MetadataParser.namespace2Type(providedHandler.namespace);
                        if (string == null) {
                            if (P2MetadataParser.this.logLevel >= 4) {
                                Message.debug("Unsupported provided capability " + providedHandler.namespace + " " + providedHandler.name + " " + providedHandler.version);
                            }
                            return;
                        }
                        BundleCapability bundleCapability = string == "package" ? new ExportPackage(providedHandler.name, providedHandler.version) : new BundleCapability(string, providedHandler.name, providedHandler.version);
                        ProvidesHandler.this.capabilities.add(bundleCapability);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.capabilities = new ArrayList<BundleCapability>(n);
        }
    }

    private static class FilterHandler
    extends DelegatingHandler {
        private static final String FILTER = "filter";

        public FilterHandler() {
            super(FILTER);
            this.setBufferingChar(true);
        }
    }

    class UnitHandler
    extends DelegatingHandler {
        private static final String CATEGORY_PROPERTY = "org.eclipse.equinox.p2.type.category";
        private static final String UNIT = "unit";
        private static final String ID = "id";
        private static final String VERSION = "version";
        BundleInfo bundleInfo;

        public UnitHandler() {
            super(UNIT);
            this.addChild(new PropertiesParser.PropertiesHandler(new String[]{CATEGORY_PROPERTY}), new DelegatingHandler.ChildElementHandler<PropertiesParser.PropertiesHandler>(){

                @Override
                public void childHanlded(PropertiesParser.PropertiesHandler propertiesHandler) {
                    String string = propertiesHandler.properties.get(UnitHandler.CATEGORY_PROPERTY);
                    if (string != null && Boolean.valueOf(string).booleanValue()) {
                        propertiesHandler.getParent().skip();
                        UnitHandler.this.bundleInfo = null;
                    }
                }
            });
            this.addChild(new ProvidesHandler(), new DelegatingHandler.ChildElementHandler<ProvidesHandler>(){

                @Override
                public void childHanlded(ProvidesHandler providesHandler) {
                    if ("source".equals(providesHandler.eclipseType)) {
                        UnitHandler.this.bundleInfo.setSource(true);
                        String string = UnitHandler.this.bundleInfo.getSymbolicName();
                        if (string.endsWith(".source")) {
                            UnitHandler.this.bundleInfo.setSymbolicNameTarget(string.substring(0, string.length() - 7));
                            UnitHandler.this.bundleInfo.setVersionTarget(UnitHandler.this.bundleInfo.getVersion());
                        }
                    }
                    for (BundleCapability bundleCapability : providesHandler.capabilities) {
                        UnitHandler.this.bundleInfo.addCapability(bundleCapability);
                    }
                }
            });
            this.addChild(new FilterHandler(), new DelegatingHandler.ChildElementHandler<FilterHandler>(){

                @Override
                public void childHanlded(FilterHandler filterHandler) {
                }
            });
            this.addChild(new RequiresHandler(), new DelegatingHandler.ChildElementHandler<RequiresHandler>(){

                @Override
                public void childHanlded(RequiresHandler requiresHandler) {
                    for (BundleRequirement bundleRequirement : requiresHandler.requirements) {
                        UnitHandler.this.bundleInfo.addRequirement(bundleRequirement);
                    }
                }
            });
            this.addChild(new HostRequirementsHandler(), new DelegatingHandler.ChildElementHandler<HostRequirementsHandler>(){

                @Override
                public void childHanlded(HostRequirementsHandler hostRequirementsHandler) {
                }
            });
            this.addChild(new MetaRequirementsHandler(), new DelegatingHandler.ChildElementHandler<MetaRequirementsHandler>(){

                @Override
                public void childHanlded(MetaRequirementsHandler metaRequirementsHandler) {
                }
            });
            this.addChild(new ArtifactsHandler(), new DelegatingHandler.ChildElementHandler<ArtifactsHandler>(){

                @Override
                public void childHanlded(ArtifactsHandler artifactsHandler) {
                }
            });
            this.addChild(new TouchpointDataHandler(), new DelegatingHandler.ChildElementHandler<TouchpointDataHandler>(){

                @Override
                public void childHanlded(TouchpointDataHandler touchpointDataHandler) throws SAXParseException {
                    if (touchpointDataHandler.zipped != null) {
                        UnitHandler.this.bundleInfo.setHasInnerClasspath(touchpointDataHandler.zipped);
                    }
                    if (!UnitHandler.this.bundleInfo.isSource()) {
                        return;
                    }
                    if (touchpointDataHandler.manifest != null) {
                        BundleInfo bundleInfo;
                        String string = ManifestParser.formatLines(touchpointDataHandler.manifest.trim());
                        try {
                            bundleInfo = ManifestParser.parseManifest(string);
                        }
                        catch (IOException iOException) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " could not be parsed", iOException);
                            }
                            return;
                        }
                        catch (ParseException parseException) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is ill formed", parseException);
                            }
                            return;
                        }
                        if (!bundleInfo.isSource()) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is not declaring being a source.");
                            }
                            return;
                        }
                        String string2 = bundleInfo.getSymbolicNameTarget();
                        if (string2 == null) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is not declaring a target symbolic name.");
                            }
                            return;
                        }
                        Version version = bundleInfo.getVersionTarget();
                        if (version == null) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is not declaring a target version.");
                            }
                            return;
                        }
                        UnitHandler.this.bundleInfo.setSymbolicNameTarget(string2);
                        UnitHandler.this.bundleInfo.setVersionTarget(version);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            try {
                this.bundleInfo = new BundleInfo(string, new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on bundle '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
        }
    }

    private class UnitsHandler
    extends DelegatingHandler {
        private static final String UNITS = "units";
        private static final String SIZE = "size";
        List<BundleInfo> bundles;

        public UnitsHandler() {
            super(UNITS);
            this.addChild(new UnitHandler(), new DelegatingHandler.ChildElementHandler<UnitHandler>(){

                @Override
                public void childHanlded(UnitHandler unitHandler) {
                    if (unitHandler.bundleInfo != null && !unitHandler.bundleInfo.getCapabilities().isEmpty()) {
                        UnitsHandler.this.bundles.add(unitHandler.bundleInfo);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.bundles = new ArrayList<BundleInfo>(n);
        }
    }

    private class RepositoryReferenceHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";
        private static final String URI = "uri";
        private static final String URL = "url";
        URI uri;

        public RepositoryReferenceHandler() {
            super(REPOSITORY);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(URI);
            String string2 = attributes.getValue(URL);
            if (string != null) {
                try {
                    this.uri = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new SAXParseException("Invalid uri attribute " + string + "(" + uRISyntaxException.getMessage() + ")", this.getLocator());
                }
            }
            if (this.uri != null && string2 != null) {
                try {
                    this.uri = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new SAXParseException("Invalid url attribute " + string2 + "(" + uRISyntaxException.getMessage() + ")", this.getLocator());
                }
            }
        }
    }

    private class ReferencesHandler
    extends DelegatingHandler {
        private static final String REFERENCES = "references";
        private static final String SIZE = "size";
        List<URI> repositoryUris;

        public ReferencesHandler() {
            super(REFERENCES);
            this.addChild(new RepositoryReferenceHandler(), new DelegatingHandler.ChildElementHandler<RepositoryReferenceHandler>(){

                @Override
                public void childHanlded(RepositoryReferenceHandler repositoryReferenceHandler) {
                    ReferencesHandler.this.repositoryUris.add(repositoryReferenceHandler.uri);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.repositoryUris = new ArrayList<URI>(n);
        }
    }

    private class RepositoryHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";

        public RepositoryHandler(final P2Descriptor p2Descriptor) {
            super(REPOSITORY);
            this.addChild(new UnitsHandler(), new DelegatingHandler.ChildElementHandler<UnitsHandler>(){

                @Override
                public void childHanlded(UnitsHandler unitsHandler) {
                    for (BundleInfo bundleInfo : unitsHandler.bundles) {
                        p2Descriptor.addBundle(bundleInfo);
                    }
                }
            });
            this.addChild(new ReferencesHandler(), new DelegatingHandler.ChildElementHandler<ReferencesHandler>(){

                @Override
                public void childHanlded(ReferencesHandler referencesHandler) {
                }
            });
        }
    }
}

