/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.net.URI;
import java.text.ParseException;
import java.util.Iterator;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.util.Message;

public class BundleRepoDescriptor
extends EditableRepoDescriptor {
    private String name;
    private String lastModified;

    public BundleRepoDescriptor(URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        super(uRI, executionEnvironmentProfileProvider);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setLastModified(String string) {
        this.lastModified = string;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void populate(Iterator<ManifestAndLocation> iterator) {
        while (iterator.hasNext()) {
            ManifestAndLocation manifestAndLocation = iterator.next();
            try {
                BundleInfo bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.addArtifact(new BundleArtifact(false, manifestAndLocation.getUri(), null));
                this.addBundle(bundleInfo);
            }
            catch (ParseException parseException) {
                Message.error("Rejected " + manifestAndLocation.getUri() + ": " + parseException.getMessage());
            }
        }
    }
}

