/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.Message;

public class EditableRepoDescriptor
extends RepoDescriptor {
    private final Map<String, Map<String, Set<ModuleDescriptorWrapper>>> moduleByCapabilities = new HashMap<String, Map<String, Set<ModuleDescriptorWrapper>>>();
    private final Set<ModuleDescriptorWrapper> modules = new HashSet<ModuleDescriptorWrapper>();
    private final ExecutionEnvironmentProfileProvider profileProvider;
    private final URI baseUri;
    private int logLevel = 2;

    public EditableRepoDescriptor(URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        this.baseUri = uRI;
        this.profileProvider = executionEnvironmentProfileProvider;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public Iterator<ModuleDescriptorWrapper> getModules() {
        return this.modules.iterator();
    }

    @Override
    public Set<String> getCapabilities() {
        return this.moduleByCapabilities.keySet();
    }

    @Override
    public Set<ModuleDescriptorWrapper> findModules(String string, String string2) {
        Map<String, Set<ModuleDescriptorWrapper>> map = this.moduleByCapabilities.get(string);
        if (map == null) {
            return null;
        }
        return map.get(string2);
    }

    public ModuleDescriptorWrapper findModule(String string, Version version) {
        Set<ModuleDescriptorWrapper> set = this.findModules("bundle", string);
        if (set == null) {
            return null;
        }
        for (ModuleDescriptorWrapper moduleDescriptorWrapper : set) {
            if (!moduleDescriptorWrapper.getBundleInfo().getVersion().equals(version)) continue;
            return moduleDescriptorWrapper;
        }
        return null;
    }

    @Override
    public Set<String> getCapabilityValues(String string) {
        Map<String, Set<ModuleDescriptorWrapper>> map = this.moduleByCapabilities.get(string);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    private void add(String string, String string2, ModuleDescriptorWrapper moduleDescriptorWrapper) {
        Set<ModuleDescriptorWrapper> set;
        this.modules.add(moduleDescriptorWrapper);
        Map<String, Set<ModuleDescriptorWrapper>> map = this.moduleByCapabilities.get(string);
        if (map == null) {
            map = new HashMap<String, Set<ModuleDescriptorWrapper>>();
            this.moduleByCapabilities.put(string, map);
        }
        if ((set = map.get(string2)) == null) {
            set = new HashSet<ModuleDescriptorWrapper>();
            map.put(string2, set);
        }
        if (!set.add(moduleDescriptorWrapper) && this.logLevel <= 4) {
            Message.debug("Duplicate module in the repo " + this.baseUri + " for " + string + " " + string2 + ": " + moduleDescriptorWrapper.getBundleInfo().getSymbolicName() + "#" + moduleDescriptorWrapper.getBundleInfo().getVersion());
        }
    }

    public void addBundle(BundleInfo bundleInfo) {
        ModuleDescriptorWrapper moduleDescriptorWrapper = this.findModule(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        if (moduleDescriptorWrapper != null) {
            Message.debug("Duplicate module " + bundleInfo.getSymbolicName() + "@" + bundleInfo.getVersion());
            return;
        }
        ModuleDescriptorWrapper moduleDescriptorWrapper2 = new ModuleDescriptorWrapper(bundleInfo, this.baseUri, this.profileProvider);
        this.add("bundle", bundleInfo.getSymbolicName(), moduleDescriptorWrapper2);
        for (BundleCapability bundleCapability : bundleInfo.getCapabilities()) {
            this.add(bundleCapability.getType(), bundleCapability.getName(), moduleDescriptorWrapper2);
        }
    }

    public String toString() {
        return this.modules.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.modules == null ? 0 : ((Object)this.modules).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EditableRepoDescriptor editableRepoDescriptor = (EditableRepoDescriptor)object;
        return !(this.modules == null ? editableRepoDescriptor.modules != null : !((Object)this.modules).equals(editableRepoDescriptor.modules));
    }
}

