/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.OSGiManifestParser;

public class ModuleDescriptorWrapper {
    private BundleInfo bundleInfo;
    private DefaultModuleDescriptor md;
    private URI baseUri;
    private ExecutionEnvironmentProfileProvider profileProvider;

    public ModuleDescriptorWrapper(BundleInfo bundleInfo, URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        this.bundleInfo = bundleInfo;
        this.baseUri = uRI;
        this.profileProvider = executionEnvironmentProfileProvider;
    }

    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultModuleDescriptor getModuleDescriptor() {
        if (this.md == null) {
            ModuleDescriptorWrapper moduleDescriptorWrapper = this;
            synchronized (moduleDescriptorWrapper) {
                if (this.md != null) {
                    return this.md;
                }
                this.md = BundleInfoAdapter.toModuleDescriptor(OSGiManifestParser.getInstance(), this.baseUri, this.bundleInfo, this.profileProvider);
            }
        }
        return this.md;
    }

    public static Collection<ModuleDescriptor> unwrap(Collection<ModuleDescriptorWrapper> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleDescriptor> arrayList = new ArrayList<ModuleDescriptor>();
        for (ModuleDescriptorWrapper moduleDescriptorWrapper : collection) {
            arrayList.add(moduleDescriptorWrapper.getModuleDescriptor());
        }
        return arrayList;
    }

    public int hashCode() {
        return this.bundleInfo.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ModuleDescriptorWrapper)) {
            return false;
        }
        return this.bundleInfo.equals(((ModuleDescriptorWrapper)object).bundleInfo);
    }

    public String toString() {
        return this.getModuleDescriptor().toString();
    }
}

