/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.osgi.repo.AbstractFSManifestIterable;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;

public class RepositoryManifestIterable
extends AbstractFSManifestIterable<String> {
    private final Repository repo;

    public RepositoryManifestIterable(Repository repository) {
        super("");
        this.repo = repository;
    }

    @Override
    protected URI buildBundleURI(String string) throws IOException {
        Resource resource = this.repo.getResource(string);
        try {
            return new URI(resource.getName());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(resource.getName()).toURI();
        }
    }

    @Override
    protected InputStream getInputStream(String string) throws IOException {
        return this.repo.getResource(string).openStream();
    }

    @Override
    protected List<String> listBundleFiles(String string) throws IOException {
        return this.asList(ResolverHelper.listAll(this.repo, string));
    }

    @Override
    protected List<String> listDirs(String string) throws IOException {
        return this.asList(ResolverHelper.listAll(this.repo, string));
    }

    private List<String> asList(String[] stringArray) {
        return stringArray == null ? Collections.emptyList() : Arrays.asList(stringArray);
    }
}

