/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.repo.AbstractOSGiResolver;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.updatesite.UpdateSiteLoader;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class UpdateSiteResolver
extends AbstractOSGiResolver {
    private String url;
    private Long metadataTtl;
    private Boolean forceMetadataUpdate;
    private String logLevel;

    public void setUrl(String string) {
        this.url = string;
    }

    public void setMetadataTtl(Long l) {
        this.metadataTtl = l;
    }

    public void setForceMetadataUpdate(Boolean bl) {
        this.forceMetadataUpdate = bl;
    }

    public void setLogLevel(String string) {
        this.logLevel = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init() {
        RepoDescriptor repoDescriptor;
        int n;
        if (this.url == null) {
            throw new RuntimeException("Missing url");
        }
        CacheResourceOptions cacheResourceOptions = new CacheResourceOptions();
        if (this.metadataTtl != null) {
            cacheResourceOptions.setTtl(this.metadataTtl);
        }
        if (this.forceMetadataUpdate != null) {
            cacheResourceOptions.setForce(this.forceMetadataUpdate);
        }
        if (this.logLevel != null) {
            if ("debug".equalsIgnoreCase(this.logLevel)) {
                n = 4;
            } else if ("verbose".equalsIgnoreCase(this.logLevel)) {
                n = 3;
            } else if ("info".equalsIgnoreCase(this.logLevel)) {
                n = 2;
            } else if ("warn".equalsIgnoreCase(this.logLevel)) {
                n = 1;
            } else {
                if (!"error".equalsIgnoreCase(this.logLevel)) throw new RuntimeException("Unknown log level: " + this.logLevel);
                n = 0;
            }
        } else {
            n = 2;
        }
        cacheResourceOptions.setListener(new DownloadListener(){

            @Override
            public void startArtifactDownload(RepositoryCacheManager repositoryCacheManager, ResolvedResource resolvedResource, Artifact artifact, ArtifactOrigin artifactOrigin) {
                if (n <= 2) {
                    Message.info("\tdownloading " + resolvedResource.getResource().getName());
                }
            }

            @Override
            public void needArtifact(RepositoryCacheManager repositoryCacheManager, Artifact artifact) {
                if (n <= 3) {
                    Message.verbose("\ttrying to download " + artifact);
                }
            }

            @Override
            public void endArtifactDownload(RepositoryCacheManager repositoryCacheManager, Artifact artifact, ArtifactDownloadReport artifactDownloadReport, File file) {
                if (n <= 3) {
                    if (artifactDownloadReport.isDownloaded()) {
                        Message.verbose("\tdownloaded to " + file.getAbsolutePath());
                    } else {
                        Message.verbose("\tnothing to download");
                    }
                }
            }
        });
        UpdateSiteLoader updateSiteLoader = new UpdateSiteLoader(this.getRepositoryCacheManager(), this.getEventManager(), cacheResourceOptions);
        updateSiteLoader.setLogLevel(n);
        try {
            repoDescriptor = updateSiteLoader.load(new URI(this.url));
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO issue while trying to read the update site (" + iOException.getMessage() + ")");
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Failed to parse the updatesite (" + parseException.getMessage() + ")", parseException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Illformed updatesite (" + sAXException.getMessage() + ")", sAXException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Illformed url (" + uRISyntaxException.getMessage() + ")", uRISyntaxException);
        }
        if (repoDescriptor == null) {
            this.setRepoDescriptor(FAILING_REPO_DESCRIPTOR);
            throw new RuntimeException("No update site was found at the location: " + this.url);
        }
        this.setRepoDescriptor(repoDescriptor);
    }
}

