/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.text.ParseException;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int patch;
    private String qualifier;
    private String version;
    private String input;
    private boolean splitted = false;
    private boolean toString = false;

    public Version(String string, String string2) throws ParseException {
        this(string2 == null ? string : string + "." + string2);
    }

    public Version(String string) throws ParseException {
        this.input = string;
        this.splitted = false;
        this.toString = false;
    }

    public Version(int n, int n2, int n3, String string) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.qualifier = string;
        this.splitted = true;
        this.toString = false;
    }

    public Version(Version version, String string) {
        this.major = version.major;
        this.minor = version.minor;
        this.patch = version.patch;
        this.qualifier = version.qualifier == null ? string : version.qualifier + string;
        this.splitted = true;
        this.toString = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSplitted() {
        if (!this.splitted) {
            Version version = this;
            synchronized (version) {
                if (this.splitted) {
                    return;
                }
                String[] stringArray = this.input.split("\\.");
                if (stringArray == null || stringArray.length == 0 || stringArray.length > 4) {
                    throw new RuntimeException(new ParseException("Ill formed OSGi version", 0));
                }
                try {
                    this.major = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException(new ParseException("Major part of an OSGi version should be an integer", 0));
                }
                try {
                    this.minor = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : 0;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException(new ParseException("Minor part of an OSGi version should be an integer", 0));
                }
                try {
                    this.patch = stringArray.length >= 3 ? Integer.parseInt(stringArray[2]) : 0;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException(new ParseException("Patch part of an OSGi version should be an integer", 0));
                }
                this.qualifier = stringArray.length == 4 ? stringArray[3] : null;
                this.splitted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureToString() {
        if (!this.toString) {
            Version version = this;
            synchronized (version) {
                if (this.toString) {
                    return;
                }
                this.ensureSplitted();
                this.version = this.major + "." + this.minor + "." + this.patch + (this.qualifier == null ? "" : "." + this.qualifier);
                this.toString = true;
            }
        }
    }

    public String toString() {
        this.ensureToString();
        return this.version;
    }

    public int hashCode() {
        this.ensureSplitted();
        int n = 1;
        n = 31 * n + this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.patch;
        n = 31 * n + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        this.ensureSplitted();
        version.ensureSplitted();
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.patch != version.patch) {
            return false;
        }
        return !(this.qualifier == null ? version.qualifier != null : !this.qualifier.equals(version.qualifier));
    }

    public Version withNudgedPatch() {
        this.ensureSplitted();
        return new Version(this.major, this.minor, this.patch + 1, null);
    }

    public Version withoutQualifier() {
        this.ensureSplitted();
        return new Version(this.major, this.minor, this.patch, null);
    }

    public String qualifier() {
        this.ensureSplitted();
        return this.qualifier == null ? "" : this.qualifier;
    }

    public int compareUnqualified(Version version) {
        this.ensureSplitted();
        version.ensureSplitted();
        int n = this.major - version.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - version.minor;
        if (n != 0) {
            return n;
        }
        n = this.patch - version.patch;
        if (n != 0) {
            return n;
        }
        return 0;
    }

    @Override
    public int compareTo(Version version) {
        this.ensureSplitted();
        version.ensureSplitted();
        int n = this.compareUnqualified(version);
        if (n != 0) {
            return n;
        }
        if (this.qualifier == null) {
            return version.qualifier != null ? -1 : 0;
        }
        if (version.qualifier == null) {
            return 1;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

