/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.CredentialsUtil;
import org.apache.ivy.util.Message;

public final class SshCache {
    private static final int SSH_DEFAULT_PORT = 22;
    private static SshCache instance = new SshCache();
    private Map uriCacheMap = new HashMap();
    private Map sessionCacheMap = new HashMap();

    private SshCache() {
    }

    public static SshCache getInstance() {
        return instance;
    }

    private Entry getCacheEntry(String string, String string2, int n) {
        return (Entry)this.uriCacheMap.get(SshCache.createCacheKey(string, string2, n));
    }

    private static String createCacheKey(String string, String string2, int n) {
        String string3 = "22";
        if (n != -1 && n != 22) {
            string3 = Integer.toString(n);
        }
        return string.toLowerCase(Locale.US).trim() + "@" + string2.toLowerCase(Locale.US).trim() + ":" + string3;
    }

    private Entry getCacheEntry(Session session) {
        return (Entry)this.sessionCacheMap.get(session);
    }

    private void setSession(String string, String string2, int n, Session session) {
        Object object;
        Entry entry = (Entry)this.uriCacheMap.get(SshCache.createCacheKey(string, string2, n));
        Session session2 = null;
        if (entry != null) {
            session2 = entry.getSession();
        }
        if (session2 != null && !session2.equals(session) && session2.isConnected()) {
            entry.releaseChannelSftp();
            object = session2.getHost();
            Message.verbose(":: SSH :: closing ssh connection from " + (String)object + "...");
            session2.disconnect();
            Message.verbose(":: SSH :: ssh connection closed from " + (String)object);
        }
        if (session == null && entry != null) {
            this.uriCacheMap.remove(SshCache.createCacheKey(string, string2, n));
            if (entry.getSession() != null) {
                this.sessionCacheMap.remove(entry.getSession());
            }
        } else {
            object = new Entry(session, string, string2, n);
            this.uriCacheMap.put(SshCache.createCacheKey(string, string2, n), object);
            this.sessionCacheMap.put(session, object);
        }
    }

    public void clearSession(Session session) {
        Entry entry = (Entry)this.sessionCacheMap.get(session);
        if (entry != null) {
            this.setSession(entry.getUser(), entry.getHost(), entry.getPort(), null);
        }
    }

    public ChannelSftp getChannelSftp(Session session) throws IOException {
        ChannelSftp channelSftp = null;
        Entry entry = this.getCacheEntry(session);
        if (entry != null && (channelSftp = entry.getChannelSftp()) != null && !channelSftp.isConnected()) {
            entry.releaseChannelSftp();
            channelSftp = null;
        }
        return channelSftp;
    }

    public void attachChannelSftp(Session session, ChannelSftp channelSftp) {
        Entry entry = this.getCacheEntry(session);
        if (entry == null) {
            throw new IllegalArgumentException("No entry for " + session + " in the cache");
        }
        entry.setChannelSftp(channelSftp);
    }

    private boolean attemptAgentUse(JSch jSch) {
        try {
            Connector connector = ConnectorFactory.getDefault().createConnector();
            jSch.setIdentityRepository((IdentityRepository)new RemoteIdentityRepository(connector));
            return true;
        }
        catch (AgentProxyException agentProxyException) {
            Message.verbose(":: SSH :: Failure connecting to agent :: " + agentProxyException.toString());
            return false;
        }
    }

    public Session getSession(String string, int n, String string2, String string3, File file, String string4, File file2, boolean bl) throws IOException {
        Checks.checkNotNull(string, "host");
        Checks.checkNotNull(string2, "user");
        Entry entry = this.getCacheEntry(string2, string, n);
        Session session = null;
        if (entry != null) {
            session = entry.getSession();
        }
        if (session == null || !session.isConnected()) {
            Message.verbose(":: SSH :: connecting to " + string + "...");
            try {
                JSch jSch = new JSch();
                session = n != -1 ? jSch.getSession(string2, string, n) : jSch.getSession(string2, string);
                if (bl) {
                    this.attemptAgentUse(jSch);
                }
                if (file != null) {
                    jSch.addIdentity(file.getAbsolutePath(), string4);
                }
                session.setUserInfo((UserInfo)new CfUserInfo(string, string2, string3, file, string4, file2));
                session.setDaemonThread(true);
                Properties properties = new Properties();
                properties.setProperty("PreferredAuthentications", "publickey,keyboard-interactive,password");
                session.setConfig(properties);
                session.connect();
                Message.verbose(":: SSH :: connected to " + string + "!");
                this.setSession(string2, string, n, session);
            }
            catch (JSchException jSchException) {
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
                IOException iOException = new IOException(jSchException.getMessage());
                iOException.initCause(jSchException);
                throw iOException;
            }
        }
        return session;
    }

    private static class CfUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String userPassword;
        private String pemPassword;
        private String userName;
        private final File pemFile;
        private final String host;
        private final File passfile;

        public CfUserInfo(String string, String string2, String string3, File file, String string4, File file2) {
            this.userPassword = string3;
            this.pemPassword = string4;
            this.host = string;
            this.passfile = file2;
            this.userName = string2;
            this.pemFile = file;
        }

        public void showMessage(String string) {
            Message.info(string);
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public String getPassword() {
            Credentials credentials;
            if (this.userPassword == null && (credentials = CredentialsUtil.promptCredentials(new Credentials(null, this.host, this.userName, this.userPassword), this.passfile)) != null) {
                this.userName = credentials.getUserName();
                this.userPassword = credentials.getPasswd();
            }
            return this.userPassword;
        }

        public String getPassphrase() {
            Credentials credentials;
            if (this.pemPassword == null && this.pemFile != null && (credentials = CredentialsUtil.promptCredentials(new Credentials(null, this.pemFile.getAbsolutePath(), this.userName, this.pemPassword), this.passfile)) != null) {
                this.userName = credentials.getUserName();
                this.pemPassword = credentials.getPasswd();
            }
            return this.pemPassword;
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            return new String[]{this.getPassword()};
        }
    }

    private class Entry {
        private Session session = null;
        private ChannelSftp channelSftp = null;
        private String host = null;
        private String user = null;
        private int port = 22;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public Entry(Session session, String string, String string2, int n) {
            this.session = session;
            this.host = string2;
            this.user = string;
            this.port = n;
            IvyContext.getContext().getEventManager().addIvyListener(new IvyListener(){

                @Override
                public void progress(IvyEvent ivyEvent) {
                    ivyEvent.getSource().removeIvyListener(this);
                    SshCache.this.clearSession(Entry.this.session);
                }
            }, "post-resolve");
        }

        public void setChannelSftp(ChannelSftp channelSftp) {
            if (this.channelSftp != null && channelSftp != null) {
                throw new IllegalStateException("Only one sftp channelSftp per session allowed");
            }
            this.channelSftp = channelSftp;
        }

        public ChannelSftp getChannelSftp() {
            return this.channelSftp;
        }

        private Session getSession() {
            return this.session;
        }

        public void releaseChannelSftp() {
            if (this.channelSftp != null && this.channelSftp.isConnected()) {
                Message.verbose(":: SFTP :: closing sftp connection from " + this.host + "...");
                this.channelSftp.disconnect();
                this.channelSftp = null;
                Message.verbose(":: SFTP :: sftp connection closed from " + this.host);
            }
        }
    }
}

