/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.ChecksumHelper;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;

public abstract class BasicResolver
extends AbstractResolver {
    public static final String DESCRIPTOR_OPTIONAL = "optional";
    public static final String DESCRIPTOR_REQUIRED = "required";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private String workspaceName;
    private boolean envDependent = true;
    private List ivyattempts = new ArrayList();
    private Map artattempts = new HashMap();
    private boolean checkconsistency = true;
    private boolean allownomd = true;
    private boolean force = false;
    private String checksums = null;
    private URLRepository extartifactrep = new URLRepository();
    private final ArtifactResourceResolver artifactResourceResolver = new ArtifactResourceResolver(){

        @Override
        public ResolvedResource resolve(Artifact artifact) {
            artifact = BasicResolver.this.fromSystem(artifact);
            return BasicResolver.this.getArtifactRef(artifact, null);
        }
    };
    private final ResourceDownloader downloader = new ResourceDownloader(){

        @Override
        public void download(Artifact artifact, Resource resource, File file) throws IOException {
            if (file.exists()) {
                file.delete();
            }
            File file2 = new File(file.getAbsolutePath() + ".part");
            if (resource.getName().equals(String.valueOf(artifact.getUrl()))) {
                if (file2.getParentFile() != null) {
                    file2.getParentFile().mkdirs();
                }
                BasicResolver.this.extartifactrep.get(resource.getName(), file2);
            } else {
                BasicResolver.this.getAndCheck(resource, file2);
            }
            if (!file2.renameTo(file)) {
                throw new IOException("impossible to move part file to definitive one: " + file2 + " -> " + file);
            }
        }
    };

    public BasicResolver() {
        this.workspaceName = HostUtil.getLocalHostName();
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String string) {
        this.workspaceName = string;
    }

    public boolean isEnvDependent() {
        return this.envDependent;
    }

    public void setEnvDependent(boolean bl) {
        this.envDependent = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        Object object;
        IvyContext ivyContext = IvyContext.pushNewCopyContext();
        try {
            Object object2;
            ResolvedModuleRevision resolvedModuleRevision = resolveData.getCurrentResolvedModuleRevision();
            if (resolvedModuleRevision != null && this.shouldReturnResolvedModule(dependencyDescriptor, resolvedModuleRevision)) {
                ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision;
                return resolvedModuleRevision2;
            }
            if (this.isForce()) {
                dependencyDescriptor = dependencyDescriptor.clone(ModuleRevisionId.newInstance(dependencyDescriptor.getDependencyRevisionId(), "latest.integration"));
            }
            object = dependencyDescriptor;
            DependencyDescriptor dependencyDescriptor2 = this.fromSystem(dependencyDescriptor);
            ivyContext.setDependencyDescriptor((DependencyDescriptor)object);
            ivyContext.setResolveData(resolveData);
            this.clearIvyAttempts();
            this.clearArtifactAttempts();
            ModuleRevisionId moduleRevisionId = object.getDependencyRevisionId();
            ModuleRevisionId moduleRevisionId2 = dependencyDescriptor2.getDependencyRevisionId();
            this.checkRevision(moduleRevisionId);
            boolean bl = this.getAndCheckIsDynamic(moduleRevisionId);
            ResolvedModuleRevision resolvedModuleRevision3 = null;
            resolvedModuleRevision3 = this.findModuleInCache((DependencyDescriptor)object, resolveData);
            if (resolvedModuleRevision3 != null) {
                if (resolvedModuleRevision3.getDescriptor().isDefault() && resolvedModuleRevision3.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + moduleRevisionId + " (resolved by " + resolvedModuleRevision3.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else if (this.isForce() && resolvedModuleRevision3.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + moduleRevisionId + " (resolved by " + resolvedModuleRevision3.getResolver().getName() + "): but we are in force mode, let's try to find one ourself");
                } else {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + moduleRevisionId);
                    ResolvedModuleRevision resolvedModuleRevision4 = this.checkLatest((DependencyDescriptor)object, this.checkForcedResolvedModuleRevision(resolvedModuleRevision3), resolveData);
                    return resolvedModuleRevision4;
                }
            }
            if (resolveData.getOptions().isUseCacheOnly()) {
                throw new UnresolvedDependencyException("\t" + this.getName() + " (useCacheOnly) : no ivy file found for " + moduleRevisionId, false);
            }
            this.checkInterrupted();
            ResolvedResource resolvedResource = this.findIvyFileRef(dependencyDescriptor2, resolveData);
            this.checkInterrupted();
            ModuleDescriptor moduleDescriptor = null;
            if (resolvedResource == null) {
                if (!this.isAllownomd()) {
                    throw new UnresolvedDependencyException("\t" + this.getName() + ": no ivy file found for " + moduleRevisionId, false);
                }
                DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newDefaultInstance(moduleRevisionId2, dependencyDescriptor2.getAllDependencyArtifacts());
                object2 = this.findFirstArtifactRef(defaultModuleDescriptor, dependencyDescriptor2, resolveData);
                this.checkInterrupted();
                if (object2 == null) {
                    throw new UnresolvedDependencyException("\t" + this.getName() + ": no ivy file nor artifact found for " + moduleRevisionId, false);
                }
                long l = ((ResolvedResource)object2).getLastModified();
                if (l != 0L && defaultModuleDescriptor instanceof DefaultModuleDescriptor) {
                    defaultModuleDescriptor.setLastModified(l);
                }
                Message.verbose("\t" + this.getName() + ": no ivy file found for " + moduleRevisionId + ": using default data");
                if (bl) {
                    defaultModuleDescriptor.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(moduleRevisionId2, ((ResolvedResource)object2).getRevision()));
                }
                moduleDescriptor = this.toSystem(defaultModuleDescriptor);
                MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
                metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                metadataArtifactDownloadReport.setSearched(true);
                resolvedModuleRevision3 = new ResolvedModuleRevision(this, this, moduleDescriptor, metadataArtifactDownloadReport, this.isForce());
                this.getRepositoryCacheManager().cacheModuleDescriptor(this, (ResolvedResource)object2, this.toSystem(dependencyDescriptor), moduleDescriptor.getAllArtifacts()[0], null, this.getCacheOptions(resolveData));
            } else {
                if (resolvedResource instanceof MDResolvedResource) {
                    resolvedModuleRevision3 = ((MDResolvedResource)resolvedResource).getResolvedModuleRevision();
                }
                if (resolvedModuleRevision3 == null && (resolvedModuleRevision3 = this.parse(resolvedResource, (DependencyDescriptor)object, resolveData)) == null) {
                    throw new UnresolvedDependencyException();
                }
                if (!resolvedModuleRevision3.getReport().isDownloaded() && resolvedModuleRevision3.getReport().getLocalFile() != null) {
                    ResolvedModuleRevision resolvedModuleRevision5 = this.checkLatest((DependencyDescriptor)object, this.checkForcedResolvedModuleRevision(resolvedModuleRevision3), resolveData);
                    return resolvedModuleRevision5;
                }
                ModuleDescriptor moduleDescriptor2 = resolvedModuleRevision3.getDescriptor();
                moduleDescriptor = this.toSystem(moduleDescriptor2);
                if (this.isCheckconsistency()) {
                    this.checkDescriptorConsistency(moduleRevisionId, moduleDescriptor, resolvedResource);
                    this.checkDescriptorConsistency(moduleRevisionId2, moduleDescriptor2, resolvedResource);
                } else if (moduleDescriptor instanceof DefaultModuleDescriptor) {
                    object2 = (DefaultModuleDescriptor)moduleDescriptor;
                    ModuleRevisionId moduleRevisionId3 = this.getRevision(resolvedResource, moduleRevisionId, moduleDescriptor);
                    ((DefaultModuleDescriptor)object2).setModuleRevisionId(moduleRevisionId3);
                    ((DefaultModuleDescriptor)object2).setResolvedModuleRevisionId(moduleRevisionId3);
                } else {
                    Message.warn("consistency disabled with instance of non DefaultModuleDescriptor... module info can't be updated, so consistency check will be done");
                    this.checkDescriptorConsistency(moduleRevisionId2, moduleDescriptor2, resolvedResource);
                    this.checkDescriptorConsistency(moduleRevisionId, moduleDescriptor, resolvedResource);
                }
                resolvedModuleRevision3 = new ResolvedModuleRevision(this, this, moduleDescriptor, this.toSystem(resolvedModuleRevision3.getReport()), this.isForce());
            }
            this.resolveAndCheckRevision(moduleDescriptor, moduleRevisionId, resolvedResource, bl);
            this.resolveAndCheckPublicationDate((DependencyDescriptor)object, moduleDescriptor, moduleRevisionId, resolveData);
            this.checkNotConvertedExclusionRule(moduleDescriptor, resolvedResource, resolveData);
            if (resolvedResource == null || resolvedResource.getResource() != null) {
                this.cacheModuleDescriptor(moduleDescriptor, moduleRevisionId, resolvedResource, resolvedModuleRevision3);
            }
            object2 = this.checkLatest((DependencyDescriptor)object, this.checkForcedResolvedModuleRevision(resolvedModuleRevision3), resolveData);
            return object2;
        }
        catch (UnresolvedDependencyException unresolvedDependencyException) {
            if (unresolvedDependencyException.getMessage().length() > 0) {
                if (unresolvedDependencyException.isError()) {
                    Message.error(unresolvedDependencyException.getMessage());
                } else {
                    Message.verbose(unresolvedDependencyException.getMessage());
                }
            }
            object = resolveData.getCurrentResolvedModuleRevision();
            return object;
        }
        finally {
            IvyContext.popContext();
        }
    }

    protected boolean shouldReturnResolvedModule(DependencyDescriptor dependencyDescriptor, ResolvedModuleRevision resolvedModuleRevision) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        boolean bl = this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId);
        boolean bl2 = resolvedModuleRevision.isForce();
        bl2 |= !bl && !resolvedModuleRevision.getDescriptor().isDefault();
        return bl2 &= !this.isForce();
    }

    private ResolvedModuleRevision checkForcedResolvedModuleRevision(ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision == null) {
            return null;
        }
        if (!this.isForce() || resolvedModuleRevision.isForce()) {
            return resolvedModuleRevision;
        }
        return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), resolvedModuleRevision.getArtifactResolver(), resolvedModuleRevision.getDescriptor(), resolvedModuleRevision.getReport(), true);
    }

    private void cacheModuleDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ResolvedResource resolvedResource, ResolvedModuleRevision resolvedModuleRevision) {
        RepositoryCacheManager repositoryCacheManager = this.getRepositoryCacheManager();
        final ModuleDescriptorParser moduleDescriptorParser = moduleDescriptor.getParser();
        Artifact artifact = resolvedResource == null ? moduleDescriptor.getMetadataArtifact() : moduleDescriptorParser.getMetadataArtifact(ModuleRevisionId.newInstance(moduleRevisionId, moduleDescriptor.getRevision()), resolvedResource.getResource());
        repositoryCacheManager.originalToCachedModuleDescriptor(this, resolvedResource, artifact, resolvedModuleRevision, new ModuleDescriptorWriter(){

            @Override
            public void write(ResolvedResource resolvedResource, ModuleDescriptor moduleDescriptor, File file, File file2) throws IOException, ParseException {
                if (resolvedResource == null) {
                    XmlModuleDescriptorWriter.write(moduleDescriptor, file2);
                } else {
                    moduleDescriptorParser.toIvyFile(new FileInputStream(file), resolvedResource.getResource(), file2, moduleDescriptor);
                    long l = resolvedResource.getLastModified();
                    if (l > 0L) {
                        file2.setLastModified(l);
                    }
                }
            }
        });
    }

    private void checkNotConvertedExclusionRule(ModuleDescriptor moduleDescriptor, ResolvedResource resolvedResource, ResolveData resolveData) {
        DefaultModuleDescriptor defaultModuleDescriptor;
        if (!this.getNamespace().equals(Namespace.SYSTEM_NAMESPACE) && !moduleDescriptor.isDefault() && resolveData.getSettings().logNotConvertedExclusionRule() && moduleDescriptor instanceof DefaultModuleDescriptor && (defaultModuleDescriptor = (DefaultModuleDescriptor)moduleDescriptor).isNamespaceUseful()) {
            Message.warn("the module descriptor " + resolvedResource.getResource() + " has information which can't be converted into " + "the system namespace. " + "It will require the availability of the namespace '" + this.getNamespace().getName() + "' to be fully usable.");
        }
    }

    private void resolveAndCheckPublicationDate(DependencyDescriptor dependencyDescriptor, ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ResolveData resolveData) {
        if (resolveData.getDate() != null) {
            long l = this.getPublicationDate(moduleDescriptor, dependencyDescriptor, resolveData);
            if (l > resolveData.getDate().getTime()) {
                throw new UnresolvedDependencyException("\t" + this.getName() + ": unacceptable publication date => was=" + new Date(l) + " required=" + resolveData.getDate());
            }
            if (l == -1L) {
                throw new UnresolvedDependencyException("\t" + this.getName() + ": impossible to guess publication date: artifact missing for " + moduleRevisionId);
            }
            moduleDescriptor.setResolvedPublicationDate(new Date(l));
        }
    }

    protected void checkModuleDescriptorRevision(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId) {
        if (!this.getSettings().getVersionMatcher().accept(moduleRevisionId, moduleDescriptor)) {
            throw new UnresolvedDependencyException("\t" + this.getName() + ": unacceptable revision => was=" + moduleDescriptor.getResolvedModuleRevisionId().getRevision() + " required=" + moduleRevisionId.getRevision());
        }
    }

    private boolean getAndCheckIsDynamic(ModuleRevisionId moduleRevisionId) {
        boolean bl = this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId);
        if (bl && !this.acceptLatest()) {
            throw new UnresolvedDependencyException("dynamic revisions not handled by " + this.getClass().getName() + ". impossible to resolve " + moduleRevisionId);
        }
        return bl;
    }

    private void checkRevision(ModuleRevisionId moduleRevisionId) {
        int n = moduleRevisionId.getRevision().indexOf("@");
        if (n != -1 && !moduleRevisionId.getRevision().substring(n + 1).equals(this.workspaceName)) {
            throw new UnresolvedDependencyException("\t" + this.getName() + ": unhandled revision => " + moduleRevisionId.getRevision());
        }
    }

    private void resolveAndCheckRevision(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ResolvedResource resolvedResource, boolean bl) {
        ModuleRevisionId moduleRevisionId2 = moduleDescriptor.getResolvedModuleRevisionId();
        if (moduleRevisionId2.getRevision() == null || moduleRevisionId2.getRevision().length() == 0 || moduleRevisionId2.getRevision().startsWith("working@")) {
            moduleRevisionId2 = !bl ? ModuleRevisionId.newInstance(moduleRevisionId2, moduleRevisionId.getRevision()) : (resolvedResource == null ? moduleDescriptor.getMetadataArtifact().getModuleRevisionId() : (resolvedResource.getRevision() == null || resolvedResource.getRevision().length() == 0 ? ModuleRevisionId.newInstance(moduleRevisionId2, "working@" + this.getName()) : ModuleRevisionId.newInstance(moduleRevisionId2, resolvedResource.getRevision())));
        }
        if (bl) {
            Message.verbose("\t\t[" + this.toSystem(moduleRevisionId2).getRevision() + "] " + moduleRevisionId.getModuleId());
        }
        moduleDescriptor.setResolvedModuleRevisionId(moduleRevisionId2);
        this.checkModuleDescriptorRevision(moduleDescriptor, moduleRevisionId);
    }

    private ModuleRevisionId getRevision(ResolvedResource resolvedResource, ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) throws ParseException {
        HashMap hashMap = new HashMap();
        hashMap.putAll(moduleDescriptor.getQualifiedExtraAttributes());
        hashMap.putAll(moduleRevisionId.getQualifiedExtraAttributes());
        String string = resolvedResource.getRevision();
        if (string == null) {
            Message.debug("no revision found in reference for " + moduleRevisionId);
            if (this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId)) {
                if (moduleDescriptor.getModuleRevisionId().getRevision() == null) {
                    string = "working@" + this.getName();
                } else {
                    Message.debug("using " + moduleRevisionId);
                    string = moduleRevisionId.getRevision();
                }
            } else {
                Message.debug("using " + moduleRevisionId);
                string = moduleRevisionId.getRevision();
            }
        }
        return ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), string, hashMap);
    }

    public ResolvedModuleRevision parse(ResolvedResource resolvedResource, DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        Object object;
        DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
        dependencyDescriptor = this.toSystem(dependencyDescriptor2);
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resolvedResource.getResource());
        if (moduleDescriptorParser == null) {
            Message.warn("no module descriptor parser available for " + resolvedResource.getResource());
            return null;
        }
        Message.verbose("\t" + this.getName() + ": found md file for " + moduleRevisionId);
        Message.verbose("\t\t=> " + resolvedResource);
        Message.debug("\tparser = " + moduleDescriptorParser);
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        if (this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId) && (object = resolveData.getNode(moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource.getRevision()))) != null && ((IvyNode)object).getModuleRevision() != null) {
            if (((IvyNode)object).getDescriptor() != null && ((IvyNode)object).getDescriptor().isDefault()) {
                Message.verbose("\t" + this.getName() + ": found already resolved revision: " + moduleRevisionId2 + ": but it's a default one, maybe we can find a better one");
            } else {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + moduleRevisionId2);
                ((IvyNode)object).getModuleRevision().getReport().setSearched(true);
                return ((IvyNode)object).getModuleRevision();
            }
        }
        object = moduleDescriptorParser.getMetadataArtifact(moduleRevisionId2, resolvedResource.getResource());
        return this.getRepositoryCacheManager().cacheModuleDescriptor(this, resolvedResource, dependencyDescriptor, (Artifact)object, this.downloader, this.getCacheOptions(resolveData));
    }

    protected ResourceMDParser getRMDParser(final DependencyDescriptor dependencyDescriptor, final ResolveData resolveData) {
        return new ResourceMDParser(){

            @Override
            public MDResolvedResource parse(Resource resource, String string) {
                try {
                    ResolvedModuleRevision resolvedModuleRevision = BasicResolver.this.parse(new ResolvedResource(resource, string), dependencyDescriptor, resolveData);
                    if (resolvedModuleRevision == null) {
                        return null;
                    }
                    return new MDResolvedResource(resource, string, resolvedModuleRevision);
                }
                catch (ParseException parseException) {
                    Message.warn("Failed to parse the file '" + resource + "'", parseException);
                    return null;
                }
            }
        };
    }

    protected ResourceMDParser getDefaultRMDParser(final ModuleId moduleId) {
        return new ResourceMDParser(){

            @Override
            public MDResolvedResource parse(Resource resource, String string) {
                DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newDefaultInstance(new ModuleRevisionId(moduleId, string));
                MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(defaultModuleDescriptor.getMetadataArtifact());
                metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                metadataArtifactDownloadReport.setSearched(true);
                return new MDResolvedResource(resource, string, new ResolvedModuleRevision(BasicResolver.this, BasicResolver.this, defaultModuleDescriptor, metadataArtifactDownloadReport, BasicResolver.this.isForce()));
            }
        };
    }

    private void checkDescriptorConsistency(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor, ResolvedResource resolvedResource) throws ParseException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (!moduleRevisionId.getOrganisation().equals(moduleDescriptor.getModuleRevisionId().getOrganisation())) {
            Message.error("\t" + this.getName() + ": bad organisation found in " + resolvedResource.getResource() + ": expected='" + moduleRevisionId.getOrganisation() + "' found='" + moduleDescriptor.getModuleRevisionId().getOrganisation() + "'");
            stringBuffer.append("bad organisation: expected='" + moduleRevisionId.getOrganisation() + "' found='" + moduleDescriptor.getModuleRevisionId().getOrganisation() + "'; ");
            bl = false;
        }
        if (!moduleRevisionId.getName().equals(moduleDescriptor.getModuleRevisionId().getName())) {
            Message.error("\t" + this.getName() + ": bad module name found in " + resolvedResource.getResource() + ": expected='" + moduleRevisionId.getName() + " found='" + moduleDescriptor.getModuleRevisionId().getName() + "'");
            stringBuffer.append("bad module name: expected='" + moduleRevisionId.getName() + "' found='" + moduleDescriptor.getModuleRevisionId().getName() + "'; ");
            bl = false;
        }
        if (moduleRevisionId.getBranch() != null && !moduleRevisionId.getBranch().equals(moduleDescriptor.getModuleRevisionId().getBranch())) {
            Message.error("\t" + this.getName() + ": bad branch name found in " + resolvedResource.getResource() + ": expected='" + moduleRevisionId.getBranch() + " found='" + moduleDescriptor.getModuleRevisionId().getBranch() + "'");
            stringBuffer.append("bad branch name: expected='" + moduleRevisionId.getBranch() + "' found='" + moduleDescriptor.getModuleRevisionId().getBranch() + "'; ");
            bl = false;
        }
        if (resolvedResource.getRevision() != null && !resolvedResource.getRevision().startsWith("working@") && !moduleRevisionId.getRevision().equals(moduleDescriptor.getModuleRevisionId().getRevision())) {
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision());
            if (!this.getSettings().getVersionMatcher().accept(moduleRevisionId2, moduleDescriptor)) {
                Message.error("\t" + this.getName() + ": bad revision found in " + resolvedResource.getResource() + ": expected='" + resolvedResource.getRevision() + " found='" + moduleDescriptor.getModuleRevisionId().getRevision() + "'");
                stringBuffer.append("bad revision: expected='" + resolvedResource.getRevision() + "' found='" + moduleDescriptor.getModuleRevisionId().getRevision() + "'; ");
                bl = false;
            }
        }
        if (!this.getSettings().getStatusManager().isStatus(moduleDescriptor.getStatus())) {
            Message.error("\t" + this.getName() + ": bad status found in " + resolvedResource.getResource() + ": '" + moduleDescriptor.getStatus() + "'");
            stringBuffer.append("bad status: '" + moduleDescriptor.getStatus() + "'; ");
            bl = false;
        }
        for (Map.Entry entry : moduleRevisionId.getExtraAttributes().entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals(moduleDescriptor.getExtraAttribute((String)entry.getKey()))) continue;
            String string = "bad " + entry.getKey() + " found in " + resolvedResource.getResource() + ": expected='" + entry.getValue() + "' found='" + moduleDescriptor.getExtraAttribute((String)entry.getKey()) + "'";
            Message.error("\t" + this.getName() + ": " + string);
            stringBuffer.append(string + ";");
            bl = false;
        }
        if (!bl) {
            throw new ParseException("inconsistent module descriptor file found in '" + resolvedResource.getResource() + "': " + stringBuffer, 0);
        }
    }

    public ResolvedResource findResource(ResolvedResource[] resolvedResourceArray, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        Object object;
        Object object2;
        String string = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        Object object3 = null;
        List list = this.getLatestStrategy().sort(resolvedResourceArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        IvyContext ivyContext = IvyContext.getContext();
        Object object4 = list.listIterator(list.size());
        while (object4.hasPrevious()) {
            object2 = (ResolvedResource)object4.previous();
            if (this.filterNames(new ArrayList<String>(Collections.singleton(((ResolvedResource)object2).getRevision()))).isEmpty()) {
                Message.debug("\t" + string + ": filtered by name: " + object2);
                continue;
            }
            object = ModuleRevisionId.newInstance(moduleRevisionId, ((ResolvedResource)object2).getRevision());
            ResolveData resolveData = ivyContext.getResolveData();
            if (resolveData != null && resolveData.getReport() != null && resolveData.isBlacklisted(resolveData.getReport().getConfiguration(), (ModuleRevisionId)object)) {
                Message.debug("\t" + string + ": blacklisted: " + object2);
                arrayList.add(((ResolvedResource)object2).getRevision() + " (blacklisted)");
                arrayList2.add(object);
                continue;
            }
            if (!versionMatcher.accept(moduleRevisionId, (ModuleRevisionId)object)) {
                Message.debug("\t" + string + ": rejected by version matcher: " + object2);
                arrayList.add(((ResolvedResource)object2).getRevision());
                continue;
            }
            if (((ResolvedResource)object2).getResource() != null && !((ResolvedResource)object2).getResource().exists()) {
                Message.debug("\t" + string + ": unreachable: " + object2 + "; res=" + ((ResolvedResource)object2).getResource());
                arrayList.add(((ResolvedResource)object2).getRevision() + " (unreachable)");
                continue;
            }
            if (date != null && ((ResolvedResource)object2).getLastModified() > date.getTime()) {
                Message.verbose("\t" + string + ": too young: " + object2);
                arrayList.add(((ResolvedResource)object2).getRevision() + " (" + ((ResolvedResource)object2).getLastModified() + ")");
                continue;
            }
            if (versionMatcher.needModuleDescriptor(moduleRevisionId, (ModuleRevisionId)object)) {
                MDResolvedResource mDResolvedResource = resourceMDParser.parse(((ResolvedResource)object2).getResource(), ((ResolvedResource)object2).getRevision());
                if (mDResolvedResource == null) {
                    Message.debug("\t" + string + ": impossible to get module descriptor resource: " + object2);
                    arrayList.add(((ResolvedResource)object2).getRevision() + " (no or bad MD)");
                    continue;
                }
                ModuleDescriptor moduleDescriptor = mDResolvedResource.getResolvedModuleRevision().getDescriptor();
                if (moduleDescriptor.isDefault()) {
                    Message.debug("\t" + string + ": default md rejected by version matcher" + "requiring module descriptor: " + object2);
                    arrayList.add(((ResolvedResource)object2).getRevision() + " (MD)");
                    continue;
                }
                if (!versionMatcher.accept(moduleRevisionId, moduleDescriptor)) {
                    Message.debug("\t" + string + ": md rejected by version matcher: " + object2);
                    arrayList.add(((ResolvedResource)object2).getRevision() + " (MD)");
                    continue;
                }
                object3 = mDResolvedResource;
            } else {
                object3 = object2;
            }
            if (object3 == null) continue;
            break;
        }
        if (object3 == null && !arrayList.isEmpty()) {
            this.logAttempt(((Object)arrayList).toString());
        }
        if (object3 == null && !arrayList2.isEmpty()) {
            object4 = ivyContext.getDependencyDescriptor();
            object2 = ivyContext.getResolveData().getNode(object4.getParentRevisionId());
            object = ((IvyNode)object2).getConflictManager(moduleRevisionId.getModuleId());
            object.handleAllBlacklistedRevisions((DependencyDescriptor)object4, arrayList2);
        }
        return object3;
    }

    protected Collection filterNames(Collection collection) {
        this.getSettings().filterIgnore(collection);
        return collection;
    }

    protected void clearIvyAttempts() {
        this.ivyattempts.clear();
        this.clearArtifactAttempts();
    }

    protected void logIvyAttempt(String string) {
        this.ivyattempts.add(string);
        Message.verbose("\t\ttried " + string);
    }

    protected void logArtifactAttempt(Artifact artifact, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.artattempts.get(artifact);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.artattempts.put(artifact, arrayList);
        }
        arrayList.add(string);
        Message.verbose("\t\ttried " + string);
    }

    protected void logAttempt(String string) {
        Artifact artifact = (Artifact)IvyContext.getContext().get(this.getName() + ".artifact");
        if (artifact != null) {
            this.logArtifactAttempt(artifact, string);
        } else {
            this.logIvyAttempt(string);
        }
    }

    @Override
    public void reportFailure() {
        Message.warn("==== " + this.getName() + ": tried");
        Iterator<Object> iterator = this.ivyattempts.listIterator();
        while (iterator.hasNext()) {
            Object object = (String)iterator.next();
            Message.warn("  " + (String)object);
        }
        for (Object object : this.artattempts.keySet()) {
            List list = (List)this.artattempts.get(object);
            if (list == null) continue;
            Message.warn("  -- artifact " + object + ":");
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Message.warn("  " + string);
            }
        }
    }

    @Override
    public void reportFailure(Artifact artifact) {
        Message.warn("==== " + this.getName() + ": tried");
        List list = (List)this.artattempts.get(artifact);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Message.warn("  " + string);
            }
        }
    }

    protected boolean acceptLatest() {
        return true;
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        RepositoryCacheManager repositoryCacheManager = this.getRepositoryCacheManager();
        this.clearArtifactAttempts();
        DownloadReport downloadReport = new DownloadReport();
        for (int i = 0; i < artifactArray.length; ++i) {
            ArtifactDownloadReport artifactDownloadReport = repositoryCacheManager.download(artifactArray[i], this.artifactResourceResolver, this.downloader, this.getCacheDownloadOptions(downloadOptions));
            if (DownloadStatus.FAILED == artifactDownloadReport.getDownloadStatus()) {
                if (!"missing artifact".equals(artifactDownloadReport.getDownloadDetails())) {
                    Message.warn("\t" + artifactDownloadReport);
                }
            } else if (DownloadStatus.NO == artifactDownloadReport.getDownloadStatus()) {
                Message.verbose("\t" + artifactDownloadReport);
            } else if ("quiet".equals(downloadOptions.getLog())) {
                Message.verbose("\t" + artifactDownloadReport);
            } else {
                Message.info("\t" + artifactDownloadReport);
            }
            downloadReport.addArtifactReport(artifactDownloadReport);
            this.checkInterrupted();
        }
        return downloadReport;
    }

    protected void clearArtifactAttempts() {
        this.artattempts.clear();
    }

    @Override
    public ArtifactDownloadReport download(final ArtifactOrigin artifactOrigin, DownloadOptions downloadOptions) {
        Checks.checkNotNull(artifactOrigin, "origin");
        return this.getRepositoryCacheManager().download(artifactOrigin.getArtifact(), new ArtifactResourceResolver(){

            @Override
            public ResolvedResource resolve(Artifact artifact) {
                try {
                    Resource resource = BasicResolver.this.getResource(artifactOrigin.getLocation());
                    if (resource == null) {
                        return null;
                    }
                    String string = artifactOrigin.getArtifact().getModuleRevisionId().getRevision();
                    return new ResolvedResource(resource, string);
                }
                catch (IOException iOException) {
                    Message.debug(iOException);
                    return null;
                }
            }
        }, this.downloader, this.getCacheDownloadOptions(downloadOptions));
    }

    protected abstract Resource getResource(String var1) throws IOException;

    @Override
    public boolean exists(Artifact artifact) {
        ResolvedResource resolvedResource = this.getArtifactRef(artifact, null);
        if (resolvedResource != null) {
            return resolvedResource.getResource().exists();
        }
        return false;
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        ArtifactOrigin artifactOrigin = this.getRepositoryCacheManager().getSavedArtifactOrigin(this.toSystem(artifact));
        if (!ArtifactOrigin.isUnknown(artifactOrigin)) {
            return artifactOrigin;
        }
        ResolvedResource resolvedResource = this.getArtifactRef(artifact, null);
        if (resolvedResource != null && resolvedResource.getResource().exists()) {
            return new ArtifactOrigin(artifact, resolvedResource.getResource().isLocal(), resolvedResource.getResource().getName());
        }
        return null;
    }

    protected long getPublicationDate(ModuleDescriptor moduleDescriptor, DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        if (moduleDescriptor.getPublicationDate() != null) {
            return moduleDescriptor.getPublicationDate().getTime();
        }
        ResolvedResource resolvedResource = this.findFirstArtifactRef(moduleDescriptor, dependencyDescriptor, resolveData);
        if (resolvedResource != null) {
            return resolvedResource.getLastModified();
        }
        return -1L;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String[] listTokenValues(String string, Map map) {
        Collection collection = this.findNames(map, string);
        return collection.toArray(new String[collection.size()]);
    }

    @Override
    public OrganisationEntry[] listOrganisations() {
        Collection collection = this.findNames(Collections.EMPTY_MAP, "organisation");
        OrganisationEntry[] organisationEntryArray = new OrganisationEntry[collection.size()];
        int n = 0;
        for (String string : collection) {
            organisationEntryArray[n] = new OrganisationEntry(this, string);
            ++n;
        }
        return organisationEntryArray;
    }

    @Override
    public ModuleEntry[] listModules(OrganisationEntry organisationEntry) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", organisationEntry.getOrganisation());
        Collection collection = this.findNames(hashMap, "module");
        ModuleEntry[] moduleEntryArray = new ModuleEntry[collection.size()];
        int n = 0;
        for (String string : collection) {
            moduleEntryArray[n] = new ModuleEntry(organisationEntry, string);
            ++n;
        }
        return moduleEntryArray;
    }

    @Override
    public RevisionEntry[] listRevisions(ModuleEntry moduleEntry) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("organisation", moduleEntry.getOrganisation());
        hashMap.put("module", moduleEntry.getModule());
        Collection collection = this.findNames(hashMap, "revision");
        RevisionEntry[] revisionEntryArray = new RevisionEntry[collection.size()];
        int n = 0;
        for (String string : collection) {
            revisionEntryArray[n] = new RevisionEntry(moduleEntry, string);
            ++n;
        }
        return revisionEntryArray;
    }

    protected abstract Collection findNames(Map var1, String var2);

    protected ResolvedResource findFirstArtifactRef(ModuleDescriptor moduleDescriptor, DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        ResolvedResource resolvedResource = null;
        String[] stringArray = moduleDescriptor.getConfigurationsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Artifact[] artifactArray = moduleDescriptor.getArtifacts(stringArray[i]);
            for (int j = 0; j < artifactArray.length; ++j) {
                resolvedResource = this.getArtifactRef(artifactArray[j], resolveData.getDate());
                if (resolvedResource == null) continue;
                return resolvedResource;
            }
        }
        return null;
    }

    protected long getAndCheck(Resource resource, File file) throws IOException {
        long l = this.get(resource, file);
        String[] stringArray = this.getChecksumAlgorithms();
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            bl = this.check(resource, file, stringArray[i]);
        }
        return l;
    }

    private boolean check(Resource resource, File file, String string) throws IOException {
        if (!ChecksumHelper.isKnownAlgorithm(string)) {
            throw new IllegalArgumentException("Unknown checksum algorithm: " + string);
        }
        Resource resource2 = resource.clone(resource.getName() + "." + string);
        if (resource2.exists()) {
            Message.debug(string + " file found for " + resource + ": checking...");
            File file2 = File.createTempFile("ivytmp", string);
            try {
                this.get(resource2, file2);
                try {
                    ChecksumHelper.check(file, file2, string);
                    Message.verbose(string + " OK for " + resource);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    file.delete();
                    throw iOException;
                }
            }
            finally {
                file2.delete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResolvedResource getArtifactRef(Artifact artifact, Date date) {
        IvyContext.getContext().set(this.getName() + ".artifact", artifact);
        try {
            Object object;
            ResolvedResource resolvedResource = this.findArtifactRef(artifact, date);
            if (resolvedResource == null && artifact.getUrl() != null) {
                Resource resource;
                object = artifact.getUrl();
                Message.verbose("\tusing url for " + artifact + ": " + object);
                this.logArtifactAttempt(artifact, ((URL)object).toExternalForm());
                if ("file".equals(((URL)object).getProtocol())) {
                    File file;
                    try {
                        file = new File(new URI(((URL)object).toExternalForm()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        file = new File(((URL)object).getPath());
                    }
                    resource = new FileResource(new FileRepository(), file);
                } else {
                    resource = new URLResource((URL)object);
                }
                resolvedResource = new ResolvedResource(resource, artifact.getModuleRevisionId().getRevision());
            }
            object = resolvedResource;
            return object;
        }
        finally {
            IvyContext.getContext().set(this.getName() + ".artifact", null);
        }
    }

    public ResolvedResource doFindArtifactRef(Artifact artifact, Date date) {
        return this.findArtifactRef(artifact, date);
    }

    protected abstract ResolvedResource findArtifactRef(Artifact var1, Date var2);

    protected abstract long get(Resource var1, File var2) throws IOException;

    public boolean isCheckconsistency() {
        return this.checkconsistency;
    }

    public void setCheckconsistency(boolean bl) {
        this.checkconsistency = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isAllownomd() {
        return this.allownomd;
    }

    public void setAllownomd(boolean bl) {
        Message.deprecated("allownomd is deprecated, please use descriptor=\"" + (bl ? DESCRIPTOR_OPTIONAL : DESCRIPTOR_REQUIRED) + "\" instead");
        this.allownomd = bl;
    }

    public void setDescriptor(String string) {
        if (DESCRIPTOR_REQUIRED.equals(string)) {
            this.allownomd = false;
        } else if (DESCRIPTOR_OPTIONAL.equals(string)) {
            this.allownomd = true;
        } else {
            throw new IllegalArgumentException("unknown descriptor rule '" + string + "'. Allowed rules are: " + Arrays.asList(DESCRIPTOR_REQUIRED, DESCRIPTOR_OPTIONAL));
        }
    }

    public String[] getChecksumAlgorithms() {
        String string;
        String string2 = string = this.checksums == null ? this.getSettings().getVariable("ivy.checksums") : this.checksums;
        if (string == null) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if ("".equals(string3) || "none".equals(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setChecksums(String string) {
        this.checksums = string;
    }

    private static class UnresolvedDependencyException
    extends RuntimeException {
        private boolean error;

        public UnresolvedDependencyException() {
            this("", false);
        }

        public UnresolvedDependencyException(String string) {
            this(string, true);
        }

        public UnresolvedDependencyException(String string, boolean bl) {
            super(string);
            this.error = bl;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

