/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.internal.charsets.Base64Charset;
import io.apigee.trireme.core.internal.charsets.BinaryCharset;
import io.apigee.trireme.core.internal.charsets.HexCharset;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCharsetProvider
extends CharsetProvider {
    private final Charset binaryCharset = new BinaryCharset();
    private final Charset hexCharset = new HexCharset();
    private final Charset base64Charset = new Base64Charset();

    @Override
    public Iterator<Charset> charsets() {
        ArrayList<Charset> sets = new ArrayList<Charset>();
        sets.add(this.binaryCharset);
        sets.add(this.hexCharset);
        sets.add(this.base64Charset);
        return sets.iterator();
    }

    @Override
    public Charset charsetForName(String s) {
        if ("Node-Binary".equals(s)) {
            return this.binaryCharset;
        }
        if ("Node-Hex".equals(s)) {
            return this.hexCharset;
        }
        if ("Node-Base64".equals(s)) {
            return this.base64Charset;
        }
        return null;
    }
}

