/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.modules.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Pattern DOUBLE_QUOTED = Pattern.compile("^[\\s]*\"(.*)\"[\\s]*$");
    private static final Pattern SINGLE_QUOTED = Pattern.compile("^[\\s]*'(.*)'[\\s]*$");

    public static String readStream(InputStream in) throws IOException {
        int r;
        InputStreamReader rdr = new InputStreamReader(in, Charsets.UTF8);
        StringBuilder str = new StringBuilder();
        char[] buf = new char[4096];
        do {
            if ((r = rdr.read(buf)) <= 0) continue;
            str.append(buf, 0, r);
        } while (r > 0);
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            String string = Utils.readStream(in);
            return string;
        }
        finally {
            in.close();
        }
    }

    public static Method findMethod(Class<?> klass, String name) {
        for (Method m : klass.getMethods()) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static String bufferToString(ByteBuffer buf, Charset cs) {
        CoderResult result;
        CharsetDecoder decoder = Charsets.get().getDecoder(cs);
        int bufLen = (int)((float)buf.limit() * decoder.averageCharsPerByte());
        CharBuffer cBuf = CharBuffer.allocate(bufLen);
        do {
            if (!(result = decoder.decode(buf, cBuf, true)).isOverflow()) continue;
            cBuf = Utils.doubleBuffer(cBuf);
        } while (result.isOverflow());
        do {
            if (!(result = decoder.flush(cBuf)).isOverflow()) continue;
            cBuf = Utils.doubleBuffer(cBuf);
        } while (result.isOverflow());
        cBuf.flip();
        return cBuf.toString();
    }

    public static String bufferToString(ByteBuffer[] bufs, Charset cs) {
        CoderResult result;
        CharsetDecoder decoder = Charsets.get().getDecoder(cs);
        int totalBytes = 0;
        for (int i = 0; i < bufs.length; ++i) {
            totalBytes += bufs[i] == null ? 0 : bufs[i].remaining();
        }
        int bufLen = (int)((float)totalBytes * decoder.averageCharsPerByte());
        CharBuffer cBuf = CharBuffer.allocate(bufLen);
        for (int i = 0; i < bufs.length; ++i) {
            do {
                if (!(result = decoder.decode(bufs[i], cBuf, i == bufs.length - 1)).isOverflow()) continue;
                cBuf = Utils.doubleBuffer(cBuf);
            } while (result.isOverflow());
        }
        do {
            if (!(result = decoder.flush(cBuf)).isOverflow()) continue;
            cBuf = Utils.doubleBuffer(cBuf);
        } while (result.isOverflow());
        cBuf.flip();
        return cBuf.toString();
    }

    public static ByteBuffer stringToBuffer(String str, Charset cs) {
        CoderResult result;
        CharsetEncoder enc = Charsets.get().getEncoder(cs);
        CharBuffer chars = CharBuffer.wrap(str);
        int bufLen = (int)((float)chars.remaining() * enc.averageBytesPerChar());
        ByteBuffer writeBuf = ByteBuffer.allocate(bufLen);
        do {
            if (!(result = enc.encode(chars, writeBuf, true)).isOverflow()) continue;
            writeBuf = Utils.doubleBuffer(writeBuf);
        } while (result.isOverflow());
        do {
            if (!(result = enc.flush(writeBuf)).isOverflow()) continue;
            writeBuf = Utils.doubleBuffer(writeBuf);
        } while (result.isOverflow());
        writeBuf.flip();
        return writeBuf;
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message) {
        return cx.newObject(scope, "Error", new Object[]{message});
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, RhinoException re) {
        Scriptable e = cx.newObject(scope, "Error", new Object[]{message});
        e.put("stack", e, (Object)re.getScriptStackTrace());
        return e;
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message));
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message, RhinoException re) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message, re));
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, String code) {
        return Utils.makeErrorObject(cx, scope, message, code, null);
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, String code, String path) {
        Scriptable err = cx.newObject(scope, "Error", new Object[]{message});
        err.put("code", err, (Object)code);
        int errno = Constants.getErrno(code);
        if (errno >= 0) {
            err.put("errno", err, (Object)errno);
        }
        if (path != null) {
            err.put("path", err, (Object)path);
        }
        return err;
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message, String code) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message, code));
    }

    public static RhinoException makeError(Context cx, Scriptable scope, NodeOSException e) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, e));
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, NodeOSException e) {
        return Utils.makeErrorObject(cx, scope, e.getMessage(), e.getCode(), e.getPath());
    }

    public static RhinoException makeRangeError(Context cx, Scriptable scope, String message) {
        Scriptable err = cx.newObject(scope, "RangeError", new Object[]{message});
        return new JavaScriptException((Object)err);
    }

    public static RhinoException makeTypeError(Context cx, Scriptable scope, String message) {
        Scriptable err = cx.newObject(scope, "TypeError", new Object[]{message});
        return new JavaScriptException((Object)err);
    }

    public static List<String> toStringList(Scriptable o) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object id : o.getIds()) {
            Object val = id instanceof Integer ? o.get(((Integer)id).intValue(), o) : o.get((String)id, o);
            ret.add(Context.toString((Object)val));
        }
        return ret;
    }

    public static ByteBuffer catBuffers(ByteBuffer b1, ByteBuffer b2) {
        if (b1 != null && b2 == null) {
            return b1;
        }
        if (b1 == null && b2 != null) {
            return b2;
        }
        int len = (b1 == null ? 0 : b1.remaining()) + (b2 == null ? 0 : b2.remaining());
        if (len == 0) {
            return null;
        }
        ByteBuffer r = ByteBuffer.allocate(len);
        if (b1 != null) {
            r.put(b1);
        }
        if (b2 != null) {
            r.put(b2);
        }
        r.flip();
        return r;
    }

    public static CharBuffer doubleBuffer(CharBuffer b) {
        int newCap = Math.max(b.capacity() * 2, 1);
        CharBuffer d = CharBuffer.allocate(newCap);
        b.flip();
        d.put(b);
        return d;
    }

    public static ByteBuffer doubleBuffer(ByteBuffer b) {
        int newCap = Math.max(b.capacity() * 2, 1);
        ByteBuffer d = ByteBuffer.allocate(newCap);
        b.flip();
        d.put(b);
        return d;
    }

    public static void zeroBuffer(ByteBuffer b) {
        b.clear();
        while (b.hasRemaining()) {
            b.put((byte)0);
        }
        b.clear();
    }

    public static ByteBuffer duplicateBuffer(ByteBuffer b) {
        ByteBuffer ret = ByteBuffer.allocate(b.remaining());
        ByteBuffer tmp = b.duplicate();
        ret.put(tmp);
        ret.flip();
        return ret;
    }

    public static String unquote(String s) {
        Matcher m = DOUBLE_QUOTED.matcher(s);
        if (m.matches()) {
            return m.group(1);
        }
        Matcher m2 = SINGLE_QUOTED.matcher(s);
        if (m2.matches()) {
            return m2.group(1);
        }
        return s;
    }
}

