/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal.charsets;

import io.apigee.trireme.core.internal.charsets.HexCharset;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayDeque;

public class Base64Charset
extends Charset {
    public static final String NAME = "Node-Base64";

    public Base64Charset() {
        super(NAME, null);
    }

    public boolean contains(Charset charset) {
        return charset instanceof HexCharset;
    }

    public CharsetDecoder newDecoder() {
        return new Dec(this);
    }

    public CharsetEncoder newEncoder() {
        return new Enc(this);
    }

    private static final class Dec
    extends CharsetDecoder {
        private static final char[] encoding = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private final int[] leftover = new int[2];
        private int leftoverLen;

        Dec(Charset c) {
            super(c, 1.4f, 4.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            assert (this.leftoverLen <= 2);
            while (in.remaining() + this.leftoverLen >= 3) {
                if (out.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                int b1 = this.leftoverLen >= 1 ? this.leftover[0] : in.get() & 0xFF;
                int b2 = this.leftoverLen >= 2 ? this.leftover[1] : in.get() & 0xFF;
                int b3 = in.get() & 0xFF;
                this.leftoverLen = 0;
                out.put(encoding[b1 >>> 2]);
                out.put(encoding[(b1 & 3) << 4 | b2 >>> 4]);
                out.put(encoding[(b2 & 0xF) << 2 | b3 >>> 6]);
                out.put(encoding[b3 & 0x3F]);
            }
            assert (in.remaining() <= 2);
            while (in.hasRemaining()) {
                this.leftover[this.leftoverLen] = in.get() & 0xFF;
                ++this.leftoverLen;
            }
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult implFlush(CharBuffer out) {
            assert (this.leftoverLen <= 2);
            if (this.leftoverLen > 0) {
                if (out.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                int b1 = this.leftover[0];
                int b2 = this.leftoverLen >= 2 ? this.leftover[1] : 0;
                out.put(encoding[b1 >>> 2]);
                out.put(encoding[(b1 & 3) << 4 | b2 >>> 4]);
                if (this.leftoverLen >= 2) {
                    out.put(encoding[(b2 & 0xF) << 2]);
                } else {
                    out.put('=');
                }
                out.put('=');
            }
            return CoderResult.UNDERFLOW;
        }

        protected void implReset() {
            this.leftoverLen = 0;
        }
    }

    private static final class Enc
    extends CharsetEncoder {
        private static final int[] decoding = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
        private final ArrayDeque<Integer> leftovers = new ArrayDeque(4);
        private CodingErrorAction unmappableAction = CodingErrorAction.REPORT;

        Enc(Charset c) {
            super(c, 0.75f, 3.0f);
        }

        protected void implReset() {
            this.leftovers.clear();
        }

        protected void implOnUnmappableCharacter(CodingErrorAction a) {
            this.unmappableAction = a;
        }

        public boolean canEncode(char c) {
            return c == '=' || Character.isWhitespace(c) || c < decoding.length && decoding[c] >= 0;
        }

        private int getFourChars(int[] chars, CharBuffer in) throws CharacterCodingException {
            int count = 0;
            while ((in.hasRemaining() || !this.leftovers.isEmpty()) && count < 4) {
                if (this.leftovers.isEmpty()) {
                    boolean valid;
                    char c = in.get();
                    if (Character.isWhitespace(c) || c == '=') continue;
                    boolean bl = valid = c <= decoding.length && decoding[c] >= 0;
                    if (!valid && CodingErrorAction.REPORT.equals(this.unmappableAction)) {
                        throw new CharacterCodingException();
                    }
                    if (!valid && !CodingErrorAction.REPLACE.equals(this.unmappableAction)) continue;
                    chars[count] = valid ? decoding[c] : 0;
                    ++count;
                    continue;
                }
                chars[count] = this.leftovers.remove();
                ++count;
            }
            return count;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int rem;
            int[] chars = new int[4];
            int origPos = in.position();
            do {
                try {
                    rem = this.getFourChars(chars, in);
                }
                catch (CharacterCodingException cce) {
                    return CoderResult.unmappableForLength(in.position() - origPos);
                }
                if (rem != 4) continue;
                if (out.remaining() < 3) {
                    this.saveOutput(chars, rem);
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)(chars[0] << 2 | chars[1] >> 4));
                out.put((byte)(chars[1] << 4 & 0xFF | chars[2] >> 2));
                out.put((byte)(chars[2] << 6 & 0xFF | chars[3]));
            } while (rem == 4);
            this.saveOutput(chars, rem);
            assert (this.leftovers.size() <= 3);
            return CoderResult.UNDERFLOW;
        }

        private void saveOutput(int[] chars, int len) {
            for (int i = 0; i < len; ++i) {
                this.leftovers.add(chars[i]);
            }
        }

        protected CoderResult implFlush(ByteBuffer out) {
            assert (this.leftovers.size() <= 4);
            if (this.leftovers.size() > 1) {
                if (out.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                int rem = this.leftovers.size();
                int c0 = this.leftovers.remove();
                int c1 = this.leftovers.remove();
                int c2 = this.leftovers.isEmpty() ? 0 : this.leftovers.remove();
                int c3 = this.leftovers.isEmpty() ? 0 : this.leftovers.remove();
                out.put((byte)(c0 << 2 | c1 >> 4));
                int next = c1 << 4 & 0xFF;
                if (rem >= 3 || next != 0) {
                    out.put((byte)(next | c2 >> 2));
                }
                if (rem >= 3) {
                    next = c2 << 6 & 0xFF;
                    if (rem >= 4 || next != 0) {
                        out.put((byte)(next | c3));
                    }
                }
            }
            assert (this.leftovers.size() < 2);
            return CoderResult.UNDERFLOW;
        }
    }
}

