/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal.handles;

import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.handles.AbstractHandle;
import io.apigee.trireme.core.internal.handles.HandleListener;
import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Future;

public class ConsoleHandle
extends AbstractHandle {
    private static final int READ_BUFFER_SIZE = 8192;
    private final Console console = System.console();
    private final PrintWriter writer = this.console.writer();
    private final Reader reader = this.console.reader();
    private final NodeRuntime runtime;
    private volatile boolean reading;
    private Future<?> readTask;

    public static boolean isConsoleSupported() {
        return System.console() != null;
    }

    public ConsoleHandle(NodeRuntime runtime) {
        this.runtime = runtime;
    }

    public int write(ByteBuffer buf, HandleListener listener, Object context) {
        int len = buf.remaining();
        String str = Utils.bufferToString(buf, Charsets.UTF8);
        this.writer.print(str);
        this.writer.flush();
        listener.onWriteComplete(len, true, context);
        return len;
    }

    public int write(String s, Charset cs, HandleListener listener, Object context) {
        int len = s.length();
        this.writer.print(s);
        this.writer.flush();
        listener.onWriteComplete(len, true, context);
        return len;
    }

    public void startReading(final HandleListener listener, final Object context) {
        if (this.reading) {
            return;
        }
        this.reading = true;
        this.runtime.pin();
        this.readTask = this.runtime.getUnboundedPool().submit(new Runnable(){

            public void run() {
                ConsoleHandle.this.readLoop(listener, context);
            }
        });
    }

    protected void readLoop(HandleListener listener, Object context) {
        char[] readBuf = new char[8192];
        try {
            int count = 0;
            while (this.reading && count >= 0) {
                count = this.reader.read(readBuf);
                if (count <= 0) continue;
                String rs = new String(readBuf, 0, count);
                ByteBuffer buf = Utils.stringToBuffer(rs, Charsets.UTF8);
                listener.onReadComplete(buf, false, context);
            }
            if (count < 0) {
                listener.onReadError("EOF", false, context);
            }
        }
        catch (InterruptedIOException iee) {
        }
        catch (EOFException eofe) {
            listener.onReadError("EOF", false, context);
        }
        catch (IOException ioe) {
            String err = "Stream Closed".equalsIgnoreCase(ioe.getMessage()) ? "EOF" : "EIO";
            listener.onReadError(err, false, context);
        }
    }

    public void stopReading() {
        if (this.reading) {
            this.runtime.unPin();
            this.reading = false;
        }
        if (this.readTask != null) {
            this.readTask.cancel(true);
        }
    }

    public void close() {
    }
}

