/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.internal.Platform;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.AbstractFilesystem;
import io.apigee.trireme.core.modules.Buffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFilesystem
implements InternalNodeModule {
    private static final Logger log = LoggerFactory.getLogger(AsyncFilesystem.class);

    public String getModuleName() {
        return "fs";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, FSImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)scope, StatsImpl.class, (boolean)false, (boolean)true);
        FSImpl fs = (FSImpl)cx.newObject(scope, "_fsClass");
        fs.initialize(runner, runner.getAsyncPool());
        ScriptableObject.defineClass((Scriptable)fs, StatsImpl.class, (boolean)false, (boolean)true);
        return fs;
    }

    private static abstract class AsyncAction {
        private AsyncAction() {
        }

        public abstract Object[] execute() throws NodeOSException;

        public Object[] mapException(Context cx, Scriptable scope, NodeOSException e) {
            return new Object[]{Utils.makeErrorObject(cx, scope, e)};
        }

        public Object[] mapSyncException(NodeOSException e) {
            return null;
        }
    }

    public static class FileHandle {
        static final String KEY = "_fileHandle";
        AsynchronousFileChannel file;
        Path path;
        long position;
        boolean noFollow;

        FileHandle(Path path, AsynchronousFileChannel file) {
            this.path = path;
            this.file = file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatsImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "Stats";
        private PosixFileAttributes attrs;

        public String getClassName() {
            return CLASS_NAME;
        }

        public void setAttributes(Context cx, Path path, Map<String, Object> attrs) {
            this.put("size", (Scriptable)this, attrs.get("size"));
            this.put("dev", (Scriptable)this, 0);
            Object ino = attrs.get("fileKey");
            if (ino instanceof Number) {
                this.put("ino", (Scriptable)this, ino);
            } else if (ino != null) {
                this.put("ino", (Scriptable)this, ino.hashCode());
            }
            this.put("atime", (Scriptable)this, this.makeDate(cx, attrs.get("lastAccessTime")));
            this.put("mtime", (Scriptable)this, this.makeDate(cx, attrs.get("lastModifiedTime")));
            this.put("ctime", (Scriptable)this, this.makeDate(cx, attrs.get("creationTime")));
            if (attrs.containsKey("owner")) {
                UserPrincipal up = (UserPrincipal)attrs.get("owner");
                this.put("uid", (Scriptable)this, up.hashCode());
            } else {
                this.put("uid", (Scriptable)this, 0);
            }
            if (attrs.containsKey("group")) {
                GroupPrincipal gp = (GroupPrincipal)attrs.get("group");
                this.put("gid", (Scriptable)this, gp.hashCode());
            } else {
                this.put("gid", (Scriptable)this, 0);
            }
            int mode = 0;
            if (((Boolean)attrs.get("isRegularFile")).booleanValue()) {
                mode |= 0x8000;
            }
            if (((Boolean)attrs.get("isDirectory")).booleanValue()) {
                mode |= 0x4000;
            }
            if (((Boolean)attrs.get("isSymbolicLink")).booleanValue()) {
                mode |= 0xA000;
            }
            if (attrs.containsKey("permissions")) {
                Set perms = (Set)attrs.get("permissions");
                mode |= this.setPosixPerms(perms);
            } else {
                mode |= this.setNonPosixPerms(path);
            }
            this.put("mode", (Scriptable)this, mode);
        }

        public int setPosixPerms(Set<PosixFilePermission> perms) {
            int mode = 0;
            if (perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                mode |= 8;
            }
            if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
                mode |= 0x20;
            }
            if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                mode |= 0x10;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                mode |= 1;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
                mode |= 4;
            }
            if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                mode |= 2;
            }
            if (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                mode |= 0x40;
            }
            if (perms.contains((Object)PosixFilePermission.OWNER_READ)) {
                mode |= 0x100;
            }
            if (perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                mode |= 0x80;
            }
            return mode;
        }

        public int setNonPosixPerms(Path p) {
            File file = p.toFile();
            int mode = 0;
            if (file.canRead()) {
                mode |= 0x100;
            }
            if (file.canWrite()) {
                mode |= 0x80;
            }
            if (file.canExecute()) {
                mode |= 0x40;
            }
            return mode;
        }

        private Object makeDate(Context cx, Object o) {
            FileTime ft = (FileTime)o;
            return cx.newObject((Scriptable)this, "Date", new Object[]{ft.toMillis()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FSImpl
    extends AbstractFilesystem {
        public static final String CLASS_NAME = "_fsClass";
        private static final int FIRST_FD = 4;
        protected ScriptRunner runner;
        protected ExecutorService pool;
        private final AtomicInteger nextFd = new AtomicInteger(4);
        private final ConcurrentHashMap<Integer, FileHandle> descriptors = new ConcurrentHashMap();

        public String getClassName() {
            return CLASS_NAME;
        }

        protected void initialize(NodeRuntime runner, ExecutorService fsPool) {
            this.runner = (ScriptRunner)runner;
            this.pool = fsPool;
        }

        @Override
        public void cleanup() {
            for (FileHandle handle : this.descriptors.values()) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing leaked file descriptor " + handle);
                }
                if (handle.file == null) continue;
                try {
                    handle.file.close();
                }
                catch (IOException iOException) {}
            }
            this.descriptors.clear();
        }

        private static Object mapResponse(Object[] ret) {
            if (ret == null || ret.length < 2) {
                return null;
            }
            return ret[1];
        }

        private Object runAction(final Context cx, final Function callback, final AsyncAction action) {
            if (callback == null) {
                try {
                    Object[] ret = action.execute();
                    return FSImpl.mapResponse(ret);
                }
                catch (NodeOSException e) {
                    Object[] err;
                    if (log.isDebugEnabled()) {
                        log.debug("I/O exception: {}: {}", (Object)e.getCode(), (Object)e);
                    }
                    if ((err = action.mapSyncException(e)) == null) {
                        throw Utils.makeError(cx, (Scriptable)this, e);
                    }
                    return err[1];
                }
            }
            final FSImpl self = this;
            final Scriptable domain = this.runner.getDomain();
            this.runner.pin();
            this.pool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (log.isDebugEnabled()) {
                        log.debug("Executing async action {}", (Object)action);
                    }
                    try {
                        Object[] args = action.execute();
                        if (args == null) {
                            args = new Object[]{};
                        }
                        FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, args);
                    }
                    catch (NodeOSException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Async action {} failed: {}: {}", new Object[]{action, e.getCode(), e});
                        }
                        FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, action.mapException(cx, (Scriptable)self, e));
                    }
                    finally {
                        FSImpl.this.runner.unPin();
                    }
                }
            });
            return null;
        }

        private String getErrorCode(IOException ioe) {
            String code = "EIO";
            if (ioe instanceof FileNotFoundException) {
                code = "ENOENT";
            } else if (ioe instanceof AccessDeniedException) {
                code = "EPERM";
            } else if (ioe instanceof DirectoryNotEmptyException) {
                code = "ENOTEMPTY";
            } else if (ioe instanceof FileAlreadyExistsException) {
                code = "EEXIST";
            } else if (ioe instanceof NoSuchFileException) {
                code = "ENOENT";
            } else if (ioe instanceof NotDirectoryException) {
                code = "ENOTDIR";
            } else if (ioe instanceof NotLinkException) {
                code = "EINVAL";
            }
            if (log.isDebugEnabled()) {
                log.debug("File system error {} = code {}", (Object)ioe, (Object)code);
            }
            return code;
        }

        private Path translatePath(String path) throws NodeOSException {
            File trans = this.runner.translatePath(path);
            if (trans == null) {
                throw new NodeOSException("ENOENT", path);
            }
            return Paths.get(trans.getPath(), new String[0]);
        }

        private FileHandle ensureHandle(int fd) throws NodeOSException {
            FileHandle handle = this.descriptors.get(fd);
            if (handle == null) {
                if (log.isTraceEnabled()) {
                    log.trace("File handle {} is not a regular file, fd");
                }
                throw new NodeOSException("EBADF");
            }
            return handle;
        }

        private FileHandle ensureRegularFileHandle(int fd) throws NodeOSException {
            FileHandle h = this.ensureHandle(fd);
            if (h.file == null) {
                if (Files.isDirectory(h.path, new LinkOption[0])) {
                    if (log.isTraceEnabled()) {
                        log.trace("File handle {} is a directory and not a regular file", (Object)fd);
                    }
                    throw new NodeOSException("EISDIR");
                }
                if (log.isTraceEnabled()) {
                    log.trace("File handle {} is not a regular file", (Object)fd);
                }
                throw new NodeOSException("EBADF");
            }
            return h;
        }

        private static Buffer.BufferImpl ensureBuffer(Context cx, Scriptable scope, Object[] args, int pos) {
            ArgUtils.ensureArg(args, pos);
            try {
                return (Buffer.BufferImpl)((Object)args[pos]);
            }
            catch (ClassCastException cce) {
                throw Utils.makeError(cx, scope, "Not a buffer", "EINVAL");
            }
        }

        @JSFunction
        public static Object open(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final String pathStr = ArgUtils.stringArg(args, 0);
            final int flags = ArgUtils.intArg(args, 1);
            final int mode = ArgUtils.intArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doOpen(pathStr, flags, mode);
                }

                public Object[] mapException(Context cx, Scriptable scope, NodeOSException e) {
                    return new Object[]{Utils.makeErrorObject(cx, thisObj, e)};
                }
            });
        }

        private Object[] doOpen(String pathStr, int flags, int mode) throws NodeOSException {
            if (log.isDebugEnabled()) {
                log.debug("open({}, {}, {})", new Object[]{pathStr, flags, mode});
            }
            Path path = this.translatePath(pathStr);
            AsynchronousFileChannel file = null;
            if (!Files.isDirectory(path, new LinkOption[0])) {
                HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
                if ((flags & 0x200) != 0) {
                    if ((flags & 0x800) != 0) {
                        options.add(StandardOpenOption.CREATE_NEW);
                    } else {
                        options.add(StandardOpenOption.CREATE);
                    }
                }
                if ((flags & 2) != 0) {
                    options.add(StandardOpenOption.READ);
                    options.add(StandardOpenOption.WRITE);
                } else if ((flags & 1) != 0) {
                    options.add(StandardOpenOption.WRITE);
                } else {
                    options.add(StandardOpenOption.READ);
                }
                if ((flags & 0x400) != 0) {
                    options.add(StandardOpenOption.TRUNCATE_EXISTING);
                }
                if ((flags & 0x80) != 0) {
                    options.add(StandardOpenOption.SYNC);
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Opening {} with {}", (Object)path, options);
                    }
                    if (Platform.get().isPosixFilesystem()) {
                        file = AsynchronousFileChannel.open(path, options, this.pool, PosixFilePermissions.asFileAttribute(this.modeToPerms(mode, true)));
                    } else {
                        file = AsynchronousFileChannel.open(path, options, this.pool, new FileAttribute[0]);
                        this.setModeNoPosix(path, mode);
                    }
                }
                catch (IOException ioe) {
                    throw new NodeOSException(this.getErrorCode(ioe), ioe, pathStr);
                }
            }
            try {
                FileHandle fileHandle = new FileHandle(path, file);
                int fd = this.nextFd.getAndIncrement();
                if (log.isDebugEnabled()) {
                    log.debug("  open({}) = {}", (Object)pathStr, (Object)fd);
                }
                if ((flags & 8) != 0 && file != null && file.size() > 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("  setting file position to {}", (Object)file.size());
                    }
                    fileHandle.position = file.size();
                }
                this.descriptors.put(fd, fileHandle);
                return new Object[]{Context.getUndefinedValue(), fd};
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, pathStr);
            }
        }

        @JSFunction
        public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doClose(fd);
                    return null;
                }
            });
        }

        private void doClose(int fd) throws NodeOSException {
            FileHandle handle = this.ensureHandle(fd);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("close({})", (Object)fd);
                }
                if (handle.file != null) {
                    handle.file.close();
                }
                this.descriptors.remove(fd);
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe);
            }
        }

        @JSFunction
        public static Object read(Context cx, Scriptable thisObj, Object[] args, Function func) {
            FSImpl fs = (FSImpl)thisObj;
            int fd = ArgUtils.intArg(args, 0);
            Buffer.BufferImpl buf = FSImpl.ensureBuffer(cx, thisObj, args, 1);
            int off = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 2, 0);
            int len = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 3, 0);
            long pos = ArgUtils.longArgOnly(cx, (Scriptable)fs, args, 4, -1L);
            Function callback = ArgUtils.functionArg(args, 5, false);
            if (off >= buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Offset is out of bounds", "EINVAL");
            }
            if (off + len > buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Length extends beyond buffer", "EINVAL");
            }
            try {
                return FSImpl.mapResponse(fs.doRead(cx, fd, buf, off, len, pos, callback));
            }
            catch (NodeOSException ne) {
                if (callback == null) {
                    throw Utils.makeError(cx, thisObj, ne);
                }
                Scriptable err = Utils.makeErrorObject(cx, thisObj, ne);
                fs.runner.enqueueCallback(callback, (Scriptable)callback, null, fs.runner.getDomain(), new Object[]{err});
                return null;
            }
        }

        private Object[] doRead(final Context cx, int fd, final Buffer.BufferImpl buf, final int off, final int len, long pos, final Function callback) throws NodeOSException {
            byte[] bytes = buf.getArray();
            int bytesOffset = buf.getArrayOffset() + off;
            ByteBuffer readBuf = ByteBuffer.wrap(bytes, bytesOffset, len);
            final FileHandle handle = this.ensureRegularFileHandle(fd);
            if (pos < 0L) {
                pos = handle.position;
            }
            if (callback == null) {
                int count;
                try {
                    Future<Integer> result = handle.file.read(readBuf, pos);
                    count = result.get();
                    handle.position += (long)count;
                }
                catch (InterruptedException ie) {
                    throw new NodeOSException("EINTR");
                }
                catch (ExecutionException e) {
                    throw new NodeOSException("EIO", e.getCause());
                }
                if (count < 0) {
                    count = 0;
                }
                if (log.isDebugEnabled()) {
                    log.debug("read({}, {}, {}) = {}", new Object[]{off, len, pos, count});
                }
                return new Object[]{Context.getUndefinedValue(), count, buf};
            }
            final Scriptable domain = this.runner.getDomain();
            final long readPos = pos;
            this.runner.pin();
            handle.file.read(readBuf, pos, null, new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer result, Object attachment) {
                    int count = result;
                    if (count < 0) {
                        count = 0;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("async read({}, {}, {}) = {}", new Object[]{off, len, readPos, count});
                    }
                    handle.position += (long)count;
                    FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, new Object[]{Context.getUndefinedValue(), count, buf});
                    FSImpl.this.runner.unPin();
                }

                @Override
                public void failed(Throwable t, Object attachment) {
                    FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, new Object[]{Utils.makeErrorObject(cx, (Scriptable)FSImpl.this, "EIO", "EIO"), 0, buf});
                    FSImpl.this.runner.unPin();
                }
            });
            return null;
        }

        @JSFunction
        public static Object write(Context cx, Scriptable thisObj, Object[] args, Function func) {
            FSImpl fs = (FSImpl)thisObj;
            int fd = ArgUtils.intArg(args, 0);
            Buffer.BufferImpl buf = FSImpl.ensureBuffer(cx, thisObj, args, 1);
            int off = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 2, 0);
            int len = ArgUtils.intArgOnly(cx, (Scriptable)fs, args, 3, 0);
            long pos = ArgUtils.longArgOnly(cx, (Scriptable)fs, args, 4, 0L);
            Function callback = ArgUtils.functionArg(args, 5, false);
            if (off >= buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Offset is out of bounds", "EINVAL");
            }
            if (off + len > buf.getLength()) {
                throw Utils.makeError(cx, thisObj, "Length extends beyond buffer", "EINVAL");
            }
            try {
                return FSImpl.mapResponse(fs.doWrite(cx, fd, buf, off, len, pos, callback));
            }
            catch (NodeOSException ne) {
                Scriptable err = Utils.makeErrorObject(cx, thisObj, ne);
                if (callback == null) {
                    return err;
                }
                fs.runner.enqueueCallback(callback, (Scriptable)callback, null, fs.runner.getDomain(), new Object[]{err});
                return null;
            }
        }

        private Object[] doWrite(final Context cx, int fd, final Buffer.BufferImpl buf, final int off, final int len, long pos, final Function callback) throws NodeOSException {
            byte[] bytes = buf.getArray();
            int bytesOffset = buf.getArrayOffset() + off;
            ByteBuffer writeBuf = ByteBuffer.wrap(bytes, bytesOffset, len);
            FileHandle handle = this.ensureRegularFileHandle(fd);
            if (pos <= 0L) {
                pos = handle.position;
            }
            if (callback == null) {
                int count;
                try {
                    Future<Integer> result = handle.file.write(writeBuf, pos);
                    count = result.get();
                    handle.position += (long)count;
                    if (log.isDebugEnabled()) {
                        log.debug("write({}, {}, {}) = {}", new Object[]{off, len, pos, count});
                    }
                }
                catch (InterruptedException e) {
                    throw new NodeOSException("EINTR");
                }
                catch (ExecutionException e) {
                    throw new NodeOSException("EIO", e.getCause());
                }
                return new Object[]{Context.getUndefinedValue(), count, buf};
            }
            final Scriptable domain = this.runner.getDomain();
            final long readPos = pos;
            handle.position += (long)writeBuf.remaining();
            this.runner.pin();
            handle.file.write(writeBuf, pos, 0, new CompletionHandler<Integer, Integer>(){

                @Override
                public void completed(Integer result, Integer attachment) {
                    int count = result;
                    if (log.isDebugEnabled()) {
                        log.debug("write({}, {}, {}) = {}", new Object[]{off, len, readPos, count});
                    }
                    FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, new Object[]{Context.getUndefinedValue(), count, buf});
                    FSImpl.this.runner.unPin();
                }

                @Override
                public void failed(Throwable exc, Integer attachment) {
                    FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain, new Object[]{Utils.makeErrorObject(cx, (Scriptable)FSImpl.this, "EIO", "EIO"), 0, buf});
                    FSImpl.this.runner.unPin();
                }
            });
            return null;
        }

        @JSFunction
        public static void fsync(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doSync(fd, true);
                    return null;
                }
            });
        }

        @JSFunction
        public static void fdatasync(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doSync(fd, false);
                    return null;
                }
            });
        }

        private void doSync(int fd, boolean metaData) throws NodeOSException {
            FileHandle handle = this.ensureRegularFileHandle(fd);
            if (log.isDebugEnabled()) {
                log.debug("fsync({})", (Object)fd);
            }
            try {
                handle.file.force(metaData);
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe);
            }
        }

        @JSFunction
        public static void rename(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String oldPath = ArgUtils.stringArg(args, 0);
            final String newPath = ArgUtils.stringArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl fs = (FSImpl)thisObj;
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doRename(oldPath, newPath);
                    return null;
                }
            });
        }

        private void doRename(String oldPath, String newPath) throws NodeOSException {
            Path oldFile = this.translatePath(oldPath);
            Path newFile = this.translatePath(newPath);
            try {
                Files.copy(oldFile, newFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, oldPath);
            }
        }

        @JSFunction
        public static void ftruncate(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            final long len = ArgUtils.longArgOnly(cx, (Scriptable)fs, args, 1, 0L);
            Function callback = ArgUtils.functionArg(args, 2, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doTruncate(fd, len);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTruncate(int fd, long len) throws NodeOSException {
            block7: {
                if (log.isDebugEnabled()) {
                    log.debug("ftruncate({}, {})", (Object)fd, (Object)len);
                }
                try {
                    FileHandle handle = this.ensureRegularFileHandle(fd);
                    if (len > handle.file.size()) {
                        RandomAccessFile tmp = new RandomAccessFile(handle.path.toFile(), "rw");
                        try {
                            tmp.setLength(len);
                            break block7;
                        }
                        finally {
                            tmp.close();
                        }
                    }
                    handle.file.truncate(len);
                }
                catch (IOException e) {
                    throw new NodeOSException(this.getErrorCode(e), e);
                }
            }
        }

        @JSFunction
        public static void rmdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doRmdir(path);
                    return null;
                }
            });
        }

        private void doRmdir(String path) throws NodeOSException {
            Path p;
            if (log.isDebugEnabled()) {
                log.debug("rmdir({})", (Object)path);
            }
            if (!Files.isDirectory(p = this.translatePath(path), new LinkOption[0])) {
                throw new NodeOSException("ENOTDIR", path);
            }
            try {
                Files.delete(p);
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, path);
            }
        }

        @JSFunction
        public static void unlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doUnlink(path);
                    return null;
                }
            });
        }

        private void doUnlink(String path) throws NodeOSException {
            if (log.isDebugEnabled()) {
                log.debug("unlink({})", (Object)path);
            }
            Path p = this.translatePath(path);
            try {
                Files.delete(p);
            }
            catch (DirectoryNotEmptyException dne) {
                throw new NodeOSException("EPERM", dne, path);
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, path);
            }
        }

        @JSFunction
        public static void mkdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final int mode = ArgUtils.intArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl fs = (FSImpl)thisObj;
            fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    fs.doMkdir(path, mode);
                    return null;
                }
            });
        }

        private void doMkdir(String path, int mode) throws NodeOSException {
            if (log.isDebugEnabled()) {
                log.debug("mkdir({})", (Object)path);
            }
            Path p = this.translatePath(path);
            try {
                if (Platform.get().isPosixFilesystem()) {
                    Set<PosixFilePermission> perms = this.modeToPerms(mode, true);
                    Files.createDirectory(p, PosixFilePermissions.asFileAttribute(perms));
                } else {
                    Files.createDirectory(p, new FileAttribute[0]);
                    this.setModeNoPosix(p, mode);
                }
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, path);
            }
        }

        @JSFunction
        public static Object readdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return fs.doReaddir(path);
                }
            });
        }

        private Object[] doReaddir(String dn) throws NodeOSException {
            Path sp = this.translatePath(dn);
            Context cx = Context.enter();
            if (!Files.isDirectory(sp, new LinkOption[0])) {
                throw new NodeOSException("ENOTDIR", sp.toString());
            }
            try {
                final ArrayList paths = new ArrayList();
                Set<FileVisitOption> options = Collections.emptySet();
                Files.walkFileTree(sp, options, 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path child, BasicFileAttributes attrs) {
                        if (log.isTraceEnabled()) {
                            log.trace("  " + child.getFileName());
                        }
                        paths.add(child.getFileName().toString());
                        return FileVisitResult.CONTINUE;
                    }
                });
                Object[] objs = new Object[paths.size()];
                paths.toArray(objs);
                Scriptable fileList = cx.newArray((Scriptable)this, objs);
                if (log.isDebugEnabled()) {
                    log.debug("readdir({}) = {}", (Object)dn, (Object)objs.length);
                }
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), fileList};
                return objectArray;
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, dn);
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static Object stat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    Path p = fs.translatePath(path);
                    return fs.doStat(p, false);
                }
            });
        }

        private Map<String, Object> readAttrs(String attrNames, Path p, boolean noFollow) throws IOException {
            if (noFollow) {
                return Files.readAttributes(p, attrNames, LinkOption.NOFOLLOW_LINKS);
            }
            return Files.readAttributes(p, attrNames, new LinkOption[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doStat(Path p, boolean noFollow) {
            Context cx = Context.enter();
            try {
                StatsImpl s;
                try {
                    HashMap<String, Object> attrs;
                    if (Platform.get().isPosixFilesystem()) {
                        attrs = this.readAttrs("posix:*", p, noFollow);
                    } else {
                        attrs = new HashMap<String, Object>();
                        attrs.putAll(this.readAttrs("*", p, noFollow));
                        attrs.putAll(this.readAttrs("owner:*", p, noFollow));
                    }
                    s = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
                    s.setAttributes(cx, p, attrs);
                }
                catch (IOException ioe) {
                    throw new NodeOSException(this.getErrorCode(ioe), ioe, p.toString());
                }
                catch (Throwable t) {
                    log.error("Error on stat: {}", t);
                    throw new NodeOSException("Error on Stat", t);
                }
                if (log.isTraceEnabled()) {
                    log.trace("stat {} = {}", (Object)p, (Object)s);
                }
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), s};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static Object lstat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl fs = (FSImpl)thisObj;
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    Path p = fs.translatePath(path);
                    return fs.doStat(p, true);
                }
            });
        }

        @JSFunction
        public static Object fstat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            return fs.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    FileHandle fh = fs.ensureHandle(fd);
                    return fs.doStat(fh.path, fh.noFollow);
                }
            });
        }

        @JSFunction
        public static void utimes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final double atime = ArgUtils.doubleArg(args, 1);
            final double mtime = ArgUtils.doubleArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    Path p = self.translatePath(path);
                    return self.doUTimes(p, atime, mtime, false);
                }
            });
        }

        @JSFunction
        public static void futimes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg(args, 0);
            final double atime = ArgUtils.doubleArg(args, 1);
            final double mtime = ArgUtils.doubleArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    FileHandle fh = self.ensureHandle(fd);
                    return self.doUTimes(fh.path, atime, mtime, fh.noFollow);
                }
            });
        }

        private Object[] doUTimes(Path path, double atime, double mtime, boolean nofollow) throws NodeOSException {
            try {
                BasicFileAttributeView attrView = nofollow ? Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS) : Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
                BasicFileAttributes attrs = attrView.readAttributes();
                FileTime newATime = FileTime.fromMillis((long)(atime * 1000.0));
                FileTime newMTime = FileTime.fromMillis((long)(mtime * 1000.0));
                attrView.setTimes(newMTime, newATime, attrs.creationTime());
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, path.toString());
            }
            return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
        }

        @JSFunction
        public static void chmod(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final int mode = ArgUtils.intArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    Path p = self.translatePath(path);
                    if (Platform.get().isPosixFilesystem()) {
                        return self.doChmod(p, mode, false);
                    }
                    return self.setModeNoPosix(p, mode);
                }
            });
        }

        private Set<PosixFilePermission> modeToPerms(int origMode, boolean onCreate) {
            int mode = onCreate ? origMode & ~this.runner.getProcess().getUmask() : origMode;
            EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
            if ((mode & 0x40) != 0) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if ((mode & 0x100) != 0) {
                perms.add(PosixFilePermission.OWNER_READ);
            }
            if ((mode & 0x80) != 0) {
                perms.add(PosixFilePermission.OWNER_WRITE);
            }
            if ((mode & 8) != 0) {
                perms.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if ((mode & 0x20) != 0) {
                perms.add(PosixFilePermission.GROUP_READ);
            }
            if ((mode & 0x10) != 0) {
                perms.add(PosixFilePermission.GROUP_WRITE);
            }
            if ((mode & 1) != 0) {
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            if ((mode & 4) != 0) {
                perms.add(PosixFilePermission.OTHERS_READ);
            }
            if ((mode & 2) != 0) {
                perms.add(PosixFilePermission.OTHERS_WRITE);
            }
            if (log.isDebugEnabled()) {
                log.debug("Mode {} and {} becomes {} then {}", new Object[]{Integer.toOctalString(origMode), Integer.toOctalString(this.runner.getProcess().getUmask()), Integer.toOctalString(mode), perms});
            }
            return perms;
        }

        private Object[] doChmod(Path path, int mode, boolean noFollow) throws NodeOSException {
            Set<PosixFilePermission> perms = this.modeToPerms(mode, false);
            if (log.isDebugEnabled()) {
                log.debug("chmod({}, {}) to {}", new Object[]{path, mode, perms});
            }
            try {
                if (noFollow) {
                    Files.setAttribute(path, "posix:permissions", perms, LinkOption.NOFOLLOW_LINKS);
                } else {
                    Files.setAttribute(path, "posix:permissions", perms, new LinkOption[0]);
                }
                return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, path.toString());
            }
        }

        private Object[] setModeNoPosix(Path p, int origMode) {
            File f = p.toFile();
            int mode = origMode & ~this.runner.getProcess().getUmask();
            if ((mode & 4) != 0 || (mode & 0x20) != 0) {
                f.setReadable(true, false);
            } else if ((mode & 0x100) != 0) {
                f.setReadable(true, true);
            } else {
                f.setReadable(false, true);
            }
            if ((mode & 2) != 0 || (mode & 0x10) != 0) {
                f.setWritable(true, false);
            } else if ((mode & 0x80) != 0) {
                f.setWritable(true, true);
            } else {
                f.setWritable(false, true);
            }
            if ((mode & 1) != 0 || (mode & 8) != 0) {
                f.setExecutable(true, false);
            } else if ((mode & 0x40) != 0) {
                f.setExecutable(true, true);
            } else {
                f.setExecutable(false, true);
            }
            return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
        }

        @JSFunction
        public static void fchmod(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg(args, 0);
            final int mode = ArgUtils.intArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    FileHandle fh = self.ensureHandle(fd);
                    if (Platform.get().isPosixFilesystem()) {
                        return self.doChmod(fh.path, mode, fh.noFollow);
                    }
                    return self.setModeNoPosix(fh.path, mode);
                }
            });
        }

        private Object[] doChown(Path path, String uid, String gid, boolean noFollow) throws NodeOSException {
            if (log.isDebugEnabled()) {
                log.debug("chown({}) to {}:{}", new Object[]{path, uid, gid});
            }
            UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            try {
                UserPrincipal user = lookupService.lookupPrincipalByName(uid);
                if (Platform.get().isPosixFilesystem()) {
                    GroupPrincipal group = lookupService.lookupPrincipalByGroupName(gid);
                    if (noFollow) {
                        Files.setAttribute(path, "posix:owner", user, LinkOption.NOFOLLOW_LINKS);
                        Files.setAttribute(path, "posix:group", group, LinkOption.NOFOLLOW_LINKS);
                    } else {
                        Files.setAttribute(path, "posix:owner", user, new LinkOption[0]);
                        Files.setAttribute(path, "posix:group", group, new LinkOption[0]);
                    }
                } else {
                    Files.setOwner(path, user);
                }
                return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, path.toString());
            }
        }

        @JSFunction
        public static void chown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            final String uid = ArgUtils.stringArg(args, 1);
            final String gid = ArgUtils.stringArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, true);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    Path p = self.translatePath(path);
                    return self.doChown(p, uid, gid, false);
                }
            });
        }

        @JSFunction
        public static void fchown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg(args, 0);
            final String uid = ArgUtils.stringArg(args, 1);
            final String gid = ArgUtils.stringArg(args, 2);
            Function callback = ArgUtils.functionArg(args, 3, true);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    FileHandle fh = self.ensureHandle(fd);
                    return self.doChown(fh.path, uid, gid, fh.noFollow);
                }
            });
        }

        @JSFunction
        public static Object link(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String srcPath = ArgUtils.stringArg(args, 0);
            final String destPath = ArgUtils.stringArg(args, 1);
            Function callback = ArgUtils.functionArg(args, 2, false);
            final FSImpl self = (FSImpl)thisObj;
            return self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return self.doLink(destPath, srcPath);
                }
            });
        }

        private Object[] doLink(String destPath, String srcPath) throws NodeOSException {
            Path dest = this.translatePath(destPath);
            Path src = this.translatePath(srcPath);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("link from {} to {}", (Object)src, (Object)dest);
                }
                Files.createLink(dest, src);
                return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, destPath);
            }
        }

        @JSFunction
        public static Object symlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String srcPath = ArgUtils.stringArg(args, 0);
            final String destPath = ArgUtils.stringArg(args, 1);
            String type = ArgUtils.stringArg(args, 2, null);
            Function callback = ArgUtils.functionArg(args, 3, false);
            final FSImpl self = (FSImpl)thisObj;
            return self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return self.doSymlink(destPath, srcPath);
                }
            });
        }

        private Object[] doSymlink(String destPath, String srcPath) throws NodeOSException {
            Path dest = this.translatePath(destPath);
            Path src = this.translatePath(srcPath);
            if (dest == null) {
                throw new NodeOSException("EPERM", "Attempt to link file above filesystem root");
            }
            Path origSrc = Paths.get(srcPath, new String[0]);
            if (!origSrc.isAbsolute()) {
                src = origSrc;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("symlink from {} to {}", (Object)src, (Object)dest);
                }
                Files.createSymbolicLink(dest, src, new FileAttribute[0]);
                return new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue()};
            }
            catch (IOException ioe) {
                throw new NodeOSException(this.getErrorCode(ioe), ioe, destPath);
            }
        }

        @JSFunction
        public static Object readlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path = ArgUtils.stringArg(args, 0);
            Function callback = ArgUtils.functionArg(args, 1, false);
            final FSImpl self = (FSImpl)thisObj;
            return self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws NodeOSException {
                    return self.doReadLink(path);
                }
            });
        }

        private Object[] doReadLink(String pathStr) throws NodeOSException {
            Path path = this.translatePath(pathStr);
            try {
                Path target = Files.readSymbolicLink(path);
                if (log.isDebugEnabled()) {
                    log.debug("readLink({}) = {}", (Object)path, (Object)target);
                }
                String result = Files.isDirectory(target, new LinkOption[0]) ? target.toString() + '/' : target.toString();
                return new Object[]{Context.getUndefinedValue(), result};
            }
            catch (IOException ioe) {
                log.debug("IOException: {}", (Throwable)ioe);
                throw new NodeOSException(this.getErrorCode(ioe), ioe, pathStr);
            }
        }
    }
}

