/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.ScriptRunner;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;

public class Buffer
implements NodeModule {
    private static final String DEFAULT_ENCODING = "utf8";
    public static final String MODULE_NAME = "buffer";
    public static final int MAX_LENGTH = 0x3FFFFFFF;

    public String getModuleName() {
        return MODULE_NAME;
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, BufferModuleImpl.class);
        BufferModuleImpl export = (BufferModuleImpl)cx.newObject(scope, "_bufferModule");
        ScriptableObject.defineClass((Scriptable)export, BufferImpl.class, (boolean)false, (boolean)true);
        ScriptableObject buf = (ScriptableObject)export.get("Buffer", (Scriptable)export);
        buf.defineProperty("_charsWritten", (Object)export, Utils.findMethod(BufferModuleImpl.class, "getCharsWritten"), null, 0);
        export.put("SlowBuffer", (Scriptable)export, buf);
        return export;
    }

    public static class BufferImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "Buffer";
        private byte[] buf;
        private int bufOffset;
        private int bufLength;

        public static BufferImpl newBuffer(Context cx, Scriptable scope, ByteBuffer bb, boolean copy) {
            BufferImpl buf = (BufferImpl)cx.newObject(scope, CLASS_NAME);
            if (bb == null) {
                return buf;
            }
            if (bb.hasArray() && !copy) {
                buf.buf = bb.array();
                buf.bufOffset = bb.arrayOffset() + bb.position();
                buf.bufLength = bb.remaining();
            } else {
                buf.buf = new byte[bb.remaining()];
                bb.get(buf.buf);
                buf.bufOffset = 0;
                buf.bufLength = buf.buf.length;
            }
            return buf;
        }

        public static BufferImpl newBuffer(Context cx, Scriptable scope, byte[] bb) {
            return BufferImpl.newBuffer(cx, scope, bb, 0, bb.length);
        }

        public static BufferImpl newBuffer(Context cx, Scriptable scope, byte[] bb, int offset, int length) {
            BufferImpl buf = (BufferImpl)cx.newObject(scope, CLASS_NAME);
            if (bb == null) {
                return buf;
            }
            buf.buf = bb;
            buf.bufOffset = offset;
            buf.bufLength = length;
            return buf;
        }

        public ByteBuffer getBuffer() {
            return ByteBuffer.wrap(this.buf, this.bufOffset, this.bufLength);
        }

        public String getString(String encoding) {
            Charset cs = Charsets.get().getCharset(encoding);
            return Utils.bufferToString(ByteBuffer.wrap(this.buf, this.bufOffset, this.bufLength), cs);
        }

        public byte[] getArray() {
            return this.buf;
        }

        public int getArrayOffset() {
            return this.bufOffset;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        public Object get(int index, Scriptable start) {
            if (index < this.bufLength) {
                return this.get(index);
            }
            return Undefined.instance;
        }

        public int get(int index) {
            return this.buf[index + this.bufOffset] & 0xFF;
        }

        public boolean has(int index, Scriptable start) {
            return index < this.bufLength;
        }

        public void put(int index, Scriptable start, Object value) {
            if (index < this.bufLength) {
                int val = (Integer)Context.jsToJava((Object)value, Integer.class);
                this.putByte(index + this.bufOffset, val);
            }
        }

        private void putByte(int pos, int v) {
            int val = v;
            if (val < 0) {
                val = 255 + val + 1;
            }
            this.buf[pos] = (byte)(val & 0xFF);
        }

        @JSConstructor
        public static Object bufferConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            BufferImpl ret = inNewExpr ? new BufferImpl() : (BufferImpl)cx.newObject((Scriptable)ctorObj, CLASS_NAME);
            BufferImpl.initializeBuffer(ret, cx, args, ctorObj);
            return ret;
        }

        static void initializeBuffer(BufferImpl buf, Context cx, Object[] args, Function ctorObj) {
            if (args.length == 0) {
                return;
            }
            if (args[0] instanceof String) {
                Charset encoding = BufferImpl.resolveEncoding(args, 1);
                buf.fromStringInternal((String)args[0], encoding);
            } else if (args[0] instanceof Number) {
                int len = ArgUtils.parseUnsignedIntForgiveably(args[0]);
                if (len < 0 || len > 0x3FFFFFFF) {
                    throw Utils.makeRangeError(cx, (Scriptable)ctorObj, "Length out of range");
                }
                buf.buf = new byte[len];
                buf.bufOffset = 0;
                buf.bufLength = len;
            } else if (args[0] instanceof BufferImpl) {
                BufferImpl src = (BufferImpl)((Object)args[0]);
                buf.buf = new byte[src.bufLength];
                buf.bufOffset = 0;
                buf.bufLength = src.bufLength;
                System.arraycopy(src.buf, src.bufOffset, buf.buf, 0, buf.bufLength);
            } else if (args[0] instanceof Scriptable) {
                Scriptable s = (Scriptable)args[0];
                if (s.getPrototype().equals(ScriptableObject.getArrayPrototype((Scriptable)ctorObj))) {
                    Object[] ids = s.getIds();
                    buf.buf = new byte[ids.length];
                    int pos = 0;
                    for (Object id : ids) {
                        Object e;
                        if (id instanceof Number) {
                            e = s.get(((Number)id).intValue(), s);
                        } else if (id instanceof String) {
                            e = s.get((String)id, s);
                        } else {
                            throw Utils.makeTypeError(cx, (Scriptable)ctorObj, "Invalid argument type in array");
                        }
                        buf.putByte(pos++, (int)Context.toNumber((Object)e));
                    }
                } else if (s.has("length", s)) {
                    int len = ArgUtils.parseUnsignedIntForgiveably(s.get("length", s));
                    if (len < 0 || len > 0x3FFFFFFF) {
                        throw Utils.makeRangeError(cx, (Scriptable)ctorObj, "Length out of range");
                    }
                    buf.buf = new byte[len];
                    for (Object id : s.getIds()) {
                        if (!(id instanceof Number)) continue;
                        int iid = ((Number)id).intValue();
                        Object v = s.get(iid, s);
                        if (iid >= len) continue;
                        int val = (Integer)Context.jsToJava((Object)v, Integer.class);
                        buf.buf[iid] = (byte)(val & 0xFF);
                    }
                } else {
                    buf.buf = new byte[0];
                }
                buf.bufOffset = 0;
                buf.bufLength = buf.buf.length;
            } else {
                throw Utils.makeTypeError(cx, (Scriptable)ctorObj, "Invalid argument type");
            }
        }

        @JSFunction
        public static Object write(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String data = ArgUtils.stringArg(args, 0);
            Charset charset = null;
            boolean hasOffset = false;
            boolean hasLength = false;
            boolean hasCharset = false;
            int offset = 0;
            int length = 0;
            BufferImpl b = (BufferImpl)thisObj;
            if (args.length > 1) {
                if (ArgUtils.isIntArg(args[1])) {
                    offset = ArgUtils.intArg(args, 1);
                    hasOffset = true;
                } else {
                    charset = BufferImpl.resolveEncoding(args, 1);
                    hasCharset = true;
                }
            }
            if (args.length > 2) {
                if (ArgUtils.isIntArg(args[2])) {
                    if (hasOffset) {
                        length = ArgUtils.intArg(args, 2);
                        hasLength = true;
                    } else {
                        offset = ArgUtils.intArg(args, 2);
                        hasOffset = true;
                    }
                } else {
                    charset = BufferImpl.resolveEncoding(args, 2);
                    hasCharset = true;
                }
            }
            if (args.length > 3 && ArgUtils.isIntArg(args[3])) {
                if (hasOffset) {
                    length = ArgUtils.intArg(args, 3);
                    hasLength = true;
                } else {
                    throw Utils.makeRangeError(cx, thisObj, "Invalid arguments");
                }
            }
            if (!hasCharset) {
                charset = BufferImpl.resolveEncoding(args, 3);
            }
            if (!hasLength) {
                length = b.bufLength - offset;
            }
            CharsetEncoder encoder = Charsets.get().getEncoder(charset);
            if (offset < 0) {
                throw Utils.makeRangeError(cx, thisObj, "offset out of bounds");
            }
            if (length < 0) {
                return Context.toNumber((Object)0);
            }
            int maxLen = Math.min(length, b.bufLength - offset);
            if (maxLen < 0) {
                return Context.toNumber((Object)0);
            }
            ByteBuffer writeBuf = ByteBuffer.wrap(b.buf, offset + b.bufOffset, maxLen);
            CharBuffer chars = CharBuffer.wrap(data);
            encoder.encode(chars, writeBuf, true);
            encoder.flush(writeBuf);
            b.setCharsWritten(chars.position());
            return Context.toNumber((Object)(writeBuf.position() - offset - b.bufOffset));
        }

        @JSFunction
        public static String toString(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Charset charset = BufferImpl.resolveEncoding(args, 0);
            int start = ArgUtils.intArg(args, 1, 0);
            BufferImpl b = (BufferImpl)thisObj;
            int end = args.length > 2 ? ArgUtils.intArg(args, 2) : b.bufLength;
            if (end == start) {
                return "";
            }
            int length = end - start;
            int realLength = Math.min(length, b.bufLength - start);
            return Utils.bufferToString(ByteBuffer.wrap(b.buf, start + b.bufOffset, realLength), charset);
        }

        private void fromStringInternal(String s, Charset cs) {
            ByteBuffer writeBuf = Utils.stringToBuffer(s, cs);
            assert (!writeBuf.isDirect());
            this.buf = writeBuf.array();
            this.bufOffset = writeBuf.arrayOffset();
            this.bufLength = writeBuf.remaining();
        }

        private static int clamp(int i, int l) {
            if (i >= l) {
                return l;
            }
            if (i >= 0) {
                return i;
            }
            if ((i += l) >= 0) {
                return i;
            }
            return 0;
        }

        @JSFunction
        public static BufferImpl slice(Context cx, Scriptable thisObj, Object[] args, Function func) {
            BufferImpl b = (BufferImpl)thisObj;
            int start = BufferImpl.clamp(ArgUtils.intArg(args, 0, 0), b.bufLength);
            int end = BufferImpl.clamp(ArgUtils.intArg(args, 1, b.bufLength), b.bufLength);
            BufferImpl s = (BufferImpl)cx.newObject(thisObj, CLASS_NAME);
            s.buf = b.buf;
            if (start > end) {
                s.bufOffset = 0;
                s.bufLength = 0;
            } else {
                s.bufOffset = start + b.bufOffset;
                s.bufLength = end - start;
            }
            return s;
        }

        @JSGetter(value="length")
        public int getLength() {
            return this.bufLength;
        }

        private void setCharsWritten(int cw) {
            BufferImpl.getRunner(Context.getCurrentContext()).getBufferModule().setCharsWritten(cw);
        }

        @JSFunction
        public static Object copy(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int sourceEnd;
            BufferImpl b = (BufferImpl)thisObj;
            BufferImpl t = ArgUtils.objArg(args, 0, BufferImpl.class, true);
            int targetStart = ArgUtils.intArg(args, 1, 0);
            int sourceStart = ArgUtils.intArg(args, 2, 0);
            if (sourceStart == (sourceEnd = ArgUtils.intArg(args, 3, b.bufLength)) || t.bufLength == 0 || b.bufLength == 0 || sourceStart > b.bufLength) {
                return 0;
            }
            if (sourceEnd < sourceStart) {
                throw Utils.makeRangeError(cx, thisObj, "sourceEnd < sourceStart");
            }
            if (targetStart >= t.bufLength) {
                throw Utils.makeRangeError(cx, thisObj, "targetStart out of bounds");
            }
            if (t.bufLength - targetStart < sourceEnd - sourceStart) {
                sourceEnd = t.bufLength - targetStart + sourceStart;
            }
            int len = Math.min(Math.min(sourceEnd - sourceStart, t.bufLength - targetStart), b.bufLength - sourceStart);
            System.arraycopy(b.buf, sourceStart + b.bufOffset, t.buf, targetStart + t.bufOffset, len);
            return Context.toNumber((Object)len);
        }

        @JSFunction
        public static void fill(Context cx, Scriptable thisObj, Object[] args, Function func) {
            BufferImpl b = (BufferImpl)thisObj;
            ArgUtils.ensureArg(args, 0);
            int offset = ArgUtils.intArg(args, 1, 0);
            int end = ArgUtils.intArg(args, 2, b.bufLength);
            if (b.bufLength == 0) {
                return;
            }
            if (offset < 0 || offset >= b.bufLength) {
                throw Utils.makeRangeError(cx, thisObj, "offset out of bounds");
            }
            if (end < 0) {
                throw Utils.makeRangeError(cx, thisObj, "end out of bounds");
            }
            if (offset == end) {
                return;
            }
            int realEnd = Math.min(end, b.bufLength);
            if (args[0] instanceof Number) {
                Arrays.fill(b.buf, b.bufOffset + offset, b.bufOffset + realEnd, (byte)((Number)args[0]).intValue());
            } else if (args[0] instanceof Boolean) {
                Arrays.fill(b.buf, b.bufOffset + offset, b.bufOffset + realEnd, (Boolean)args[0] != false ? (byte)1 : 0);
            } else if (args[0] instanceof String) {
                Arrays.fill(b.buf, b.bufOffset + offset, b.bufOffset + realEnd, (byte)((String)args[0]).charAt(0));
            } else {
                throw Utils.makeTypeError(cx, thisObj, "Invalid value argument");
            }
        }

        @JSFunction
        public static Object readInt8(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)BufferImpl.readInt8(thisObj, args));
        }

        @JSFunction
        public static Object readUInt8(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)(BufferImpl.readInt8(thisObj, args) & 0xFF));
        }

        private static int readInt8(Scriptable thisObj, Object[] args) {
            boolean noAssert;
            BufferImpl b = (BufferImpl)thisObj;
            int offset = ArgUtils.intArg(args, 0);
            if (b.inBounds(offset, offset, noAssert = ArgUtils.booleanArg(args, 1, false))) {
                return b.buf[offset + b.bufOffset];
            }
            return 0;
        }

        @JSFunction
        public static Object readInt16LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)BufferImpl.readInt16(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN));
        }

        @JSFunction
        public static Object readInt16BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)BufferImpl.readInt16(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN));
        }

        @JSFunction
        public static Object readUInt16LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)(BufferImpl.readInt16(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN) & 0xFFFF));
        }

        @JSFunction
        public static Object readUInt16BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)(BufferImpl.readInt16(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN) & 0xFFFF));
        }

        private static short readInt16(Context cx, Scriptable thisObj, Object[] args, Function func, ByteOrder order) {
            boolean noAssert;
            BufferImpl b = (BufferImpl)thisObj;
            int offset = ArgUtils.intArg(args, 0);
            if (b.inBounds(offset, offset + 1, noAssert = ArgUtils.booleanArg(args, 1, false))) {
                if (order == ByteOrder.BIG_ENDIAN) {
                    return (short)((b.buf[b.bufOffset + offset] & 0xFF) << 8 | b.buf[b.bufOffset + offset + 1] & 0xFF);
                }
                return (short)(b.buf[b.bufOffset + offset] & 0xFF | (b.buf[b.bufOffset + offset + 1] & 0xFF) << 8);
            }
            return 0;
        }

        @JSFunction
        public static Object readInt32LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)BufferImpl.readInt32(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN));
        }

        @JSFunction
        public static Object readInt32BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)BufferImpl.readInt32(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN));
        }

        @JSFunction
        public static Object readUInt32LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)((long)BufferImpl.readInt32(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL));
        }

        @JSFunction
        public static Object readUInt32BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toNumber((Object)((long)BufferImpl.readInt32(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN) & 0xFFFFFFFFL));
        }

        private static int readInt32(Context cx, Scriptable thisObj, Object[] args, Function func, ByteOrder order) {
            boolean noAssert;
            BufferImpl b = (BufferImpl)thisObj;
            int offset = ArgUtils.intArg(args, 0);
            if (b.inBounds(offset, offset + 3, noAssert = ArgUtils.booleanArg(args, 1, false))) {
                if (order == ByteOrder.BIG_ENDIAN) {
                    return (b.buf[b.bufOffset + offset] & 0xFF) << 24 | (b.buf[b.bufOffset + offset + 1] & 0xFF) << 16 | (b.buf[b.bufOffset + offset + 2] & 0xFF) << 8 | b.buf[b.bufOffset + offset + 3] & 0xFF;
                }
                return b.buf[b.bufOffset + offset] & 0xFF | (b.buf[b.bufOffset + offset + 1] & 0xFF) << 8 | (b.buf[b.bufOffset + offset + 2] & 0xFF) << 16 | (b.buf[b.bufOffset + offset + 3] & 0xFF) << 24;
            }
            return 0;
        }

        private static long readInt64(Context cx, Scriptable thisObj, Object[] args, Function func, ByteOrder order) {
            boolean noAssert;
            BufferImpl b = (BufferImpl)thisObj;
            int offset = ArgUtils.intArg(args, 0);
            if (b.inBounds(offset, offset + 7, noAssert = ArgUtils.booleanArg(args, 1, false))) {
                if (order == ByteOrder.BIG_ENDIAN) {
                    return ((long)b.buf[b.bufOffset + offset] & 0xFFL) << 56 | ((long)b.buf[b.bufOffset + offset + 1] & 0xFFL) << 48 | ((long)b.buf[b.bufOffset + offset + 2] & 0xFFL) << 40 | ((long)b.buf[b.bufOffset + offset + 3] & 0xFFL) << 32 | ((long)b.buf[b.bufOffset + offset + 4] & 0xFFL) << 24 | ((long)b.buf[b.bufOffset + offset + 5] & 0xFFL) << 16 | ((long)b.buf[b.bufOffset + offset + 6] & 0xFFL) << 8 | (long)b.buf[b.bufOffset + offset + 7] & 0xFFL;
                }
                return (long)b.buf[b.bufOffset + offset] & 0xFFL | ((long)b.buf[b.bufOffset + offset + 1] & 0xFFL) << 8 | ((long)b.buf[b.bufOffset + offset + 2] & 0xFFL) << 16 | ((long)b.buf[b.bufOffset + offset + 3] & 0xFFL) << 24 | ((long)b.buf[b.bufOffset + offset + 4] & 0xFFL) << 32 | ((long)b.buf[b.bufOffset + offset + 5] & 0xFFL) << 40 | ((long)b.buf[b.bufOffset + offset + 6] & 0xFFL) << 48 | ((long)b.buf[b.bufOffset + offset + 7] & 0xFFL) << 56;
            }
            return 0L;
        }

        @JSFunction
        public static Object readFloatLE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int intVal = BufferImpl.readInt32(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN);
            return Context.toNumber((Object)Float.valueOf(Float.intBitsToFloat(intVal)));
        }

        @JSFunction
        public static Object readFloatBE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int intVal = BufferImpl.readInt32(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN);
            return Context.toNumber((Object)Float.valueOf(Float.intBitsToFloat(intVal)));
        }

        @JSFunction
        public static Object readDoubleLE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long lVal = BufferImpl.readInt64(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN);
            return Context.toNumber((Object)Double.longBitsToDouble(lVal));
        }

        @JSFunction
        public static Object readDoubleBE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long lVal = BufferImpl.readInt64(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN);
            return Context.toNumber((Object)Double.longBitsToDouble(lVal));
        }

        @JSFunction
        public static void writeInt8(Context cx, Scriptable thisObj, Object[] args, Function func) {
            BufferImpl b = (BufferImpl)thisObj;
            int value = ArgUtils.intArg(args, 0);
            if (value > 127 || value < -128) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            b.writeInt8Internal(args, value);
        }

        @JSFunction
        public static void writeUInt8(Context cx, Scriptable thisObj, Object[] args, Function func) {
            BufferImpl b = (BufferImpl)thisObj;
            int value = ArgUtils.intArg(args, 0);
            if (value > 255 || value < 0) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            b.writeInt8Internal(args, value &= 0xFF);
        }

        private void writeInt8Internal(Object[] args, int value) {
            boolean noAssert;
            int offset = ArgUtils.intArg(args, 1);
            if (this.inBounds(offset, offset, noAssert = ArgUtils.booleanArg(args, 2, false))) {
                this.buf[this.bufOffset + offset] = (byte)value;
            }
        }

        @JSFunction
        public static void writeInt16LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int value = ArgUtils.intArg(args, 0);
            if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt16(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN, value);
        }

        @JSFunction
        public static void writeInt16BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int value = ArgUtils.intArg(args, 0);
            if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt16(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN, value);
        }

        @JSFunction
        public static void writeUInt16LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int value = ArgUtils.intArg(args, 0);
            if (value > 65535 || value < 0) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt16(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN, value & 0xFFFF);
        }

        @JSFunction
        public static void writeUInt16BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int value = ArgUtils.intArg(args, 0);
            if (value > 65535 || value < 0) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt16(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN, value & 0xFFFF);
        }

        private static void writeInt16(Context cx, Scriptable thisObj, Object[] args, Function func, ByteOrder order, int value) {
            boolean noAssert;
            BufferImpl b = (BufferImpl)thisObj;
            int offset = ArgUtils.intArg(args, 1);
            if (b.inBounds(offset, offset + 1, noAssert = ArgUtils.booleanArg(args, 2, false))) {
                if (order == ByteOrder.BIG_ENDIAN) {
                    b.buf[b.bufOffset + offset] = (byte)(value >>> 8 & 0xFF);
                    b.buf[b.bufOffset + offset + 1] = (byte)(value & 0xFF);
                } else {
                    b.buf[b.bufOffset + offset] = (byte)(value & 0xFF);
                    b.buf[b.bufOffset + offset + 1] = (byte)(value >>> 8 & 0xFF);
                }
            }
        }

        @JSFunction
        public static void writeInt32LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long value = ArgUtils.longArg(args, 0);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt32(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN, value);
        }

        @JSFunction
        public static void writeInt32BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long value = ArgUtils.longArg(args, 0);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt32(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN, value);
        }

        @JSFunction
        public static void writeUInt32LE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long value = ArgUtils.longArg(args, 0);
            if (value > 0xFFFFFFFFL || value < 0L) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt32(cx, thisObj, args, func, ByteOrder.LITTLE_ENDIAN, value & 0xFFFFFFFFL);
        }

        @JSFunction
        public static void writeUInt32BE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long value = ArgUtils.longArg(args, 0);
            if (value > 0xFFFFFFFFL || value < 0L) {
                throw Utils.makeRangeError(cx, thisObj, "out of range");
            }
            BufferImpl.writeInt32(cx, thisObj, args, func, ByteOrder.BIG_ENDIAN, value & 0xFFFFFFFFL);
        }

        private static void writeInt32(Context cx, Scriptable thisObj, Object[] args, Function func, ByteOrder order, long value) {
            int offset = ArgUtils.intArg(args, 1);
            boolean noAssert = ArgUtils.booleanArg(args, 2, false);
            BufferImpl b = (BufferImpl)thisObj;
            b.writeInt32(offset, value, noAssert, order);
        }

        private void writeInt32(int offset, long value, boolean noAssert, ByteOrder order) {
            if (this.inBounds(offset, offset + 3, noAssert)) {
                if (order == ByteOrder.BIG_ENDIAN) {
                    this.buf[this.bufOffset + offset] = (byte)(value >>> 24 & 0xFFL);
                    this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 16 & 0xFFL);
                    this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 8 & 0xFFL);
                    this.buf[this.bufOffset + offset + 3] = (byte)(value & 0xFFL);
                } else {
                    this.buf[this.bufOffset + offset] = (byte)(value & 0xFFL);
                    this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 8 & 0xFFL);
                    this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 16 & 0xFFL);
                    this.buf[this.bufOffset + offset + 3] = (byte)(value >>> 24 & 0xFFL);
                }
            }
        }

        private void writeInt64(int offset, long value, boolean noAssert, ByteOrder order) {
            if (this.inBounds(offset, offset + 7, noAssert)) {
                if (order == ByteOrder.BIG_ENDIAN) {
                    this.buf[this.bufOffset + offset] = (byte)(value >>> 56 & 0xFFL);
                    this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 48 & 0xFFL);
                    this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 40 & 0xFFL);
                    this.buf[this.bufOffset + offset + 3] = (byte)(value >>> 32 & 0xFFL);
                    this.buf[this.bufOffset + offset + 4] = (byte)(value >>> 24 & 0xFFL);
                    this.buf[this.bufOffset + offset + 5] = (byte)(value >>> 16 & 0xFFL);
                    this.buf[this.bufOffset + offset + 6] = (byte)(value >>> 8 & 0xFFL);
                    this.buf[this.bufOffset + offset + 7] = (byte)(value & 0xFFL);
                } else {
                    this.buf[this.bufOffset + offset] = (byte)(value & 0xFFL);
                    this.buf[this.bufOffset + offset + 1] = (byte)(value >>> 8 & 0xFFL);
                    this.buf[this.bufOffset + offset + 2] = (byte)(value >>> 16 & 0xFFL);
                    this.buf[this.bufOffset + offset + 3] = (byte)(value >>> 24 & 0xFFL);
                    this.buf[this.bufOffset + offset + 4] = (byte)(value >>> 32 & 0xFFL);
                    this.buf[this.bufOffset + offset + 5] = (byte)(value >>> 40 & 0xFFL);
                    this.buf[this.bufOffset + offset + 6] = (byte)(value >>> 48 & 0xFFL);
                    this.buf[this.bufOffset + offset + 7] = (byte)(value >>> 56 & 0xFFL);
                }
            }
        }

        @JSFunction
        public static void writeFloatLE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            float value = (float)Context.toNumber((Object)args[0]);
            int offset = ArgUtils.intArg(args, 1);
            boolean noAssert = ArgUtils.booleanArg(args, 2, false);
            BufferImpl b = (BufferImpl)thisObj;
            int iVal = Float.floatToIntBits(value);
            b.writeInt32(offset, iVal, noAssert, ByteOrder.LITTLE_ENDIAN);
        }

        @JSFunction
        public static void writeFloatBE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            float value = (float)Context.toNumber((Object)args[0]);
            int offset = ArgUtils.intArg(args, 1);
            boolean noAssert = ArgUtils.booleanArg(args, 2, false);
            BufferImpl b = (BufferImpl)thisObj;
            int iVal = Float.floatToIntBits(value);
            b.writeInt32(offset, iVal, noAssert, ByteOrder.BIG_ENDIAN);
        }

        @JSFunction
        public static void writeDoubleLE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            double value = Context.toNumber((Object)args[0]);
            int offset = ArgUtils.intArg(args, 1);
            boolean noAssert = ArgUtils.booleanArg(args, 2, false);
            BufferImpl b = (BufferImpl)thisObj;
            long lVal = Double.doubleToLongBits(value);
            b.writeInt64(offset, lVal, noAssert, ByteOrder.LITTLE_ENDIAN);
        }

        @JSFunction
        public static void writeDoubleBE(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ArgUtils.ensureArg(args, 0);
            double value = Context.toNumber((Object)args[0]);
            int offset = ArgUtils.intArg(args, 1);
            boolean noAssert = ArgUtils.booleanArg(args, 2, false);
            BufferImpl b = (BufferImpl)thisObj;
            long lVal = Double.doubleToLongBits(value);
            b.writeInt64(offset, lVal, noAssert, ByteOrder.BIG_ENDIAN);
        }

        private boolean inBounds(int offset, int position, boolean noAssert) {
            if (offset < 0 && !noAssert) {
                throw Utils.makeRangeError(Context.getCurrentContext(), (Scriptable)this, "offset is not uint");
            }
            if (position >= this.bufLength) {
                if (!noAssert) {
                    throw Utils.makeRangeError(Context.getCurrentContext(), (Scriptable)this, "Trying to access beyond buffer length");
                }
                return false;
            }
            return true;
        }

        @JSStaticFunction
        public static Object isEncoding(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String enc = ArgUtils.stringArg(args, 0);
            return Context.toBoolean((Object)(Charsets.get().getCharset(enc) != null ? 1 : 0));
        }

        @JSStaticFunction
        public static Object isBuffer(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return Context.toBoolean((Object)(args.length > 0 && args[0] instanceof BufferImpl ? 1 : 0));
        }

        @JSStaticFunction
        public static Object byteLength(Context cx, Scriptable thisObj, Object[] args, Function func) {
            CoderResult result;
            String data = ArgUtils.stringArg(args, 0);
            Charset charset = BufferImpl.resolveEncoding(args, 1);
            CharsetEncoder encoder = Charsets.get().getEncoder(charset);
            CharBuffer chars = CharBuffer.wrap(data);
            ByteBuffer tmp = ByteBuffer.allocate(256);
            int total = 0;
            do {
                tmp.clear();
                result = encoder.encode(chars, tmp, true);
                total += tmp.position();
            } while (result.isOverflow());
            do {
                tmp.clear();
                result = encoder.flush(tmp);
                total += tmp.position();
            } while (result.isOverflow());
            return Context.toNumber((Object)total);
        }

        @JSStaticFunction
        public static Object concat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            NativeArray bufs = ArgUtils.objArg(args, 0, NativeArray.class, true);
            int totalLen = ArgUtils.intArg(args, 1, -1);
            if (bufs.getLength() == 0L) {
                return cx.newObject(thisObj, CLASS_NAME, new Object[]{0});
            }
            if (bufs.getLength() == 1L) {
                return bufs.get(0);
            }
            if (totalLen < 0) {
                totalLen = 0;
                for (Integer i : bufs.getIndexIds()) {
                    BufferImpl buf = (BufferImpl)((Object)bufs.get((Object)i));
                    totalLen += buf.bufLength;
                }
            }
            int pos = 0;
            BufferImpl ret = (BufferImpl)cx.newObject(thisObj, CLASS_NAME, new Object[]{totalLen});
            for (Integer i : bufs.getIndexIds()) {
                BufferImpl from = (BufferImpl)((Object)bufs.get((Object)i));
                System.arraycopy(from.buf, from.bufOffset, ret.buf, pos, from.bufLength);
                pos += from.bufLength;
            }
            return ret;
        }

        @JSStaticFunction
        public static void makeFastBuffer(Context cx, Scriptable thisObj, Object[] args, Function func) {
        }

        @JSFunction
        public String inspect() {
            StringBuilder s = new StringBuilder();
            s.append("<Buffer ");
            boolean once = false;
            for (int i = 0; i < this.bufLength; ++i) {
                if (once) {
                    s.append(' ');
                } else {
                    once = true;
                }
                int v = this.get(i);
                if (v < 16) {
                    s.append('0');
                }
                s.append(Integer.toHexString(v));
            }
            s.append('>');
            return s.toString();
        }

        @JSFunction
        public Object toJSON() {
            Object[] elts = new Object[this.bufLength];
            for (int i = 0; i < this.bufLength; ++i) {
                elts[i] = this.get(i);
            }
            return Context.getCurrentContext().newArray((Scriptable)this, elts);
        }

        public String toString() {
            return "Buffer[length=" + this.buf.length + ", offset=" + this.bufOffset + ", bufLength=" + this.bufLength + ']';
        }

        private static Charset resolveEncoding(Object[] args, int pos) {
            Charset charset;
            String encArg = null;
            if (pos < args.length && args[pos] instanceof String) {
                encArg = Context.toString((Object)args[pos]);
            }
            if ((charset = Charsets.get().resolveCharset(encArg)) == null) {
                throw new EvaluatorException("Unknown encoding: " + encArg);
            }
            return charset;
        }

        private static ScriptRunner getRunner(Context cx) {
            return (ScriptRunner)cx.getThreadLocal((Object)"runner");
        }
    }

    public static class BufferModuleImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_bufferModule";
        private int inspectMaxBytes = 50;
        private int charsWritten;

        public String getClassName() {
            return CLASS_NAME;
        }

        public int getCharsWritten(Scriptable obj) {
            return this.charsWritten;
        }

        void setCharsWritten(int cw) {
            this.charsWritten = cw;
        }

        @JSGetter(value="INSPECT_MAX_BYTES")
        public int getInspectMaxBytes() {
            return this.inspectMaxBytes;
        }

        @JSSetter(value="INSPECT_MAX_BYTES")
        public void setInspectMaxBytes(int i) {
            this.inspectMaxBytes = i;
        }
    }
}

