/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.reporter;

import org.specs2.control.ActionT;
import org.specs2.control.package;
import org.specs2.data.Fold$;
import org.specs2.execute.Error;
import org.specs2.execute.Failure;
import org.specs2.execute.Pending;
import org.specs2.execute.Result;
import org.specs2.execute.Skipped;
import org.specs2.execute.Success;
import org.specs2.foldm.FoldM;
import org.specs2.foldm.stream.FoldProcessM$;
import org.specs2.io.FilePath$;
import org.specs2.reporter.MarkdownOptions;
import org.specs2.reporter.MarkdownOptions$;
import org.specs2.reporter.MarkdownPrinter;
import org.specs2.specification.core.Description;
import org.specs2.specification.core.Env;
import org.specs2.specification.core.Fragment;
import org.specs2.specification.core.Fragment$;
import org.specs2.specification.core.SpecStructure;
import org.specs2.specification.core.SpecificationRef;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.xml.Text;
import scalaz.Cord;
import scalaz.Show;
import scalaz.stream.Process;
import scalaz.syntax.ShowSyntax;

public abstract class MarkdownPrinter$class {
    public static ActionT prepare(MarkdownPrinter $this, Env env, List specifications2) {
        return env.fileSystem().mkdirs(MarkdownOptions$.MODULE$.create(env.arguments()).outDir());
    }

    public static ActionT finalize(MarkdownPrinter $this, Env env, List specifications2) {
        return package.Actions$.MODULE$.unit();
    }

    public static FoldM sink(MarkdownPrinter $this, Env env, SpecStructure spec) {
        MarkdownOptions options = MarkdownOptions$.MODULE$.create(env.arguments());
        Show<Fragment> show2 = $this.MarkdownFragmentShow(options);
        Process sink2 = Fold$.MODULE$.showToFilePath(options.outDir().$div(FilePath$.MODULE$.unsafe(new StringBuilder().append((Object)spec.header().className()).append((Object)".").append((Object)options.extension()).toString())), show2);
        return FoldProcessM$.MODULE$.fromSink(sink2);
    }

    public static Function1 fragmentToLine(MarkdownPrinter $this, MarkdownOptions options) {
        return new Serializable($this, options){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MarkdownPrinter $outer;
            private final MarkdownOptions options$1;

            public final String apply(Fragment fragment) {
                Description ref;
                String string;
                Fragment fragment2 = fragment;
                if (Fragment$.MODULE$.isText(fragment2)) {
                    string = fragment2.description().show();
                } else if (Fragment$.MODULE$.isExample(fragment2)) {
                    String string2;
                    Result result2 = fragment2.executionResult();
                    if (result2 instanceof Success) {
                        string2 = this.$outer.showDescription(fragment2);
                    } else if (result2 instanceof Failure) {
                        Failure failure = (Failure)result2;
                        String m = failure.m();
                        string2 = new StringBuilder().append((Object)this.$outer.showDescription(fragment2)).append((Object)"\n  ").append((Object)m).toString();
                    } else if (result2 instanceof Error) {
                        Error error = (Error)result2;
                        Throwable e1 = error.t();
                        string2 = new StringBuilder().append((Object)this.$outer.showDescription(fragment2)).append((Object)"\n  ").append((Object)e1).toString();
                    } else if (result2 instanceof Skipped) {
                        Skipped skipped = (Skipped)result2;
                        string2 = new StringBuilder().append((Object)this.$outer.showDescription(fragment2)).append((Object)"\n  ").append((Object)skipped.message()).toString();
                    } else if (result2 instanceof Pending) {
                        Pending pending = (Pending)result2;
                        string2 = new StringBuilder().append((Object)this.$outer.showDescription(fragment2)).append((Object)" - ").append((Object)pending.message()).toString();
                    } else {
                        string2 = new StringBuilder().append((Object)fragment2.description().show()).append((Object)"\n").append((Object)result2.message()).toString();
                    }
                    string = string2;
                } else if (Fragment$.MODULE$.isStepOrAction(fragment2)) {
                    String string3;
                    Result result3 = fragment2.executionResult();
                    if (result3 instanceof Failure) {
                        Failure failure = (Failure)result3;
                        String m = failure.m();
                        string3 = new StringBuilder().append((Object)"Step failed ").append((Object)m).toString();
                    } else if (result3 instanceof Error) {
                        Error error = (Error)result3;
                        String m = error.m();
                        string3 = new StringBuilder().append((Object)"Step error ").append((Object)m).toString();
                    } else {
                        string3 = "";
                    }
                    string = string3;
                } else if (fragment2 != null && (ref = fragment2.description()) instanceof SpecificationRef) {
                    SpecificationRef specificationRef2 = (SpecificationRef)ref;
                    string = this.$outer.toMarkdown(specificationRef2, this.options$1);
                } else {
                    string = "";
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.options$1 = options$1;
            }
        };
    }

    public static String showDescription(MarkdownPrinter $this, Fragment example2) {
        String description = example2.description().show();
        String string = description.trim();
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*", "-"}))).exists((Function1)new Serializable($this, string){
            public static final long serialVersionUID = 0L;
            private final String eta$0$1$1;

            public final boolean apply(String x$1) {
                return this.eta$0$1$1.startsWith(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }) ? description : new StringBuilder().append((Object)example2.executionResult().status()).append((Object)" ").append((Object)description).toString();
    }

    public static String toMarkdown(MarkdownPrinter $this, SpecificationRef ref, MarkdownOptions options) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "](", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ref.linkText(), options.outDir().$div(FilePath$.MODULE$.unsafe(ref.url()))}));
    }

    public static Show MarkdownFragmentShow(MarkdownPrinter $this, MarkdownOptions options) {
        return new Show<Fragment>($this, options){
            private final /* synthetic */ MarkdownPrinter $outer;
            private final MarkdownOptions options$2;
            private final Object showSyntax;
            private volatile boolean bitmap$init$0;

            public Object showSyntax() {
                if (this.bitmap$init$0) {
                    return this.showSyntax;
                }
                throw new UninitializedFieldError("Uninitialized field: MarkdownPrinter.scala: 68".toString());
            }

            public void scalaz$Show$_setter_$showSyntax_$eq(ShowSyntax x$1) {
                this.showSyntax = x$1;
                this.bitmap$init$0 = true;
            }

            public Cord show(Object f) {
                return Show.class.show((Show)this, (Object)f);
            }

            public Text xmlText(Object f) {
                return Show.class.xmlText((Show)this, (Object)f);
            }

            public String shows(Fragment f) {
                return (String)this.$outer.fragmentToLine(this.options$2).apply((Object)f);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.options$2 = options$2;
                Show.class.$init$((Show)this);
            }
        };
    }

    public static void $init$(MarkdownPrinter $this) {
    }
}

