/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.AppCacheStatus;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.BrowserConnection;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteLocalStorage;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.html5.RemoteSessionStorage;

public class AndroidDriver
extends RemoteWebDriver
implements TakesScreenshot,
Rotatable,
BrowserConnection,
HasTouchScreen,
WebStorage,
LocationContext,
ApplicationCache {
    private TouchScreen touch;
    private RemoteLocalStorage localStorage;
    private RemoteSessionStorage sessionStorage;
    private RemoteLocationContext locationContext;

    public AndroidDriver() {
        this(AndroidDriver.getDefaultUrl());
    }

    public AndroidDriver(Capabilities ignored) {
        this();
    }

    public AndroidDriver(String remoteAddress) throws MalformedURLException {
        this(new URL(remoteAddress));
    }

    public AndroidDriver(DesiredCapabilities caps) {
        this(AndroidDriver.getDefaultUrl(), caps);
    }

    public AndroidDriver(URL remoteAddress) {
        super(remoteAddress, (Capabilities)AndroidDriver.getAndroidCapabilities(null));
        this.init();
    }

    public AndroidDriver(URL url, DesiredCapabilities caps) {
        super(url, (Capabilities)AndroidDriver.getAndroidCapabilities(caps));
        this.init();
    }

    private void init() {
        this.touch = new RemoteTouchScreen(this.getExecuteMethod());
        this.localStorage = new RemoteLocalStorage(this.getExecuteMethod());
        this.sessionStorage = new RemoteSessionStorage(this.getExecuteMethod());
        this.locationContext = new RemoteLocationContext(this.getExecuteMethod());
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64Png = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64Png);
    }

    public boolean isOnline() {
        return (Boolean)this.execute("isBrowserOnline").getValue();
    }

    public void setOnline(boolean online) throws WebDriverException {
        this.execute("setBrowserOnline", (Map)ImmutableMap.of((Object)"state", (Object)online));
    }

    private static DesiredCapabilities getAndroidCapabilities(DesiredCapabilities userPrefs) {
        DesiredCapabilities caps = DesiredCapabilities.android();
        caps.setCapability("takesScreenshot", true);
        caps.setCapability("rotatable", true);
        caps.setCapability("browserConnectionEnabled", true);
        if (userPrefs != null) {
            caps.merge((Capabilities)userPrefs);
        }
        return caps;
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map)ImmutableMap.of((Object)"orientation", (Object)orientation));
    }

    public ScreenOrientation getOrientation() {
        return ScreenOrientation.valueOf((String)((String)this.execute("getScreenOrientation").getValue()));
    }

    private static URL getDefaultUrl() {
        try {
            return new URL("http://localhost:8080/wd/hub");
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Malformed default remote URL: " + e.getMessage());
        }
    }

    public TouchScreen getTouch() {
        return this.touch;
    }

    public LocalStorage getLocalStorage() {
        return this.localStorage;
    }

    public SessionStorage getSessionStorage() {
        return this.sessionStorage;
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location loc) {
        this.locationContext.setLocation(loc);
    }

    public AppCacheStatus getStatus() {
        String status = (String)this.execute("getStatus").getValue();
        return AppCacheStatus.getEnum((String)status);
    }
}

