/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.serialization;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.persistence.serialization.Snapshot;
import akka.persistence.serialization.SnapshotHeader;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001%\u0011!c\u00158baNDw\u000e^*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Mi\u0011A\u0005\u0006\u0003\u0007\u0019I!\u0001\u0006\n\u0003\u0015M+'/[1mSj,'\u000f\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u0003\u0019\u0019\u0018p\u001d;f[B\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\u0006C\u000e$xN]\u0005\u00039e\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDC\u0001\u0011#!\t\t\u0003!D\u0001\u0003\u0011\u00151R\u00041\u0001\u0018\u0011\u0015!\u0003\u0001\"\u0001&\u0003)IG-\u001a8uS\u001aLWM]\u000b\u0002MA\u00111bJ\u0005\u0003Q1\u00111!\u00138u\u0011\u0015Q\u0003\u0001\"\u0001,\u0003=Ign\u00197vI\u0016l\u0015M\\5gKN$X#\u0001\u0017\u0011\u0005-i\u0013B\u0001\u0018\r\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\r\u0001\t\u0006\u0004%I!M\u0001\u0015iJ\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8\u0016\u0003I\u00022aC\u001a6\u0013\t!DB\u0001\u0004PaRLwN\u001c\t\u0003mer!!E\u001c\n\u0005a\u0012\u0012!D*fe&\fG.\u001b>bi&|g.\u0003\u0002;w\tY\u0011J\u001c4pe6\fG/[8o\u0015\tA$\u0003\u0003\u0005>\u0001!\u0005\t\u0015)\u00033\u0003U!(/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]\u0002BQa\u0010\u0001\u0005\u0002\u0001\u000b\u0001\u0002^8CS:\f'/\u001f\u000b\u0003\u0003\u001e\u00032a\u0003\"E\u0013\t\u0019EBA\u0003BeJ\f\u0017\u0010\u0005\u0002\f\u000b&\u0011a\t\u0004\u0002\u0005\u0005f$X\rC\u0003I}\u0001\u0007!\"A\u0001p\u0011\u0015Q\u0005\u0001\"\u0001L\u0003)1'o\\7CS:\f'/\u001f\u000b\u0004\u00151s\u0005\"B'J\u0001\u0004\t\u0015!\u00022zi\u0016\u001c\b\"B(J\u0001\u0004\u0001\u0016\u0001C7b]&4Wm\u001d;\u0011\u0007-\u0019\u0014\u000b\r\u0002S7B\u00191KV-\u000f\u0005-!\u0016BA+\r\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0006\u00072\f7o\u001d\u0006\u0003+2\u0001\"AW.\r\u0001\u0011IALTA\u0001\u0002\u0003\u0015\t!\u0018\u0002\u0004?\u0012\n\u0014C\u00010b!\tYq,\u0003\u0002a\u0019\t9aj\u001c;iS:<\u0007CA\u0006c\u0013\t\u0019GBA\u0002B]fDQ!\u001a\u0001\u0005\n\u0019\f\u0001c\u001d8baNDw\u000e\u001e+p\u0005&t\u0017M]=\u0015\u0005\u0005;\u0007\"\u00025e\u0001\u0004Q\u0011\u0001C:oCB\u001c\bn\u001c;\t\u000b)\u0004A\u0011B6\u0002%Mt\u0017\r]:i_R4%o\\7CS:\f'/\u001f\u000b\u0003\u00151DQ!T5A\u0002\u0005CQA\u001c\u0001\u0005\n=\f\u0001b\u001e:ji\u0016Le\u000e\u001e\u000b\u0004aNl\bCA\u0006r\u0013\t\u0011HB\u0001\u0003V]&$\b\"\u0002;n\u0001\u0004)\u0018\u0001D8viB,Ho\u0015;sK\u0006l\u0007C\u0001<|\u001b\u00059(B\u0001=z\u0003\tIwNC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(\u0001D(viB,Ho\u0015;sK\u0006l\u0007\"\u0002@n\u0001\u00041\u0013!A5\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u00059!/Z1e\u0013:$Hc\u0001\u0014\u0002\u0006!9\u0011qA@A\u0002\u0005%\u0011aC5oaV$8\u000b\u001e:fC6\u00042A^A\u0006\u0013\r\tia\u001e\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e")
public class SnapshotSerializer
implements Serializer {
    public final ExtendedActorSystem akka$persistence$serialization$SnapshotSerializer$$system;
    private Option<Serialization.Information> transportInformation;
    private volatile boolean bitmap$0;

    private Option transportInformation$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if (!this.bitmap$0) {
                Address address = this.akka$persistence$serialization$SnapshotSerializer$$system.provider().getDefaultAddress();
                this.transportInformation = address.hasLocalScope() ? None$.MODULE$ : new Some((Object)new Serialization.Information(address, (ActorSystem)this.akka$persistence$serialization$SnapshotSerializer$$system));
                this.bitmap$0 = true;
            }
            return this.transportInformation;
        }
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.class.fromBinary((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) {
        return Serializer.class.fromBinary((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return 8;
    }

    public boolean includeManifest() {
        return false;
    }

    private Option<Serialization.Information> transportInformation() {
        return this.bitmap$0 ? this.transportInformation : this.transportInformation$lzycompute();
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof Snapshot) {
            Snapshot snapshot = (Snapshot)object;
            Object data = snapshot.data();
            byte[] byArray = this.snapshotToBinary(data);
            return byArray;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't serialize object of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.getClass()})));
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] snapshotToBinary(Object snapshot) {
        Option<Serialization.Information> option;
        block4: {
            byte[] byArray;
            block3: {
                block2: {
                    option = this.transportInformation();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Serialization.Information ti = (Serialization.Information)some.x();
                    byArray = (byte[])Serialization$.MODULE$.currentTransportInformation().withValue((Object)ti, (Function0)new Serializable(this, snapshot){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SnapshotSerializer $outer;
                        private final Object snapshot$1;

                        public final byte[] apply() {
                            return this.$outer.akka$persistence$serialization$SnapshotSerializer$$serialize$1(this.snapshot$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.snapshot$1 = snapshot$1;
                        }
                    });
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Serialization.Information> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                byArray = this.akka$persistence$serialization$SnapshotSerializer$$serialize$1(snapshot);
            }
            return byArray;
        }
        throw new MatchError(option);
    }

    private Object snapshotFromBinary(byte[] bytes) {
        Try try_;
        block7: {
            SnapshotHeader snapshotHeader;
            byte[] snapshotBytes;
            Serialization extension;
            block6: {
                None$ none$;
                byte[] headerBytes;
                block5: {
                    SnapshotHeader header;
                    extension = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.akka$persistence$serialization$SnapshotSerializer$$system);
                    int headerLength = this.readInt(new ByteArrayInputStream(bytes));
                    headerBytes = (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(4, headerLength + 4);
                    snapshotBytes = (byte[])Predef$.MODULE$.byteArrayOps(bytes).drop(headerLength + 4);
                    try_ = extension.deserialize(headerBytes, SnapshotHeader.class);
                    if (!(try_ instanceof Success)) break block5;
                    Success success = (Success)try_;
                    snapshotHeader = header = (SnapshotHeader)success.value();
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block7;
                ByteArrayInputStream headerIn = new ByteArrayInputStream(headerBytes);
                int serializerId = this.readInt(headerIn);
                int remaining = headerIn.available();
                if (remaining == 0) {
                    none$ = None$.MODULE$;
                } else {
                    byte[] manifestBytes = (byte[])Array$.MODULE$.ofDim(remaining, ClassTag$.MODULE$.Byte());
                    headerIn.read(manifestBytes);
                    none$ = new Some((Object)new String(manifestBytes, "utf-8"));
                }
                None$ manifest = none$;
                snapshotHeader = new SnapshotHeader(serializerId, (Option<String>)manifest);
            }
            SnapshotHeader header = snapshotHeader;
            Option manifest = header.manifest().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SnapshotSerializer $outer;

                public final Class<?> apply(String x$1) {
                    return (Class)this.$outer.akka$persistence$serialization$SnapshotSerializer$$system.dynamicAccess().getClassFor(x$1, ClassTag$.MODULE$.AnyRef()).get();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return extension.deserialize(snapshotBytes, header.serializerId(), manifest).get();
        }
        throw new MatchError((Object)try_);
    }

    private void writeInt(OutputStream outputStream, int i) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 24).by(8).foreach$mVc$sp((Function1)new Serializable(this, outputStream, i){
            public static final long serialVersionUID = 0L;
            private final OutputStream outputStream$1;
            private final int i$1;

            public final void apply(int shift) {
                this.apply$mcVI$sp(shift);
            }

            public void apply$mcVI$sp(int shift) {
                this.outputStream$1.write(this.i$1 >> shift);
            }
            {
                this.outputStream$1 = outputStream$1;
                this.i$1 = i$1;
            }
        });
    }

    private int readInt(InputStream inputStream) {
        return BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 24).by(8).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this, inputStream){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;

            public final int apply(int id, int shift) {
                return this.apply$mcIII$sp(id, shift);
            }

            public int apply$mcIII$sp(int id, int shift) {
                return id | this.inputStream$1.read() << shift;
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        }));
    }

    public final byte[] akka$persistence$serialization$SnapshotSerializer$$serialize$1(Object snapshot$1) {
        Serialization extension = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.akka$persistence$serialization$SnapshotSerializer$$system);
        Serializer snapshotSerializer = extension.findSerializerFor(snapshot$1);
        ByteArrayOutputStream headerOut = new ByteArrayOutputStream();
        this.writeInt(headerOut, snapshotSerializer.identifier());
        if (snapshotSerializer.includeManifest()) {
            headerOut.write(snapshot$1.getClass().getName().getBytes("utf-8"));
        }
        byte[] headerBytes = headerOut.toByteArray();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.akka$persistence$serialization$SnapshotSerializer$$system = system;
        Serializer.class.$init$((Serializer)this);
    }
}

