/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import akka.Done;
import akka.actor.ActorSystem;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.netty.HandlerPublisher;
import com.typesafe.netty.http.HttpStreamsServerHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLEngine;
import org.reactivestreams.Publisher;
import play.api.Application;
import play.api.Mode$;
import play.api.Play$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.core.ApplicationProvider;
import play.core.NamedThreadFactory;
import play.core.server.Jdk$;
import play.core.server.Native$;
import play.core.server.NettyServer$;
import play.core.server.NettyServerProvider;
import play.core.server.NettyTransport;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerListenException;
import play.core.server.ServerStartException;
import play.core.server.ServerStartException$;
import play.core.server.netty.PlayRequestHandler;
import play.core.server.ssl.ServerSSLEngine$;
import play.server.SSLEngineProvider;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u0001\u0003\u0001%\u00111BT3uif\u001cVM\u001d<fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011\u0001B2pe\u0016T\u0011aB\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001Q!\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u0004TKJ4XM\u001d\u0005\t/\u0001\u0011\t\u0011)A\u00051\u000511m\u001c8gS\u001e\u0004\"aE\r\n\u0005i\u0011!\u0001D*feZ,'oQ8oM&<\u0007\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002'\u0005\u0004\b\u000f\\5dCRLwN\u001c)s_ZLG-\u001a:\u0016\u0003y\u0001\"a\b\u0011\u000e\u0003\u0011I!!\t\u0003\u0003'\u0005\u0003\b\u000f\\5dCRLwN\u001c)s_ZLG-\u001a:\t\u0011\r\u0002!\u0011!Q\u0001\ny\tA#\u00199qY&\u001c\u0017\r^5p]B\u0013xN^5eKJ\u0004\u0003\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0011M$x\u000e\u001d%p_.\u00042a\n\u0016-\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#!\u0003$v]\u000e$\u0018n\u001c81a\tiS\u0007E\u0002/cMj\u0011a\f\u0006\u0003a!\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0011tF\u0001\u0004GkR,(/\u001a\t\u0003iUb\u0001\u0001B\u00057I\u0005\u0005\t\u0011!B\u0001o\t\u0019q\fJ\u0019\u0012\u0005aZ\u0004CA\u0014:\u0013\tQ\u0004FA\u0004O_RD\u0017N\\4\u0011\u0005\u001db\u0014BA\u001f)\u0005\r\te.\u001f\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\u0006Y\u0011m\u0019;peNK8\u000f^3n+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0015\t7\r^8s\u0015\u00051\u0015\u0001B1lW\u0006L!\u0001S\"\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0003\u0006a\u0011m\u0019;peNK8\u000f^3nA!AA\n\u0001BC\u0002\u0013\rQ*\u0001\u0007nCR,'/[1mSj,'/F\u0001O!\ty%+D\u0001Q\u0015\t\tV)\u0001\u0004tiJ,\u0017-\\\u0005\u0003'B\u0013A\"T1uKJL\u0017\r\\5{KJD\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IAT\u0001\u000e[\u0006$XM]5bY&TXM\u001d\u0011\t\u000b]\u0003A\u0011\u0001-\u0002\rqJg.\u001b;?)\u0015IF,\u00180e)\tQ6\f\u0005\u0002\u0014\u0001!)AJ\u0016a\u0002\u001d\")qC\u0016a\u00011!)AD\u0016a\u0001=!)QE\u0016a\u0001?B\u0019qE\u000b11\u0005\u0005\u001c\u0007c\u0001\u00182EB\u0011Ag\u0019\u0003\nmy\u000b\t\u0011!A\u0003\u0002]BQa\u0010,A\u0002\u0005CqA\u001a\u0001C\u0002\u0013%q-A\u0006oKR$\u0018pQ8oM&<W#\u00015\u0011\u0005%|W\"\u00016\u000b\u0005]Y'B\u00017n\u0003!!\u0018\u0010]3tC\u001a,'\"\u00018\u0002\u0007\r|W.\u0003\u0002qU\n11i\u001c8gS\u001eDaA\u001d\u0001!\u0002\u0013A\u0017\u0001\u00048fiRL8i\u001c8gS\u001e\u0004\u0003b\u0002;\u0001\u0005\u0004%I!^\u0001\u0015[\u0006D\u0018J\\5uS\u0006dG*\u001b8f\u0019\u0016tw\r\u001e5\u0016\u0003Y\u0004\"aJ<\n\u0005aD#aA%oi\"1!\u0010\u0001Q\u0001\nY\fQ#\\1y\u0013:LG/[1m\u0019&tW\rT3oORD\u0007\u0005C\u0004}\u0001\t\u0007I\u0011B;\u0002\u001b5\f\u0007\u0010S3bI\u0016\u00148+\u001b>f\u0011\u0019q\b\u0001)A\u0005m\u0006qQ.\u0019=IK\u0006$WM]*ju\u0016\u0004\u0003\u0002CA\u0001\u0001\t\u0007I\u0011B;\u0002\u00195\f\u0007p\u00115v].\u001c\u0016N_3\t\u000f\u0005\u0015\u0001\u0001)A\u0005m\u0006iQ.\u0019=DQVt7nU5{K\u0002B\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\u0002\u000f1|wmV5sKV\u0011\u0011Q\u0002\t\u0004O\u0005=\u0011bAA\tQ\t9!i\\8mK\u0006t\u0007\u0002CA\u000b\u0001\u0001\u0006I!!\u0004\u0002\u00111|wmV5sK\u0002B!\"!\u0007\u0001\u0011\u000b\u0007I\u0011BA\u000e\u0003%!(/\u00198ta>\u0014H/\u0006\u0002\u0002\u001eIA\u0011qDA\u0012\u0003S\tyC\u0002\u0004\u0002\"\u0001\u0001\u0011Q\u0004\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004O\u0005\u0015\u0012bAA\u0014Q\t9\u0001K]8ek\u000e$\bcA\u0014\u0002,%\u0019\u0011Q\u0006\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0007M\t\t$C\u0002\u00024\t\u0011aBT3uif$&/\u00198ta>\u0014H\u000f\u0003\u0006\u00028\u0001A\t\u0011)Q\u0005\u0003;\t!\u0002\u001e:b]N\u0004xN\u001d;!\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\tA!\\8eKV\u0011\u0011q\b\t\u0005\u0003\u0003\niE\u0004\u0003\u0002D\u0005%SBAA#\u0015\r\t9EB\u0001\u0004CBL\u0017\u0002BA&\u0003\u000b\nA!T8eK&!\u0011qJA)\u0005\u0011iu\u000eZ3\u000b\t\u0005-\u0013Q\t\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/\n\u0011\"\u001a<f]Rdun\u001c9\u0016\u0005\u0005e\u0003\u0003BA.\u0003Sj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\bG\"\fgN\\3m\u0015\u0011\t\u0019'!\u001a\u0002\u000b9,G\u000f^=\u000b\u0005\u0005\u001d\u0014AA5p\u0013\u0011\tY'!\u0018\u000335+H\u000e^5uQJ,\u0017\rZ#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002Z\u0005QQM^3oi2{w\u000e\u001d\u0011\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0014aC1mY\u000eC\u0017M\u001c8fYN,\"!a\u001e\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wRA!! \u0002^\u0005)qM]8va&!\u0011\u0011QA>\u0005M!UMZ1vYR\u001c\u0005.\u00198oK2<%o\\;q\u0011!\t)\t\u0001Q\u0001\n\u0005]\u0014\u0001D1mY\u000eC\u0017M\u001c8fYN\u0004\u0003BCAE\u0001!\u0015\r\u0011\"\u0003\u0002\f\u0006\t2o\u001d7F]\u001eLg.\u001a)s_ZLG-\u001a:\u0016\u0005\u00055\u0005#B\u0014\u0002\u0010\u0006M\u0015bAAIQ\t1q\n\u001d;j_:\u0004B!!&\u0002\u001a6\u0011\u0011q\u0013\u0006\u0003\u0007\u0019IA!a'\u0002\u0018\n\t2k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\t\u0015\u0005}\u0005\u0001#A!B\u0013\ti)\u0001\ntg2,enZ5oKB\u0013xN^5eKJ\u0004\u0003bBAR\u0001\u0011%\u0011QU\u0001\u000bg\u0016$x\n\u001d;j_:\u001cHCBAT\u0003[\u000b\u0019\rE\u0002(\u0003SK1!a+)\u0005\u0011)f.\u001b;\t\u0011\u0005=\u0016\u0011\u0015a\u0001\u0003c\u000b\u0011b]3u\u001fB$\u0018n\u001c8\u0011\u0011\u001d\n\u0019,a.\u0002>nJ1!!.)\u0005%1UO\\2uS>t'\u0007\u0005\u0004\u0002\\\u0005e\u0016QX\u0005\u0005\u0003w\u000biFA\u0007DQ\u0006tg.\u001a7PaRLwN\u001c\t\u0004O\u0005}\u0016bAAaQ\t1\u0011I\\=SK\u001aDaaFAQ\u0001\u0004A\u0007bBAd\u0001\u0011%\u0011\u0011Z\u0001\u0005E&tG\r\u0006\u0003\u0002L\u0006-\bcB\u0014\u0002N\u0006E\u0017q[\u0005\u0004\u0003\u001fD#A\u0002+va2,'\u0007\u0005\u0003\u0002\\\u0005M\u0017\u0002BAk\u0003;\u0012qa\u00115b]:,G\u000e\r\u0003\u0002Z\u0006\u001d\b\u0003CAn\u0003C\f\t.!:\u000e\u0005\u0005u'bAAp!\u0006A1oY1mC\u0012\u001cH.\u0003\u0003\u0002d\u0006u'AB*pkJ\u001cW\rE\u00025\u0003O$1\"!;\u0002F\u0006\u0005\t\u0011!B\u0001o\t\u0019q\f\n\u001a\t\u0011\u00055\u0018Q\u0019a\u0001\u0003_\fq!\u00193ee\u0016\u001c8\u000f\u0005\u0003\u0002r\u0006]XBAAz\u0015\r\t)PD\u0001\u0004]\u0016$\u0018\u0002BA}\u0003g\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007f\f1b\u00195b]:,GnU5oWR!!\u0011\u0001B\t!!\tYNa\u0001\u0002R\n\u001d\u0011\u0002\u0002B\u0003\u0003;\u0014AaU5oWB!a&\rB\u0005!\u0011\u0011YA!\u0004\u000e\u0003\u0015K1Aa\u0004F\u0005\u0011!uN\\3\t\u0011\tM\u00111 a\u0001\u0003\u001b\taa]3dkJ,\u0007b\u0002B\f\u0001\u0011%!\u0011D\u0001\u0016Q\u0006tG\r\\3Tk\n\u001c8M]5cKJ,%O]8s)\u0011\t9Ka\u0007\t\u0011\tu!Q\u0003a\u0001\u0005?\tQ!\u001a:s_J\u0004BA!\t\u000329!!1\u0005B\u0017\u001d\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"b\u0001B\u0015\u0011\u00051AH]8pizJ\u0011!K\u0005\u0004\u0005_A\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005g\u0011)DA\u0005UQJ|w/\u00192mK*\u0019!q\u0006\u0015\t\u0013\te\u0002A1A\u0005\n\tm\u0012a\u00035uiB\u001c\u0005.\u00198oK2,\"A!\u0010\u0011\u000b\u001d\ny)!5\t\u0011\t\u0005\u0003\u0001)A\u0005\u0005{\tA\u0002\u001b;ua\u000eC\u0017M\u001c8fY\u0002B\u0011B!\u0012\u0001\u0005\u0004%IAa\u000f\u0002\u0019!$H\u000f]:DQ\u0006tg.\u001a7\t\u0011\t%\u0003\u0001)A\u0005\u0005{\tQ\u0002\u001b;uaN\u001c\u0005.\u00198oK2\u0004\u0003b\u0002B'\u0001\u0011%!qJ\u0001\fE&tGm\u00115b]:,G\u000e\u0006\u0004\u0002R\nE#Q\u000b\u0005\b\u0005'\u0012Y\u00051\u0001w\u0003\u0011\u0001xN\u001d;\t\u0011\tM!1\na\u0001\u0003\u001bAqA!\u0017\u0001\t\u0003\u0012Y&\u0001\u0003ti>\u0004HCAAT\u0011)\u0011y\u0006\u0001EC\u0002\u0013\u0005#\u0011M\u0001\f[\u0006Lg.\u00113ee\u0016\u001c8/\u0006\u0002\u0002p\"Q!Q\r\u0001\t\u0002\u0003\u0006K!a<\u0002\u00195\f\u0017N\\!eIJ,7o\u001d\u0011\t\u000f\t%\u0004\u0001\"\u0001\u0003l\u0005A\u0001\u000e\u001e;q!>\u0014H/\u0006\u0002\u0003nA!q%a$w\u0011\u001d\u0011\t\b\u0001C\u0001\u0005W\n\u0011\u0002\u001b;uaN\u0004vN\u001d;\b\u000f\tU$\u0001#\u0001\u0003x\u0005Ya*\u001a;usN+'O^3s!\r\u0019\"\u0011\u0010\u0004\u0007\u0003\tA\tAa\u001f\u0014\t\te\u0014Q\u0018\u0005\b/\neD\u0011\u0001B@)\t\u00119\b\u0003\u0006\u0003\u0004\ne$\u0019!C\u0005\u0005\u000b\u000ba\u0001\\8hO\u0016\u0014XC\u0001BD!\u0011\t\u0019E!#\n\t\t-\u0015Q\t\u0002\u0007\u0019><w-\u001a:\t\u0013\t=%\u0011\u0010Q\u0001\n\t\u001d\u0015a\u00027pO\u001e,'\u000f\t\u0005\u000b\u0005'\u0013IH1A\u0005\u0004\tU\u0015\u0001\u00039s_ZLG-\u001a:\u0016\u0005\t]\u0005cA\n\u0003\u001a&\u0019!1\u0014\u0002\u0003'9+G\u000f^=TKJ4XM\u001d)s_ZLG-\u001a:\t\u0013\t}%\u0011\u0010Q\u0001\n\t]\u0015!\u00039s_ZLG-\u001a:!\u0011!\u0011\u0019K!\u001f\u0005\u0002\t\u0015\u0016\u0001B7bS:$B!a*\u0003(\"A!\u0011\u0016BQ\u0001\u0004\u0011Y+\u0001\u0003be\u001e\u001c\b#B\u0014\u0003.\nE\u0016b\u0001BXQ\t)\u0011I\u001d:bsB!!1\u0017B]\u001d\r9#QW\u0005\u0004\u0005oC\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0003<\nu&AB*ue&twMC\u0002\u00038\"B\u0001B!1\u0003z\u0011\u0005!1Y\u0001\u0010MJ|W.\u00119qY&\u001c\u0017\r^5p]R)!L!2\u0003P\"A!q\u0019B`\u0001\u0004\u0011I-A\u0006baBd\u0017nY1uS>t\u0007\u0003BA\"\u0005\u0017LAA!4\u0002F\tY\u0011\t\u001d9mS\u000e\fG/[8o\u0011!9\"q\u0018I\u0001\u0002\u0004A\u0002\u0002\u0003Bj\u0005s\"\tA!6\u0002\u0015\u0019\u0014x.\u001c*pkR,'\u000f\u0006\u0003\u0003X\nUHc\u0001.\u0003Z\"A!1\u001cBi\u0001\u0004\u0011i.\u0001\u0004s_V$Xm\u001d\t\bO\t}'1\u001dBx\u0013\r\u0011\t\u000f\u000b\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B!!Q\u001dBv\u001b\t\u00119O\u0003\u0003\u0003j\u0006\u0015\u0013aA7wG&!!Q\u001eBt\u00055\u0011V-];fgRDU-\u00193feB!!Q\u001dBy\u0013\u0011\u0011\u0019Pa:\u0003\u000f!\u000bg\u000e\u001a7fe\"AqC!5\u0011\u0002\u0003\u0007\u0001\u0004\u0003\u0006\u0003z\ne\u0014\u0013!C\u0001\u0005w\f\u0011D\u001a:p[\u0006\u0003\b\u000f\\5dCRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q \u0016\u00041\t}8FAB\u0001!\u0011\u0019\u0019a!\u0004\u000e\u0005\r\u0015!\u0002BB\u0004\u0007\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r-\u0001&\u0001\u0006b]:|G/\u0019;j_:LAaa\u0004\u0004\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\rM!\u0011PI\u0001\n\u0003\u0011Y0\u0001\u000bge>l'k\\;uKJ$C-\u001a4bk2$H%\r")
public class NettyServer
implements Server {
    public final ServerConfig play$core$server$NettyServer$$config;
    private final ApplicationProvider applicationProvider;
    private final Function0<Future<?>> stopHook;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final Config play$core$server$NettyServer$$nettyConfig;
    private final int play$core$server$NettyServer$$maxInitialLineLength;
    private final int play$core$server$NettyServer$$maxHeaderSize;
    private final int play$core$server$NettyServer$$maxChunkSize;
    private final boolean play$core$server$NettyServer$$logWire;
    private Product play$core$server$NettyServer$$transport;
    private final MultithreadEventLoopGroup play$core$server$NettyServer$$eventLoop;
    private final DefaultChannelGroup play$core$server$NettyServer$$allChannels;
    private Option<SSLEngineProvider> play$core$server$NettyServer$$sslEngineProvider;
    private final Option<Channel> httpChannel;
    private final Option<Channel> play$core$server$NettyServer$$httpsChannel;
    private InetSocketAddress mainAddress;
    private volatile byte bitmap$0;

    public static ServerConfig fromRouter$default$1() {
        return NettyServer$.MODULE$.fromRouter$default$1();
    }

    public static ServerConfig fromApplication$default$2() {
        return NettyServer$.MODULE$.fromApplication$default$2();
    }

    public static NettyServer fromRouter(ServerConfig serverConfig, PartialFunction<RequestHeader, Handler> partialFunction) {
        return NettyServer$.MODULE$.fromRouter(serverConfig, partialFunction);
    }

    public static NettyServer fromApplication(Application application, ServerConfig serverConfig) {
        return NettyServer$.MODULE$.fromApplication(application, serverConfig);
    }

    public static void main(String[] stringArray) {
        NettyServer$.MODULE$.main(stringArray);
    }

    public static NettyServerProvider provider() {
        return NettyServer$.MODULE$.provider();
    }

    private Product play$core$server$NettyServer$$transport$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                NettyTransport nettyTransport;
                String string = this.play$core$server$NettyServer$$nettyConfig().getString("transport");
                if ("native".equals(string)) {
                    nettyTransport = Native$.MODULE$;
                } else {
                    if (!"jdk".equals(string)) {
                        throw new ServerStartException("Netty transport configuration value should be either jdk or native", ServerStartException$.MODULE$.apply$default$2());
                    }
                    nettyTransport = Jdk$.MODULE$;
                }
                this.play$core$server$NettyServer$$transport = nettyTransport;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.play$core$server$NettyServer$$transport;
        }
    }

    private Option play$core$server$NettyServer$$sslEngineProvider$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.play$core$server$NettyServer$$sslEngineProvider = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.play$core$server$NettyServer$$sslEngineProvider;
        }
    }

    private InetSocketAddress mainAddress$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.mainAddress = (InetSocketAddress)((Channel)this.httpChannel().orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyServer $outer;

                    public final Option<Channel> apply() {
                        return this.$outer.play$core$server$NettyServer$$httpsChannel();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).localAddress();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.mainAddress;
        }
    }

    public Either<Future<Result>, Tuple3<RequestHeader, Handler, Application>> getHandlerFor(RequestHeader request) {
        return Server.class.getHandlerFor((Server)this, (RequestHeader)request);
    }

    public ApplicationProvider applicationProvider() {
        return this.applicationProvider;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public Config play$core$server$NettyServer$$nettyConfig() {
        return this.play$core$server$NettyServer$$nettyConfig;
    }

    public int play$core$server$NettyServer$$maxInitialLineLength() {
        return this.play$core$server$NettyServer$$maxInitialLineLength;
    }

    public int play$core$server$NettyServer$$maxHeaderSize() {
        return this.play$core$server$NettyServer$$maxHeaderSize;
    }

    public int play$core$server$NettyServer$$maxChunkSize() {
        return this.play$core$server$NettyServer$$maxChunkSize;
    }

    public boolean play$core$server$NettyServer$$logWire() {
        return this.play$core$server$NettyServer$$logWire;
    }

    public Product play$core$server$NettyServer$$transport() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.play$core$server$NettyServer$$transport$lzycompute() : this.play$core$server$NettyServer$$transport;
    }

    public Enumeration.Value mode() {
        return this.play$core$server$NettyServer$$config.mode();
    }

    public MultithreadEventLoopGroup play$core$server$NettyServer$$eventLoop() {
        return this.play$core$server$NettyServer$$eventLoop;
    }

    public DefaultChannelGroup play$core$server$NettyServer$$allChannels() {
        return this.play$core$server$NettyServer$$allChannels;
    }

    public Option<SSLEngineProvider> play$core$server$NettyServer$$sslEngineProvider() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.play$core$server$NettyServer$$sslEngineProvider$lzycompute() : this.play$core$server$NettyServer$$sslEngineProvider;
    }

    public void play$core$server$NettyServer$$setOptions(Function2<ChannelOption<Object>, Object, Object> setOption, Config config) {
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(config.entrySet()).asScala()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map.Entry<String, ConfigValue> x$1) {
                return x$1.getKey().startsWith("child.");
            }
        })).foreach((Function1)new Serializable(this, setOption){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyServer $outer;
            private final Function2 setOption$1;

            public final Object apply(Map.Entry<String, ConfigValue> option) {
                Product product;
                block6: {
                    Object object;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    if (!ChannelOption.exists((String)option.getKey())) break block2;
                                    object = this.setOption$1.apply((Object)ChannelOption.valueOf((String)option.getKey()), this.$outer.play$core$server$NettyServer$$unwrap$1(option.getValue()));
                                    break block3;
                                }
                                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0)new Serializable(this, option){
                                    public static final long serialVersionUID = 0L;
                                    private final Map.Entry option$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Ignoring unknown Netty channel option: ").append(this.option$1.getKey()).toString();
                                    }
                                    {
                                        this.option$1 = option$1;
                                    }
                                });
                                product = this.$outer.play$core$server$NettyServer$$transport();
                                if (!Native$.MODULE$.equals(product)) break block4;
                                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Valid values can be found at http://netty.io/4.0/api/io/netty/channel/ChannelOption.html and http://netty.io/4.0/api/io/netty/channel/epoll/EpollChannelOption.html";
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block5;
                            }
                            if (!Jdk$.MODULE$.equals(product)) break block6;
                            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Valid values can be found at http://netty.io/4.0/api/io/netty/channel/ChannelOption.html";
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                throw new MatchError((Object)product);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.setOption$1 = setOption$1;
            }
        });
    }

    private Tuple2<Channel, Source<Channel, ?>> bind(InetSocketAddress address) {
        Product product;
        block4: {
            Class<EpollServerSocketChannel> clazz;
            HandlerPublisher channelPublisher;
            EventLoop serverChannelEventLoop;
            block3: {
                block2: {
                    serverChannelEventLoop = this.play$core$server$NettyServer$$eventLoop().next();
                    channelPublisher = new HandlerPublisher((EventExecutor)serverChannelEventLoop, Channel.class);
                    product = this.play$core$server$NettyServer$$transport();
                    if (!Native$.MODULE$.equals(product)) break block2;
                    clazz = EpollServerSocketChannel.class;
                    break block3;
                }
                if (!Jdk$.MODULE$.equals(product)) break block4;
                clazz = NioServerSocketChannel.class;
            }
            Class<EpollServerSocketChannel> channelClass = clazz;
            Bootstrap bootstrap = (Bootstrap)new Bootstrap().channel(channelClass).group((EventLoopGroup)serverChannelEventLoop).option(ChannelOption.AUTO_READ, (Object)Boolean.FALSE).handler((ChannelHandler)channelPublisher).localAddress((SocketAddress)address);
            this.play$core$server$NettyServer$$setOptions((Function2<ChannelOption<Object>, Object, Object>)new Serializable(this, bootstrap){
                public static final long serialVersionUID = 0L;
                private final Bootstrap bootstrap$1;

                public final Bootstrap apply(ChannelOption<Object> x$1, Object x$2) {
                    return (Bootstrap)this.bootstrap$1.option(x$1, x$2);
                }
                {
                    this.bootstrap$1 = bootstrap$1;
                }
            }, this.play$core$server$NettyServer$$nettyConfig().getConfig("option"));
            Channel channel = bootstrap.bind().await().channel();
            this.play$core$server$NettyServer$$allChannels().add(channel);
            return new Tuple2((Object)channel, (Object)Source$.MODULE$.fromPublisher((Publisher)channelPublisher));
        }
        throw new MatchError((Object)product);
    }

    private Sink<Channel, Future<Done>> channelSink(boolean secure) {
        return Sink$.MODULE$.foreach((Function1)new Serializable(this, secure){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyServer $outer;
            private final boolean secure$1;

            public final void apply(Channel connChannel) {
                connChannel.config().setOption(ChannelOption.AUTO_READ, (Object)Boolean.FALSE);
                ChannelConfig channelConfig = connChannel.config();
                this.$outer.play$core$server$NettyServer$$setOptions((Function2<ChannelOption<Object>, Object, Object>)new Serializable(this, channelConfig){
                    public static final long serialVersionUID = 0L;
                    private final ChannelConfig eta$0$1$1;

                    public final boolean apply(ChannelOption<Object> x$1, Object x$2) {
                        return this.eta$0$1$1.setOption(x$1, x$2);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                }, this.$outer.play$core$server$NettyServer$$nettyConfig().getConfig("option.child"));
                ChannelPipeline pipeline = connChannel.pipeline();
                Object object = this.secure$1 ? this.$outer.play$core$server$NettyServer$$sslEngineProvider().map((Function1)new Serializable(this, pipeline){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$channelSink$1 $outer;
                    private final ChannelPipeline pipeline$1;

                    public final ChannelPipeline apply(SSLEngineProvider sslEngineProvider) {
                        SSLEngine sslEngine = sslEngineProvider.createSSLEngine();
                        sslEngine.setUseClientMode(false);
                        if (BoxesRunTime.unboxToBoolean((Object)this.$outer.play$core$server$NettyServer$$anonfun$$$outer().play$core$server$NettyServer$$config.configuration().getBoolean("play.server.https.wantClientAuth").getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        }))) {
                            sslEngine.setWantClientAuth(true);
                        }
                        if (BoxesRunTime.unboxToBoolean((Object)this.$outer.play$core$server$NettyServer$$anonfun$$$outer().play$core$server$NettyServer$$config.configuration().getBoolean("play.server.https.needClientAuth").getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        }))) {
                            sslEngine.setNeedClientAuth(true);
                        }
                        return this.pipeline$1.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.pipeline$1 = pipeline$1;
                    }
                }) : BoxedUnit.UNIT;
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.$outer.play$core$server$NettyServer$$maxInitialLineLength(), this.$outer.play$core$server$NettyServer$$maxHeaderSize(), this.$outer.play$core$server$NettyServer$$maxChunkSize()));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("decompressor", (ChannelHandler)new HttpContentDecompressor());
                Object object2 = this.$outer.play$core$server$NettyServer$$logWire() ? pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG)) : BoxedUnit.UNIT;
                PlayRequestHandler requestHandler = new PlayRequestHandler(this.$outer);
                pipeline.addLast("http-handler", (ChannelHandler)new HttpStreamsServerHandler((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelHandler[]{requestHandler}))).asJava()));
                pipeline.addLast("request-handler", (ChannelHandler)requestHandler);
                EventLoop childChannelEventLoop = this.$outer.play$core$server$NettyServer$$eventLoop().next();
                childChannelEventLoop.register(connChannel);
                this.$outer.play$core$server$NettyServer$$allChannels().add(connChannel);
            }

            public /* synthetic */ NettyServer play$core$server$NettyServer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secure$1 = secure$1;
            }
        });
    }

    private void handleSubscriberError(Throwable error) {
        Throwable throwable = error;
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().trace((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Benign IO exception caught in Netty";
                }
            }, (Function0)new Serializable(this, iOException){
                public static final long serialVersionUID = 0L;
                private final IOException x2$1;

                public final IOException apply() {
                    return this.x2$1;
                }
                {
                    this.x2$1 = x2$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception caught in Netty";
                }
            }, (Function0)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable x1$1;

                public final Throwable apply() {
                    return this.x1$1;
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<Channel> httpChannel() {
        return this.httpChannel;
    }

    public Option<Channel> play$core$server$NettyServer$$httpsChannel() {
        return this.play$core$server$NettyServer$$httpsChannel;
    }

    public Channel play$core$server$NettyServer$$bindChannel(int port, boolean secure) {
        String protocolName = secure ? "HTTPS" : "HTTP";
        InetSocketAddress address = new InetSocketAddress(this.play$core$server$NettyServer$$config.address(), port);
        Tuple2<Channel, Source<Channel, ?>> tuple2 = this.bind(address);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Channel serverChannel = (Channel)tuple2._1();
            Source channelSource = (Source)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)serverChannel, (Object)channelSource);
            Channel serverChannel2 = (Channel)tuple23._1();
            Source channelSource2 = (Source)tuple23._2();
            channelSource2.runWith(this.channelSink(secure), this.materializer());
            SocketAddress boundAddress = serverChannel2.localAddress();
            if (boundAddress == null) {
                ServerListenException e = new ServerListenException(protocolName, (SocketAddress)address);
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final ServerListenException e$2;

                    public final String apply() {
                        return this.e$2.getMessage();
                    }
                    {
                        this.e$2 = e$2;
                    }
                });
                throw e;
            }
            Enumeration.Value value = this.mode();
            Enumeration.Value value2 = Mode$.MODULE$.Test();
            if (value == null ? value2 != null : !value.equals(value2)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0)new Serializable(this, protocolName, boundAddress){
                    public static final long serialVersionUID = 0L;
                    private final String protocolName$1;
                    private final SocketAddress boundAddress$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listening for ", " on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocolName$1, this.boundAddress$1}));
                    }
                    {
                        this.protocolName$1 = protocolName$1;
                        this.boundAddress$1 = boundAddress$1;
                    }
                });
            }
            return serverChannel2;
        }
        throw new MatchError(tuple2);
    }

    public void stop() {
        this.play$core$server$NettyServer$$allChannels().close().awaitUninterruptibly();
        this.play$core$server$NettyServer$$eventLoop().shutdownGracefully();
        this.applicationProvider().current().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Application app) {
                Play$.MODULE$.stop(app);
            }
        });
        try {
            Server.class.stop((Server)this);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while stopping logger";
                }
            }, (Function0)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$3;

                public final Throwable apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = e$3;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = Mode$.MODULE$.Test();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping server...";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Await$.MODULE$.result((Awaitable)this.stopHook.apply(), (Duration)Duration$.MODULE$.Inf());
    }

    public InetSocketAddress mainAddress() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.mainAddress$lzycompute() : this.mainAddress;
    }

    public Option<Object> httpPort() {
        return this.httpChannel().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Channel x$5) {
                return ((InetSocketAddress)x$5.localAddress()).getPort();
            }
        });
    }

    public Option<Object> httpsPort() {
        return this.play$core$server$NettyServer$$httpsChannel().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Channel x$6) {
                return ((InetSocketAddress)x$6.localAddress()).getPort();
            }
        });
    }

    private final Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)ServerSSLEngine$.MODULE$.createSSLEngineProvider(this.play$core$server$NettyServer$$config, this.applicationProvider()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot load SSL context"})).s((Seq)Nil$.MODULE$);
                }
            }, (Function0)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public final Object play$core$server$NettyServer$$unwrap$1(ConfigValue value) {
        Object object;
        Object object2 = value.unwrapped();
        if (object2 instanceof Number) {
            Number number = (Number)object2;
            object = BoxesRunTime.boxToInteger((int)number.intValue());
        } else {
            object = object2;
        }
        return object;
    }

    public NettyServer(ServerConfig config, ApplicationProvider applicationProvider, Function0<Future<?>> stopHook, ActorSystem actorSystem, Materializer materializer) {
        Product product;
        block4: {
            EpollEventLoopGroup epollEventLoopGroup;
            block3: {
                NamedThreadFactory threadFactory;
                int threadCount;
                block2: {
                    this.play$core$server$NettyServer$$config = config;
                    this.applicationProvider = applicationProvider;
                    this.stopHook = stopHook;
                    this.actorSystem = actorSystem;
                    this.materializer = materializer;
                    Server.class.$init$((Server)this);
                    this.play$core$server$NettyServer$$nettyConfig = config.configuration().underlying().getConfig("play.server.netty");
                    this.play$core$server$NettyServer$$maxInitialLineLength = this.play$core$server$NettyServer$$nettyConfig().getInt("maxInitialLineLength");
                    this.play$core$server$NettyServer$$maxHeaderSize = this.play$core$server$NettyServer$$nettyConfig().getInt("maxHeaderSize");
                    this.play$core$server$NettyServer$$maxChunkSize = this.play$core$server$NettyServer$$nettyConfig().getInt("maxChunkSize");
                    this.play$core$server$NettyServer$$logWire = this.play$core$server$NettyServer$$nettyConfig().getBoolean("log.wire");
                    threadCount = this.play$core$server$NettyServer$$nettyConfig().getInt("eventLoopThreads");
                    threadFactory = new NamedThreadFactory("netty-event-loop");
                    product = this.play$core$server$NettyServer$$transport();
                    if (!Native$.MODULE$.equals(product)) break block2;
                    epollEventLoopGroup = new EpollEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
                    break block3;
                }
                if (!Jdk$.MODULE$.equals(product)) break block4;
                epollEventLoopGroup = new NioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
            }
            this.play$core$server$NettyServer$$eventLoop = epollEventLoopGroup;
            this.play$core$server$NettyServer$$allChannels = new DefaultChannelGroup((EventExecutor)this.play$core$server$NettyServer$$eventLoop().next());
            this.httpChannel = config.port().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyServer $outer;

                public final Channel apply(int x$2) {
                    return this.$outer.play$core$server$NettyServer$$bindChannel(x$2, false);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.play$core$server$NettyServer$$httpsChannel = config.sslPort().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyServer $outer;

                public final Channel apply(int x$3) {
                    return this.$outer.play$core$server$NettyServer$$bindChannel(x$3, true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError((Object)product);
    }
}

