/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.NativeFunctionToStringFunction;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptExecutor;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.DateCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.StringCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEngine {
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private final WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private final JavaScriptConfiguration jsConfig_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient boolean holdPostponedActions_;
    private transient JavaScriptExecutor javaScriptExecutor_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
        this.jsConfig_ = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    public void initialize(final WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                try {
                    JavaScriptEngine.this.init(webWindow, cx);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                    throw new ScriptException(null, (Throwable)e);
                }
                return null;
            }
        };
        this.getContextFactory().call(action);
    }

    public JavaScriptExecutor getJavaScriptExecutor() {
        return this.javaScriptExecutor_;
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        Scriptable prototype;
        WebClient webClient = webWindow.getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        HashMap<Class<? extends SimpleScriptable>, Scriptable> prototypes = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
        HashMap<String, ScriptableObject> prototypesPerJSName = new HashMap<String, ScriptableObject>();
        Window window = new Window();
        context.initStandardObjects((ScriptableObject)window);
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSTRUCTOR)) {
            this.defineConstructor(window, window, new Window());
        } else {
            this.deleteProperties(window, "constructor");
        }
        this.deleteProperties(window, "java", "javax", "org", "com", "edu", "net", "JavaAdapter", "JavaImporter", "Continuation", "Packages", "getClass");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_XML)) {
            this.deleteProperties(window, "XML", "XMLList", "Namespace", "QName");
        }
        FallbackCaller fallbackCaller = new FallbackCaller();
        ScriptableObject.getObjectPrototype((Scriptable)window).setPrototype((Scriptable)fallbackCaller);
        boolean putPrototypeInWindowScope = browserVersion.hasFeature(BrowserVersionFeatures.JS_HAS_OBJECT_WITH_PROTOTYPE_PROPERTY_IN_WINDOW_SCOPE);
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            boolean isWindow = Window.class.getName().equals(config.getHostClass().getName());
            if (isWindow) {
                this.configureConstantsPropertiesAndFunctions(config, window);
                continue;
            }
            ScriptableObject prototype2 = this.configureClass(config, window);
            if (config.isJsObject()) {
                if (putPrototypeInWindowScope) {
                    Page page;
                    SimpleScriptable obj = config.getHostClass().newInstance();
                    prototype2.defineProperty("__proto__", (Object)prototype2, 2);
                    obj.defineProperty("prototype", prototype2, 2);
                    obj.setParentScope(window);
                    ScriptableObject.defineProperty((Scriptable)window, (String)obj.getClassName(), (Object)obj, (int)2);
                    this.configureConstants(config, obj);
                    if (obj.getClass() == Element.class && (page = webWindow.getEnclosedPage()) != null && page.isHtmlPage()) {
                        HtmlDivision domNode = new HtmlDivision(null, "", (HtmlPage)page, null);
                        obj.setDomNode(domNode);
                    }
                }
                prototypes.put(config.getHostClass(), (Scriptable)prototype2);
            }
            prototypesPerJSName.put(config.getHostClass().getSimpleName(), prototype2);
        }
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype((Scriptable)window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = this.jsConfig_.getClassConfiguration(name);
            prototype = (Scriptable)entry.getValue();
            if (prototype.getPrototype() != null) {
                prototype = prototype.getPrototype();
            }
            if (!StringUtils.isEmpty((CharSequence)config.getExtendedClassName())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                prototype.setPrototype(parentPrototype);
                continue;
            }
            prototype.setPrototype(objectPrototype);
        }
        for (ClassConfiguration config : this.jsConfig_.getAll()) {
            Method jsConstructor = config.getJsConstructor();
            String jsClassName = config.getHostClass().getSimpleName();
            prototype = (ScriptableObject)prototypesPerJSName.get(jsClassName);
            if (prototype == null) continue;
            if (jsConstructor != null) {
                FunctionObject functionObject = new FunctionObject(jsClassName, (Member)jsConstructor, (Scriptable)window);
                functionObject.addAsConstructor((Scriptable)window, prototype);
                this.configureConstants(config, (ScriptableObject)functionObject);
                continue;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSTRUCTOR)) {
                Class<? extends SimpleScriptable> jsHostClass = config.getHostClass();
                ScriptableObject constructor = jsHostClass.newInstance();
                this.defineConstructor(window, prototype, constructor);
                this.configureConstants(config, constructor);
                continue;
            }
            this.deleteProperties((ScriptableObject)prototype, "constructor");
        }
        this.removePrototypeProperties(window, "String", "equals", "equalsIgnoreCase");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM)) {
            this.removePrototypeProperties(window, "String", "trim");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM_LEFT_RIGHT)) {
            ScriptableObject stringPrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"String");
            stringPrototype.defineFunctionProperties(new String[]{"trimLeft", "trimRight"}, StringCustom.class, 0);
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_BIND)) {
            this.removePrototypeProperties(window, "Function", "bind");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ECMA5_FUNCTIONS)) {
            this.removePrototypeProperties(window, "Date", "toISOString", "toJSON");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DEFINE_GETTER)) {
            this.removePrototypeProperties(window, "Object", "__defineGetter__", "__defineSetter__", "__lookupGetter__", "__lookupSetter__");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_TOSOURCE)) {
            this.deleteProperties(window, "uneval");
            this.removePrototypeProperties(window, "Object", "toSource");
            this.removePrototypeProperties(window, "Array", "toSource");
            this.removePrototypeProperties(window, "Date", "toSource");
            this.removePrototypeProperties(window, "Function", "toSource");
            this.removePrototypeProperties(window, "Number", "toSource");
            this.removePrototypeProperties(window, "String", "toSource");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_ISXMLNAME)) {
            this.deleteProperties(window, "isXMLName");
        }
        NativeFunctionToStringFunction.installFix(window, webClient.getBrowserVersion());
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ALLOW_CONST_ASSIGNMENT)) {
            this.makeConstWritable(window, "undefined", "NaN", "Infinity");
        }
        ScriptableObject datePrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Date");
        datePrototype.defineFunctionProperties(new String[]{"toLocaleDateString", "toLocaleTimeString"}, DateCustom.class, 2);
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_USE_UTC)) {
            datePrototype.defineFunctionProperties(new String[]{"toUTCString"}, DateCustom.class, 2);
        }
        window.setPrototypes(prototypes);
        window.initialize(webWindow);
    }

    private void defineConstructor(Window window, Scriptable prototype, ScriptableObject constructor) {
        constructor.setParentScope((Scriptable)window);
        ScriptableObject.defineProperty((Scriptable)prototype, (String)"constructor", (Object)constructor, (int)7);
        ScriptableObject.defineProperty((Scriptable)constructor, (String)"prototype", (Object)prototype, (int)7);
        window.defineProperty(constructor.getClassName(), constructor, 2);
    }

    private void makeConstWritable(ScriptableObject scope, String ... constNames) {
        for (String name : constNames) {
            Object value = ScriptableObject.getProperty((Scriptable)scope, (String)name);
            ScriptableObject.defineProperty((Scriptable)scope, (String)name, (Object)value, (int)6);
        }
    }

    private void deleteProperties(ScriptableObject scope, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            scope.delete(property);
        }
    }

    private void removePrototypeProperties(Scriptable scope, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)scope, (String)className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    private ScriptableObject configureClass(ClassConfiguration config, Scriptable window) throws InstantiationException, IllegalAccessException {
        Class<? extends SimpleScriptable> jsHostClass = config.getHostClass();
        ScriptableObject prototype = jsHostClass.newInstance();
        prototype.setParentScope(window);
        this.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        this.configureConstants(config, scriptable);
        for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : config.propertyEntries()) {
            String propertyName = propertyEntry.getKey();
            Method readMethod = propertyEntry.getValue().getReadMethod();
            Method writeMethod = propertyEntry.getValue().getWriteMethod();
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
        int attributes = this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DONT_ENUM_FUNCTIONS) ? 2 : 0;
        for (Map.Entry<String, Method> functionInfo : config.functionEntries()) {
            String functionName = functionInfo.getKey();
            Method method = functionInfo.getValue();
            FunctionObject functionObject = new FunctionObject(functionName, (Member)method, (Scriptable)scriptable);
            scriptable.defineProperty(functionName, (Object)functionObject, attributes);
        }
    }

    private void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        Class<? extends SimpleScriptable> linkedClass = config.getHostClass();
        for (String constant : config.constants()) {
            try {
                Object value = linkedClass.getField(constant).get(null);
                scriptable.defineProperty(constant, value, 0);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Cannot get field '" + constant + "' for type: " + config.getHostClass().getName()));
            }
        }
    }

    public void registerWindowAndMaybeStartEventLoop(WebWindow webWindow) {
        if (this.javaScriptExecutor_ == null) {
            this.javaScriptExecutor_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptExecutor(this.webClient_);
        }
        this.javaScriptExecutor_.addWindow(webWindow);
    }

    public int pumpEventLoop(long timeoutMillis) {
        if (this.javaScriptExecutor_ == null) {
            return 0;
        }
        return this.javaScriptExecutor_.pumpEventLoop(timeoutMillis);
    }

    public void shutdownJavaScriptExecutor() {
        if (this.javaScriptExecutor_ != null) {
            this.javaScriptExecutor_.shutdown();
            this.javaScriptExecutor_ = null;
        }
    }

    public Script compile(HtmlPage htmlPage, String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        if (LOG.isTraceEnabled()) {
            String newline = System.getProperty("line.separator");
            LOG.trace((Object)("Javascript compile " + sourceName + newline + sourceCode + newline));
        }
        Scriptable scope = this.getScope(htmlPage, null);
        final String source = sourceCode;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            @Override
            public Object doRun(Context cx) {
                return cx.compileString(source, sourceName, startLine, null);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return source;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(htmlPage, sourceCode, sourceName, startLine);
        if (script == null) {
            return null;
        }
        return this.execute(htmlPage, script);
    }

    public Object execute(HtmlPage htmlPage, final Script script) {
        final Scriptable scope = this.getScope(htmlPage, null);
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            @Override
            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().call(action);
    }

    public Object callFunction(HtmlPage htmlPage, Function javaScriptFunction, Scriptable thisObject, Object[] args, DomNode htmlElement) {
        Scriptable scope = this.getScope(htmlPage, htmlElement);
        return this.callFunction(htmlPage, javaScriptFunction, scope, thisObject, args);
    }

    public Object callFunction(HtmlPage htmlPage, final Function function, final Scriptable scope, final Scriptable thisObject, final Object[] args) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            @Override
            public Object doRun(Context cx) {
                return function.call(cx, scope, thisObject, args);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private Scriptable getScope(HtmlPage htmlPage, DomNode htmlElement) {
        if (htmlElement != null) {
            return htmlElement.getScriptObject();
        }
        return (Window)htmlPage.getEnclosingWindow().getScriptObject();
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    private void doProcessPostponedActions() {
        this.holdPostponedActions_ = false;
        try {
            this.getWebClient().loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions != null) {
            this.postponedActions_.set(null);
            try {
                for (PostponedAction action : actions) {
                    Page owningPage = action.getOwningPage();
                    if (owningPage == null || owningPage != owningPage.getEnclosingWindow().getEnclosedPage()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
        JavaScriptErrorListener javaScriptErrorListener;
        Window w;
        WebWindow window;
        HtmlPage page = scriptException.getPage();
        if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptObject()) != null) {
            try {
                w.triggerOnError(scriptException);
            }
            catch (Exception e) {
                this.handleJavaScriptException(new ScriptException(page, e, null), false);
            }
        }
        if ((javaScriptErrorListener = this.getWebClient().getJavaScriptErrorListener()) != null) {
            javaScriptErrorListener.scriptException(page, scriptException);
        }
        if (this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        LOG.info((Object)"Caught script exception", (Throwable)scriptException);
    }

    public void holdPosponedActions() {
        this.holdPostponedActions_ = true;
    }

    public void processPostponedActions() {
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = false;
    }

    public Class<? extends SimpleScriptable> getJavaScriptClass(Class<?> c) {
        return this.jsConfig_.getDomJavaScriptMapping().get(c);
    }

    public JavaScriptConfiguration getJavaScriptConfiguration() {
        return this.jsConfig_;
    }

    private static class FallbackCaller
    extends ScriptableObject {
        private static final long serialVersionUID = 5142592186670858001L;

        private FallbackCaller() {
        }

        public Object get(String name, Scriptable start) {
            if (start instanceof ScriptableWithFallbackGetter) {
                return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
            }
            return NOT_FOUND;
        }

        public String getClassName() {
            return "htmlUnitHelper-fallbackCaller";
        }
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction {
        private final Scriptable scope_;
        private final HtmlPage htmlPage_;

        public HtmlUnitContextAction(Scriptable scope, HtmlPage htmlPage) {
            this.scope_ = scope;
            this.htmlPage_ = htmlPage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object run(Context cx) {
            Object object;
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                Object response;
                Stack<Scriptable> stack = (Stack<Scriptable>)cx.getThreadLocal((Object)JavaScriptEngine.KEY_STARTING_SCOPE);
                if (null == stack) {
                    stack = new Stack<Scriptable>();
                    cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_SCOPE, stack);
                }
                stack.push(this.scope_);
                try {
                    cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_PAGE, (Object)this.htmlPage_);
                    object = this.htmlPage_;
                    synchronized (object) {
                        block20: {
                            if (this.htmlPage_ == this.htmlPage_.getEnclosingWindow().getEnclosedPage()) break block20;
                            Object var6_7 = null;
                            return var6_7;
                        }
                        response = this.doRun(cx);
                    }
                }
                finally {
                    stack.pop();
                }
                if (!JavaScriptEngine.this.holdPostponedActions_) {
                    JavaScriptEngine.this.doProcessPostponedActions();
                }
                object = response;
                return object;
            }
            catch (Exception e) {
                JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.htmlPage_, e, this.getSourceCode(cx)), true);
                Object response = null;
                return response;
            }
            catch (TimeoutError e) {
                JavaScriptErrorListener javaScriptErrorListener = JavaScriptEngine.this.getWebClient().getJavaScriptErrorListener();
                if (javaScriptErrorListener != null) {
                    javaScriptErrorListener.timeoutError(this.htmlPage_, e.getAllowedTime(), e.getExecutionTime());
                }
                if (JavaScriptEngine.this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
                    throw new RuntimeException(e);
                }
                LOG.info((Object)"Caught script timeout error", (Throwable)e);
                object = null;
                return object;
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

