/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClasses={HtmlTableCell.class})
public class HTMLTableCellElement
extends HTMLTableComponent {
    @Override
    public void setAttribute(String name, String value) {
        if ("noWrap".equals(name) && value != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_92)) {
            value = "true";
        }
        super.setAttribute(name, value);
    }

    @Override
    public int getOffsetHeight() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return super.getOffsetHeight();
        }
        ComputedCSSStyleDeclaration style = this.getCurrentStyle();
        boolean includeBorder = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_93);
        return style.getCalculatedHeight(includeBorder, true);
    }

    @Override
    public int getOffsetWidth() {
        HtmlTableRow row;
        float w = super.getOffsetWidth();
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return (int)w;
        }
        ComputedCSSStyleDeclaration style = this.getCurrentStyle();
        if ("collapse".equals(style.getBorderCollapse()) && (row = this.getRow()) != null) {
            HtmlElement thiz = this.getDomNodeOrDie();
            List<HtmlTableCell> cells = row.getCells();
            boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_94);
            boolean leftmost = cells.indexOf(thiz) == 0;
            boolean rightmost = cells.indexOf(thiz) == cells.size() - 1;
            w = (float)((double)w - (ie && leftmost ? 0.0 : 0.5) * (double)style.getBorderLeftValue());
            w = (float)((double)w - (ie && rightmost ? 0.0 : 0.5) * (double)style.getBorderRightValue());
        }
        return (int)w;
    }

    @JsxGetter
    public Integer getCellIndex() {
        HtmlTableCell cell = (HtmlTableCell)this.getDomNodeOrDie();
        HtmlTableRow row = cell.getEnclosingRow();
        if (row == null) {
            return -1;
        }
        return row.getCells().indexOf(cell);
    }

    @JsxGetter
    public String getAbbr() {
        return this.getDomNodeOrDie().getAttribute("abbr");
    }

    @JsxSetter
    public void setAbbr(String abbr) {
        this.getDomNodeOrDie().setAttribute("abbr", abbr);
    }

    @JsxGetter
    public String getAxis() {
        return this.getDomNodeOrDie().getAttribute("axis");
    }

    @JsxSetter
    public void setAxis(String axis) {
        this.getDomNodeOrDie().setAttribute("axis", axis);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter
    public int getColSpan() {
        String s = this.getDomNodeOrDie().getAttribute("colSpan");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @JsxSetter
    public void setColSpan(String colSpan) {
        String s;
        try {
            int i = (int)Double.parseDouble(colSpan);
            if (i <= 0) {
                throw new NumberFormatException(colSpan);
            }
            s = Integer.toString(i);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_95)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            s = "1";
        }
        this.getDomNodeOrDie().setAttribute("colSpan", s);
    }

    @JsxGetter
    public int getRowSpan() {
        String s = this.getDomNodeOrDie().getAttribute("rowSpan");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @JsxSetter
    public void setRowSpan(String rowSpan) {
        String s;
        try {
            int i = (int)Double.parseDouble(rowSpan);
            if (i <= 0) {
                throw new NumberFormatException(rowSpan);
            }
            s = Integer.toString(i);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_96)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            s = "1";
        }
        this.getDomNodeOrDie().setAttribute("rowSpan", s);
    }

    @JsxGetter
    public boolean getNoWrap() {
        return this.getDomNodeOrDie().hasAttribute("noWrap");
    }

    @JsxSetter
    public void setNoWrap(boolean noWrap) {
        if (noWrap) {
            String value = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_97) ? "true" : "";
            this.getDomNodeOrDie().setAttribute("noWrap", value);
        } else {
            this.getDomNodeOrDie().removeAttribute("noWrap");
        }
    }

    private HtmlTableRow getRow() {
        DomNode node;
        for (node = this.getDomNodeOrDie(); node != null && !(node instanceof HtmlTableRow); node = node.getParentNode()) {
        }
        return (HtmlTableRow)node;
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_98);
        Boolean returnNegativeValues = ie ? Boolean.TRUE : null;
        return this.getWidthOrHeight("width", returnNegativeValues);
    }

    @JsxSetter
    public void setWidth(String width) {
        this.setWidthOrHeight("width", width, !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_99));
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_100);
        Boolean returnNegativeValues = ie ? Boolean.TRUE : null;
        return this.getWidthOrHeight("height", returnNegativeValues);
    }

    @JsxSetter
    public void setHeight(String height) {
        this.setWidthOrHeight("height", height, !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_101));
    }

    @Override
    public String getDefaultStyleDisplay() {
        return "table-cell";
    }
}

