/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.trace.receive;

import akka.actor.ActorSystem;
import com.google.protobuf.CodedInputStream;
import com.typesafe.trace.Batch;
import com.typesafe.trace.InternalSystem$;
import com.typesafe.trace.TraceEventHandler;
import com.typesafe.trace.TraceProtocol;
import com.typesafe.trace.TraceReceiver;
import com.typesafe.trace.util.ProtobufConverter$;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u0017\t)\u0002K]8u_\n,h\r\u0016:bG\u0016\u0014VmY3jm\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0011XmY3jm\u0016T!!\u0002\u0004\u0002\u000bQ\u0014\u0018mY3\u000b\u0005\u001dA\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\u000e)J\f7-\u001a*fG\u0016Lg/\u001a:\t\u0011]\u0001!Q1A\u0005\u0002a\tA\"\u001a<f]RD\u0015M\u001c3mKJ,\u0012!\u0007\t\u0003'iI!a\u0007\u0003\u0003#Q\u0013\u0018mY3Fm\u0016tG\u000fS1oI2,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001a\u00035)g/\u001a8u\u0011\u0006tG\r\\3sA!Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0003q_J$\bCA\u0007\"\u0013\t\u0011cBA\u0002J]RD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u000f[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q!\u0001FK\u0016-!\tI\u0003!D\u0001\u0003\u0011\u00159R\u00051\u0001\u001a\u0011\u0015yR\u00051\u0001!\u0011\u0015!S\u00051\u0001!\u0011\u0019q\u0003\u0001)A\u0005_\u000511/\u001a:wKJ\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u0019\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016DaA\u000f\u0001!\u0002\u0013Y\u0014\u0001\u00037jgR,g.\u001a:\u0011\u0005qzT\"A\u001f\u000b\u0005y*\u0014a\u00018fi&\u0011\u0001)\u0010\u0002\r'\u0016\u0014h/\u001a:T_\u000e\\W\r\u001e\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u0018\u0002\u0017\r|gN\\3di&|gn\u001d\u0005\u0007\t\u0002\u0001\u000b\u0015B#\u0002\u000fM|7m[3ugB\u0019aiS'\u000e\u0003\u001dS!\u0001S%\u0002\u0013%lW.\u001e;bE2,'B\u0001&\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0019\u001e\u00131aU3u!\tad*\u0003\u0002P{\t11k\\2lKRDQ!\u0015\u0001\u0005\nI\u000bQ\"\u00193e\u0007>tg.Z2uS>tGCA*W!\tiA+\u0003\u0002V\u001d\t!QK\\5u\u0011\u00159\u0006\u000b1\u0001N\u0003\u0019\u0019xnY6fi\")\u0011\f\u0001C\u00055\u0006y1\r\\8tK\u000e{gN\\3di&|g\u000e\u0006\u0002T7\")q\u000b\u0017a\u0001\u001b\")Q\f\u0001C\u0005=\u0006\u00192\r\\8tK\u0006cGnQ8o]\u0016\u001cG/[8ogR\t1\u000bC\u0003a\u0001\u0011%\u0011-A\u0005sK\u000e,\u0017N^3P]R\u00111K\u0019\u0005\u0006/~\u0003\r!\u0014\u0005\u0006I\u0002!\tAX\u0001\tg\",H\u000fZ8x]\u0002")
public class ProtobufTraceReceiver
implements TraceReceiver {
    private final TraceEventHandler eventHandler;
    public final int com$typesafe$trace$receive$ProtobufTraceReceiver$$maxConnections;
    private final ExecutorService server;
    public final ServerSocket com$typesafe$trace$receive$ProtobufTraceReceiver$$listener;
    private final ExecutorService connections;
    private Set<Socket> sockets;

    @Override
    public TraceEventHandler eventHandler() {
        return this.eventHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void com$typesafe$trace$receive$ProtobufTraceReceiver$$addConnection(Socket socket) {
        Boolean bl;
        ProtobufTraceReceiver protobufTraceReceiver = this;
        synchronized (protobufTraceReceiver) {
            boolean addable;
            boolean bl2 = addable = this.sockets.size() < this.com$typesafe$trace$receive$ProtobufTraceReceiver$$maxConnections;
            if (addable) {
                this.sockets = (Set)this.sockets.$plus((Object)socket);
            }
            bl = BoxesRunTime.boxToBoolean((boolean)addable);
        }
        boolean added = BoxesRunTime.unboxToBoolean((Object)bl);
        if (added) {
            this.connections.execute(new Runnable(this, socket){
                private final /* synthetic */ ProtobufTraceReceiver $outer;
                private final Socket socket$1;

                public void run() {
                    this.$outer.com$typesafe$trace$receive$ProtobufTraceReceiver$$receiveOn(this.socket$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.socket$1 = socket$1;
                }
            });
            return;
        }
        socket.close();
        InternalSystem$.MODULE$.enabled(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProtobufTraceReceiver $outer;

            public final void apply(ActorSystem system) {
                system.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't accept new trace receiver connection - already at max connections: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.com$typesafe$trace$receive$ProtobufTraceReceiver$$maxConnections)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(Socket socket) {
        ProtobufTraceReceiver protobufTraceReceiver = this;
        synchronized (protobufTraceReceiver) {
            this.sockets = (Set)this.sockets.$minus((Object)socket);
        }
        socket.close();
    }

    public synchronized void com$typesafe$trace$receive$ProtobufTraceReceiver$$closeAllConnections() {
        this.sockets.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$1) {
                x$1.close();
            }
        });
        this.sockets = Predef$.MODULE$.Set().empty();
    }

    public void com$typesafe$trace$receive$ProtobufTraceReceiver$$receiveOn(Socket socket) {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)socket.getInputStream());
        try {
            while (true) {
                int size = input.readRawVarint32();
                int oldLimit = input.pushLimit(size);
                TraceProtocol.ProtoBatch message = TraceProtocol.ProtoBatch.parseFrom((CodedInputStream)input);
                Batch batch = ProtobufConverter$.MODULE$.fromProto(message);
                this.eventHandler().publish(batch);
                input.popLimit(oldLimit);
                input.resetSizeCounter();
            }
        }
        catch (Exception exception) {
            this.closeConnection(socket);
            return;
        }
    }

    @Override
    public void shutdown() {
        this.com$typesafe$trace$receive$ProtobufTraceReceiver$$listener.close();
        this.server.shutdown();
        this.server.awaitTermination(1L, TimeUnit.SECONDS);
        this.connections.shutdown();
        this.connections.awaitTermination(1L, TimeUnit.SECONDS);
        this.eventHandler().shutdown();
    }

    public ProtobufTraceReceiver(TraceEventHandler eventHandler, int port, int maxConnections) {
        this.eventHandler = eventHandler;
        this.com$typesafe$trace$receive$ProtobufTraceReceiver$$maxConnections = maxConnections;
        this.server = Executors.newSingleThreadExecutor();
        this.com$typesafe$trace$receive$ProtobufTraceReceiver$$listener = new ServerSocket(port);
        this.connections = Executors.newFixedThreadPool(maxConnections);
        this.sockets = Predef$.MODULE$.Set().empty();
        this.server.execute(new Runnable(this){
            private final /* synthetic */ ProtobufTraceReceiver $outer;

            public void run() {
                try {
                    while (true) {
                        Socket socket = this.$outer.com$typesafe$trace$receive$ProtobufTraceReceiver$$listener.accept();
                        this.$outer.com$typesafe$trace$receive$ProtobufTraceReceiver$$addConnection(socket);
                    }
                }
                catch (Exception exception) {
                    this.$outer.com$typesafe$trace$receive$ProtobufTraceReceiver$$closeAllConnections();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

