/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class Storage
extends SimpleScriptable {
    private static List<String> RESERVED_NAMES_ = Arrays.asList("clear", "key", "getItem", "length", "removeItem", "setItem");
    private final Map<String, String> store_;

    @Deprecated
    public Storage() {
        this.store_ = null;
    }

    public Storage(Window window, Map<String, String> store) {
        this.store_ = store;
        this.setParentScope(window);
        this.setPrototype(window.getPrototype(Storage.class));
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.store_ == null || RESERVED_NAMES_.contains(name)) {
            super.put(name, start, value);
            return;
        }
        this.setItem(name, Context.toString((Object)value));
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.store_ == null || RESERVED_NAMES_.contains(name)) {
            return super.get(name, start);
        }
        return this.getItem(name);
    }

    @JsxGetter
    public int getLength() {
        return this.getMap().size();
    }

    @JsxFunction
    public void removeItem(String key) {
        this.getMap().remove(key);
    }

    @JsxFunction
    public String key(int index) {
        int counter = 0;
        for (String key : this.getMap().keySet()) {
            if (counter++ != index) continue;
            return key;
        }
        return null;
    }

    private Map<String, String> getMap() {
        return this.store_;
    }

    @JsxFunction
    public Object getItem(String key) {
        return this.getMap().get(key);
    }

    @JsxFunction
    public void setItem(String key, String data) {
        this.getMap().put(key, data);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STORAGE_OBSOLETE)) {
            return "StorageObsolete";
        }
        return super.getClassName();
    }
}

