/*
 * Decompiled with CFR 0.152.
 */
package play.libs.streams;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Keep;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import play.api.libs.streams.Accumulator$;
import scala.compat.java8.FutureConverters;

public abstract class Accumulator<E, A> {
    private Accumulator() {
    }

    public abstract <B> Accumulator<E, B> map(Function<? super A, ? extends B> var1, Executor var2);

    public abstract <B> Accumulator<E, B> mapFuture(Function<? super A, ? extends CompletionStage<B>> var1, Executor var2);

    public abstract Accumulator<E, A> recover(Function<? super Throwable, ? extends A> var1, Executor var2);

    public abstract Accumulator<E, A> recoverWith(Function<? super Throwable, ? extends CompletionStage<A>> var1, Executor var2);

    public abstract <D> Accumulator<D, A> through(Flow<D, E, ?> var1);

    public abstract CompletionStage<A> run(Materializer var1);

    public abstract CompletionStage<A> run(Source<E, ?> var1, Materializer var2);

    public abstract Sink<E, CompletionStage<A>> toSink();

    public abstract play.api.libs.streams.Accumulator<E, A> asScala();

    public static <E, A> Accumulator<E, A> fromSink(Sink<E, CompletionStage<A>> sink) {
        return new SinkAccumulator(sink);
    }

    public static <E> Accumulator<E, Source<E, ?>> source() {
        return new SinkAccumulator(Sink.asPublisher((AsPublisher)AsPublisher.WITHOUT_FANOUT).mapMaterializedValue((akka.japi.function.Function & Serializable)publisher -> CompletableFuture.completedFuture(Source.fromPublisher((Publisher)publisher))));
    }

    public static <E, A> Accumulator<E, A> done(A a) {
        return Accumulator.done(CompletableFuture.completedFuture(a));
    }

    public static <E, A> Accumulator<E, A> done(CompletionStage<A> completionStage) {
        return new DoneAccumulator(completionStage);
    }

    private static <A> CompletionStage<A> completionStageRecoverWith(CompletionStage<A> completionStage, Function<? super Throwable, ? extends CompletionStage<A>> function, Executor executor) {
        return completionStage.handleAsync((object, throwable) -> {
            if (object != null) {
                return CompletableFuture.completedFuture(object);
            }
            if (throwable instanceof CompletionException) {
                return (CompletionStage)function.apply(throwable.getCause());
            }
            return (CompletionStage)function.apply((Throwable)throwable);
        }, executor).thenCompose(Function.identity());
    }

    private static <A> CompletionStage<A> completionStageRecover(CompletionStage<A> completionStage, Function<? super Throwable, ? extends A> function, Executor executor) {
        return completionStage.handleAsync((object, throwable) -> {
            if (object != null) {
                return object;
            }
            return function.apply((Throwable)throwable);
        }, executor);
    }

    private static final class DoneAccumulator<E, A>
    extends Accumulator<E, A> {
        private final CompletionStage<A> value;

        private DoneAccumulator(CompletionStage<A> completionStage) {
            this.value = completionStage;
        }

        @Override
        public <B> Accumulator<E, B> map(Function<? super A, ? extends B> function, Executor executor) {
            return new DoneAccumulator<E, B>(this.value.thenApplyAsync(function, executor));
        }

        @Override
        public <B> Accumulator<E, B> mapFuture(Function<? super A, ? extends CompletionStage<B>> function, Executor executor) {
            return new DoneAccumulator(this.value.thenComposeAsync(function, executor));
        }

        @Override
        public Accumulator<E, A> recover(Function<? super Throwable, ? extends A> function, Executor executor) {
            return new DoneAccumulator<E, A>(Accumulator.completionStageRecover(this.value, function, executor));
        }

        @Override
        public Accumulator<E, A> recoverWith(Function<? super Throwable, ? extends CompletionStage<A>> function, Executor executor) {
            return new DoneAccumulator<E, A>(Accumulator.completionStageRecoverWith(this.value, function, executor));
        }

        @Override
        public <D> Accumulator<D, A> through(Flow<D, E, ?> flow) {
            return this;
        }

        @Override
        public CompletionStage<A> run(Materializer materializer) {
            return this.value;
        }

        @Override
        public CompletionStage<A> run(Source<E, ?> source2, Materializer materializer) {
            source2.runWith((Graph)Sink.cancelled(), materializer);
            return this.value;
        }

        @Override
        public Sink<E, CompletionStage<A>> toSink() {
            return Sink.cancelled().mapMaterializedValue((akka.japi.function.Function & Serializable)notUsed -> this.value);
        }

        @Override
        public play.api.libs.streams.Accumulator<E, A> asScala() {
            return Accumulator$.MODULE$.done(FutureConverters.toScala(this.value));
        }
    }

    private static final class SinkAccumulator<E, A>
    extends Accumulator<E, A> {
        private final Sink<E, CompletionStage<A>> sink;

        private SinkAccumulator(Sink<E, CompletionStage<A>> sink) {
            this.sink = sink;
        }

        @Override
        public <B> Accumulator<E, B> map(Function<? super A, ? extends B> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((akka.japi.function.Function & Serializable)completionStage -> completionStage.thenApplyAsync(function, executor)));
        }

        @Override
        public <B> Accumulator<E, B> mapFuture(Function<? super A, ? extends CompletionStage<B>> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((akka.japi.function.Function & Serializable)completionStage -> completionStage.thenComposeAsync(function, executor)));
        }

        @Override
        public Accumulator<E, A> recover(Function<? super Throwable, ? extends A> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((akka.japi.function.Function & Serializable)completionStage -> Accumulator.completionStageRecover(completionStage, function, executor)));
        }

        @Override
        public Accumulator<E, A> recoverWith(Function<? super Throwable, ? extends CompletionStage<A>> function, Executor executor) {
            return new SinkAccumulator<E, A>(this.sink.mapMaterializedValue((akka.japi.function.Function & Serializable)completionStage -> Accumulator.completionStageRecoverWith(completionStage, function, executor)));
        }

        @Override
        public <D> Accumulator<D, A> through(Flow<D, E, ?> flow) {
            return new SinkAccumulator<E, A>(flow.toMat(this.sink, Keep.right()));
        }

        @Override
        public CompletionStage<A> run(Materializer materializer) {
            return (CompletionStage)Source.empty().runWith(this.sink, materializer);
        }

        @Override
        public CompletionStage<A> run(Source<E, ?> source2, Materializer materializer) {
            return (CompletionStage)source2.runWith(this.sink, materializer);
        }

        @Override
        public Sink<E, CompletionStage<A>> toSink() {
            return this.sink;
        }

        @Override
        public play.api.libs.streams.Accumulator<E, A> asScala() {
            return Accumulator$.MODULE$.apply(this.sink.mapMaterializedValue(FutureConverters::toScala).asScala());
        }
    }
}

