/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.persistence.JournalProtocol;
import akka.persistence.JournalProtocol$DeleteMessages$;
import akka.persistence.PersistentId;
import akka.persistence.PersistentIdImpl;
import akka.persistence.PersistentRepr;
import akka.persistence.Processor;
import akka.persistence.Processor$;
import akka.persistence.Recover;
import akka.persistence.Recover$;
import akka.persistence.Recovery;
import akka.persistence.RecoveryException;
import akka.persistence.RecoveryFailure;
import akka.persistence.SnapshotSelectionCriteria;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxedUnit;

public abstract class Processor$class {
    public static void onReplaySuccess(Processor $this, PartialFunction receive2, boolean awaitReplay) {
        $this._currentState_$eq($this.akka$persistence$Processor$$initializing());
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.ReadHighestSequenceNr($this.lastSequenceNr(), $this.processorId(), $this.self()), $this.self());
    }

    public static void onReplayFailure(Processor $this, PartialFunction receive2, boolean awaitReplay, Throwable cause) {
        Processor$class.akka$persistence$Processor$$onRecoveryFailure($this, receive2, cause);
    }

    public static void akka$persistence$Processor$$onRecoveryFailure(Processor $this, PartialFunction receive2, Throwable cause) {
        RecoveryFailure notification = new RecoveryFailure(cause);
        if (receive2.isDefinedAt((Object)notification)) {
            receive2.apply((Object)notification);
            return;
        }
        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovery failure by journal (processor id = [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.processorId()}));
        throw new RecoveryException(errorMsg, cause);
    }

    public static String processorId(Processor $this) {
        return $this.akka$persistence$Processor$$_processorId();
    }

    public static String snapshotterId(Processor $this) {
        return $this.processorId();
    }

    public static boolean recoveryRunning(Processor $this) {
        Recovery.State state = $this._currentState();
        Recovery.State state2 = $this.akka$persistence$Processor$$processing();
        return state != null ? !state.equals(state2) : state2 != null;
    }

    public static boolean recoveryFinished(Processor $this) {
        Recovery.State state = $this._currentState();
        Recovery.State state2 = $this.akka$persistence$Processor$$processing();
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static void deleteMessage(Processor $this, long sequenceNr) {
        $this.deleteMessage(sequenceNr, false);
    }

    public static void deleteMessage(Processor $this, long sequenceNr, boolean permanent) {
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.DeleteMessages((scala.collection.immutable.Seq<PersistentId>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PersistentIdImpl[]{new PersistentIdImpl($this.processorId(), sequenceNr)})), permanent, JournalProtocol$DeleteMessages$.MODULE$.apply$default$3()), $this.self());
    }

    public static void deleteMessages(Processor $this, long toSequenceNr) {
        $this.deleteMessages(toSequenceNr, true);
    }

    public static void deleteMessages(Processor $this, long toSequenceNr, boolean permanent) {
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.DeleteMessagesTo($this.processorId(), toSequenceNr, permanent), $this.self());
    }

    public static final void aroundPreStart(Processor $this) {
        try {
            $this.preStart();
            return;
        }
        finally {
            $this.akka$persistence$Processor$$super$preStart();
        }
    }

    public static final void aroundPostStop(Processor $this) {
        try {
            $this.unstashAll($this.akka$persistence$Processor$$unstashFilterPredicate());
            return;
        }
        finally {
            $this.postStop();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void aroundPreRestart(Processor $this, Throwable reason, Option message) {
        try {
            $this.receiverStash().prepend((scala.collection.immutable.Seq)$this.akka$persistence$Processor$$processorBatch().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Processor $outer;

                public final Envelope apply(PersistentRepr p) {
                    return Envelope$.MODULE$.apply((Object)p, p.sender(), this.$outer.context().system());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Vector$.MODULE$.canBuildFrom()));
            $this.receiverStash().unstashAll();
            $this.unstashAll($this.akka$persistence$Processor$$unstashFilterPredicate());
            return;
        }
        finally {
            var4_3 = false;
            var5_5 = null;
            var6_7 = message;
            if (!(var6_7 instanceof Some)) ** GOTO lbl-1000
            var4_3 = true;
            var5_5 = (Some)var6_7;
            var7_9 = var5_5.x();
            if (var7_9 instanceof JournalProtocol.WriteMessageSuccess) {
                var8_11 = (JournalProtocol.WriteMessageSuccess)var7_9;
                m = var8_11.persistent();
                $this.preRestartDefault(reason, (Option<Object>)new Some((Object)m));
                var10_15 = BoxedUnit.UNIT;
            } else if (var4_3 && (var11_23 = var5_5.x()) instanceof JournalProtocol.LoopMessageSuccess) {
                var12_25 = (JournalProtocol.LoopMessageSuccess)var11_23;
                m = var12_25.message();
                $this.preRestartDefault(reason, (Option<Object>)new Some(m));
                var10_16 = BoxedUnit.UNIT;
            } else if (var4_3 && (var14_29 = var5_5.x()) instanceof JournalProtocol.ReplayedMessage) {
                var15_31 = (JournalProtocol.ReplayedMessage)var14_29;
                m = var15_31.persistent();
                $this.preRestartDefault(reason, (Option<Object>)new Some((Object)m));
                var10_17 = BoxedUnit.UNIT;
            } else {
                $this.preRestartDefault(reason, (Option<Object>)None$.MODULE$);
                var10_18 = BoxedUnit.UNIT;
            }
        }
    }

    public static void preStart(Processor $this) throws Exception {
        akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new Recover(Recover$.MODULE$.apply$default$1(), Recover$.MODULE$.apply$default$2(), Recover$.MODULE$.apply$default$3()), $this.self());
    }

    public static void preRestart(Processor $this, Throwable reason, Option message) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = message;
                    if (!(option instanceof Some)) break block2;
                    long x$9 = $this.lastSequenceNr();
                    SnapshotSelectionCriteria x$10 = Recover$.MODULE$.apply$default$1();
                    long x$11 = Recover$.MODULE$.apply$default$3();
                    akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new Recover(x$10, x$9, x$11), $this.self());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new Recover(Recover$.MODULE$.apply$default$1(), Recover$.MODULE$.apply$default$2(), Recover$.MODULE$.apply$default$3()), $this.self());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static void preRestartDefault(Processor $this, Throwable reason, Option message) {
        try {
            $this.preRestart(reason, (Option<Object>)message);
            return;
        }
        finally {
            $this.akka$persistence$Processor$$super$preRestart(reason, (Option<Object>)message);
        }
    }

    public static long akka$persistence$Processor$$nextSequenceNr(Processor $this) {
        $this.akka$persistence$Processor$$sequenceNr_$eq($this.akka$persistence$Processor$$sequenceNr() + 1L);
        return $this.akka$persistence$Processor$$sequenceNr();
    }

    public static void $init$(Processor $this) {
        $this.akka$persistence$Processor$_setter_$akka$persistence$Processor$$initializing_$eq(new Processor$.anon.1($this));
        $this.akka$persistence$Processor$_setter_$akka$persistence$Processor$$processing_$eq(new Processor$.anon.2($this));
        $this.akka$persistence$Processor$_setter_$akka$persistence$Processor$$_processorId_$eq($this.extension().processorId($this.self()));
        $this.akka$persistence$Processor$$processorBatch_$eq((Vector<PersistentRepr>)package$.MODULE$.Vector().empty());
        $this.akka$persistence$Processor$$sequenceNr_$eq(0L);
        $this.akka$persistence$Processor$_setter_$akka$persistence$Processor$$unstashFilterPredicate_$eq((Function1)new Processor$.anonfun.1($this));
    }
}

