/*
 * Decompiled with CFR 0.152.
 */
package activator.properties;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;

public class ActivatorProperties {
    private static Properties props = ActivatorProperties.loadProperties();
    public static String TEMPLATE_UUID_PROPERTY_NAME = "template.uuid";
    public static String SCRIPT_NAME = "activator";

    private static Properties loadProperties() {
        Properties properties = new Properties();
        InputStream inputStream = ActivatorProperties.class.getResourceAsStream("activator.properties");
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return properties;
    }

    private static String getPropertyNoOverrides(String string) {
        return props.getProperty(string);
    }

    private static String ensureNamespacing(String string) {
        if (string.startsWith("activator.")) {
            return string;
        }
        return "activator." + string;
    }

    private static String getPropertyWithOverrides(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = System.getenv(ActivatorProperties.ensureNamespacing(string));
        }
        if (string2 == null) {
            string2 = System.getenv(ActivatorProperties.ensureNamespacing(string).replace('.', '_').toUpperCase());
        }
        if (string2 == null) {
            string2 = ActivatorProperties.getPropertyNoOverrides(string);
        }
        return string2;
    }

    private static String lookupOr(String string, String string2) {
        String string3 = ActivatorProperties.getPropertyWithOverrides(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private static String requirePropertyWithOverrides(String string) {
        String string2 = ActivatorProperties.getPropertyWithOverrides(string);
        if (string2 == null) {
            throw new RuntimeException("Property '" + string + "' has not been set");
        }
        return string2;
    }

    private static String requirePropertyNoOverrides(String string) {
        String string2 = ActivatorProperties.getPropertyNoOverrides(string);
        if (string2 == null) {
            throw new RuntimeException("Property '" + string + "' has not been set");
        }
        return string2;
    }

    public static String APP_VERSION() {
        return ActivatorProperties.requirePropertyNoOverrides("app.version");
    }

    public static String APP_ABI_VERSION() {
        return ActivatorProperties.APP_VERSION();
    }

    public static String APP_SCALA_VERSION() {
        return ActivatorProperties.requirePropertyNoOverrides("app.scala.version");
    }

    public static String SBT_DEFAULT_VERSION() {
        return ActivatorProperties.requirePropertyNoOverrides("sbt.default.version");
    }

    private static String cleanUriFileString(String string) {
        return string.replaceAll(" ", "%20");
    }

    private static String uriToFilename(String string) {
        String string2 = ActivatorProperties.cleanUriFileString(string);
        try {
            URI uRI = new URI(string2);
            if (uRI.getAuthority() != null) {
                string2 = string2.replace("file://", "file:/");
                uRI = new URI(string2);
            }
            return new File(uRI).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("BAD URI: " + string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("BAD URI: " + string2 + "\n", illegalArgumentException);
        }
    }

    public static String ACTIVATOR_HOME_FILENAME() {
        return ActivatorProperties.uriToFilename("file://" + ActivatorProperties.ACTIVATOR_HOME());
    }

    public static String ACTIVATOR_HOME() {
        return ActivatorProperties.requirePropertyWithOverrides("activator.home");
    }

    public static String GLOBAL_USER_HOME() {
        return ActivatorProperties.requirePropertyWithOverrides("user.home");
    }

    private static String ACTIVATOR_UNVERSIONED_USER_HOME() {
        return ActivatorProperties.lookupOr("activator.user.home", ActivatorProperties.GLOBAL_USER_HOME() + "/.activator");
    }

    private static String ACTIVATOR_VERSIONED_USER_HOME() {
        return ActivatorProperties.ACTIVATOR_UNVERSIONED_USER_HOME() + "/" + ActivatorProperties.APP_ABI_VERSION();
    }

    private static String ACTIVATOR_USER_CONFIG_HOME() {
        return ActivatorProperties.ACTIVATOR_UNVERSIONED_USER_HOME() + "/" + ActivatorProperties.requirePropertyWithOverrides("app.config.version");
    }

    private static String ACTIVATOR_PREVIOUS_USER_CONFIG_HOME() {
        return ActivatorProperties.ACTIVATOR_UNVERSIONED_USER_HOME() + "/" + ActivatorProperties.requirePropertyWithOverrides("app.config.previousVersion");
    }

    public static String ACTIVATOR_USER_CONFIG_FILE() {
        return ActivatorProperties.ACTIVATOR_USER_CONFIG_HOME() + "/config.json";
    }

    public static String ACTIVATOR_PREVIOUS_USER_CONFIG_FILE() {
        return ActivatorProperties.ACTIVATOR_PREVIOUS_USER_CONFIG_HOME() + "/config.json";
    }

    public static String ACTIVATOR_VERSION_FILE() {
        return ActivatorProperties.ACTIVATOR_UNVERSIONED_USER_HOME() + "/version-" + ActivatorProperties.ACTIVATOR_LAUNCHER_GENERATION() + ".properties";
    }

    public static String ACTIVATOR_LATEST_URL() {
        return ActivatorProperties.lookupOr("activator.latest.url", "https://lightbend.com/activator/latest");
    }

    public static int ACTIVATOR_LAUNCHER_GENERATION() {
        return Integer.parseInt(ActivatorProperties.requirePropertyWithOverrides("activator.launcher.generation"));
    }

    public static String ACTIVATOR_TEMPLATE_CACHE() {
        return ActivatorProperties.lookupOr("activator.template.cache", ActivatorProperties.ACTIVATOR_VERSIONED_USER_HOME() + "/templates");
    }

    public static String ACTIVATOR_TEMPLATE_LOCAL_REPO() {
        String string = ActivatorProperties.ACTIVATOR_HOME_FILENAME();
        if (string != null) {
            string = string + "/templates";
        }
        return ActivatorProperties.lookupOr("activator.template.localrepo", string);
    }

    private static String ACTIVATOR_LAUNCHER_JAR_MATCHING_VERSION_NAME() {
        String string = ActivatorProperties.APP_VERSION();
        if (string != null) {
            return SCRIPT_NAME + "-launch-" + string + ".jar";
        }
        return null;
    }

    private static FilenameFilter activatorLauncherFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith("activator-launch-") && string.endsWith(".jar");
            }
        };
    }

    public static String ACTIVATOR_LAUNCHER_JAR_NAME(String string) {
        File file = LauncherJarHolder.launcherJar(string);
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    public static String ACTIVATOR_LAUNCHER_JAR(String string) {
        File file = LauncherJarHolder.launcherJar(string);
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    public static String ACTIVATOR_LAUNCHER_BAT(String string) {
        String string2 = ActivatorProperties.ACTIVATOR_HOME_FILENAME();
        if (string2 != null) {
            string2 = string2 + string + SCRIPT_NAME + ".bat";
        }
        return string2;
    }

    public static String ACTIVATOR_LAUNCHER_BASH(String string) {
        String string2 = ActivatorProperties.ACTIVATOR_HOME_FILENAME();
        if (string2 != null) {
            string2 = string2 + string + SCRIPT_NAME;
        }
        return string2;
    }

    public static File ACTIVATOR_LOCK_FILE() {
        return new File(ActivatorProperties.ACTIVATOR_VERSIONED_USER_HOME() + "/.lock");
    }

    public static File ACTIVATOR_PID_FILE() {
        return new File(ActivatorProperties.ACTIVATOR_VERSIONED_USER_HOME() + "/.currentpid");
    }

    public static boolean ACTIVATOR_CHECK_FOR_UPDATES() {
        try {
            return Boolean.parseBoolean(ActivatorProperties.lookupOr("activator.checkForUpdates", "true"));
        }
        catch (Exception exception) {
            System.err.println("Warning: bad value for activator.checkForUpdates: " + exception.getMessage());
            return true;
        }
    }

    public static boolean ACTIVATOR_PROXY_DEBUG() {
        try {
            return Boolean.parseBoolean(ActivatorProperties.lookupOr("activator.proxyDebug", "false"));
        }
        catch (Exception exception) {
            System.err.println("Warning: bad value for activator.proxyDebug: " + exception.getMessage());
            return false;
        }
    }

    private static class LauncherJarHolder {
        private LauncherJarHolder() {
        }

        private static File doFindLauncherJar(String string, File file) {
            File file2 = new File(file, string);
            if (file2.exists()) {
                return file2;
            }
            File[] fileArray = file.listFiles(ActivatorProperties.activatorLauncherFilter());
            if (fileArray != null && fileArray.length > 0) {
                return fileArray[0];
            }
            File file3 = new File(file, "libexec");
            File[] fileArray2 = file3.listFiles(ActivatorProperties.activatorLauncherFilter());
            if (fileArray2 != null && fileArray2.length > 0) {
                return fileArray2[0];
            }
            System.err.println("No activator-launch-*.jar in " + file3);
            return null;
        }

        private static File findLauncherJar(File file) {
            String string = ActivatorProperties.ACTIVATOR_LAUNCHER_JAR_MATCHING_VERSION_NAME();
            if (string != null) {
                return LauncherJarHolder.doFindLauncherJar(string, file);
            }
            return null;
        }

        public static File launcherJar(String string) {
            String string2 = ActivatorProperties.ACTIVATOR_HOME_FILENAME();
            if (string2 != null) {
                if (string != null && !string.isEmpty()) {
                    return LauncherJarHolder.findLauncherJar(new File(string2, string));
                }
                return LauncherJarHolder.findLauncherJar(new File(string2));
            }
            return null;
        }
    }
}

