/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.easymock.ConstructorArgs;
import org.easymock.internal.BridgeMethodResolver;
import org.easymock.internal.ClassExtensionHelper;
import org.easymock.internal.ClassInstantiatorFactory;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.MethodSerializationWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassProxyFactory<T>
implements IProxyFactory<T> {
    private static final NamingPolicy ALLOWS_MOCKING_CLASSES_IN_SIGNED_PACKAGES = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T createProxy(Class<T> toMock, InvocationHandler handler) {
        Class mockClass;
        Enhancer enhancer = this.createEnhancer(toMock);
        MockMethodInterceptor interceptor = new MockMethodInterceptor(handler);
        enhancer.setCallbackType(interceptor.getClass());
        try {
            mockClass = enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            enhancer.setClassLoader(this.getClass().getClassLoader());
            mockClass = enhancer.createClass();
        }
        try {
            Factory mock;
            Enhancer.registerCallbacks((Class)mockClass, (Callback[])new Callback[]{interceptor});
            if (ClassExtensionHelper.getCurrentConstructorArgs() != null) {
                Object mock2;
                Constructor cstr;
                ConstructorArgs args = ClassExtensionHelper.getCurrentConstructorArgs();
                try {
                    cstr = mockClass.getDeclaredConstructor(args.getConstructor().getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Fail to find constructor for param types", e);
                }
                try {
                    cstr.setAccessible(true);
                    mock2 = cstr.newInstance(args.getInitArgs());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor: Exception in constructor", e.getTargetException());
                }
                Object t = mock2;
                return t;
            }
            try {
                mock = (Factory)ClassInstantiatorFactory.getInstantiator().newInstance(mockClass);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Fail to instantiate mock for " + toMock + " on " + ClassInstantiatorFactory.getJVM() + " JVM");
            }
            mock.getCallback(0);
            Factory factory = mock;
            return (T)factory;
        }
        finally {
            Enhancer.registerCallbacks((Class)mockClass, null);
        }
    }

    private Enhancer createEnhancer(Class<T> toMock) {
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
                CollectionUtils.filter((Collection)constructors, (Predicate)new VisibilityPredicate(sc, true));
            }
        };
        enhancer.setSuperclass(toMock);
        if (toMock.getSigners() != null) {
            enhancer.setNamingPolicy(ALLOWS_MOCKING_CLASSES_IN_SIGNED_PACKAGES);
        }
        return enhancer;
    }

    public static class MockMethodInterceptor
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = -9054190871232972342L;
        private final InvocationHandler handler;
        private transient Set<Method> mockedMethods;

        public MockMethodInterceptor(InvocationHandler handler) {
            this.handler = handler;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            StackTraceElement element;
            Exception e;
            StackTraceElement[] elements;
            if (Modifier.isAbstract(method.getModifiers())) {
                return this.handler.invoke(obj, method, args);
            }
            if (obj instanceof Throwable && method.getName().equals("fillInStackTrace") && (elements = (e = new Exception()).getStackTrace()).length > 2 && (element = elements[2]).getClassName().equals("org.easymock.internal.MockInvocationHandler") && element.getMethodName().equals("invoke")) {
                return proxy.invokeSuper(obj, args);
            }
            if (method.isBridge()) {
                method = BridgeMethodResolver.findBridgedMethod(method);
            }
            if (this.mockedMethods != null && !this.mockedMethods.contains(method)) {
                return proxy.invokeSuper(obj, args);
            }
            return this.handler.invoke(obj, method, args);
        }

        public InvocationHandler getHandler() {
            return this.handler;
        }

        public void setMockedMethods(Method ... mockedMethods) {
            this.mockedMethods = new HashSet<Method>(Arrays.asList(mockedMethods));
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            Set methods = (Set)stream.readObject();
            if (methods == null) {
                return;
            }
            this.mockedMethods = new HashSet<Method>(methods.size());
            for (MethodSerializationWrapper m : methods) {
                try {
                    this.mockedMethods.add(m.getMethod());
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e.toString());
                }
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            if (this.mockedMethods == null) {
                stream.writeObject(null);
                return;
            }
            HashSet<MethodSerializationWrapper> methods = new HashSet<MethodSerializationWrapper>(this.mockedMethods.size());
            for (Method m : this.mockedMethods) {
                methods.add(new MethodSerializationWrapper(m));
            }
            stream.writeObject(methods);
        }
    }
}

