/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.Utils;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgUtils {
    private static final Pattern NUMBER_RE = Pattern.compile("^([0-9]+(\\.[0-9]+)?((e|E)(\\+\\-)?[0-9]+)?)|(0(x|X)[0-9a-fA-F]+)$");

    public static void ensureArg(Object[] args, int pos) {
        if (pos >= args.length) {
            throw new EvaluatorException("Not enough arguments.");
        }
    }

    public static String stringArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.stringArg(args, pos, null);
    }

    public static String stringArg(Object[] args, int pos, String def) {
        if (pos < args.length) {
            return Context.toString((Object)args[pos]);
        }
        return def;
    }

    public static int intArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.intArg(args, pos, 0);
    }

    public static int intArg(Object[] args, int pos, int def) {
        Double n;
        if (pos < args.length && !((Object)(n = Double.valueOf(Context.toNumber((Object)args[pos])))).equals(ScriptRuntime.NaN)) {
            return ((Number)n).intValue();
        }
        return def;
    }

    public static int octalOrHexIntArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.octalOrHexIntArg(args, pos, 0);
    }

    public static int octalOrHexIntArg(Object[] args, int pos, int def) {
        if (pos < args.length) {
            if (args[pos] instanceof String) {
                String s = Context.toString((Object)args[pos]);
                try {
                    return Integer.decode(s);
                }
                catch (NumberFormatException nfe) {
                    return def;
                }
            }
            Double n = Context.toNumber((Object)args[pos]);
            if (!((Object)n).equals(ScriptRuntime.NaN)) {
                return ((Number)n).intValue();
            }
        }
        return def;
    }

    public static Number numberArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return Context.toNumber((Object)args[pos]);
    }

    public static int intArgOnly(Object[] args, int pos) {
        Number n = ArgUtils.numberArg(args, pos);
        if (n.doubleValue() == (double)n.intValue()) {
            return n.intValue();
        }
        throw new EvaluatorException("Not an integer");
    }

    public static int intArgOnly(Context cx, Scriptable scope, Object[] args, int pos, int def) {
        if (pos < args.length) {
            if (args[pos] == null || Context.getUndefinedValue().equals(args[pos])) {
                return def;
            }
            Number n = ArgUtils.numberArg(args, pos);
            if (n.doubleValue() == (double)n.intValue()) {
                return n.intValue();
            }
            throw Utils.makeError(cx, scope, "Not an integer");
        }
        return def;
    }

    public static long longArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.longArg(args, pos, 0L);
    }

    public static long longArg(Object[] args, int pos, long def) {
        Double n;
        if (pos < args.length && !((Object)(n = Double.valueOf(Context.toNumber((Object)args[pos])))).equals(ScriptRuntime.NaN)) {
            return ((Number)n).longValue();
        }
        return def;
    }

    public static long longArgOnly(Context cx, Scriptable scope, Object[] args, int pos, long def) {
        if (pos < args.length) {
            if (args[pos] == null || Context.getUndefinedValue().equals(args[pos])) {
                return def;
            }
            Number n = ArgUtils.numberArg(args, pos);
            if (n.doubleValue() == (double)n.longValue()) {
                return n.longValue();
            }
            throw Utils.makeError(cx, scope, "Not an integer");
        }
        return def;
    }

    public static boolean booleanArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.booleanArg(args, pos, false);
    }

    public static boolean booleanArg(Object[] args, int pos, boolean def) {
        if (pos < args.length) {
            return Context.toBoolean((Object)args[pos]);
        }
        return def;
    }

    public static float floatArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.floatArg(args, pos, 0.0f);
    }

    public static float floatArg(Object[] args, int pos, float def) {
        Double n;
        if (pos < args.length && !((Object)(n = Double.valueOf(Context.toNumber((Object)args[pos])))).equals(ScriptRuntime.NaN)) {
            return ((Number)n).floatValue();
        }
        return def;
    }

    public static double doubleArg(Object[] args, int pos) {
        ArgUtils.ensureArg(args, pos);
        return ArgUtils.doubleArg(args, pos, 0.0);
    }

    public static double doubleArg(Object[] args, int pos, double def) {
        Double n;
        if (pos < args.length && !((Object)(n = Double.valueOf(Context.toNumber((Object)args[pos])))).equals(ScriptRuntime.NaN)) {
            return n;
        }
        return def;
    }

    public static Function functionArg(Object[] args, int pos, boolean required) {
        if (required) {
            ArgUtils.ensureArg(args, pos);
        }
        if (pos < args.length) {
            if (args[pos] instanceof Function) {
                return (Function)args[pos];
            }
            if (required) {
                throw new EvaluatorException("Function expected");
            }
            return null;
        }
        return null;
    }

    public static <T> T objArg(Object[] args, int pos, Class<T> type, boolean required) {
        if (required) {
            ArgUtils.ensureArg(args, pos);
        }
        if (pos < args.length) {
            if (type.isInstance(args[pos])) {
                return type.cast(args[pos]);
            }
            Object arg = args[pos];
            while (arg instanceof Wrapper) {
                if (!type.isInstance(arg = ((Wrapper)arg).unwrap())) continue;
                return type.cast(arg);
            }
            if (required) {
                throw new EvaluatorException("Object of type " + type + " expected");
            }
            return null;
        }
        return null;
    }

    public static boolean isIntArg(Object o) {
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            return NUMBER_RE.matcher((String)o).matches();
        }
        return false;
    }

    public static int parseUnsignedIntForgiveably(Object o) {
        Object val = o;
        if (val instanceof String) {
            try {
                val = Double.parseDouble((String)val);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        if (val instanceof Double) {
            Double dVal = (Double)val;
            if (dVal < 0.0 || dVal.isNaN()) {
                return 0;
            }
            if (dVal.isInfinite()) {
                return Integer.MAX_VALUE;
            }
            if (dVal > 2.147483647E9) {
                return -1;
            }
            return (int)Math.ceil(dVal);
        }
        if (val instanceof Number) {
            Number num = (Number)val;
            if (num.longValue() > Integer.MAX_VALUE) {
                return -1;
            }
            if (num.longValue() < 0L) {
                return 0;
            }
            return num.intValue();
        }
        return 0;
    }

    public static Scriptable ensureValid(Object obj) {
        if (obj == null || Scriptable.NOT_FOUND.equals(obj) || Context.getUndefinedValue().equals(obj)) {
            return null;
        }
        return (Scriptable)obj;
    }
}

