/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.NodeEnvironment;
import io.apigee.trireme.core.NodeException;
import io.apigee.trireme.core.Sandbox;
import io.apigee.trireme.core.ScriptFuture;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.ChildModuleRegistry;
import io.apigee.trireme.core.internal.RootModuleRegistry;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.ProcessWrap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeScript {
    private final NodeEnvironment env;
    private File scriptFile;
    private String script;
    private String scriptName;
    private String displayName;
    private final String[] args;
    private ScriptRunner runner;
    private Object attachment;
    private Sandbox sandbox;
    private Object parentProcess;
    private boolean childProcess;
    private boolean pin;
    private boolean forceRepl;
    private boolean printEval;
    private String workingDir;
    private Map<String, String> environment;
    private String nodeVersion = "0.10.x";

    NodeScript(NodeEnvironment env, String scriptName, File script, String[] args) {
        this.env = env;
        this.scriptName = scriptName;
        this.scriptFile = script;
        this.args = args;
        this.sandbox = env.getSandbox();
    }

    NodeScript(NodeEnvironment env, String scriptName, String script, String[] args) {
        this.env = env;
        this.scriptName = scriptName;
        this.script = script;
        this.args = args;
        this.sandbox = env.getSandbox();
    }

    NodeScript(NodeEnvironment env, String[] args, boolean forceRepl) {
        this.args = args;
        this.env = env;
        this.forceRepl = forceRepl;
        this.sandbox = env.getSandbox();
    }

    public ScriptFuture execute() throws NodeException {
        AbstractModuleRegistry registry = this.getRegistry();
        this.runner = this.scriptFile == null && this.script == null ? new ScriptRunner(this, this.env, this.sandbox, this.args, this.forceRepl) : (this.scriptFile == null ? new ScriptRunner(this, this.env, this.sandbox, this.scriptName, this.script, this.args) : new ScriptRunner(this, this.env, this.sandbox, this.scriptFile, this.args));
        this.runner.setRegistry(registry);
        this.runner.setParentProcess((ProcessWrap.ProcessImpl)((Object)this.parentProcess));
        if (this.workingDir != null) {
            try {
                this.runner.setWorkingDirectory(this.workingDir);
            }
            catch (IOException ioe) {
                throw new NodeException(ioe);
            }
        }
        ScriptFuture future = new ScriptFuture(this.runner);
        this.runner.setFuture(future);
        if (this.pin) {
            this.runner.pin();
        }
        this.env.getScriptPool().execute(future);
        return future;
    }

    public ScriptFuture executeModule() throws NodeException {
        if (this.scriptFile == null) {
            throw new NodeException("Modules must be specified as a file name and not as a string");
        }
        AbstractModuleRegistry registry = this.getRegistry();
        this.runner = new ScriptRunner(this, this.env, this.sandbox, this.scriptName, this.makeModuleScript(), this.args);
        this.runner.setParentProcess((ProcessWrap.ProcessImpl)((Object)this.parentProcess));
        this.runner.setRegistry(registry);
        if (this.workingDir != null) {
            try {
                this.runner.setWorkingDirectory(this.workingDir);
            }
            catch (IOException ioe) {
                throw new NodeException(ioe);
            }
        }
        ScriptFuture future = new ScriptFuture(this.runner);
        this.runner.setFuture(future);
        this.runner.pin();
        this.env.getScriptPool().execute(future);
        return future;
    }

    private AbstractModuleRegistry getRegistry() throws NodeException {
        RootModuleRegistry root = this.env.getRegistry(this.nodeVersion);
        if (root == null) {
            throw new NodeException("No available Node.js implementation matches version " + this.nodeVersion);
        }
        return new ChildModuleRegistry(root);
    }

    private String makeModuleScript() {
        String scriptName = this.scriptFile.getAbsolutePath().replace("\\", "\\\\");
        return "var runtime = process.binding('trireme-module-loader');\nvar suppliedModule = require('" + scriptName + "');\n" + "runtime.loaded(suppliedModule);";
    }

    public void close() {
        if (this.runner != null) {
            this.runner.close();
        }
    }

    public void setSandbox(Sandbox box) {
        this.sandbox = box;
    }

    public Sandbox getSandbox() {
        return this.sandbox;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public void setPinned(boolean p) {
        this.pin = p;
    }

    public boolean isPinned() {
        return this.pin;
    }

    public void setPrintEval(boolean print) {
        this.printEval = print;
    }

    public boolean isPrintEval() {
        return this.printEval;
    }

    public Map<String, String> getEnvironment() {
        if (this.environment == null) {
            return System.getenv();
        }
        return this.environment;
    }

    public void setEnvironment(Map<String, String> env) {
        this.environment = env;
    }

    public void setWorkingDirectory(String wd) {
        this.workingDir = wd;
    }

    public String getWorkingDirectory() {
        return this.workingDir;
    }

    public void setNodeVersion(String v) {
        this.nodeVersion = v;
    }

    public String getNodeVersion() {
        return this.nodeVersion;
    }

    public void setDisplayName(String dn) {
        this.displayName = dn;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void addEnvironment(String name, String value) {
        if (this.environment == null) {
            this.environment = new HashMap<String, String>(System.getenv());
        }
        this.environment.put(name, value);
    }

    public void _setParentProcess(Object parent) {
        this.parentProcess = parent;
        if (this.runner != null) {
            this.runner.setParentProcess((ProcessWrap.ProcessImpl)((Object)parent));
        }
    }

    public Scriptable _getProcessObject() {
        ScriptRunner runner = this._getRuntime();
        return runner == null ? null : runner.getProcess();
    }

    public void _setChildProcess(boolean child) {
        this.childProcess = child;
    }

    public boolean _isChildProcess() {
        return this.childProcess;
    }

    public ScriptRunner _getRuntime() {
        if (this.runner == null) {
            return null;
        }
        this.runner.awaitInitialization();
        return this.runner;
    }
}

