/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NativeNodeModule;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.JavaVersion;
import io.apigee.trireme.core.spi.NodeImplementation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootModuleRegistry
extends AbstractModuleRegistry {
    private final HashMap<String, NodeModule> modules = new HashMap();
    private final HashMap<String, InternalNodeModule> internalModules = new HashMap();
    private final HashMap<String, Script> compiledModules = new HashMap();
    private final HashMap<String, NativeNodeModule> nativeModules = new HashMap();
    private final NodeImplementation implementation;
    private Script mainScript;
    private boolean loaded;

    public RootModuleRegistry(NodeImplementation impl) {
        this.implementation = impl;
    }

    @Override
    public NodeImplementation getImplementation() {
        return this.implementation;
    }

    @Override
    public synchronized void loadRoot(Context cx) {
        if (this.loaded) {
            return;
        }
        this.load(cx, this.getClass().getClassLoader());
        if (JavaVersion.get().hasAsyncFileIO().booleanValue()) {
            this.loadModuleByName("io.apigee.trireme.core.modules.AsyncFilesystem");
        } else {
            this.loadModuleByName("io.apigee.trireme.core.modules.Filesystem");
        }
        this.loadMainScript(this.getImplementation().getMainScriptClass());
        for (String[] builtin : this.implementation.getBuiltInModules()) {
            this.addCompiledModule(builtin[0], builtin[1]);
        }
        for (Class<? extends NodeModule> nat : this.implementation.getNativeModules()) {
            this.loadModuleByClass(nat);
        }
        this.loaded = true;
    }

    private void loadMainScript(String className) {
        try {
            Class<?> klass = Class.forName(className);
            this.mainScript = (Script)klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void loadModuleByName(String className) {
        try {
            Class<?> klass = Class.forName(className);
            this.loadModuleByClass(klass);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void loadModuleByClass(Class<? extends NodeModule> klass) {
        try {
            NodeModule mod = klass.newInstance();
            this.addNativeModule(mod);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void addCompiledModule(String name, String className) {
        try {
            Class<?> cl = Class.forName(className);
            Script script = (Script)cl.newInstance();
            this.compiledModules.put(name, script);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Missing built-in module " + className));
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Error creating Script instance for " + className));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Error creating Script instance for " + className));
        }
    }

    @Override
    public NodeModule get(String name) {
        return this.modules.get(name);
    }

    @Override
    public NodeModule getInternal(String name) {
        return this.internalModules.get(name);
    }

    @Override
    public NodeModule getNative(String name) {
        return this.nativeModules.get(name);
    }

    @Override
    public Script getCompiledModule(String name) {
        return this.compiledModules.get(name);
    }

    @Override
    public Set<String> getCompiledModuleNames() {
        return Collections.unmodifiableSet(this.compiledModules.keySet());
    }

    @Override
    public Script getMainScript() {
        return this.mainScript;
    }

    @Override
    protected void putCompiledModule(String name, Script script) {
        this.compiledModules.put(name, script);
    }

    @Override
    protected void putInternalModule(String name, InternalNodeModule mod) {
        this.internalModules.put(name, mod);
    }

    @Override
    protected void putNativeModule(String name, NativeNodeModule mod) {
        this.nativeModules.put(name, mod);
    }

    @Override
    protected void putRegularModule(String name, NodeModule mod) {
        this.modules.put(name, mod);
    }
}

