/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.ScriptRunner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeModule
implements NodeModule {
    protected static final Logger log = LoggerFactory.getLogger(NativeModule.class);
    public static final String MODULE_NAME = "native_module";
    public static final String NODE_SCRIPT_BASE = "/io/apigee/trireme/fromnode/";
    public static final String NR_SCRIPT_BASE = "/io/apigee/trireme/scripts/";
    public static final String SCRIPT_SUFFIX = ".js";

    public String getModuleName() {
        return MODULE_NAME;
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, NativeImpl.class);
        ScriptableObject.defineClass((Scriptable)scope, ModuleImpl.class);
        NativeImpl nat = (NativeImpl)cx.newObject(scope, "NativeModule");
        nat.initialize(cx, runner);
        return nat;
    }

    private static ScriptRunner getRunner(Context cx) {
        return (ScriptRunner)cx.getThreadLocal((Object)"runner");
    }

    public static class ModuleImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_moduleImplClass";
        private String fileName;
        private String id;
        private Scriptable exports;
        private boolean loaded;

        public static ModuleImpl newModule(Context cx, Scriptable scope, String id, String fileName) {
            ModuleImpl mod = (ModuleImpl)cx.newObject(scope, CLASS_NAME);
            mod.setFileName(fileName);
            mod.setId(id);
            return mod;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JSSetter(value="fileName")
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @JSGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JSSetter(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JSGetter(value="exports")
        public Scriptable getExports() {
            return this.exports;
        }

        @JSSetter(value="exports")
        public void setExports(Scriptable exports) {
            this.exports = exports;
        }

        @JSGetter(value="loaded")
        public boolean isLoaded() {
            return this.loaded;
        }

        @JSSetter(value="loaded")
        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }
    }

    public static class NativeImpl
    extends ScriptableObject {
        public static final String WRAP_PREFIX = "(function (exports, require, module, __filename, __dirname) {";
        public static final String WRAP_POSTFIX = "\n});";
        public static final String CLASS_NAME = "NativeModule";
        private ScriptRunner runner;
        private String fileName;
        private String id;
        private Scriptable exports;
        private boolean loaded;
        private Scriptable cache;

        void initialize(Context cx, NodeRuntime runner) {
            this.runner = (ScriptRunner)runner;
            this.cache = cx.newObject((Scriptable)this);
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSGetter(value="filename")
        public String getFileName() {
            return this.fileName;
        }

        @JSGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JSGetter(value="loaded")
        public boolean isLoaded() {
            return this.loaded;
        }

        @JSGetter(value="exports")
        public Scriptable getExports() {
            return this.exports;
        }

        @JSSetter(value="exports")
        public void setExports(Scriptable s) {
            this.exports = s;
        }

        @JSGetter(value="_cache")
        public Scriptable getCache() {
            return this.cache;
        }

        @JSFunction
        public static Object require(Context cx, Scriptable thisObj, Object[] args, Function func) throws InvocationTargetException, InstantiationException, IllegalAccessException {
            String name = ArgUtils.stringArg(args, 0);
            if (thisObj != null && thisObj instanceof NativeImpl) {
                NativeImpl self = (NativeImpl)thisObj;
                return self.internalRequire(name, cx);
            }
            ScriptRunner r = NativeModule.getRunner(cx);
            return r.getNativeModule().internalRequire(name, cx);
        }

        public Scriptable internalRequire(String name, Context cx) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            ModuleImpl ret = this.runner.getCachedModule(name);
            if (ret != null) {
                return ret.getExports();
            }
            Object exp = this.runner.initializeModule(name, AbstractModuleRegistry.ModuleType.PUBLIC, cx, this.runner.getScriptScope());
            if (exp != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Loaded {} from Java object {}", (Object)name, exp);
                }
                ModuleImpl mod = ModuleImpl.newModule(cx, this.runner.getScriptScope(), name, name);
                mod.setExports((Scriptable)exp);
                mod.setLoaded(true);
                this.runner.cacheModule(name, mod);
                return mod.getExports();
            }
            Script compiled = this.runner.getRegistry().getCompiledModule(name);
            if (compiled != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Loading {} from compiled script", (Object)name);
                }
                ModuleImpl mod = ModuleImpl.newModule(cx, this.runner.getScriptScope(), name, name + NativeModule.SCRIPT_SUFFIX);
                mod.setExports(cx.newObject(this.runner.getScriptScope()));
                this.runner.cacheModule(name, mod);
                this.runCompiledModule(compiled, cx, mod);
                return mod.getExports();
            }
            return null;
        }

        private void runCompiledModule(Script compiled, Context cx, ModuleImpl mod) {
            FunctionObject requireFunc = new FunctionObject("require", (Member)Utils.findMethod(NativeImpl.class, "require"), (Scriptable)this);
            Object ret = compiled.exec(cx, this.runner.getScriptScope());
            Function fn = (Function)ret;
            fn.call(cx, this.runner.getScriptScope(), null, new Object[]{mod.getExports(), requireFunc, mod, mod.getFileName()});
            mod.setLoaded(true);
        }

        @JSFunction
        public static Object getCached(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String name = ArgUtils.stringArg(args, 0);
            NativeImpl self = (NativeImpl)thisObj;
            return self.runner.getCachedModule(name);
        }

        @JSFunction
        public static boolean exists(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String name = ArgUtils.stringArg(args, 0);
            NativeImpl self = (NativeImpl)thisObj;
            return self.runner.isNativeModule(name);
        }

        @JSFunction
        public static String wrap(String source) {
            return WRAP_PREFIX + source + WRAP_POSTFIX;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JSFunction
        public static Object getSource(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String name = ArgUtils.stringArg(args, 0);
            InputStream in = NativeImpl.class.getResourceAsStream(NativeModule.NODE_SCRIPT_BASE + name + NativeModule.SCRIPT_SUFFIX);
            if (in == null) {
                in = NativeImpl.class.getResourceAsStream(NativeModule.NR_SCRIPT_BASE + name + NativeModule.SCRIPT_SUFFIX);
            }
            if (in == null) {
                return Context.getUndefinedValue();
            }
            try {
                String string = Utils.readStream(in);
                return string;
            }
            catch (IOException ioe) {
                log.debug("Error reading native code stream: {}", (Throwable)ioe);
                Object object = Context.getUndefinedValue();
                return object;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    log.debug("Error closing stream {}", (Throwable)ioe);
                }
            }
        }

        @JSGetter(value="wrapper")
        public Object getWrapper() {
            Object[] wrap = new Object[]{WRAP_PREFIX, WRAP_POSTFIX};
            return Context.getCurrentContext().newArray((Scriptable)this, wrap);
        }
    }
}

