/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeException;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.NodeScript;
import io.apigee.trireme.core.Sandbox;
import io.apigee.trireme.core.ScriptFuture;
import io.apigee.trireme.core.ScriptStatus;
import io.apigee.trireme.core.ScriptStatusListener;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.SubprocessPolicy;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.BitBucketInputStream;
import io.apigee.trireme.core.internal.BitBucketOutputStream;
import io.apigee.trireme.core.internal.NoCloseInputStream;
import io.apigee.trireme.core.internal.NoCloseOutputStream;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.internal.StreamPiper;
import io.apigee.trireme.core.internal.handles.AbstractHandle;
import io.apigee.trireme.core.internal.handles.JavaInputStreamHandle;
import io.apigee.trireme.core.internal.handles.JavaOutputStreamHandle;
import io.apigee.trireme.core.modules.Referenceable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(ProcessWrap.class);
    public static final String STDIO_PIPE = "pipe";
    public static final String STDIO_FD = "fd";
    public static final String STDIO_IGNORE = "ignore";
    public static final String STDIO_IPC = "ipc";
    private static final Pattern EQUALS = Pattern.compile("=");
    public static final Object IPC_DISCONNECT = new Object();
    private static final ConcurrentHashMap<Integer, SpawnedProcess> processTable = new ConcurrentHashMap();
    private static final AtomicInteger nextPid = new AtomicInteger(1);

    public String getModuleName() {
        return "trireme_process_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptRunner internalRunner = (ScriptRunner)runner;
        internalRunner.require("stream", cx);
        ScriptableObject.defineClass((Scriptable)scope, ProcessImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)scope, ProcessModuleImpl.class);
        ProcessModuleImpl exports = (ProcessModuleImpl)cx.newObject(scope, "_processModule");
        exports.initialize(internalRunner);
        return exports;
    }

    public static void kill(Context cx, Scriptable scope, int pid, String signal) {
        SpawnedProcess proc = processTable.get(pid);
        if (proc == null) {
            throw Utils.makeError(cx, scope, new NodeOSException("ESRCH"));
        }
        if (signal != null) {
            if (log.isDebugEnabled()) {
                log.debug("Terminating pid {} ({}) with {}", new Object[]{pid, proc, signal});
            }
            proc.terminate(signal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpawnedTriremeProcess
    extends SpawnedProcess {
        public static final int PROCESS_PIPE_SIZE = 65536;
        private ScriptFuture future;
        private NodeScript script;
        private boolean ipcEnabled;

        SpawnedTriremeProcess(ProcessImpl parent) {
            super(parent);
        }

        @Override
        void terminate(String code) {
            this.future.cancel(true);
        }

        @Override
        void close() {
            if (!this.finished) {
                this.future.cancel(true);
            }
        }

        private void createReadableStream(Context cx, Scriptable stdio, int arg, Sandbox sandbox) throws IOException {
            Scriptable opts = this.getStdioObj(stdio, arg);
            String type = this.getStdioType(opts);
            if (ProcessWrap.STDIO_PIPE.equals(type)) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating input stream pipe for stdio {}", (Object)arg);
                }
                PipedInputStream pipeIn = new PipedInputStream(65536);
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                sandbox.setStdin(pipeIn);
                JavaOutputStreamHandle streamHandle = new JavaOutputStreamHandle(pipeOut);
                Scriptable handle = this.createStreamHandle(cx, streamHandle);
                opts.put("handle", opts, (Object)handle);
            } else if (ProcessWrap.STDIO_FD.equals(type)) {
                int fd = this.getStdioFD(opts);
                if (fd != 0) {
                    throw new AssertionError((Object)"stdin only supported on fd 0");
                }
                log.debug("Using standard input for script input");
                sandbox.setStdin(new NoCloseInputStream(this.parent.runner.getStdin()));
            } else if (ProcessWrap.STDIO_IGNORE.equals(type)) {
                sandbox.setStdin(new BitBucketInputStream());
            } else if (ProcessWrap.STDIO_IPC.equals(type)) {
                this.ipcEnabled = true;
            } else {
                throw Utils.makeError(cx, (Scriptable)this.parent, "Trireme unsupported stdio type " + type);
            }
        }

        private void createWritableStream(Context cx, Scriptable stdio, int arg, Sandbox sandbox) throws IOException {
            block20: {
                String type;
                block22: {
                    block21: {
                        NoCloseOutputStream out;
                        Scriptable opts;
                        block19: {
                            opts = this.getStdioObj(stdio, arg);
                            type = this.getStdioType(opts);
                            if (!ProcessWrap.STDIO_PIPE.equals(type)) break block19;
                            if (log.isDebugEnabled()) {
                                log.debug("Creating writable stream pipe for stdio {}", (Object)arg);
                            }
                            PipedInputStream pipeIn = new PipedInputStream(65536);
                            PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                            JavaInputStreamHandle streamHandle = new JavaInputStreamHandle(pipeIn, this.parent.runner);
                            Scriptable handle = this.createStreamHandle(cx, streamHandle);
                            opts.put("handle", opts, (Object)handle);
                            switch (arg) {
                                case 1: {
                                    sandbox.setStdout(pipeOut);
                                    break;
                                }
                                case 2: {
                                    sandbox.setStderr(pipeOut);
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)"Child process only supported on fds 1 and 2");
                                }
                            }
                            break block20;
                        }
                        if (!ProcessWrap.STDIO_FD.equals(type)) break block21;
                        int fd = this.getStdioFD(opts);
                        switch (fd) {
                            case 1: {
                                log.debug("Using standard output for script output");
                                out = new NoCloseOutputStream(this.parent.runner.getStdout());
                                break;
                            }
                            case 2: {
                                log.debug("Using standard error for script output");
                                out = new NoCloseOutputStream(this.parent.runner.getStderr());
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)"Child process only supported on fds 1 and 2");
                            }
                        }
                        switch (arg) {
                            case 1: {
                                sandbox.setStdout(out);
                                break;
                            }
                            case 2: {
                                sandbox.setStderr(out);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)"Child process only supported on fds 1 and 2");
                            }
                        }
                        break block20;
                    }
                    if (!ProcessWrap.STDIO_IGNORE.equals(type)) break block22;
                    switch (arg) {
                        case 1: {
                            sandbox.setStdout(new BitBucketOutputStream());
                            break block20;
                        }
                        case 2: {
                            sandbox.setStderr(new BitBucketOutputStream());
                            break block20;
                        }
                        default: {
                            throw new AssertionError((Object)"Child process only supported on fds 1 and 2");
                        }
                    }
                }
                if (ProcessWrap.STDIO_IPC.equals(type)) {
                    this.ipcEnabled = true;
                } else {
                    throw Utils.makeError(cx, (Scriptable)this.parent, "Trireme unsupported stdio type " + type);
                }
            }
        }

        @Override
        Object spawn(Context cx, List<String> execArgs, Scriptable options) {
            int i;
            if (log.isDebugEnabled()) {
                log.debug("About to launch another ScriptRunner thread");
            }
            String scriptPath = null;
            for (i = 1; i < execArgs.size(); ++i) {
                if (execArgs.get(i).startsWith("-")) continue;
                scriptPath = execArgs.get(i);
                ++i;
                break;
            }
            if (scriptPath == null) {
                throw new EvaluatorException("No script path to spawn");
            }
            ArrayList<String> args = new ArrayList<String>(execArgs.size() - i);
            while (i < execArgs.size()) {
                String arg = execArgs.get(i);
                if (arg != null) {
                    args.add(arg);
                }
                ++i;
            }
            if (!options.has("stdio", options)) {
                throw new EvaluatorException("Missing stdio in options");
            }
            Scriptable stdio = (Scriptable)options.get("stdio", options);
            Sandbox scriptSandbox = new Sandbox(this.parent.runner.getSandbox());
            try {
                this.createReadableStream(cx, stdio, 0, scriptSandbox);
                this.createWritableStream(cx, stdio, 1, scriptSandbox);
                this.createWritableStream(cx, stdio, 2, scriptSandbox);
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, (Scriptable)this.parent, ioe.toString());
            }
            int si = 3;
            while (stdio.has(si, stdio)) {
                Scriptable stdioObj = this.getStdioObj(stdio, si);
                if (!ProcessWrap.STDIO_IPC.equals(this.getStdioType(stdioObj))) {
                    throw Utils.makeError(cx, stdioObj, "Invalid stdio type " + this.getStdioType(stdioObj) + " for stdio index " + si);
                }
                this.ipcEnabled = true;
                ++si;
            }
            String cwd = this.getCwdOption(options);
            if (cwd != null) {
                File cwdFile = this.parent.runner.translatePath(cwd);
                if (!cwdFile.exists()) {
                    return Utils.makeErrorObject(cx, (Scriptable)this.parent, "ENOENT", "ENOENT");
                }
                if (!cwdFile.isDirectory()) {
                    return Utils.makeErrorObject(cx, (Scriptable)this.parent, "ENOTDIR", "ENOTDIR");
                }
                File scriptPathFile = new File(scriptPath);
                if (!scriptPathFile.isAbsolute()) {
                    scriptPath = new File(cwdFile, scriptPath).getPath();
                }
            }
            HashMap<String, String> env = null;
            if (options.has("envPairs", options)) {
                env = new HashMap<String, String>();
                this.setEnvironment(Utils.toStringList((Scriptable)options.get("envPairs", options)), env);
            }
            try {
                this.script = this.parent.runner.getEnvironment().createScript(scriptPath, this.parent.runner.translatePath(scriptPath), args.toArray(new String[args.size()]));
                this.script.setSandbox(scriptSandbox);
                this.script.setWorkingDirectory(cwd);
                if (env != null) {
                    this.script.setEnvironment(env);
                }
                this.script._setChildProcess(true);
                if (this.ipcEnabled) {
                    this.script._setParentProcess((Object)this.parent);
                }
                this.future = this.script.execute();
            }
            catch (NodeException ne) {
                if (log.isDebugEnabled()) {
                    log.debug("Error starting internal script: {}", (Throwable)ne);
                }
                return "EIO";
            }
            this.future.setListener(new ScriptStatusListener(){

                public void onComplete(NodeScript script, ScriptStatus status) {
                    if (log.isDebugEnabled()) {
                        log.debug("Child ScriptRunner exited: {}", (Object)status);
                    }
                    SpawnedTriremeProcess.this.finished = true;
                    script.close();
                    SpawnedTriremeProcess.this.parent.callOnExit(status.getExitCode(), 0);
                }
            });
            return Context.getUndefinedValue();
        }

        @Override
        protected Scriptable getChildProcessObject() {
            return this.script._getProcessObject();
        }

        @Override
        protected void send(Context cx, Object message) {
            this.script._getRuntime().enqueueIpc(cx, message, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpawnedOSProcess
    extends SpawnedProcess {
        private Process proc;

        SpawnedOSProcess(ProcessImpl parent) {
            super(parent);
        }

        @Override
        void terminate(String signal) {
            if (this.proc != null) {
                this.proc.destroy();
            }
        }

        @Override
        void close() {
            if (!this.finished) {
                this.finished = true;
                this.terminate("0");
            }
        }

        private void createOutputStream(Context cx, Scriptable stdio, int arg, OutputStream out) {
            Scriptable opts = this.getStdioObj(stdio, arg);
            String type = this.getStdioType(opts);
            if (ProcessWrap.STDIO_PIPE.equals(type)) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting fd {} to output stream {}", (Object)arg, (Object)out);
                }
                JavaOutputStreamHandle streamHandle = new JavaOutputStreamHandle(out);
                Scriptable handle = this.createStreamHandle(cx, streamHandle);
                opts.put("handle", opts, (Object)handle);
            } else if (ProcessWrap.STDIO_IGNORE.equals(type)) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting fd {} to produce no input", (Object)arg);
                }
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    log.debug("Output.close() threw: {}", (Throwable)ioe);
                }
            } else if (ProcessWrap.STDIO_FD.equals(type)) {
                if (this.getStdioFD(opts) != 0) {
                    throw new AssertionError((Object)"Only FDs 0, 1, and 2 supported");
                }
                StreamPiper piper = new StreamPiper(this.parent.runner.getStdin(), out, false);
                piper.start(this.parent.runner.getUnboundedPool());
            } else {
                throw Utils.makeError(cx, (Scriptable)this.parent, "Trireme unsupported stdio type " + type);
            }
        }

        private void createInputStream(Context cx, Scriptable stdio, int arg, InputStream in) {
            Scriptable opts = this.getStdioObj(stdio, arg);
            String type = this.getStdioType(opts);
            if (ProcessWrap.STDIO_PIPE.equals(type)) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting fd {} to input stream {}", (Object)arg, (Object)in);
                }
                JavaInputStreamHandle streamHandle = new JavaInputStreamHandle(in, this.parent.runner);
                Scriptable handle = this.createStreamHandle(cx, streamHandle);
                opts.put("handle", opts, (Object)handle);
            } else if (ProcessWrap.STDIO_IGNORE.equals(type)) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting fd {} to discard all output", (Object)arg);
                }
                StreamPiper piper = new StreamPiper(in, new BitBucketOutputStream(), false);
                piper.start(this.parent.runner.getUnboundedPool());
            } else if (ProcessWrap.STDIO_FD.equals(type)) {
                switch (this.getStdioFD(opts)) {
                    case 1: {
                        StreamPiper piper = new StreamPiper(in, this.parent.runner.getStdout(), false);
                        piper.start(this.parent.runner.getUnboundedPool());
                        break;
                    }
                    case 2: {
                        StreamPiper piper = new StreamPiper(in, this.parent.runner.getStderr(), false);
                        piper.start(this.parent.runner.getUnboundedPool());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Only FDs 0, 1, and 2 supported");
                    }
                }
            } else {
                throw Utils.makeError(cx, (Scriptable)this.parent, "Trireme unsupported stdio type " + type);
            }
        }

        @Override
        Object spawn(Context cx, List<String> execArgs, Scriptable options) {
            if (log.isDebugEnabled()) {
                log.debug("About to exec " + execArgs);
            }
            ProcessBuilder builder = new ProcessBuilder(execArgs);
            String cwd = this.getCwdOption(options);
            if (cwd != null) {
                File cwdFile = this.parent.runner.translatePath(cwd);
                if (!cwdFile.exists()) {
                    return Utils.makeErrorObject(cx, (Scriptable)this.parent, "ENOENT", "ENOENT");
                }
                if (!cwdFile.isDirectory()) {
                    return Utils.makeErrorObject(cx, (Scriptable)this.parent, "ENOTDIR", "ENOTDIR");
                }
                builder.directory(cwdFile);
            }
            if (options.has("envPairs", options)) {
                this.setEnvironment(Utils.toStringList((Scriptable)options.get("envPairs", options)), builder.environment());
            }
            try {
                this.proc = builder.start();
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Error in execution: {}", (Throwable)ioe);
                }
                return Utils.makeErrorObject(cx, (Scriptable)this.parent, ioe.toString(), "ENOENT");
            }
            if (log.isDebugEnabled()) {
                log.debug("Starting {}", (Object)this.proc);
            }
            options.put("pid", options, (Object)(System.identityHashCode(this.proc) % 65536));
            if (!options.has("stdio", options)) {
                throw Utils.makeError(cx, (Scriptable)this.parent, "Missing stdio in options");
            }
            Scriptable stdio = (Scriptable)options.get("stdio", options);
            this.createOutputStream(cx, stdio, 0, this.proc.getOutputStream());
            this.createInputStream(cx, stdio, 1, this.proc.getInputStream());
            this.createInputStream(cx, stdio, 2, this.proc.getErrorStream());
            this.parent.runner.getUnboundedPool().submit(new Runnable(){

                public void run() {
                    try {
                        int exitCode = SpawnedOSProcess.this.proc.waitFor();
                        if (log.isDebugEnabled()) {
                            log.debug("Child process exited with {}", (Object)exitCode);
                        }
                        SpawnedOSProcess.this.parent.callOnExit(exitCode, 0);
                    }
                    catch (InterruptedException ie) {
                        SpawnedOSProcess.this.parent.callOnExit(0, 0);
                    }
                }
            });
            return Context.getUndefinedValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SpawnedProcess {
        protected boolean finished;
        protected final ProcessImpl parent;

        SpawnedProcess(ProcessImpl parent) {
            this.parent = parent;
        }

        abstract void terminate(String var1);

        abstract void close();

        abstract Object spawn(Context var1, List<String> var2, Scriptable var3);

        protected void send(Context cx, Object message) {
            throw new EvaluatorException("IPC is not enabled to the child");
        }

        protected Scriptable getChildProcessObject() {
            return null;
        }

        protected boolean isConnected() {
            return false;
        }

        void setFinished(boolean finished) {
            this.finished = finished;
        }

        protected Scriptable getStdioObj(Scriptable stdio, int arg) {
            if (!stdio.has(arg, stdio)) {
                throw new EvaluatorException("Missing configuration for fd " + arg);
            }
            return (Scriptable)stdio.get(arg, stdio);
        }

        protected String getStdioType(Scriptable s) {
            if (!s.has("type", s)) {
                throw new EvaluatorException("Missing type in stdio");
            }
            return Context.toString((Object)s.get("type", s));
        }

        protected int getStdioFD(Scriptable s) {
            if (!s.has(ProcessWrap.STDIO_FD, s)) {
                throw new EvaluatorException("Missing fd in fd type stdio object");
            }
            return (Integer)Context.jsToJava((Object)s.get(ProcessWrap.STDIO_FD, s), Integer.class);
        }

        protected String getCwdOption(Scriptable s) {
            Object val;
            if (s.has("cwd", s) && (val = ScriptableObject.getProperty((Scriptable)s, (String)"cwd")) != null && !Context.getUndefinedValue().equals(val)) {
                return Context.toString((Object)val);
            }
            return null;
        }

        protected Scriptable createStreamHandle(Context cx, AbstractHandle handle) {
            Scriptable module = (Scriptable)this.parent.runner.requireInternal("java_stream_wrap", cx);
            return cx.newObject(module, "JavaStream", new Object[]{handle});
        }

        protected void setEnvironment(List<String> pairs, Map<String, String> env) {
            env.clear();
            for (String pair : pairs) {
                String[] kv = EQUALS.split(pair, 2);
                env.put(kv[0], kv[1]);
            }
        }
    }

    public static class ProcessImpl
    extends Referenceable {
        public static final String CLASS_NAME = "_processClass";
        private SpawnedProcess spawned;
        private Function onExit;
        private ScriptRunner runner;
        private int pid;
        private Scriptable childProcessObject;
        private Function onMessage;

        public String getClassName() {
            return CLASS_NAME;
        }

        public ScriptRunner getRuntime() {
            return this.runner;
        }

        void initialize(ScriptRunner runner) {
            this.runner = runner;
            this.requestPin();
        }

        @JSFunction
        public void close() {
            if (this.spawned != null) {
                this.spawned.close();
            }
            super.close();
        }

        @JSFunction
        public static Object spawn(Context cx, Scriptable thisObj, Object[] args, Function fn) {
            SubprocessPolicy policy;
            ArgUtils.ensureArg(args, 0);
            ProcessImpl.ensureScriptable((Object)args[0]);
            Scriptable options = (Scriptable)args[0];
            ProcessImpl self = (ProcessImpl)thisObj;
            if (!options.has("args", options)) {
                return Utils.makeErrorObject(cx, thisObj, "EINVAL", "EINVAL");
            }
            List<String> execArgs = Utils.toStringList((Scriptable)options.get("args", options));
            if (execArgs.isEmpty()) {
                return Utils.makeErrorObject(cx, thisObj, "EINVAL", "EINVAL");
            }
            for (int i = 0; i < execArgs.size(); ++i) {
                execArgs.set(i, Utils.unquote(execArgs.get(i)));
            }
            if (self.runner.getSandbox() != null && (policy = self.runner.getSandbox().getSubprocessPolicy()) != null && !policy.allowSubprocess(execArgs)) {
                return Utils.makeErrorObject(cx, thisObj, "EPERM", "EPERM");
            }
            String procName = execArgs.get(0);
            self.pid = nextPid.getAndIncrement();
            self.spawned = "node".equals(procName) || "./node".equals(procName) ? new SpawnedTriremeProcess(self) : new SpawnedOSProcess(self);
            processTable.put(self.pid, self.spawned);
            return self.spawned.spawn(cx, execArgs, options);
        }

        private void callOnExit(final int code, final int signal) {
            if (log.isDebugEnabled()) {
                log.debug("Process {} exited with code {} and signal {}", new Object[]{this.spawned, code, signal});
            }
            this.spawned.setFinished(true);
            processTable.remove(this.pid);
            Scriptable domain = this.runner.getDomain();
            this.runner.enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    ProcessImpl.this.onExit.call(cx, scope, (Scriptable)ProcessImpl.this, new Object[]{code, signal});
                }
            }, domain);
        }

        @JSFunction
        public Object kill(String signal) {
            if (this.spawned != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Killing {}", (Object)this.spawned);
                }
                this.spawned.terminate(signal);
            }
            return 0;
        }

        @JSFunction
        public static void send(Context cx, Scriptable thisObj, Object[] args, Function fn) {
            ArgUtils.ensureArg(args, 0);
            ProcessImpl self = (ProcessImpl)thisObj;
            if (self.spawned == null) {
                throw new AssertionError((Object)"Sending to closed process");
            }
            self.spawned.send(cx, args[0]);
        }

        @JSFunction
        public static void disconnect(Context cx, Scriptable thisObj, Object[] args, Function fn) {
            ProcessImpl self = (ProcessImpl)thisObj;
            if (self.spawned == null) {
                throw new AssertionError((Object)"Sending to closed process");
            }
            self.spawned.send(cx, IPC_DISCONNECT);
        }

        @JSGetter(value="connected")
        public boolean isConnected() {
            return this.spawned == null ? false : this.spawned.isConnected();
        }

        @JSGetter(value="onexit")
        public Function getOnExit() {
            return this.onExit;
        }

        @JSSetter(value="onexit")
        public void setOnExit(Function onExit) {
            this.onExit = onExit;
        }

        @JSGetter(value="pid")
        public int getPid() {
            return this.pid;
        }

        @JSGetter(value="childProcess")
        public Object getChildProcess() {
            if (this.childProcessObject == null) {
                this.childProcessObject = this.spawned == null ? null : this.spawned.getChildProcessObject();
            }
            return this.childProcessObject;
        }

        @JSSetter(value="onMessage")
        public void setOnMessage(Function om) {
            this.onMessage = om;
        }

        @JSGetter(value="onMessage")
        public Function getOnMessage() {
            return this.onMessage;
        }
    }

    public static class ProcessModuleImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_processModule";
        private ScriptRunner runner;

        public String getClassName() {
            return CLASS_NAME;
        }

        void initialize(ScriptRunner runner) {
            this.runner = runner;
        }

        @JSFunction
        public static Object createProcess(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ProcessImpl p = (ProcessImpl)cx.newObject(thisObj, "_processClass");
            p.initialize(((ProcessModuleImpl)thisObj).runner);
            return p;
        }
    }
}

